/*
 * Decompiled with CFR 0.152.
 */
package icy.resource;

import icy.image.ImageUtil;
import icy.system.thread.ThreadUtil;
import icy.util.StringUtil;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.ImageIcon;

public class ResourceUtil {
    public static final String ICON_PATH = "icon/";
    public static final String IMAGE_PATH = "image/";
    public static final String ALPHA_ICON_PATH = "alpha/";
    public static final String COLOR_ICON_PATH = "color/";
    public static final int DEFAULT_ICON_SIZE = 20;
    public static final Image IMAGE_ICY_16 = ResourceUtil.getIconAsImage("icy16.png");
    public static final Image IMAGE_ICY_32 = ResourceUtil.getIconAsImage("icy32.png");
    public static final Image IMAGE_ICY_256 = ResourceUtil.getImage("logo.png");
    public static final Image IMAGE_PLUGIN_SMALL = ResourceUtil.getImage("app/plugin_small.png");
    public static final Image IMAGE_PLUGIN = ResourceUtil.getImage("app/plugin.png");
    public static final Image IMAGE_ACCOLADE_LEFT = ResourceUtil.getImage("app/accol_left.png");
    public static final ImageIcon ICON_ICY_16 = ResourceUtil.getImageIcon(IMAGE_ICY_16);
    public static final ImageIcon ICON_ICY_32 = ResourceUtil.getImageIcon(IMAGE_ICY_32);
    public static final Image ICON_NULL = ResourceUtil.getAlphaIconAsImage("null.png");
    public static final Image ICON_WINDOW_EXPAND = ResourceUtil.getAlphaIconAsImage("top_right_expand.png");
    public static final Image ICON_WINDOW_COLLAPSE = ResourceUtil.getAlphaIconAsImage("top_right_collapse.png");
    public static final Image ICON_PICTURE = ResourceUtil.getAlphaIconAsImage("picture.png");
    public static final Image ICON_PICTURE_COPY = ResourceUtil.getAlphaIconAsImage("picture_copy.png");
    public static final Image ICON_PICTURE_PASTE = ResourceUtil.getAlphaIconAsImage("picture_paste.png");
    public static final Image ICON_WINDOW = ResourceUtil.getAlphaIconAsImage("app_window.png");
    public static final Image ICON_DETACHED_WINDOW = ResourceUtil.getAlphaIconAsImage("app_detached.png");
    public static final Image ICON_DOC = ResourceUtil.getAlphaIconAsImage("document.png");
    public static final Image ICON_DOC_NEW = ResourceUtil.getAlphaIconAsImage("doc_new.png");
    public static final Image ICON_DOC_COPY = ResourceUtil.getAlphaIconAsImage("doc_copy.png");
    public static final Image ICON_DOC_IMPORT = ResourceUtil.getAlphaIconAsImage("doc_import.png");
    public static final Image ICON_DOC_EXPORT = ResourceUtil.getAlphaIconAsImage("doc_export.png");
    public static final Image ICON_XLS_EXPORT = ResourceUtil.getAlphaIconAsImage("xls_export.png");
    public static final Image ICON_DOCEDIT = ResourceUtil.getAlphaIconAsImage("doc_edit.png");
    public static final Image ICON_DOCTEXT1 = ResourceUtil.getAlphaIconAsImage("doc_lines.png");
    public static final Image ICON_DOCTEXT2 = ResourceUtil.getAlphaIconAsImage("doc_lines_stright.png");
    public static final Image ICON_DUPLICATE = ResourceUtil.getAlphaIconAsImage("duplicate.png");
    public static final Image ICON_FOLDER = ResourceUtil.getAlphaIconAsImage("folder.png");
    public static final Image ICON_OPEN;
    public static final Image ICON_LOAD;
    public static final Image ICON_SAVE;
    public static final Image ICON_CLOSE;
    public static final Image ICON_CLIPBOARD_CLEAR;
    public static final Image ICON_COPY;
    public static final Image ICON_CUT;
    public static final Image ICON_LINK_COPY;
    public static final Image ICON_PASTE;
    public static final Image ICON_LINK_PASTE;
    public static final Image ICON_HELP;
    public static final Image ICON_INFO;
    public static final Image ICON_ON_OFF;
    public static final Image ICON_TRASH;
    public static final Image ICON_DELETE;
    public static final Image ICON_COG;
    public static final Image ICON_UNCHECKED;
    public static final Image ICON_CHECKED;
    public static final Image ICON_LOCK_OPEN;
    public static final Image ICON_LOCK_CLOSE;
    public static final Image ICON_DOWNLOAD;
    public static final Image ICON_PROPERTIES;
    public static final Image ICON_TAG;
    public static final Image ICON_TOOLS;
    public static final Image ICON_LIGHTING;
    public static final Image ICON_SEARCH;
    public static final Image ICON_WAIT;
    public static final Image ICON_VISIBLE;
    public static final Image ICON_NOT_VISIBLE;
    public static final Image ICON_EYE_INV;
    public static final Image ICON_UNDO;
    public static final Image ICON_REDO;
    public static final Image ICON_CENTER_IMAGE;
    public static final Image ICON_CROP;
    public static final Image ICON_FIT_IMAGE;
    public static final Image ICON_FIT_CANVAS;
    public static final Image ICON_TARGET;
    public static final Image ICON_PENCIL;
    public static final Image ICON_BRUSH;
    public static final Image ICON_LINK;
    public static final Image ICON_LAYER_H1;
    public static final Image ICON_LAYER_H2;
    public static final Image ICON_LAYER_REVERSE_H;
    public static final Image ICON_LAYER_EXTRACT_H;
    public static final Image ICON_LAYER_ADD_H;
    public static final Image ICON_LAYER_INSERT_H;
    public static final Image ICON_LAYER_REMOVE_H;
    public static final Image ICON_LAYER_REMOVE_ADV_H;
    public static final Image ICON_LAYER_V1;
    public static final Image ICON_LAYER_V2;
    public static final Image ICON_LAYER_REVERSE_V;
    public static final Image ICON_LAYER_EXTRACT_V;
    public static final Image ICON_LAYER_ADD_V;
    public static final Image ICON_LAYER_INSERT_V;
    public static final Image ICON_LAYER_REMOVE_V;
    public static final Image ICON_LAYER_REMOVE_V2;
    public static final Image ICON_LAYER_REMOVE_ADV_V;
    public static final Image ICON_LAYER_ADJUST_HV;
    public static final Image ICON_ROI;
    public static final Image ICON_ROI_POINT;
    public static final Image ICON_ROI_LINE;
    public static final Image ICON_ROI_OVAL;
    public static final Image ICON_ROI_POLYLINE;
    public static final Image ICON_ROI_POLYGON;
    public static final Image ICON_ROI_RECTANGLE;
    public static final Image ICON_ROI_AREA;
    public static final Image ICON_ROI_CYLINDER;
    public static final Image ICON_ROI_BOX;
    public static final Image ICON_ROI_FLATPOLYGON3D;
    public static final Image ICON_ROI_NOT;
    public static final Image ICON_ROI_OR;
    public static final Image ICON_ROI_AND;
    public static final Image ICON_ROI_XOR;
    public static final Image ICON_ROI_SUB;
    public static final Image ICON_ROI_INTERIOR;
    public static final Image ICON_ROI_UPSCALE;
    public static final Image ICON_ROI_DOWNSCALE;
    public static final Image ICON_ROI_COMP;
    public static final Image ICON_ROI_DISTANCE_MAP;
    public static final Image ICON_ROI_DILATE;
    public static final Image ICON_ROI_ERODE;
    public static final Image ICON_ROI_SEPARATE;
    public static final Image ICON_BOOL_MASK;
    public static final Image ICON_INDENT_DECREASE;
    public static final Image ICON_INDENT_INCREASE;
    public static final Image ICON_INDENT_REMOVE;
    public static final Image ICON_TOIJ;
    public static final Image ICON_TOICY;
    public static final Image ICON_PLAY;
    public static final Image ICON_STOP;
    public static final Image ICON_PAUSE;
    public static final Image ICON_PLAY_NEXT;
    public static final Image ICON_PLAY_PREV;
    public static final Image ICON_RELOAD;
    public static final Image ICON_PLUS;
    public static final Image ICON_MINUS;
    public static final Image ICON_ROUND_PLUS;
    public static final Image ICON_ROUND_MINUS;
    public static final Image ICON_ROTATE_UNCLOCK;
    public static final Image ICON_ROTATE_CLOCK;
    public static final Image ICON_ARROW_UP;
    public static final Image ICON_ARROW_LEFT;
    public static final Image ICON_ARROW_RIGHT;
    public static final Image ICON_ARROW_DOWN;
    public static final Image ICON_ARROW_TOP_RIGHT;
    public static final Image ICON_ROUND_ARROW_UP;
    public static final Image ICON_ROUND_ARROW_LEFT;
    public static final Image ICON_ROUND_ARROW_RIGHT;
    public static final Image ICON_ROUND_ARROW_DOWN;
    public static final Image ICON_SQUARE_DOWN;
    public static final Image ICON_SQUARE_UP;
    public static final Image ICON_SQUARE_PREV;
    public static final Image ICON_SQUARE_NEXT;
    public static final Image ICON_CLEAR_BEFORE;
    public static final Image ICON_CLEAR_AFTER;
    public static final Image ICON_PANEL_EXPAND;
    public static final Image ICON_PANEL_COLLAPSE;
    public static final Image ICON_PIN;
    public static final Image ICON_NODE_EXPANDED;
    public static final Image ICON_NODE_COLLAPSED;
    public static final Image ICON_BAND_RIGHT;
    public static final Image ICON_BAND_LEFT;
    public static final Image ICON_RESIZE;
    public static final Image ICON_RESIZE_2;
    public static final Image ICON_TEXT;
    public static final Image ICON_SMILEY_HAPPY;
    public static final Image ICON_SMILEY_SAD;
    public static final Image ICON_CUBE_3D;
    public static final Image ICON_PLUGIN;
    public static final Image ICON_BOX;
    public static final Image ICON_DATABASE;
    public static final Image ICON_HDD;
    public static final Image ICON_HDD_STREAM;
    public static final Image ICON_STAR;
    public static final Image ICON_NETWORK;
    public static final Image ICON_BROWSER;
    public static final Image ICON_CHAT;
    public static final Image ICON_PHOTO;
    public static final Image ICON_PHOTO_SMALL;
    @Deprecated
    public static final Image ICON_NEWDOC;
    @Deprecated
    public static final Image ICON_DOCCOPY;
    @Deprecated
    public static final Image ICON_DOCIMPORT;
    @Deprecated
    public static final Image ICON_DOCEXPORT;
    @Deprecated
    public static final Image ICON_ARROW_BOTTOM;
    @Deprecated
    public static final Image ICON_ARROW_TOP;
    @Deprecated
    public static final Image ICON_EXPAND;
    @Deprecated
    public static final Image ICON_COLLAPSE;
    public static final Image ICON_ALPHA_COLOR;
    public static final Image ICON_ARGB_COLOR;
    public static final Image ICON_RGB_COLOR;
    public static final Image ICON_GRAY_COLOR;
    public static final Image ICON_PLUGIN_COLOR;

    static {
        ICON_LOAD = ICON_OPEN = ResourceUtil.getAlphaIconAsImage("folder_open.png");
        ICON_SAVE = ResourceUtil.getAlphaIconAsImage("save.png");
        ICON_CLOSE = ResourceUtil.getAlphaIconAsImage("round_delete.png");
        ICON_CLIPBOARD_CLEAR = ResourceUtil.getAlphaIconAsImage("clipboard_clear.png");
        ICON_COPY = ResourceUtil.getAlphaIconAsImage("clipboard_copy.png");
        ICON_CUT = ResourceUtil.getAlphaIconAsImage("clipboard_cut.png");
        ICON_LINK_COPY = ResourceUtil.getAlphaIconAsImage("clipboard_link_copy.png");
        ICON_PASTE = ResourceUtil.getAlphaIconAsImage("clipboard_past.png");
        ICON_LINK_PASTE = ResourceUtil.getAlphaIconAsImage("clipboard_link_past.png");
        ICON_HELP = ResourceUtil.getAlphaIconAsImage("help.png");
        ICON_INFO = ResourceUtil.getAlphaIconAsImage("info.png");
        ICON_ON_OFF = ResourceUtil.getAlphaIconAsImage("on-off.png");
        ICON_TRASH = ResourceUtil.getAlphaIconAsImage("trash.png");
        ICON_DELETE = ResourceUtil.getAlphaIconAsImage("delete.png");
        ICON_COG = ResourceUtil.getAlphaIconAsImage("cog.png");
        ICON_UNCHECKED = ResourceUtil.getAlphaIconAsImage("checkbox_unchecked.png");
        ICON_CHECKED = ResourceUtil.getAlphaIconAsImage("checkbox_checked.png");
        ICON_LOCK_OPEN = ResourceUtil.getAlphaIconAsImage("unlocked.png");
        ICON_LOCK_CLOSE = ResourceUtil.getAlphaIconAsImage("locked.png");
        ICON_DOWNLOAD = ResourceUtil.getAlphaIconAsImage("download.png");
        ICON_PROPERTIES = ICON_DOCTEXT1;
        ICON_TAG = ResourceUtil.getAlphaIconAsImage("tag.png");
        ICON_TOOLS = ResourceUtil.getAlphaIconAsImage("wrench_plus_2.png");
        ICON_LIGHTING = ResourceUtil.getAlphaIconAsImage("lighting.png");
        ICON_SEARCH = ResourceUtil.getAlphaIconAsImage("zoom.png");
        ICON_WAIT = ResourceUtil.getAlphaIconAsImage("sand.png");
        ICON_VISIBLE = ResourceUtil.getAlphaIconAsImage("eye_open.png");
        ICON_NOT_VISIBLE = ResourceUtil.getAlphaIconAsImage("eye_close.png");
        ICON_EYE_INV = ResourceUtil.getAlphaIconAsImage("eye_inv.png");
        ICON_UNDO = ResourceUtil.getAlphaIconAsImage("undo.png");
        ICON_REDO = ResourceUtil.getAlphaIconAsImage("redo.png");
        ICON_CENTER_IMAGE = ResourceUtil.getAlphaIconAsImage("center.png");
        ICON_CROP = ResourceUtil.getAlphaIconAsImage("crop.png");
        ICON_FIT_IMAGE = ResourceUtil.getAlphaIconAsImage("fit_in2.png");
        ICON_FIT_CANVAS = ResourceUtil.getAlphaIconAsImage("fit_out.png");
        ICON_TARGET = ResourceUtil.getAlphaIconAsImage("simple_target.png");
        ICON_PENCIL = ResourceUtil.getAlphaIconAsImage("pencil.png");
        ICON_BRUSH = ResourceUtil.getAlphaIconAsImage("brush.png");
        ICON_LINK = ResourceUtil.getAlphaIconAsImage("link.png");
        ICON_LAYER_H1 = ResourceUtil.getAlphaIconAsImage("layers_h1.png");
        ICON_LAYER_H2 = ResourceUtil.getAlphaIconAsImage("layers_h2.png");
        ICON_LAYER_REVERSE_H = ResourceUtil.getAlphaIconAsImage("layers_reverse_h.png");
        ICON_LAYER_EXTRACT_H = ResourceUtil.getAlphaIconAsImage("layers_extract_h.png");
        ICON_LAYER_ADD_H = ResourceUtil.getAlphaIconAsImage("layers_add_h.png");
        ICON_LAYER_INSERT_H = ResourceUtil.getAlphaIconAsImage("layers_insert_h.png");
        ICON_LAYER_REMOVE_H = ResourceUtil.getAlphaIconAsImage("layers_remove_h.png");
        ICON_LAYER_REMOVE_ADV_H = ResourceUtil.getAlphaIconAsImage("layers_remove_adv_h.png");
        ICON_LAYER_V1 = ResourceUtil.getAlphaIconAsImage("layers_v1.png");
        ICON_LAYER_V2 = ResourceUtil.getAlphaIconAsImage("layers_v2.png");
        ICON_LAYER_REVERSE_V = ResourceUtil.getAlphaIconAsImage("layers_reverse_v.png");
        ICON_LAYER_EXTRACT_V = ResourceUtil.getAlphaIconAsImage("layers_extract_v.png");
        ICON_LAYER_ADD_V = ResourceUtil.getAlphaIconAsImage("layers_add_v.png");
        ICON_LAYER_INSERT_V = ResourceUtil.getAlphaIconAsImage("layers_insert_v.png");
        ICON_LAYER_REMOVE_V = ResourceUtil.getAlphaIconAsImage("layers_remove_v.png");
        ICON_LAYER_REMOVE_V2 = ResourceUtil.getAlphaIconAsImage("layers_remove_v2.png");
        ICON_LAYER_REMOVE_ADV_V = ResourceUtil.getAlphaIconAsImage("layers_remove_adv_v.png");
        ICON_LAYER_ADJUST_HV = ResourceUtil.getAlphaIconAsImage("layers_adjust_hv.png");
        ICON_ROI = ResourceUtil.getAlphaIconAsImage("roi.png");
        ICON_ROI_POINT = ResourceUtil.getAlphaIconAsImage("roi_point.png");
        ICON_ROI_LINE = ResourceUtil.getAlphaIconAsImage("roi_line.png");
        ICON_ROI_OVAL = ResourceUtil.getAlphaIconAsImage("roi_oval.png");
        ICON_ROI_POLYLINE = ResourceUtil.getAlphaIconAsImage("roi_polyline.png");
        ICON_ROI_POLYGON = ResourceUtil.getAlphaIconAsImage("roi_polygon.png");
        ICON_ROI_RECTANGLE = ResourceUtil.getAlphaIconAsImage("roi_rectangle.png");
        ICON_ROI_AREA = ResourceUtil.getAlphaIconAsImage("roi_area.png");
        ICON_ROI_CYLINDER = ResourceUtil.getAlphaIconAsImage("roi_cylinder.png");
        ICON_ROI_BOX = ResourceUtil.getAlphaIconAsImage("roi_box.png");
        ICON_ROI_FLATPOLYGON3D = ResourceUtil.getAlphaIconAsImage("roi_flat_polygon3D.png");
        ICON_ROI_NOT = ResourceUtil.getAlphaIconAsImage("roi_not.png");
        ICON_ROI_OR = ResourceUtil.getAlphaIconAsImage("roi_or.png");
        ICON_ROI_AND = ResourceUtil.getAlphaIconAsImage("roi_and.png");
        ICON_ROI_XOR = ResourceUtil.getAlphaIconAsImage("roi_xor.png");
        ICON_ROI_SUB = ResourceUtil.getAlphaIconAsImage("roi_sub.png");
        ICON_ROI_INTERIOR = ResourceUtil.getAlphaIconAsImage("roi_interior.png");
        ICON_ROI_UPSCALE = ResourceUtil.getAlphaIconAsImage("roi_upscale.png");
        ICON_ROI_DOWNSCALE = ResourceUtil.getAlphaIconAsImage("roi_downscale.png");
        ICON_ROI_COMP = ResourceUtil.getAlphaIconAsImage("separate_obj.png");
        ICON_ROI_DISTANCE_MAP = ResourceUtil.getAlphaIconAsImage("roi_distance_map.png");
        ICON_ROI_DILATE = ResourceUtil.getAlphaIconAsImage("roi_dilate.png");
        ICON_ROI_ERODE = ResourceUtil.getAlphaIconAsImage("roi_erode.png");
        ICON_ROI_SEPARATE = ResourceUtil.getAlphaIconAsImage("split_roi.png");
        ICON_BOOL_MASK = ResourceUtil.getAlphaIconAsImage("boolean_mask.png");
        ICON_INDENT_DECREASE = ResourceUtil.getAlphaIconAsImage("indent_decrease.png");
        ICON_INDENT_INCREASE = ResourceUtil.getAlphaIconAsImage("indent_increase.png");
        ICON_INDENT_REMOVE = ResourceUtil.getAlphaIconAsImage("indent_remove.png");
        ICON_TOIJ = ResourceUtil.getAlphaIconAsImage("to_ij.png");
        ICON_TOICY = ResourceUtil.getAlphaIconAsImage("to_icy.png");
        ICON_PLAY = ResourceUtil.getAlphaIconAsImage("playback_play.png");
        ICON_STOP = ResourceUtil.getAlphaIconAsImage("playback_stop.png");
        ICON_PAUSE = ResourceUtil.getAlphaIconAsImage("playback_pause.png");
        ICON_PLAY_NEXT = ResourceUtil.getAlphaIconAsImage("playback_next.png");
        ICON_PLAY_PREV = ResourceUtil.getAlphaIconAsImage("playback_prev.png");
        ICON_RELOAD = ResourceUtil.getAlphaIconAsImage("playback_reload.png");
        ICON_PLUS = ResourceUtil.getAlphaIconAsImage("plus.png");
        ICON_MINUS = ResourceUtil.getAlphaIconAsImage("minus.png");
        ICON_ROUND_PLUS = ResourceUtil.getAlphaIconAsImage("round_plus.png");
        ICON_ROUND_MINUS = ResourceUtil.getAlphaIconAsImage("round_minus.png");
        ICON_ROTATE_UNCLOCK = ResourceUtil.getAlphaIconAsImage("rot_unclock.png");
        ICON_ROTATE_CLOCK = ICON_RELOAD;
        ICON_ARROW_UP = ResourceUtil.getAlphaIconAsImage("arrow_top.png");
        ICON_ARROW_LEFT = ResourceUtil.getAlphaIconAsImage("arrow_left.png");
        ICON_ARROW_RIGHT = ResourceUtil.getAlphaIconAsImage("arrow_right.png");
        ICON_ARROW_DOWN = ResourceUtil.getAlphaIconAsImage("arrow_bottom.png");
        ICON_ARROW_TOP_RIGHT = ResourceUtil.getAlphaIconAsImage("arrow_top_right.png");
        ICON_ROUND_ARROW_UP = ResourceUtil.getAlphaIconAsImage("round_arrow_up.png");
        ICON_ROUND_ARROW_LEFT = ResourceUtil.getAlphaIconAsImage("round_arrow_left.png");
        ICON_ROUND_ARROW_RIGHT = ResourceUtil.getAlphaIconAsImage("round_arrow_right.png");
        ICON_ROUND_ARROW_DOWN = ResourceUtil.getAlphaIconAsImage("round_arrow_down.png");
        ICON_SQUARE_DOWN = ResourceUtil.getAlphaIconAsImage("sq_down.png");
        ICON_SQUARE_UP = ResourceUtil.getAlphaIconAsImage("sq_up.png");
        ICON_SQUARE_PREV = ResourceUtil.getAlphaIconAsImage("sq_prev.png");
        ICON_SQUARE_NEXT = ResourceUtil.getAlphaIconAsImage("sq_next.png");
        ICON_CLEAR_BEFORE = ResourceUtil.getAlphaIconAsImage("clear_top.png");
        ICON_CLEAR_AFTER = ResourceUtil.getAlphaIconAsImage("clear_bottom.png");
        ICON_PANEL_EXPAND = ResourceUtil.getAlphaIconAsImage("br_next.png");
        ICON_PANEL_COLLAPSE = ResourceUtil.getAlphaIconAsImage("br_down.png");
        ICON_PIN = ResourceUtil.getAlphaIconAsImage("pin.png");
        ICON_NODE_EXPANDED = ResourceUtil.getAlphaIconAsImage("node_expanded.png");
        ICON_NODE_COLLAPSED = ResourceUtil.getAlphaIconAsImage("node_collapsed.png");
        ICON_BAND_RIGHT = ResourceUtil.getAlphaIconAsImage("arrow_r.png");
        ICON_BAND_LEFT = ResourceUtil.getAlphaIconAsImage("arrow_l.png");
        ICON_RESIZE = ResourceUtil.getAlphaIconAsImage("cursor_drag_arrow.png");
        ICON_RESIZE_2 = ResourceUtil.getAlphaIconAsImage("cursor_drag_arrow_2.png");
        ICON_TEXT = ResourceUtil.getAlphaIconAsImage("text_letter_t.png");
        ICON_SMILEY_HAPPY = ResourceUtil.getAlphaIconAsImage("emotion_smile.png");
        ICON_SMILEY_SAD = ResourceUtil.getAlphaIconAsImage("emotion_sad.png");
        ICON_CUBE_3D = ResourceUtil.getAlphaIconAsImage("cube.png");
        ICON_PLUGIN = ResourceUtil.getAlphaIconAsImage("plugin.png");
        ICON_BOX = ResourceUtil.getAlphaIconAsImage("box.png");
        ICON_HDD = ICON_DATABASE = ResourceUtil.getAlphaIconAsImage("db.png");
        ICON_HDD_STREAM = ResourceUtil.getAlphaIconAsImage("hdd_stream.png");
        ICON_STAR = ResourceUtil.getAlphaIconAsImage("star_fav.png");
        ICON_NETWORK = ResourceUtil.getAlphaIconAsImage("network.png");
        ICON_BROWSER = ResourceUtil.getAlphaIconAsImage("browser.png");
        ICON_CHAT = ResourceUtil.getAlphaIconAsImage("spechbubble.png");
        ICON_PHOTO = ResourceUtil.getAlphaIconAsImage("photo.png");
        ICON_PHOTO_SMALL = ResourceUtil.getAlphaIconAsImage("photo_small.png");
        ICON_NEWDOC = ICON_DOC_NEW;
        ICON_DOCCOPY = ICON_DOC_COPY;
        ICON_DOCIMPORT = ICON_DOC_IMPORT;
        ICON_DOCEXPORT = ICON_DOC_EXPORT;
        ICON_ARROW_BOTTOM = ICON_ARROW_DOWN;
        ICON_ARROW_TOP = ICON_ARROW_UP;
        ICON_EXPAND = ICON_WINDOW_EXPAND;
        ICON_COLLAPSE = ICON_WINDOW_COLLAPSE;
        ICON_ALPHA_COLOR = ResourceUtil.getColorIconAsImage("alpha.png");
        ICON_ARGB_COLOR = ResourceUtil.getColorIconAsImage("argb.png");
        ICON_RGB_COLOR = ResourceUtil.getColorIconAsImage("rgb.png");
        ICON_GRAY_COLOR = ResourceUtil.getColorIconAsImage("gray.png");
        ICON_PLUGIN_COLOR = ResourceUtil.getColorIconAsImage("plugin.png");
    }

    public static ArrayList<Image> getIcyIconImages() {
        ArrayList<Image> result = new ArrayList<Image>();
        result.add(IMAGE_ICY_256);
        result.add(IMAGE_ICY_32);
        result.add(IMAGE_ICY_16);
        return result;
    }

    private static Image scaleImage(Image image, int size) {
        if (image != null && size != -1) {
            ImageUtil.waitImageReady(image);
            if (image.getWidth(null) != size || image.getWidth(null) != size) {
                return ImageUtil.scale(image, size, size);
            }
        }
        return image;
    }

    public static Image getImage(String name) {
        URL url = ResourceUtil.class.getResource("/image/" + name);
        BufferedImage result = null;
        result = url != null ? ImageUtil.load(url, false) : ImageUtil.load(new File(IMAGE_PATH + name), false);
        int retry = 3;
        while (result == null && retry-- > 0) {
            ThreadUtil.sleep(1);
            result = url != null ? ImageUtil.load(url, false) : ImageUtil.load(new File(IMAGE_PATH + name), false);
        }
        if (result == null) {
            System.out.println("Resource name can't be found: " + name);
            return null;
        }
        return result;
    }

    public static BufferedImage getLockedImage(int number) {
        BufferedImage result = ImageUtil.getCopy(ICON_LOCK_CLOSE);
        ImageUtil.drawTextTopRight(result, StringUtil.toString(number), 26, true, Color.black);
        return result;
    }

    public static BufferedImage getLockedImage(char letter) {
        BufferedImage result = ImageUtil.getCopy(ICON_LOCK_CLOSE);
        ImageUtil.drawTextTopRight(result, String.valueOf(letter), 26, true, Color.black);
        return result;
    }

    public static Image getIconAsImage(String name, int size) {
        URL url = ResourceUtil.class.getResource("/icon/" + name);
        BufferedImage result = null;
        result = url != null ? ImageUtil.load(url, false) : ImageUtil.load(new File(ICON_PATH + name), false);
        int retry = 3;
        while (result == null && retry-- > 0) {
            ThreadUtil.sleep(1);
            result = url != null ? ImageUtil.load(url, false) : ImageUtil.load(new File(ICON_PATH + name), false);
        }
        if (result == null) {
            System.out.println("Resource name can't be found: " + name);
            return null;
        }
        return ResourceUtil.scaleImage(result, size);
    }

    public static Image getIconAsImage(String name) {
        return ResourceUtil.getIconAsImage(name, -1);
    }

    public static ImageIcon getImageIcon(Image image, int size) {
        if (image != null) {
            return new ImageIcon(ResourceUtil.scaleImage(image, size));
        }
        return null;
    }

    public static ImageIcon getImageIcon(Image image) {
        if (image != null) {
            return new ImageIcon(image);
        }
        return null;
    }

    public static ImageIcon getImageIcon(String resourceName, int size) {
        return ResourceUtil.getImageIcon(ResourceUtil.getIconAsImage(resourceName, size));
    }

    public static ImageIcon getImageIcon(String resourceName) {
        return ResourceUtil.getImageIcon(ResourceUtil.getIconAsImage(resourceName));
    }

    public static Image getAlphaIconAsImage(String resourceName, int size) {
        String finalName = resourceName.toLowerCase().endsWith(".png") ? resourceName : String.valueOf(resourceName) + ".png";
        return ResourceUtil.getIconAsImage(ALPHA_ICON_PATH + finalName, size);
    }

    public static Image getAlphaIconAsImage(String resourceName) {
        return ResourceUtil.getAlphaIconAsImage(resourceName, -1);
    }

    public static ImageIcon getAlphaIcon(String resourceName, int size) {
        String finalName = resourceName.toLowerCase().endsWith(".png") ? resourceName : String.valueOf(resourceName) + ".png";
        return ResourceUtil.getImageIcon(ResourceUtil.getIconAsImage(ALPHA_ICON_PATH + finalName, size));
    }

    public static ImageIcon getAlphaIcon(String resourceName) {
        return ResourceUtil.getAlphaIcon(resourceName, -1);
    }

    public static Image getColorIconAsImage(String resourceName, int size) {
        String finalName = resourceName.toLowerCase().endsWith(".png") ? resourceName : String.valueOf(resourceName) + ".png";
        return ResourceUtil.getIconAsImage(COLOR_ICON_PATH + finalName, size);
    }

    public static Image getColorIconAsImage(String resourceName) {
        return ResourceUtil.getColorIconAsImage(resourceName, -1);
    }

    public static ImageIcon getColorIcon(String resourceName, int size) {
        String finalName = resourceName.toLowerCase().endsWith(".png") ? resourceName : String.valueOf(resourceName) + ".png";
        return ResourceUtil.getImageIcon(ResourceUtil.getIconAsImage(COLOR_ICON_PATH + finalName, size));
    }

    public static ImageIcon getColorIcon(String resourceName) {
        return ResourceUtil.getColorIcon(resourceName, -1);
    }

    @Deprecated
    public static Image getBlackIconAsImage(String resourceName, int size) {
        return ResourceUtil.getAlphaIconAsImage(resourceName, size);
    }

    @Deprecated
    public static Image getBlackIconAsImage(String resourceName) {
        return ResourceUtil.getAlphaIconAsImage(resourceName);
    }

    @Deprecated
    public static ImageIcon getBlackIcon(String resourceName, int size) {
        return ResourceUtil.getAlphaIcon(resourceName, size);
    }

    @Deprecated
    public static ImageIcon getBlackIcon(String resourceName) {
        return ResourceUtil.getAlphaIcon(resourceName);
    }

    @Deprecated
    public static ImageIcon getWhiteIcon(String resourceName, int size) {
        return ResourceUtil.getAlphaIcon(resourceName, size);
    }

    @Deprecated
    public static ImageIcon getWhiteIcon(String resourceName) {
        return ResourceUtil.getAlphaIcon(resourceName);
    }

    @Deprecated
    public static ImageIcon getIcyIcon(String resourceName, int size) {
        return ResourceUtil.getAlphaIcon(resourceName, size);
    }

    @Deprecated
    public static ImageIcon getIcyIcon(String resourceName) {
        return ResourceUtil.getAlphaIcon(resourceName);
    }

    public static ImageIcon scaleIcon(ImageIcon icon, int size) {
        if (icon != null) {
            return ResourceUtil.getImageIcon(icon.getImage(), size);
        }
        return null;
    }
}

