/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.sequence.tools;

import icy.gui.component.button.IcyToggleButton;
import icy.resource.ResourceUtil;
import icy.resource.icon.IcyIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JPanel;

public class PositionAlignmentPanel
extends JPanel {
    private static final long serialVersionUID = -811970435734479103L;
    private PositionBox topLeftBox;
    private PositionBox topBox;
    private PositionBox topRightBox;
    private PositionBox leftBox;
    private PositionBox centerBox;
    private PositionBox rightBox;
    private PositionBox bottomLeftBox;
    private PositionBox bottomBox;
    private PositionBox bottomRightBox;
    private final ButtonGroup positionGroup;

    public PositionAlignmentPanel() {
        this.initialize();
        this.positionGroup = new ButtonGroup();
        this.positionGroup.add(this.topLeftBox);
        this.positionGroup.add(this.topBox);
        this.positionGroup.add(this.topRightBox);
        this.positionGroup.add(this.leftBox);
        this.positionGroup.add(this.centerBox);
        this.positionGroup.add(this.rightBox);
        this.positionGroup.add(this.bottomLeftBox);
        this.positionGroup.add(this.bottomBox);
        this.positionGroup.add(this.bottomRightBox);
        this.centerBox.setSelected(true);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PositionAlignmentPanel.this.fireActionPerformed(e);
            }
        };
        this.topLeftBox.addActionListener(listener);
        this.topBox.addActionListener(listener);
        this.topRightBox.addActionListener(listener);
        this.leftBox.addActionListener(listener);
        this.centerBox.addActionListener(listener);
        this.rightBox.addActionListener(listener);
        this.bottomLeftBox.addActionListener(listener);
        this.bottomBox.addActionListener(listener);
        this.bottomRightBox.addActionListener(listener);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.topLeftBox.setEnabled(enabled);
        this.topBox.setEnabled(enabled);
        this.topRightBox.setEnabled(enabled);
        this.leftBox.setEnabled(enabled);
        this.centerBox.setEnabled(enabled);
        this.rightBox.setEnabled(enabled);
        this.bottomLeftBox.setEnabled(enabled);
        this.bottomBox.setEnabled(enabled);
        this.bottomRightBox.setEnabled(enabled);
    }

    public int getXAlign() {
        ButtonModel model = this.positionGroup.getSelection();
        if (model == this.topLeftBox.getModel() || model == this.leftBox.getModel() || model == this.bottomLeftBox.getModel()) {
            return 2;
        }
        if (model == this.topBox.getModel() || model == this.centerBox.getModel() || model == this.bottomBox.getModel()) {
            return 0;
        }
        return 4;
    }

    public int getYAlign() {
        ButtonModel model = this.positionGroup.getSelection();
        if (model == this.topLeftBox.getModel() || model == this.topBox.getModel() || model == this.topRightBox.getModel()) {
            return 1;
        }
        if (model == this.leftBox.getModel() || model == this.centerBox.getModel() || model == this.rightBox.getModel()) {
            return 0;
        }
        return 3;
    }

    protected void fireActionPerformed(ActionEvent event) {
        ActionListener[] actionListenerArray = this.getActionListeners();
        int n = actionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionListener listener = actionListenerArray[n2];
            listener.actionPerformed(new ActionEvent(this, 1001, event.getActionCommand(), event.getWhen(), event.getModifiers()));
            ++n2;
        }
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.listenerList.getListeners(ActionListener.class);
    }

    private void initialize() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[4];
        gridBagLayout.rowHeights = new int[4];
        gridBagLayout.columnWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        this.topLeftBox = new PositionBox();
        this.topLeftBox.setToolTipText("Align content to top left");
        GridBagConstraints gbc_topLeftBox = new GridBagConstraints();
        gbc_topLeftBox.insets = new Insets(0, 0, 5, 5);
        gbc_topLeftBox.gridx = 0;
        gbc_topLeftBox.gridy = 0;
        this.add((Component)this.topLeftBox, gbc_topLeftBox);
        this.topBox = new PositionBox();
        this.topBox.setToolTipText("Align content to top");
        GridBagConstraints gbc_topBox = new GridBagConstraints();
        gbc_topBox.insets = new Insets(0, 0, 5, 5);
        gbc_topBox.gridx = 1;
        gbc_topBox.gridy = 0;
        this.add((Component)this.topBox, gbc_topBox);
        this.topRightBox = new PositionBox();
        this.topRightBox.setToolTipText("Align content to top right");
        GridBagConstraints gbc_topRightBox = new GridBagConstraints();
        gbc_topRightBox.insets = new Insets(0, 0, 5, 0);
        gbc_topRightBox.gridx = 2;
        gbc_topRightBox.gridy = 0;
        this.add((Component)this.topRightBox, gbc_topRightBox);
        this.leftBox = new PositionBox();
        this.leftBox.setToolTipText("Align content to left");
        GridBagConstraints gbc_leftBox = new GridBagConstraints();
        gbc_leftBox.insets = new Insets(0, 0, 5, 5);
        gbc_leftBox.gridx = 0;
        gbc_leftBox.gridy = 1;
        this.add((Component)this.leftBox, gbc_leftBox);
        this.centerBox = new PositionBox();
        this.centerBox.setToolTipText("Align content to center");
        GridBagConstraints gbc_centerBox = new GridBagConstraints();
        gbc_centerBox.insets = new Insets(0, 0, 5, 5);
        gbc_centerBox.gridx = 1;
        gbc_centerBox.gridy = 1;
        this.add((Component)this.centerBox, gbc_centerBox);
        this.rightBox = new PositionBox();
        this.rightBox.setToolTipText("Align content to right");
        GridBagConstraints gbc_rightBox = new GridBagConstraints();
        gbc_rightBox.insets = new Insets(0, 0, 5, 0);
        gbc_rightBox.gridx = 2;
        gbc_rightBox.gridy = 1;
        this.add((Component)this.rightBox, gbc_rightBox);
        this.bottomLeftBox = new PositionBox();
        this.bottomLeftBox.setToolTipText("Align content to bottom left");
        GridBagConstraints gbc_bottomLeftBox = new GridBagConstraints();
        gbc_bottomLeftBox.insets = new Insets(0, 0, 0, 5);
        gbc_bottomLeftBox.gridx = 0;
        gbc_bottomLeftBox.gridy = 2;
        this.add((Component)this.bottomLeftBox, gbc_bottomLeftBox);
        this.bottomBox = new PositionBox();
        this.bottomBox.setToolTipText("Align content to bottom");
        GridBagConstraints gbc_bottomBox = new GridBagConstraints();
        gbc_bottomBox.insets = new Insets(0, 0, 0, 5);
        gbc_bottomBox.gridx = 1;
        gbc_bottomBox.gridy = 2;
        this.add((Component)this.bottomBox, gbc_bottomBox);
        this.bottomRightBox = new PositionBox();
        this.bottomRightBox.setToolTipText("Align content to bottom right");
        GridBagConstraints gbc_bottomRightBox = new GridBagConstraints();
        gbc_bottomRightBox.gridx = 2;
        gbc_bottomRightBox.gridy = 2;
        this.add((Component)this.bottomRightBox, gbc_bottomRightBox);
    }

    public static class PositionBox
    extends IcyToggleButton {
        private static final long serialVersionUID = -6952409965950366299L;

        public PositionBox() {
            super(new IcyIcon(ResourceUtil.ICON_NULL, 16));
            this.setSelectedIcon((Icon)((Object)new IcyIcon(ResourceUtil.ICON_PICTURE, 16)));
            this.setBorder(BorderFactory.createLineBorder(Color.black));
            this.setFocusPainted(false);
        }
    }
}

