/*
 * Decompiled with CFR 0.152.
 */
package icy.preferences;

import icy.preferences.WorkspacePreferences;
import icy.preferences.XMLPreferences;
import icy.workspace.Workspace;
import java.util.ArrayList;

public class WorkspaceLocalPreferences {
    private static final String PREF_ID = "local";
    private static final String ID_ACTIVES = "actives";
    private static XMLPreferences preferences;

    public static void load() {
        preferences = WorkspacePreferences.getPreferences().node(PREF_ID);
    }

    public static XMLPreferences getPreferences() {
        return preferences;
    }

    public static ArrayList<String> getActivesWorkspace() {
        ArrayList<String> result = new ArrayList<String>();
        if (preferences.nodeExists(ID_ACTIVES)) {
            XMLPreferences activesNode = preferences.node(ID_ACTIVES);
            for (String name : activesNode.keys()) {
                if (!activesNode.getBoolean(name, false)) continue;
                result.add(name);
            }
        } else {
            String[] stringArray = Workspace.DEFAULT_ACTIVE_WORKSPACES;
            int n = Workspace.DEFAULT_ACTIVE_WORKSPACES.length;
            int n2 = 0;
            while (n2 < n) {
                String workspaceName = stringArray[n2];
                result.add(workspaceName);
                ++n2;
            }
        }
        return result;
    }

    public static void setActivesWorkspace(ArrayList<String> names) {
        XMLPreferences activesNode = preferences.node(ID_ACTIVES);
        activesNode.clear();
        for (String name : names) {
            activesNode.putBoolean(name, true);
        }
        activesNode.clean();
    }

    public static boolean isWorkspaceEnable(String workspaceName) {
        return WorkspaceLocalPreferences.getActivesWorkspace().contains(workspaceName);
    }

    public static void setWorkspaceEnable(String workspaceName, boolean value) {
        ArrayList<String> activesWorkspace = WorkspaceLocalPreferences.getActivesWorkspace();
        if (value) {
            if (!activesWorkspace.contains(workspaceName)) {
                activesWorkspace.add(workspaceName);
            }
        } else {
            activesWorkspace.remove(workspaceName);
        }
        WorkspaceLocalPreferences.setActivesWorkspace(activesWorkspace);
    }
}

