/*
 * Decompiled with CFR 0.152.
 */
package org.libjpegturbo.turbojpeg;

import org.libjpegturbo.turbojpeg.TJ;
import org.libjpegturbo.turbojpeg.TJDecompressor;
import org.libjpegturbo.turbojpeg.TJLoader;
import org.libjpegturbo.turbojpeg.TJTransform;

public class TJTransformer
extends TJDecompressor {
    private int[] transformedSizes = null;

    public TJTransformer() throws Exception {
        this.init();
    }

    public TJTransformer(byte[] jpegImage) throws Exception {
        this.init();
        this.setJPEGImage(jpegImage, jpegImage.length);
    }

    public TJTransformer(byte[] jpegImage, int imageSize) throws Exception {
        this.init();
        this.setJPEGImage(jpegImage, imageSize);
    }

    public void transform(byte[][] dstBufs, TJTransform[] transforms, int flags) throws Exception {
        if (this.jpegBuf == null) {
            throw new Exception("JPEG buffer not initialized");
        }
        this.transformedSizes = this.transform(this.jpegBuf, this.jpegBufSize, dstBufs, transforms, flags);
    }

    public TJDecompressor[] transform(TJTransform[] transforms, int flags) throws Exception {
        byte[][] dstBufs = new byte[transforms.length][];
        if (this.jpegWidth < 1 || this.jpegHeight < 1) {
            throw new Exception("JPEG buffer not initialized");
        }
        for (int i = 0; i < transforms.length; ++i) {
            int w = this.jpegWidth;
            int h2 = this.jpegHeight;
            if ((transforms[i].options & 4) != 0) {
                if (transforms[i].width != 0) {
                    w = transforms[i].width;
                }
                if (transforms[i].height != 0) {
                    h2 = transforms[i].height;
                }
            }
            dstBufs[i] = new byte[TJ.bufSize(w, h2, this.jpegSubsamp)];
        }
        TJDecompressor[] tjd = new TJDecompressor[transforms.length];
        this.transform(dstBufs, transforms, flags);
        for (int i = 0; i < transforms.length; ++i) {
            tjd[i] = new TJDecompressor(dstBufs[i], this.transformedSizes[i]);
        }
        return tjd;
    }

    public int[] getTransformedSizes() throws Exception {
        if (this.transformedSizes == null) {
            throw new Exception("No image has been transformed yet");
        }
        return this.transformedSizes;
    }

    private native void init() throws Exception;

    private native int[] transform(byte[] var1, int var2, byte[][] var3, TJTransform[] var4, int var5) throws Exception;

    static {
        TJLoader.load();
    }
}

