/*
 * Decompiled with CFR 0.152.
 */
package plugins.ylemontag.mathoperations;

import javax.swing.JComponent;
import plugins.adufour.vars.gui.VarEditor;
import plugins.adufour.vars.gui.swing.SwingVarEditor;
import plugins.adufour.vars.lang.Var;
import plugins.ylemontag.mathoperations.Expression;
import plugins.ylemontag.mathoperations.ExpressionComponent;

public class VarExpression
extends Var<Expression> {
    public VarExpression(String name, Expression defaultValue) {
        super(name, Expression.class, (Object)defaultValue);
    }

    public VarEditor<Expression> createVarEditor() {
        return new Editor(this);
    }

    public Expression parse(String text) {
        if (text.equals("null")) {
            return null;
        }
        try {
            return Expression.parse(text);
        }
        catch (Expression.ParsingException e) {
            return null;
        }
    }

    private static class Editor
    extends SwingVarEditor<Expression> {
        private ExpressionComponent _component;
        private boolean _shuntVariableUpdate = false;
        private boolean _shuntComponentUpdate = false;

        public Editor(Var<Expression> variable) {
            super(variable);
        }

        protected JComponent createEditorComponent() {
            this._component = new ExpressionComponent();
            this._component.addValueListener(new ExpressionComponent.ValueListener(){

                @Override
                public void valueChanged(Expression newValue) {
                    if (_shuntVariableUpdate) {
                        return;
                    }
                    _shuntComponentUpdate = true;
                    variable.setValue((Object)newValue);
                    _shuntComponentUpdate = false;
                }
            });
            return this._component;
        }

        protected void activateListeners() {
            this._shuntVariableUpdate = false;
        }

        protected void deactivateListeners() {
            this._shuntVariableUpdate = true;
        }

        protected void updateInterfaceValue() {
            if (this._shuntComponentUpdate) {
                return;
            }
            this._component.setValue((Expression)this.variable.getValue());
        }
    }
}

