/*
 * Decompiled with CFR 0.152.
 */
package mitiv.optim;

import mitiv.exception.IllegalLinearOperationException;
import mitiv.exception.IncorrectSpaceException;
import mitiv.linalg.LinearEndomorphism;
import mitiv.linalg.LinearOperator;
import mitiv.linalg.Vector;
import mitiv.linalg.VectorSpace;

public class LBFGSOperator
extends LinearEndomorphism {
    static final int NO_SCALING = 0;
    static final int OREN_SPEDICATO_SCALING = 1;
    static final int BARZILAI_BORWEIN_SCALING = 2;
    static final int CONSTANT_SCALING = 4;
    protected Vector[] s;
    protected Vector[] y;
    protected final int m;
    protected int mp;
    protected int updates;
    protected double[] rho;
    protected double gamma;
    protected double[] alpha;
    protected LinearOperator H0;
    protected int rule = 1;

    public LBFGSOperator(VectorSpace space, int m) {
        super(space);
        this.m = m;
        this.H0 = null;
        this.allocateWorkspace();
    }

    public LBFGSOperator(LinearEndomorphism H0, int m) {
        super(H0.getSpace());
        this.m = m;
        this.H0 = H0;
        this.allocateWorkspace();
    }

    private void allocateWorkspace() {
        this.s = new Vector[this.m];
        this.y = new Vector[this.m];
        for (int i = 0; i < this.m; ++i) {
            this.s[i] = this.space.create();
            this.y[i] = this.space.create();
        }
        this.alpha = new double[this.m];
        this.rho = new double[this.m];
        this.mp = 0;
        this.updates = 0;
        this.gamma = 1.0;
    }

    public void reset() {
        this.mp = 0;
    }

    public void setScaling(int value) {
        this.rule = value;
    }

    public int getScaling() {
        return this.rule;
    }

    public void setScale(double value) {
        if (value <= 0.0) {
            throw new IllegalArgumentException("scale factor must be strictly positive");
        }
        this.gamma = value;
        this.rule = 4;
    }

    public double getScale() {
        return this.gamma;
    }

    protected int slot(int j) {
        if (j < 0 || j > this.mp) {
            throw new IndexOutOfBoundsException("BFGS slot index is out of bounds");
        }
        return (this.updates - j) % this.m;
    }

    protected Vector s(int j) {
        return this.s[this.slot(j)];
    }

    protected Vector y(int j) {
        return this.y[this.slot(j)];
    }

    private boolean applyInPlace(Vector vec) {
        int k;
        int j;
        for (j = 1; j <= this.mp; ++j) {
            k = this.slot(j);
            if (!(this.rho[k] > 0.0)) continue;
            this.alpha[k] = this.rho[k] * vec.dot(this.s[k]);
            vec.add(-this.alpha[k], this.y[k]);
        }
        if (this.H0 != null) {
            this.H0.apply(vec, vec);
        } else if (this.gamma != 1.0) {
            vec.scale(this.gamma);
        }
        for (j = this.mp; j >= 1; --j) {
            k = this.slot(j);
            if (!(this.rho[k] > 0.0)) continue;
            double beta = this.rho[k] * vec.dot(this.y[k]);
            vec.add(this.alpha[k] - beta, this.s[k]);
        }
        return true;
    }

    private boolean applyInPlace(Vector wgt, Vector vec) {
        int k;
        int j;
        boolean flag = this.H0 == null;
        this.gamma = 0.0;
        for (j = 1; j <= this.mp; ++j) {
            double yty;
            k = this.slot(j);
            double sty = wgt.dot(this.y[k], this.s[k]);
            if (sty <= 0.0) {
                this.rho[k] = 0.0;
                continue;
            }
            this.rho[k] = 1.0 / sty;
            this.alpha[k] = this.rho[k] * wgt.dot(vec, this.s[k]);
            vec.add(-this.alpha[k], this.y[k]);
            if (!flag || !((yty = wgt.dot(this.y[k], this.y[k])) > 0.0)) continue;
            this.gamma = sty / yty;
            flag = false;
        }
        if (flag) {
            return false;
        }
        if (this.H0 != null) {
            this.H0.apply(vec, vec);
        } else if (this.gamma != 1.0) {
            vec.scale(this.gamma);
        }
        for (j = this.mp; j >= 1; --j) {
            k = this.slot(j);
            if (!(this.rho[k] > 0.0)) continue;
            double beta = this.rho[k] * wgt.dot(vec, this.y[k]);
            vec.add(this.alpha[k] - beta, this.s[k]);
        }
        return true;
    }

    public boolean apply(Vector wgt, Vector vec, Vector dst) {
        if (wgt != null && !wgt.belongsTo(this.space) || !vec.belongsTo(this.space) || !dst.belongsTo(this.space)) {
            throw new IncorrectSpaceException();
        }
        if (this.mp < 1) {
            return false;
        }
        if (vec != dst) {
            dst.copy(vec);
        }
        if (wgt == null) {
            return this.applyInPlace(vec);
        }
        return this.applyInPlace(wgt, vec);
    }

    @Override
    protected void _apply(Vector dst, Vector src, int job) {
        if (job != DIRECT && job != ADJOINT) {
            throw new IllegalLinearOperationException();
        }
        if (dst != src) {
            dst.copy(src);
        }
        this.applyInPlace(dst);
    }

    public void update(Vector x1, Vector x0, Vector g1, Vector g0) throws IncorrectSpaceException {
        this.update(x1, x0, g1, g0, false);
    }

    public void update(Vector x1, Vector x0, Vector g1, Vector g0, boolean partial) throws IncorrectSpaceException {
        int k = this.slot(0);
        this.s[k].combine(1.0, x1, -1.0, x0);
        this.y[k].combine(1.0, g1, -1.0, g0);
        if (partial) {
            this.rho[k] = 0.0;
            this.gamma = 0.0;
        } else {
            double sty = this.s[k].dot(this.y[k]);
            if (sty <= 0.0) {
                this.rho[k] = 0.0;
                return;
            }
            this.rho[k] = 1.0 / sty;
            if (this.rule == 1 || this.rule == 5 && this.updates == 0) {
                double ynorm = this.y[k].norm2();
                this.gamma = sty / ynorm / ynorm;
            } else if (this.rule == 2 || this.rule == 6 && this.updates == 0) {
                double snorm = this.s[k].norm2();
                this.gamma = snorm / sty * snorm;
            }
        }
        ++this.updates;
        if (this.mp < this.m) {
            ++this.mp;
        }
    }
}

