/*
 * Decompiled with CFR 0.152.
 */
package icy.action;

import icy.action.IcyAbstractAction;
import icy.clipboard.Clipboard;
import icy.file.FileUtil;
import icy.gui.dialog.IdConfirmDialog;
import icy.gui.dialog.MessageDialog;
import icy.gui.dialog.OpenDialog;
import icy.gui.dialog.SaveDialog;
import icy.gui.inspector.RoisPanel;
import icy.gui.main.MainFrame;
import icy.main.Icy;
import icy.resource.ResourceUtil;
import icy.resource.icon.IcyIcon;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.roi.ROI3D;
import icy.roi.ROI4D;
import icy.roi.ROIUtil;
import icy.sequence.Sequence;
import icy.sequence.SequenceDataIterator;
import icy.sequence.edit.ROIAddSequenceEdit;
import icy.sequence.edit.ROIAddsSequenceEdit;
import icy.sequence.edit.ROIReplacesSequenceEdit;
import icy.system.IcyHandledException;
import icy.system.SystemUtil;
import icy.type.DataIterator;
import icy.type.DataIteratorUtil;
import icy.type.dimension.Dimension3D;
import icy.type.dimension.Dimension5D;
import icy.type.rectangle.Rectangle5D;
import icy.undo.IcyUndoableEdit;
import icy.util.ClassUtil;
import icy.util.ShapeUtil;
import icy.util.StringUtil;
import icy.util.XLSUtil;
import icy.util.XMLUtil;
import java.awt.event.ActionEvent;
import java.awt.geom.Rectangle2D;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import org.w3c.dom.Document;
import plugins.kernel.roi.roi2d.ROI2DPoint;
import plugins.kernel.roi.roi2d.ROI2DRectangle;
import plugins.kernel.roi.roi3d.ROI3DStackRectangle;
import plugins.kernel.roi.roi4d.ROI4DStackRectangle;
import plugins.kernel.roi.roi5d.ROI5DStackRectangle;

public class RoiActions {
    public static final String DEFAULT_ROI_DIR = "roi";
    public static final String DEFAULT_ROI_NAME = "roi.xml";
    public static IcyAbstractAction loadAction = new IcyAbstractAction("Load ROI(s)", new IcyIcon(ResourceUtil.ICON_OPEN), "Load ROI(s) from file", "Load ROI(s) from a XML file and add them to the active sequence"){
        private static final long serialVersionUID = 2378084039864016238L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean doAction(ActionEvent e) {
            Document doc;
            String filename = OpenDialog.chooseFile((String)"Load roi(s)...", (String)RoiActions.DEFAULT_ROI_DIR, (String)RoiActions.DEFAULT_ROI_NAME);
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            if (filename != null && sequence != null && (doc = XMLUtil.loadDocument(filename)) != null) {
                List<ROI> rois = ROI.loadROIsFromXML(XMLUtil.getRootElement(doc));
                sequence.beginUpdate();
                try {
                    for (ROI roi : rois) {
                        sequence.addROI(roi);
                    }
                }
                finally {
                    sequence.endUpdate();
                }
                sequence.addUndoableEdit((IcyUndoableEdit)new ROIAddsSequenceEdit(sequence, rois){

                    public String getPresentationName() {
                        if (this.getROIs().size() > 1) {
                            return "ROIs loaded from XML file";
                        }
                        return "ROI loaded from XML file";
                    }
                });
                return true;
            }
            return false;
        }

        public boolean isEnabled() {
            return super.isEnabled() && Icy.getMainInterface().getActiveSequence() != null;
        }
    };
    public static IcyAbstractAction saveAction = new IcyAbstractAction("Save ROI(s)", new IcyIcon(ResourceUtil.ICON_SAVE), "Save selected ROI(s) to file", "Save the selected ROI(s) from active sequence into a XML file"){
        private static final long serialVersionUID = 349358870716619748L;

        public boolean doAction(ActionEvent e) {
            Document doc;
            ArrayList rois;
            String filename = SaveDialog.chooseFile((String)"Save roi(s)...", (String)RoiActions.DEFAULT_ROI_DIR, (String)RoiActions.DEFAULT_ROI_NAME);
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            if (filename != null && sequence != null && (rois = sequence.getSelectedROIs()).size() > 0 && (doc = XMLUtil.createDocument(true)) != null) {
                ROI.saveROIsToXML(XMLUtil.getRootElement(doc), rois);
                XMLUtil.saveDocument(doc, filename);
                return true;
            }
            return false;
        }

        public boolean isEnabled() {
            return super.isEnabled() && Icy.getMainInterface().getActiveSequence() != null;
        }
    };
    public static IcyAbstractAction copyAction = new IcyAbstractAction("Copy", new IcyIcon(ResourceUtil.ICON_COPY), "Copy selected ROI to clipboard (Ctrl+C)", 67, SystemUtil.getMenuCtrlMask()){
        private static final long serialVersionUID = -4716027958152503425L;

        public boolean doAction(ActionEvent e) {
            ArrayList rois;
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            if (sequence != null && (rois = sequence.getSelectedROIs()).size() > 0) {
                for (int i = 0; i < rois.size(); ++i) {
                    ROI roi = ((ROI)rois.get(i)).getCopy();
                    if (roi == null) continue;
                    rois.set(i, roi);
                }
                Clipboard.put((String)"SequenceRoiList", (Object)new SequenceRoiList(sequence, rois));
                Clipboard.clearSystem();
                pasteAction.setEnabled(true);
                return true;
            }
            return false;
        }

        public boolean isEnabled() {
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            return super.isEnabled() && sequence != null && sequence.getSelectedROIs().size() > 0;
        }
    };
    public static IcyAbstractAction copyLinkAction = new IcyAbstractAction("Copy link", new IcyIcon(ResourceUtil.ICON_LINK_COPY), "Copy link of selected ROI to clipboard (Alt+C)", 67, 8){
        private static final long serialVersionUID = -4716027958152503425L;

        public boolean doAction(ActionEvent e) {
            List rois;
            RoisPanel roisPanel = Icy.getMainInterface().getRoisPanel();
            if (roisPanel != null && (rois = roisPanel.getSelectedRois()).size() > 0) {
                Clipboard.put((String)"RoiLinkList", (Object)rois);
                Clipboard.clearSystem();
                pasteLinkAction.setEnabled(true);
                return true;
            }
            return false;
        }

        public boolean isEnabled() {
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            return super.isEnabled() && sequence != null && sequence.getSelectedROIs().size() > 0;
        }
    };
    public static IcyAbstractAction pasteAction = new IcyAbstractAction("Paste", new IcyIcon(ResourceUtil.ICON_PASTE), "Paste ROI from clipboard (Ctrl+V)", 86, SystemUtil.getMenuCtrlMask()){
        private static final long serialVersionUID = 4878585451006567513L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean doAction(ActionEvent e) {
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            if (sequence != null) {
                SequenceRoiList sequenceRoiList = (SequenceRoiList)Clipboard.get((String)"SequenceRoiList");
                Sequence sequenceSrc = sequenceRoiList.sequence;
                List<ROI> rois = sequenceRoiList.rois;
                if (rois != null && rois.size() > 0) {
                    ArrayList<ROI> copyRois = new ArrayList<ROI>();
                    sequence.beginUpdate();
                    try {
                        sequence.setSelectedROI(null);
                        for (ROI roi : rois) {
                            ROI newROI = ROIUtil.adjustToSequence(roi, sequenceSrc, sequence, true, true, true);
                            if (newROI == null) continue;
                            copyRois.add(newROI);
                            newROI.setSelected(true);
                            sequence.addROI(newROI);
                        }
                    }
                    finally {
                        sequence.endUpdate();
                    }
                    sequence.addUndoableEdit((IcyUndoableEdit)new ROIAddsSequenceEdit(sequence, copyRois){

                        public String getPresentationName() {
                            if (this.getROIs().size() > 1) {
                                return "ROIs added from clipboard";
                            }
                            return "ROI added from clipboard";
                        }
                    });
                    return true;
                }
            }
            return false;
        }

        public boolean isEnabled() {
            return super.isEnabled() && Icy.getMainInterface().getActiveSequence() != null && Clipboard.getType().equals("SequenceRoiList");
        }
    };
    public static IcyAbstractAction pasteLinkAction = new IcyAbstractAction("Paste link", new IcyIcon(ResourceUtil.ICON_LINK_PASTE), "Paste ROI link from clipboard (Alt+V)", 86, 8){
        private static final long serialVersionUID = 4878585451006567513L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean doAction(ActionEvent e) {
            List rois;
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            if (sequence != null && (rois = (List)Clipboard.get((String)"RoiLinkList")) != null && rois.size() > 0) {
                sequence.beginUpdate();
                try {
                    for (ROI roi : rois) {
                        sequence.addROI(roi);
                    }
                }
                finally {
                    sequence.endUpdate();
                }
                sequence.addUndoableEdit((IcyUndoableEdit)new ROIAddsSequenceEdit(sequence, rois){

                    public String getPresentationName() {
                        if (this.getROIs().size() > 1) {
                            return "ROIs linked from clipboard";
                        }
                        return "ROI linked from clipboard";
                    }
                });
                return true;
            }
            return false;
        }

        public boolean isEnabled() {
            return super.isEnabled() && Icy.getMainInterface().getActiveSequence() != null && Clipboard.getType().equals("RoiLinkList");
        }
    };
    public static IcyAbstractAction selectAllAction = new IcyAbstractAction("SelectAll", null, "Select all ROI(s)"){
        private static final long serialVersionUID = 3219000949426093919L;

        public boolean doAction(ActionEvent e) {
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            if (sequence != null) {
                sequence.setSelectedROIs((List)sequence.getROIs());
                return true;
            }
            return false;
        }

        public boolean isEnabled() {
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            return super.isEnabled() && sequence != null && sequence.getROIs().size() > 0;
        }
    };
    public static IcyAbstractAction unselectAction = new IcyAbstractAction("Unselect", null, "Unselect ROI(s)", 27){
        private static final long serialVersionUID = -6136680076368815566L;

        public boolean doAction(ActionEvent e) {
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            if (sequence != null) {
                sequence.setSelectedROI(null);
                return true;
            }
            return false;
        }

        public boolean isEnabled() {
            return super.isEnabled() && Icy.getMainInterface().getActiveSequence() != null;
        }
    };
    public static IcyAbstractAction deleteAction = new IcyAbstractAction("Delete", new IcyIcon(ResourceUtil.ICON_DELETE), "Delete selected ROI(s)", "Delete selected ROI(s) from the active sequence", 127, 0){
        private static final long serialVersionUID = 9079403002834893222L;

        public boolean doAction(ActionEvent e) {
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            if (sequence != null) {
                sequence.removeSelectedROIs(true, true);
                return true;
            }
            return false;
        }

        public boolean isEnabled() {
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            return super.isEnabled() && sequence != null && sequence.getSelectedROIs().size() > 0;
        }
    };
    public static IcyAbstractAction boolNotAction = new IcyAbstractAction("Inversion", new IcyIcon(ResourceUtil.ICON_ROI_NOT), "Boolean inversion operation", "Create a new ROI representing the inverse of selected ROI", true, "Computing inverse..."){
        private static final long serialVersionUID = 6360796066188754099L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean doAction(ActionEvent e) {
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            RoisPanel roisPanel = Icy.getMainInterface().getRoisPanel();
            if (sequence != null && roisPanel != null) {
                sequence.beginUpdate();
                try {
                    Object seqRoi;
                    List selectedROI = roisPanel.getSelectedRois();
                    if (selectedROI.size() != 1) {
                        boolean bl = false;
                        return bl;
                    }
                    ROI roi = (ROI)selectedROI.get(0);
                    switch (roi.getDimension()) {
                        case 2: {
                            ROI2D roi2d = (ROI2D)roi;
                            ROI2DRectangle seqRoi2d = new ROI2DRectangle((Rectangle2D)sequence.getBounds2D());
                            seqRoi2d.setZ(roi2d.getZ());
                            seqRoi2d.setT(roi2d.getT());
                            seqRoi2d.setC(roi2d.getC());
                            seqRoi = seqRoi2d;
                            break;
                        }
                        case 3: {
                            ROI3D roi3d = (ROI3D)roi;
                            ROI3DStackRectangle seqRoi3d = new ROI3DStackRectangle(sequence.getBounds5D().toRectangle3D());
                            seqRoi3d.setT(roi3d.getT());
                            seqRoi3d.setC(roi3d.getC());
                            seqRoi = seqRoi3d;
                            break;
                        }
                        case 4: {
                            ROI4D roi4d = (ROI4D)roi;
                            ROI4DStackRectangle seqRoi4d = new ROI4DStackRectangle(sequence.getBounds5D().toRectangle4D());
                            seqRoi4d.setC(roi4d.getC());
                            seqRoi = seqRoi4d;
                            break;
                        }
                        case 5: {
                            seqRoi = new ROI5DStackRectangle((Rectangle5D)sequence.getBounds5D());
                            break;
                        }
                        default: {
                            seqRoi = null;
                        }
                    }
                    if (seqRoi != null) {
                        ROI mergeROI = ROIUtil.subtract((ROI)seqRoi, roi);
                        if (mergeROI != null) {
                            mergeROI.setName("Inverse");
                            sequence.addROI(mergeROI);
                            sequence.setSelectedROI(mergeROI);
                            sequence.addUndoableEdit((IcyUndoableEdit)new ROIAddSequenceEdit(sequence, mergeROI, "ROI Inverse"));
                        }
                    } else {
                        MessageDialog.showDialog((String)"Operation not supported", (String)"Input ROI has incorrect dimension !", (int)0);
                    }
                }
                catch (UnsupportedOperationException ex) {
                    MessageDialog.showDialog((String)"Operation not supported", (String)ex.getLocalizedMessage(), (int)0);
                }
                finally {
                    sequence.endUpdate();
                }
                return true;
            }
            return false;
        }

        public boolean isEnabled() {
            return super.isEnabled() && Icy.getMainInterface().getActiveSequence() != null;
        }
    };
    public static IcyAbstractAction boolOrAction = new IcyAbstractAction("Union", new IcyIcon(ResourceUtil.ICON_ROI_OR), "Boolean union operation", "Create a new ROI representing the union of selected ROIs", true, "Computing union..."){
        private static final long serialVersionUID = 1861052712498233441L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean doAction(ActionEvent e) {
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            RoisPanel roisPanel = Icy.getMainInterface().getRoisPanel();
            if (sequence != null && roisPanel != null) {
                sequence.beginUpdate();
                try {
                    List selectedROIs = roisPanel.getSelectedRois();
                    ROI mergeROI = ROIUtil.getUnion(selectedROIs);
                    if (mergeROI != null) {
                        mergeROI.setName("Union");
                        sequence.addROI(mergeROI);
                        sequence.setSelectedROI(mergeROI);
                        sequence.addUndoableEdit((IcyUndoableEdit)new ROIAddSequenceEdit(sequence, mergeROI, "ROI Union"));
                    }
                }
                catch (UnsupportedOperationException ex) {
                    MessageDialog.showDialog((String)"Operation not supported", (String)ex.getLocalizedMessage(), (int)0);
                }
                finally {
                    sequence.endUpdate();
                }
                return true;
            }
            return false;
        }

        public boolean isEnabled() {
            return super.isEnabled() && Icy.getMainInterface().getActiveSequence() != null;
        }
    };
    public static IcyAbstractAction boolAndAction = new IcyAbstractAction("Intersection", new IcyIcon(ResourceUtil.ICON_ROI_AND), "Boolean intersection operation", "Create a new ROI representing the intersection of selected ROIs", true, "Computing intersection..."){
        private static final long serialVersionUID = -9103158044679039413L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean doAction(ActionEvent e) {
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            RoisPanel roisPanel = Icy.getMainInterface().getRoisPanel();
            if (sequence != null && roisPanel != null) {
                sequence.beginUpdate();
                try {
                    List selectedROIs = roisPanel.getSelectedRois();
                    ROI mergeROI = ROIUtil.getIntersection(selectedROIs);
                    if (mergeROI != null) {
                        mergeROI.setName("Intersection");
                        sequence.addROI(mergeROI);
                        sequence.setSelectedROI(mergeROI);
                        sequence.addUndoableEdit((IcyUndoableEdit)new ROIAddSequenceEdit(sequence, mergeROI, "ROI Intersection"));
                    }
                }
                catch (UnsupportedOperationException ex) {
                    MessageDialog.showDialog((String)"Operation not supported", (String)ex.getLocalizedMessage(), (int)0);
                }
                finally {
                    sequence.endUpdate();
                }
                return true;
            }
            return false;
        }

        public boolean isEnabled() {
            return super.isEnabled() && Icy.getMainInterface().getActiveSequence() != null;
        }
    };
    public static IcyAbstractAction boolXorAction = new IcyAbstractAction("Exclusive union", new IcyIcon(ResourceUtil.ICON_ROI_XOR), "Boolean exclusive union operation", "Create a new ROI representing the exclusive union of selected ROIs", true, "Computing exclusive union..."){
        private static final long serialVersionUID = 1609345474914807703L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean doAction(ActionEvent e) {
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            RoisPanel roisPanel = Icy.getMainInterface().getRoisPanel();
            if (sequence != null && roisPanel != null) {
                sequence.beginUpdate();
                try {
                    List selectedROIs = roisPanel.getSelectedRois();
                    ROI mergeROI = ROIUtil.getExclusiveUnion(selectedROIs);
                    if (mergeROI != null) {
                        mergeROI.setName("Exclusive union");
                        sequence.addROI(mergeROI);
                        sequence.setSelectedROI(mergeROI);
                        sequence.addUndoableEdit((IcyUndoableEdit)new ROIAddSequenceEdit(sequence, mergeROI, "ROI Exclusive Union"));
                    }
                }
                catch (UnsupportedOperationException ex) {
                    MessageDialog.showDialog((String)"Operation not supported", (String)ex.getLocalizedMessage(), (int)0);
                }
                finally {
                    sequence.endUpdate();
                }
                return true;
            }
            return false;
        }

        public boolean isEnabled() {
            return super.isEnabled() && Icy.getMainInterface().getActiveSequence() != null;
        }
    };
    public static IcyAbstractAction boolSubtractAction = new IcyAbstractAction("Subtraction", new IcyIcon(ResourceUtil.ICON_ROI_SUB), "Boolean subtraction", "Create 2 ROIs representing the result of (A - B) and (B - A)", true, "Computing subtraction..."){
        private static final long serialVersionUID = 9094641559971542667L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean doAction(ActionEvent e) {
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            RoisPanel roisPanel = Icy.getMainInterface().getRoisPanel();
            if (sequence != null && roisPanel != null) {
                sequence.beginUpdate();
                try {
                    List selectedROI = roisPanel.getSelectedRois();
                    ArrayList<ROI> generatedROIs = new ArrayList<ROI>();
                    if (selectedROI.size() != 2) {
                        boolean bl = false;
                        return bl;
                    }
                    ROI subtractAB = ROIUtil.subtract((ROI)selectedROI.get(0), (ROI)selectedROI.get(1));
                    ROI subtractBA = ROIUtil.subtract((ROI)selectedROI.get(1), (ROI)selectedROI.get(0));
                    subtractAB.setName("Subtract A-B");
                    subtractBA.setName("Subtract B-A");
                    generatedROIs.add(subtractAB);
                    generatedROIs.add(subtractBA);
                    sequence.beginUpdate();
                    try {
                        for (ROI roi : generatedROIs) {
                            sequence.addROI(roi);
                        }
                        sequence.setSelectedROIs(generatedROIs);
                        sequence.addUndoableEdit((IcyUndoableEdit)new ROIAddsSequenceEdit(sequence, generatedROIs, "ROI Subtraction"));
                    }
                    finally {
                        sequence.endUpdate();
                    }
                }
                catch (UnsupportedOperationException ex) {
                    MessageDialog.showDialog((String)"Operation not supported", (String)ex.getLocalizedMessage(), (int)0);
                }
                finally {
                    sequence.endUpdate();
                }
                return true;
            }
            return false;
        }

        public boolean isEnabled() {
            return super.isEnabled() && Icy.getMainInterface().getActiveSequence() != null;
        }
    };
    public static IcyAbstractAction fillInteriorAction = new IcyAbstractAction("Fill interior", new IcyIcon(ResourceUtil.ICON_ROI_INTERIOR), "Fill ROI(s) interior", "Fill interior of the selected ROI(s) with specified value", true, "Fill ROI(s) interior..."){
        private static final long serialVersionUID = 4532376746365236681L;

        public boolean doAction(ActionEvent e) {
            MainFrame mainFrame;
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            if (sequence != null && (mainFrame = Icy.getMainInterface().getMainFrame()) != null) {
                double value = mainFrame.getMainRibbon().getROIRibbonTask().getFillValue();
                boolean canUndo = sequence.createUndoDataPoint("ROI fill interior");
                if (!canUndo && !IdConfirmDialog.confirm((String)"Not enough memory to undo the operation, do you want to continue ?", (String)"ROIFillInteriorConfirm")) {
                    return false;
                }
                for (ROI roi : sequence.getSelectedROIs()) {
                    DataIteratorUtil.set((DataIterator)new SequenceDataIterator(sequence, roi, true), (double)value);
                }
                sequence.dataChanged();
                if (!canUndo) {
                    sequence.clearUndoManager();
                }
                return true;
            }
            return false;
        }

        public boolean isEnabled() {
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            return super.isEnabled() && sequence != null && !sequence.isEmpty();
        }
    };
    public static IcyAbstractAction fillExteriorAction = new IcyAbstractAction("Fill exterior", new IcyIcon(ResourceUtil.ICON_ROI_NOT), "Fill ROI(s) exterior", "Fill exterior of the selected ROI(s) with specified value", true, "Fill ROI(s) exterior..."){
        private static final long serialVersionUID = 4970600052373326731L;

        public boolean doAction(ActionEvent e) {
            MainFrame mainFrame;
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            if (sequence != null && (mainFrame = Icy.getMainInterface().getMainFrame()) != null) {
                double value = mainFrame.getMainRibbon().getROIRibbonTask().getFillValue();
                boolean canUndo = sequence.createUndoDataPoint("ROI fill exterior");
                if (!canUndo && !IdConfirmDialog.confirm((String)"Not enough memory to undo the operation, do you want to continue ?", (String)"ROIFillExteriorConfirm")) {
                    return false;
                }
                try {
                    ROI roiUnion = ROIUtil.merge(sequence.getSelectedROIs(), ShapeUtil.BooleanOperator.OR);
                    ROI5DStackRectangle roiSeq = new ROI5DStackRectangle((Rectangle5D)sequence.getBounds5D());
                    ROI roi = roiSeq.getSubtraction(roiUnion);
                    DataIteratorUtil.set((DataIterator)new SequenceDataIterator(sequence, roi), (double)value);
                    sequence.dataChanged();
                    if (!canUndo) {
                        sequence.clearUndoManager();
                    }
                    return true;
                }
                catch (UnsupportedOperationException ex) {
                    if (canUndo) {
                        sequence.undo();
                    }
                    MessageDialog.showDialog((String)"Operation not supported", (String)ex.getLocalizedMessage(), (int)0);
                    return false;
                }
            }
            return false;
        }

        public boolean isEnabled() {
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            return super.isEnabled() && sequence != null && !sequence.isEmpty();
        }
    };
    public static IcyAbstractAction xlsExportAction = new IcyAbstractAction("Excel export", new IcyIcon(ResourceUtil.ICON_XLS_EXPORT), "ROI Excel export", "Export the content of the ROI table into a XLS/CSV file", true, "Exporting ROI informations..."){
        private static final long serialVersionUID = 9094641559971542667L;

        public boolean doAction(ActionEvent e) {
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            RoisPanel roisPanel = Icy.getMainInterface().getRoisPanel();
            if (sequence != null && roisPanel != null) {
                block7: {
                    String content = roisPanel.getCSVFormattedInfos();
                    if (StringUtil.isEmpty(content) || roisPanel.getVisibleRois().isEmpty()) {
                        MessageDialog.showDialog((String)"Nothing to export !", (int)1);
                        return true;
                    }
                    String filename = SaveDialog.chooseFileForResult((String)"Export ROIs...", (String)"result", (String)".xls");
                    if (filename != null) {
                        try {
                            if (!FileUtil.getFileExtension(filename, false).toLowerCase().startsWith("xls")) {
                                PrintWriter out = new PrintWriter(filename);
                                out.println(content);
                                out.close();
                                break block7;
                            }
                            WritableWorkbook workbook = XLSUtil.createWorkbook((String)filename);
                            WritableSheet sheet = XLSUtil.createNewPage((WritableWorkbook)workbook, (String)"ROIS");
                            if (XLSUtil.setFromCSV((WritableSheet)sheet, (String)content)) {
                                XLSUtil.saveAndClose((WritableWorkbook)workbook);
                                break block7;
                            }
                            MessageDialog.showDialog((String)"Error", (String)"Error while exporting ROIs table content to XLS file.", (int)0);
                            return false;
                        }
                        catch (Exception e1) {
                            MessageDialog.showDialog((String)"Error", (String)e1.getMessage(), (int)0);
                            return false;
                        }
                    }
                }
                return true;
            }
            return false;
        }

        public boolean isEnabled() {
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            return super.isEnabled() && sequence != null;
        }
    };
    public static IcyAbstractAction settingAction = new IcyAbstractAction("Preferences", new IcyIcon(ResourceUtil.ICON_COG), "ROI table preferences"){
        private static final long serialVersionUID = -3110113198501873416L;

        public boolean doAction(ActionEvent e) {
            RoisPanel roisPanel = Icy.getMainInterface().getRoisPanel();
            if (roisPanel != null) {
                roisPanel.showSettingPanel();
                return true;
            }
            return false;
        }
    };
    public static IcyAbstractAction convertTo3DAction = new IcyAbstractAction("to 3D ROI", new IcyIcon(ResourceUtil.ICON_LAYER_V2), "Convert to 3D ROI", "Convert selected 2D ROI to 3D ROI by extending it along the Z axis"){
        private static final long serialVersionUID = -6603561599009987184L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean doAction(ActionEvent e) {
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            if (sequence != null) {
                int sizeZ = sequence.getSizeZ();
                sequence.beginUpdate();
                try {
                    ArrayList selectedROIs = sequence.getSelectedROI2Ds();
                    ArrayList<ROI2D> removedROIs = new ArrayList<ROI2D>();
                    ArrayList<ROI> addedROIs = new ArrayList<ROI>();
                    for (ROI2D roi : selectedROIs) {
                        ROI stackedRoi = ROIUtil.convertTo3D(roi, 0.0, sizeZ);
                        if (stackedRoi == null) continue;
                        stackedRoi.setSelected(true);
                        sequence.removeROI((ROI)roi);
                        sequence.addROI(stackedRoi);
                        removedROIs.add(roi);
                        addedROIs.add(stackedRoi);
                    }
                    if (!addedROIs.isEmpty()) {
                        sequence.addUndoableEdit((IcyUndoableEdit)new ROIReplacesSequenceEdit(sequence, removedROIs, addedROIs, addedROIs.size() > 1 ? "ROIs 3D stack conversion" : "ROI 3D stack conversion"));
                    }
                }
                catch (UnsupportedOperationException ex) {
                    MessageDialog.showDialog((String)"Operation not supported", (String)ex.toString(), (int)0);
                }
                finally {
                    sequence.endUpdate();
                }
                return true;
            }
            return false;
        }

        public boolean isEnabled() {
            return super.isEnabled() && Icy.getMainInterface().getActiveSequence() != null;
        }
    };
    public static IcyAbstractAction convertTo2DAction = new IcyAbstractAction("to 2D ROIs", new IcyIcon(ResourceUtil.ICON_LAYER_REMOVE_V2), "Convert to 2D ROIs", "Convert selected 3D ROIs to 2D ROIs (3D stacks are converted to multiple 2D ROIs)"){
        private static final long serialVersionUID = 8540151213754012800L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean doAction(ActionEvent e) {
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            if (sequence != null) {
                sequence.beginUpdate();
                try {
                    ArrayList selectedROIs = sequence.getSelectedROI3Ds();
                    ArrayList<ROI3D> removedROIs = new ArrayList<ROI3D>();
                    ArrayList<ROI> addedROIs = new ArrayList<ROI>();
                    for (ROI3D roi : selectedROIs) {
                        ROI[] unstackedRois = ROIUtil.convertTo2D(roi);
                        if (unstackedRois == null) continue;
                        sequence.removeROI((ROI)roi);
                        removedROIs.add(roi);
                        for (ROI roi2d : unstackedRois) {
                            roi2d.setSelected(true);
                            sequence.addROI(roi2d);
                            addedROIs.add(roi2d);
                        }
                    }
                    if (!addedROIs.isEmpty()) {
                        sequence.addUndoableEdit((IcyUndoableEdit)new ROIReplacesSequenceEdit(sequence, removedROIs, addedROIs, addedROIs.size() > 1 ? "3D ROIs unstack conversion" : "3D ROI unstack conversion"));
                    }
                }
                catch (UnsupportedOperationException ex) {
                    MessageDialog.showDialog((String)"Operation not supported", (String)ex.toString(), (int)0);
                }
                finally {
                    sequence.endUpdate();
                }
                return true;
            }
            return false;
        }

        public boolean isEnabled() {
            return super.isEnabled() && Icy.getMainInterface().getActiveSequence() != null;
        }
    };
    public static IcyAbstractAction convertToMaskAction = new IcyAbstractAction("to Mask", new IcyIcon(ResourceUtil.ICON_BOOL_MASK), "Convert Shape ROI to Mask ROI", "Convert selected Shape ROI to Mask ROI by using their boolean mask"){
        private static final long serialVersionUID = -4619275091379174088L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean doAction(ActionEvent e) {
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            if (sequence != null) {
                sequence.beginUpdate();
                try {
                    ArrayList selectedROIs = sequence.getSelectedROIs();
                    ArrayList<ROI> removedROIs = new ArrayList<ROI>();
                    ArrayList<ROI> addedROIs = new ArrayList<ROI>();
                    for (ROI roi : selectedROIs) {
                        ROI maskRoi = ROIUtil.convertToMask(roi);
                        if (maskRoi == null) continue;
                        maskRoi.setSelected(true);
                        sequence.removeROI(roi);
                        sequence.addROI(maskRoi);
                        removedROIs.add(roi);
                        addedROIs.add(maskRoi);
                    }
                    if (!addedROIs.isEmpty()) {
                        sequence.addUndoableEdit((IcyUndoableEdit)new ROIReplacesSequenceEdit(sequence, removedROIs, addedROIs, addedROIs.size() > 1 ? "ROIs mask conversion" : "ROI mask conversion"));
                    }
                }
                catch (UnsupportedOperationException ex) {
                    MessageDialog.showDialog((String)"Operation not supported", (String)ex.toString(), (int)0);
                }
                finally {
                    sequence.endUpdate();
                }
                return true;
            }
            return false;
        }

        public boolean isEnabled() {
            return super.isEnabled() && Icy.getMainInterface().getActiveSequence() != null;
        }
    };
    public static IcyAbstractAction convertToPointAction = new IcyAbstractAction("to Point", new IcyIcon(ResourceUtil.ICON_ROI_POINT), "Convert ROI to Point ROI", "Converts selected ROI(s) to ROI Point (2D or 3D) representing the mass center of the input ROI(s)"){
        private static final long serialVersionUID = 8651972852084710361L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean doAction(ActionEvent e) {
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            if (sequence != null) {
                sequence.beginUpdate();
                try {
                    ArrayList selectedROIs = sequence.getSelectedROIs();
                    ArrayList<ROI> removedROIs = new ArrayList<ROI>();
                    ArrayList<ROI> addedROIs = new ArrayList<ROI>();
                    for (ROI roi : selectedROIs) {
                        ROI roiPoint = ROIUtil.convertToPoint(roi);
                        if (roiPoint == null) continue;
                        roiPoint.setSelected(true);
                        sequence.removeROI(roi);
                        sequence.addROI(roiPoint);
                        removedROIs.add(roi);
                        addedROIs.add(roiPoint);
                    }
                    if (!addedROIs.isEmpty()) {
                        sequence.addUndoableEdit((IcyUndoableEdit)new ROIReplacesSequenceEdit(sequence, removedROIs, addedROIs, addedROIs.size() > 1 ? "ROIs point conversion" : "ROI point conversion"));
                    }
                }
                catch (UnsupportedOperationException ex) {
                    MessageDialog.showDialog((String)"Operation not supported", (String)ex.toString(), (int)0);
                }
                catch (InterruptedException ex) {
                    MessageDialog.showDialog((String)"Operation interrupted", (String)ex.toString(), (int)0);
                }
                finally {
                    sequence.endUpdate();
                }
                return true;
            }
            return false;
        }

        public boolean isEnabled() {
            return super.isEnabled() && Icy.getMainInterface().getActiveSequence() != null;
        }
    };
    public static IcyAbstractAction convertToEllipseAction = new IcyAbstractAction("to Circle", new IcyIcon(ResourceUtil.ICON_ROI_OVAL), "Convert ROI to Circle ROI", "Converts selected ROI(s) to Circle ROI centered on the mass center of the input ROI(s)"){
        private static final long serialVersionUID = 6744919240594360564L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean doAction(ActionEvent e) {
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            if (sequence != null) {
                MainFrame mainFrame = Icy.getMainInterface().getMainFrame();
                if (mainFrame != null) {
                    double radius = mainFrame.getMainRibbon().getROIRibbonTask().getRadius();
                    sequence.beginUpdate();
                    try {
                        ArrayList selectedROIs = sequence.getSelectedROIs();
                        ArrayList<ROI> removedROIs = new ArrayList<ROI>();
                        ArrayList<ROI> addedROIs = new ArrayList<ROI>();
                        for (ROI roi : selectedROIs) {
                            ROI resultRoi = radius == 0.0 ? ROIUtil.convertToPoint(roi) : ROIUtil.convertToEllipse(roi, radius, radius);
                            if (resultRoi == null) continue;
                            resultRoi.setSelected(true);
                            sequence.removeROI(roi);
                            sequence.addROI(resultRoi);
                            removedROIs.add(roi);
                            addedROIs.add(resultRoi);
                        }
                        if (!addedROIs.isEmpty()) {
                            sequence.addUndoableEdit((IcyUndoableEdit)new ROIReplacesSequenceEdit(sequence, removedROIs, addedROIs, addedROIs.size() > 1 ? "ROIs circle conversion" : "ROI circle conversion"));
                        }
                    }
                    catch (UnsupportedOperationException ex) {
                        MessageDialog.showDialog((String)"Operation not supported", (String)ex.toString(), (int)0);
                    }
                    catch (InterruptedException ex) {
                        MessageDialog.showDialog((String)"Operation interrupted", (String)ex.toString(), (int)0);
                    }
                    finally {
                        sequence.endUpdate();
                    }
                }
                return true;
            }
            return false;
        }

        public boolean isEnabled() {
            return super.isEnabled() && Icy.getMainInterface().getActiveSequence() != null;
        }
    };
    public static IcyAbstractAction convertToRectangleAction = new IcyAbstractAction("to Square", new IcyIcon(ResourceUtil.ICON_ROI_RECTANGLE), "Convert ROI to Square ROI", "Converts selected ROI(s) to Square ROI centered on the mass center of the input ROI(s)"){
        private static final long serialVersionUID = 443206519870698257L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean doAction(ActionEvent e) {
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            if (sequence != null) {
                MainFrame mainFrame = Icy.getMainInterface().getMainFrame();
                if (mainFrame != null) {
                    double size = mainFrame.getMainRibbon().getROIRibbonTask().getRadius() * 2.0;
                    sequence.beginUpdate();
                    try {
                        ArrayList selectedROIs = sequence.getSelectedROIs();
                        ArrayList<ROI> removedROIs = new ArrayList<ROI>();
                        ArrayList<ROI> addedROIs = new ArrayList<ROI>();
                        for (ROI roi : selectedROIs) {
                            ROI resultRoi = size == 0.0 ? ROIUtil.convertToPoint(roi) : ROIUtil.convertToRectangle(roi, size, size);
                            if (resultRoi == null) continue;
                            resultRoi.setSelected(true);
                            sequence.removeROI(roi);
                            sequence.addROI(resultRoi);
                            removedROIs.add(roi);
                            addedROIs.add(resultRoi);
                        }
                        if (!addedROIs.isEmpty()) {
                            sequence.addUndoableEdit((IcyUndoableEdit)new ROIReplacesSequenceEdit(sequence, removedROIs, addedROIs, addedROIs.size() > 1 ? "ROIs square conversion" : "ROI square conversion"));
                        }
                    }
                    catch (UnsupportedOperationException ex) {
                        MessageDialog.showDialog((String)"Operation not supported", (String)ex.toString(), (int)0);
                    }
                    catch (InterruptedException ex) {
                        MessageDialog.showDialog((String)"Operation interrupted", (String)ex.toString(), (int)0);
                    }
                    finally {
                        sequence.endUpdate();
                    }
                }
                return true;
            }
            return false;
        }

        public boolean isEnabled() {
            return super.isEnabled() && Icy.getMainInterface().getActiveSequence() != null;
        }
    };
    public static IcyAbstractAction convertToShapeAction = new IcyAbstractAction("to Shape", new IcyIcon(ResourceUtil.ICON_ROI_POLYGON), "Convert Mask ROI to Polygon shape ROI", "Convert selected Mask ROI to Shape ROI using polygon approximation"){
        private static final long serialVersionUID = 958781178829484L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean doAction(ActionEvent e) {
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            if (sequence != null) {
                sequence.beginUpdate();
                try {
                    ArrayList selectedROIs = sequence.getSelectedROIs();
                    ArrayList<ROI> removedROIs = new ArrayList<ROI>();
                    ArrayList<ROI> addedROIs = new ArrayList<ROI>();
                    for (ROI roi : selectedROIs) {
                        ROI shapeRoi = ROIUtil.convertToShape(roi, -1.0);
                        if (shapeRoi == null) continue;
                        shapeRoi.setSelected(true);
                        sequence.removeROI(roi);
                        sequence.addROI(shapeRoi);
                        removedROIs.add(roi);
                        addedROIs.add(shapeRoi);
                    }
                    if (!addedROIs.isEmpty()) {
                        sequence.addUndoableEdit((IcyUndoableEdit)new ROIReplacesSequenceEdit(sequence, removedROIs, addedROIs, addedROIs.size() > 1 ? "ROIs shape conversion" : "ROI shape conversion"));
                    }
                }
                catch (UnsupportedOperationException ex) {
                    MessageDialog.showDialog((String)"Operation not supported", (String)ex.toString(), (int)0);
                }
                finally {
                    sequence.endUpdate();
                }
                return true;
            }
            return false;
        }

        public boolean isEnabled() {
            return super.isEnabled() && Icy.getMainInterface().getActiveSequence() != null;
        }
    };
    public static IcyAbstractAction separateObjectsAction = new IcyAbstractAction("Separate component", new IcyIcon(ResourceUtil.ICON_ROI_COMP), "Separate components from selected Mask ROI(s)", "Separate unconnected components from selected Mask ROI(s)"){
        private static final long serialVersionUID = 5289442497372947147L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean doAction(ActionEvent e) {
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            if (sequence != null) {
                sequence.beginUpdate();
                try {
                    ArrayList selectedROIs = sequence.getSelectedROIs();
                    ArrayList<ROI> removedROIs = new ArrayList<ROI>();
                    ArrayList<ROI> addedROIs = new ArrayList<ROI>();
                    for (ROI roi : selectedROIs) {
                        List<ROI> components = ROIUtil.getConnectedComponents(roi);
                        if (components.size() <= 1) continue;
                        sequence.removeROI(roi);
                        removedROIs.add(roi);
                        for (ROI component : components) {
                            sequence.addROI(component);
                            addedROIs.add(component);
                        }
                    }
                    if (!removedROIs.isEmpty()) {
                        sequence.addUndoableEdit((IcyUndoableEdit)new ROIReplacesSequenceEdit(sequence, removedROIs, addedROIs, removedROIs.size() > 1 ? "ROIs separate objects" : "ROI separate objects"));
                    }
                }
                catch (UnsupportedOperationException ex) {
                    MessageDialog.showDialog((String)"Operation not supported", (String)ex.toString(), (int)0);
                }
                finally {
                    sequence.endUpdate();
                }
                return true;
            }
            return false;
        }

        public boolean isEnabled() {
            return super.isEnabled() && Icy.getMainInterface().getActiveSequence() != null;
        }
    };
    public static IcyAbstractAction upscale2dAction = new IcyAbstractAction("Scale x2 (2D)", new IcyIcon(ResourceUtil.ICON_ROI_UPSCALE), "Create up scaled version of selected ROI(s) (2D)", "Create 2x factor up scaled version of selected ROI(s) (2D)"){
        private static final long serialVersionUID = 9059232719467440375L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean doAction(ActionEvent e) {
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            if (sequence != null) {
                sequence.beginUpdate();
                try {
                    ArrayList selectedROIs = sequence.getSelectedROIs();
                    ArrayList<ROI> newROIs = new ArrayList<ROI>();
                    for (ROI roi : selectedROIs) {
                        newROIs.add(ROIUtil.getUpscaled(roi, false));
                    }
                    if (!newROIs.isEmpty()) {
                        for (ROI roi : newROIs) {
                            sequence.addROI(roi);
                        }
                        sequence.addUndoableEdit((IcyUndoableEdit)new ROIAddsSequenceEdit(sequence, newROIs, newROIs.size() > 1 ? "ROIs scale x2" : "ROI scale x2"));
                    }
                }
                catch (UnsupportedOperationException ex) {
                    MessageDialog.showDialog((String)"Operation not supported", (String)ex.toString(), (int)0);
                }
                finally {
                    sequence.endUpdate();
                }
                return true;
            }
            return false;
        }

        public boolean isEnabled() {
            return super.isEnabled() && Icy.getMainInterface().getActiveSequence() != null;
        }
    };
    public static IcyAbstractAction upscaleAction = new IcyAbstractAction("Scale x2", new IcyIcon(ResourceUtil.ICON_ROI_UPSCALE), "Create x2 scaled version of selected ROI(s)", "Create x2 factor scaled version of selected ROI(s)"){
        private static final long serialVersionUID = 3796124503844829358L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean doAction(ActionEvent e) {
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            if (sequence != null) {
                sequence.beginUpdate();
                try {
                    ArrayList selectedROIs = sequence.getSelectedROIs();
                    ArrayList<ROI> newROIs = new ArrayList<ROI>();
                    for (ROI roi : selectedROIs) {
                        newROIs.add(ROIUtil.getUpscaled(roi, true));
                    }
                    if (!newROIs.isEmpty()) {
                        for (ROI roi : newROIs) {
                            sequence.addROI(roi);
                        }
                        sequence.addUndoableEdit((IcyUndoableEdit)new ROIAddsSequenceEdit(sequence, newROIs, newROIs.size() > 1 ? "ROIs scale x2" : "ROI scale x2"));
                    }
                }
                catch (UnsupportedOperationException ex) {
                    MessageDialog.showDialog((String)"Operation not supported", (String)ex.toString(), (int)0);
                }
                finally {
                    sequence.endUpdate();
                }
                return true;
            }
            return false;
        }

        public boolean isEnabled() {
            return super.isEnabled() && Icy.getMainInterface().getActiveSequence() != null;
        }
    };
    public static IcyAbstractAction downscale2dAction = new IcyAbstractAction("Scale /2 (2D)", new IcyIcon(ResourceUtil.ICON_ROI_DOWNSCALE), "Create /2 scaled version of selected ROI(s) (2D)", "Create /2 factor scaled version of selected ROI(s) (2D)"){
        private static final long serialVersionUID = -524220001283188724L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean doAction(ActionEvent e) {
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            if (sequence != null) {
                sequence.beginUpdate();
                try {
                    ArrayList selectedROIs = sequence.getSelectedROIs();
                    ArrayList<ROI> newROIs = new ArrayList<ROI>();
                    for (ROI roi : newROIs) {
                        newROIs.add(ROIUtil.getDownscaled(roi, false));
                    }
                    if (!newROIs.isEmpty()) {
                        for (ROI roi : selectedROIs) {
                            sequence.addROI(roi);
                        }
                        sequence.addUndoableEdit((IcyUndoableEdit)new ROIAddsSequenceEdit(sequence, newROIs, newROIs.size() > 1 ? "ROIs scale /2" : "ROI scale /2"));
                    }
                }
                catch (UnsupportedOperationException ex) {
                    MessageDialog.showDialog((String)"Operation not supported", (String)ex.toString(), (int)0);
                }
                finally {
                    sequence.endUpdate();
                }
                return true;
            }
            return false;
        }

        public boolean isEnabled() {
            return super.isEnabled() && Icy.getMainInterface().getActiveSequence() != null;
        }
    };
    public static IcyAbstractAction downscaleAction = new IcyAbstractAction("Scale /2", new IcyIcon(ResourceUtil.ICON_ROI_DOWNSCALE), "Create down scaled version of selected ROI(s)", "Create 2x factor down scaled version of selected ROI(s)"){
        private static final long serialVersionUID = -3570102897640191459L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean doAction(ActionEvent e) {
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            if (sequence != null) {
                sequence.beginUpdate();
                try {
                    ArrayList selectedROIs = sequence.getSelectedROIs();
                    ArrayList<ROI> newROIs = new ArrayList<ROI>();
                    for (ROI roi : selectedROIs) {
                        newROIs.add(ROIUtil.getDownscaled(roi, true));
                    }
                    if (!newROIs.isEmpty()) {
                        for (ROI roi : newROIs) {
                            sequence.addROI(roi);
                        }
                        sequence.addUndoableEdit((IcyUndoableEdit)new ROIAddsSequenceEdit(sequence, newROIs, newROIs.size() > 1 ? "ROIs scale /2" : "ROI scale /2"));
                    }
                }
                catch (UnsupportedOperationException ex) {
                    MessageDialog.showDialog((String)"Operation not supported", (String)ex.toString(), (int)0);
                }
                finally {
                    sequence.endUpdate();
                }
                return true;
            }
            return false;
        }

        public boolean isEnabled() {
            return super.isEnabled() && Icy.getMainInterface().getActiveSequence() != null;
        }
    };
    public static IcyAbstractAction autoSplitAction = new IcyAbstractAction("Auto split", new IcyIcon("split_roi", true), "Automatic split selected ROI", "Automatic split selected ROI using shape and size information."){
        private static final long serialVersionUID = 3979863504572671999L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean doAction(ActionEvent e) {
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            if (sequence != null) {
                sequence.beginUpdate();
                try {
                    ArrayList removedROIs = new ArrayList();
                    ArrayList addedROIs = new ArrayList();
                    if (!removedROIs.isEmpty()) {
                        sequence.addUndoableEdit((IcyUndoableEdit)new ROIReplacesSequenceEdit(sequence, removedROIs, addedROIs, removedROIs.size() > 1 ? "ROIs automatic split" : "ROI automatic split"));
                    }
                }
                catch (UnsupportedOperationException ex) {
                    MessageDialog.showDialog((String)"Operation not supported", (String)ex.toString(), (int)0);
                }
                finally {
                    sequence.endUpdate();
                }
                return true;
            }
            return false;
        }

        public boolean isEnabled() {
            return super.isEnabled() && Icy.getMainInterface().getActiveSequence() != null;
        }
    };
    public static final IcyAbstractAction computeDistanceMapAction = new IcyAbstractAction("Distance map", new IcyIcon(ResourceUtil.ICON_ROI_DISTANCE_MAP), "Compute distance map of selected ROIs", "Computes the inner distance transform of the selected ROIs."){
        private static final long serialVersionUID = -41448258413789020L;

        protected boolean doAction(ActionEvent e) {
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            if (sequence != null) {
                Sequence distanceMap;
                ArrayList selectedROIs = sequence.getSelectedROI2Ds();
                try {
                    Dimension3D.Double pixelSize = new Dimension3D.Double(1.0, 1.0, 1.0);
                    distanceMap = ROIUtil.computeDistanceMap(selectedROIs, (Dimension5D)sequence.getDimension5D(), (Dimension3D)pixelSize, false);
                }
                catch (UnsupportedOperationException ex) {
                    MessageDialog.showDialog((String)"Operation not supported", (String)ex.toString(), (int)0);
                    return false;
                }
                catch (InterruptedException ex1) {
                    throw new IcyHandledException((Throwable)ex1);
                }
                Icy.getMainInterface().addSequence(distanceMap);
            }
            return false;
        }
    };
    public static final IcyAbstractAction computeWatershedSeparation = new IcyAbstractAction("Separate by Watershed", new IcyIcon(ResourceUtil.ICON_ROI_SEPARATE), "Separate in parts selected ROIs by using watersheds of the shape", "Computes the separation of the selected ROIs by applying a watershed approach on the distance map of the ROIs."){
        private static final long serialVersionUID = 5354562004015076140L;

        protected boolean doAction(ActionEvent e) {
            final Sequence sequence = Icy.getMainInterface().getActiveSequence();
            if (sequence != null) {
                final ArrayList selectedRois = sequence.getSelectedROI2Ds();
                final List seedRois = sequence.getSelectedROIs(ROI2DPoint.class, true);
                selectedRois.removeAll(new HashSet(seedRois));
                Thread thrd = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            List<ROI> separationRois;
                            Dimension3D.Double pixelSize = new Dimension3D.Double(1.0, 1.0, 1.0);
                            ArrayList<ROI> usedSeeds = null;
                            if (seedRois.isEmpty()) {
                                usedSeeds = new ArrayList<ROI>();
                                separationRois = ROIUtil.computeWatershedSeparation((Collection<? extends ROI>)selectedRois, (Dimension5D)sequence.getDimension5D(), (Dimension3D)pixelSize, usedSeeds);
                            } else {
                                separationRois = ROIUtil.computeWatershedSeparation((Collection<? extends ROI>)selectedRois, seedRois, (Dimension5D)sequence.getDimension5D(), (Dimension3D)pixelSize);
                            }
                            sequence.beginUpdate();
                            if (usedSeeds != null) {
                                sequence.addROIs(usedSeeds, true);
                            }
                            sequence.removeROIs((Collection)selectedRois, true);
                            sequence.addROIs(separationRois, true);
                            sequence.endUpdate();
                        }
                        catch (UnsupportedOperationException ex) {
                            MessageDialog.showDialog((String)"Operation not supported", (String)ex.toString(), (int)0);
                        }
                        catch (InterruptedException ex1) {
                            throw new IcyHandledException((Throwable)ex1);
                        }
                    }
                }, "ROIWatershed");
                thrd.start();
            }
            return false;
        }
    };
    public static final IcyAbstractAction computeSkeleton = new IcyAbstractAction("Compute Skeleton", new IcyIcon(ResourceUtil.ICON_ROI_POLYLINE), "Computes the skeletons of selected ROIs", "Computes the skeletons of selected ROIs."){
        private static final long serialVersionUID = -708624356916992059L;

        protected boolean doAction(ActionEvent e) {
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            if (sequence != null) {
                ArrayList selectedROIs = sequence.getSelectedROI2Ds();
                MainFrame mainFrame = Icy.getMainInterface().getMainFrame();
                double distance = mainFrame.getMainRibbon().getROIRibbonTask().getDistance();
                try {
                    Dimension3D.Double pixelSize = new Dimension3D.Double(1.0, 1.0, 1.0);
                    List<ROI> skeletonRois = ROIUtil.computeSkeleton(selectedROIs, (Dimension3D)pixelSize, distance);
                    sequence.beginUpdate();
                    sequence.removeROIs((Collection)selectedROIs, true);
                    sequence.addROIs(skeletonRois, true);
                    sequence.endUpdate();
                }
                catch (UnsupportedOperationException ex) {
                    MessageDialog.showDialog((String)"Operation not supported", (String)ex.getMessage(), (int)0);
                    return false;
                }
                catch (InterruptedException ex1) {
                    throw new IcyHandledException((Throwable)ex1);
                }
            }
            return false;
        }
    };
    public static final IcyAbstractAction dilateObjectsAction = new IcyAbstractAction("Dilate", new IcyIcon(ResourceUtil.ICON_ROI_DILATE), "Dilates selected 2D ROIs", "Computes the dilation of selected 2D ROIs using the provided distance."){
        private static final long serialVersionUID = 5354562004015076140L;

        protected boolean doAction(ActionEvent e) {
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            if (sequence != null) {
                ArrayList selectedROIs = sequence.getSelectedROI2Ds();
                MainFrame mainFrame = Icy.getMainInterface().getMainFrame();
                double distance = mainFrame.getMainRibbon().getROIRibbonTask().getDistance();
                try {
                    Dimension3D.Double pixelSize = new Dimension3D.Double(1.0, 1.0, 1.0);
                    List<ROI> dilatedRois = ROIUtil.computeDilation(selectedROIs, (Dimension3D)pixelSize, distance);
                    sequence.beginUpdate();
                    sequence.removeROIs((Collection)selectedROIs, true);
                    sequence.addROIs(dilatedRois, true);
                    sequence.endUpdate();
                }
                catch (UnsupportedOperationException ex) {
                    MessageDialog.showDialog((String)"Operation not supported", (String)ex.getMessage(), (int)0);
                    return false;
                }
                catch (InterruptedException ex1) {
                    throw new IcyHandledException((Throwable)ex1);
                }
            }
            return false;
        }
    };
    public static final IcyAbstractAction erodeObjectsAction = new IcyAbstractAction("Erode", new IcyIcon(ResourceUtil.ICON_ROI_ERODE), "Erodes selected 2D ROIs", "Computes the erotion of selected 2D ROIs using the provided distance."){
        private static final long serialVersionUID = -708624356916992059L;

        protected boolean doAction(ActionEvent e) {
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            if (sequence != null) {
                ArrayList selectedROIs = sequence.getSelectedROI2Ds();
                MainFrame mainFrame = Icy.getMainInterface().getMainFrame();
                double distance = mainFrame.getMainRibbon().getROIRibbonTask().getDistance();
                try {
                    Dimension3D.Double pixelSize = new Dimension3D.Double(1.0, 1.0, 1.0);
                    List<ROI> dilatedRois = ROIUtil.computeErosion(selectedROIs, (Dimension3D)pixelSize, distance);
                    sequence.beginUpdate();
                    sequence.removeROIs((Collection)selectedROIs, true);
                    sequence.addROIs(dilatedRois, true);
                    sequence.endUpdate();
                }
                catch (UnsupportedOperationException ex) {
                    MessageDialog.showDialog((String)"Operation not supported", (String)ex.getMessage(), (int)0);
                    return false;
                }
                catch (InterruptedException ex1) {
                    throw new IcyHandledException((Throwable)ex1);
                }
            }
            return false;
        }
    };

    public static List<IcyAbstractAction> getAllActions() {
        ArrayList<IcyAbstractAction> result = new ArrayList<IcyAbstractAction>();
        for (Field field : RoiActions.class.getFields()) {
            Class<?> type = field.getType();
            try {
                if (ClassUtil.isSubClass(type, IcyAbstractAction[].class)) {
                    result.addAll(Arrays.asList((IcyAbstractAction[])field.get(null)));
                    continue;
                }
                if (!ClassUtil.isSubClass(type, IcyAbstractAction.class)) continue;
                result.add((IcyAbstractAction)field.get(null));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static class SequenceRoiList {
        public final Sequence sequence;
        public final List<ROI> rois;

        public SequenceRoiList(Sequence sequence, List<ROI> rois) {
            this.sequence = sequence;
            this.rois = rois;
        }
    }
}

