/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array1D;
import mitiv.array.ArrayFactory;
import mitiv.array.ShapedArray;
import mitiv.base.Shape;

public abstract class Scalar
implements ShapedArray {
    protected static final Shape shape = Shape.scalarShape;
    protected static final int number = 1;

    protected Scalar() {
    }

    protected Scalar(int[] dims) {
        this(new Shape(dims));
    }

    protected Scalar(Shape shape) {
        if (shape.rank() != 0) {
            throw new IllegalArgumentException("Bad number of dimensions for 0-D array");
        }
    }

    @Override
    public final int getRank() {
        return 0;
    }

    @Override
    public final Shape getShape() {
        return shape;
    }

    @Override
    public final int getNumber() {
        return 1;
    }

    @Override
    public final int getDimension(int k) {
        return shape.dimension(k);
    }

    public final Scalar reshape(Shape shape) {
        if (1 == (int)shape.number()) {
            return (Scalar)ArrayFactory.wrap(this.getData(), shape);
        }
        throw new IllegalArgumentException("The new shape is not commensurate with the old shape");
    }

    @Override
    public final Scalar movedims(int initpos, int finalpos) {
        if (finalpos > -1 || initpos > -1) {
            throw new IllegalArgumentException("The permutation should not change the rank");
        }
        return this.copy();
    }

    @Override
    public abstract Scalar copy();

    @Override
    public abstract Array1D as1D();
}

