/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model.enums.handlers;

import java.util.Hashtable;
import ome.units.UNITS;
import ome.units.quantity.Pressure;
import ome.units.unit.Unit;
import ome.xml.model.enums.Enumeration;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.UnitsPressure;
import ome.xml.model.enums.handlers.IEnumerationHandler;
import ome.xml.model.primitives.NonNegativeFloat;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.NonNegativeLong;
import ome.xml.model.primitives.PercentFraction;
import ome.xml.model.primitives.PositiveFloat;
import ome.xml.model.primitives.PositiveInteger;
import ome.xml.model.primitives.PositiveLong;
import ome.xml.model.primitives.PrimitiveNumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnitsPressureEnumHandler
implements IEnumerationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnitsPressureEnumHandler.class);
    private static final Hashtable<String, String> patterns = UnitsPressureEnumHandler.makePatterns();

    private static Hashtable<String, String> makePatterns() {
        Hashtable<String, String> p = new Hashtable<String, String>();
        p.put("^\\s*YPa\\s*", "YPa");
        p.put("^\\s*ZPa\\s*", "ZPa");
        p.put("^\\s*EPa\\s*", "EPa");
        p.put("^\\s*PPa\\s*", "PPa");
        p.put("^\\s*TPa\\s*", "TPa");
        p.put("^\\s*GPa\\s*", "GPa");
        p.put("^\\s*MPa\\s*", "MPa");
        p.put("^\\s*kPa\\s*", "kPa");
        p.put("^\\s*hPa\\s*", "hPa");
        p.put("^\\s*daPa\\s*", "daPa");
        p.put("^\\s*Pa\\s*", "Pa");
        p.put("^\\s*dPa\\s*", "dPa");
        p.put("^\\s*cPa\\s*", "cPa");
        p.put("^\\s*mPa\\s*", "mPa");
        p.put("^\\s*\u00b5Pa\\s*", "\u00b5Pa");
        p.put("^\\s*nPa\\s*", "nPa");
        p.put("^\\s*pPa\\s*", "pPa");
        p.put("^\\s*fPa\\s*", "fPa");
        p.put("^\\s*aPa\\s*", "aPa");
        p.put("^\\s*zPa\\s*", "zPa");
        p.put("^\\s*yPa\\s*", "yPa");
        p.put("^\\s*bar\\s*", "bar");
        p.put("^\\s*Mbar\\s*", "Mbar");
        p.put("^\\s*kbar\\s*", "kbar");
        p.put("^\\s*dbar\\s*", "dbar");
        p.put("^\\s*cbar\\s*", "cbar");
        p.put("^\\s*mbar\\s*", "mbar");
        p.put("^\\s*atm\\s*", "atm");
        p.put("^\\s*psi\\s*", "psi");
        p.put("^\\s*Torr\\s*", "Torr");
        p.put("^\\s*mTorr\\s*", "mTorr");
        p.put("^\\s*mm Hg\\s*", "mm Hg");
        return p;
    }

    @Override
    public Enumeration getEnumeration(String value) throws EnumerationException {
        if (value != null) {
            for (String pattern : patterns.keySet()) {
                if (!value.matches(pattern)) continue;
                String v = patterns.get(pattern);
                return UnitsPressure.fromString(v);
            }
        }
        LOGGER.warn("Unknown {} value '{}' will be stored as \"Other\"", (Object)"UnitsPressure", (Object)value);
        throw new EnumerationException(this.getClass().getName() + " could not find enumeration for " + value);
    }

    public Enumeration getEnumeration(Pressure inUnit) throws EnumerationException {
        return this.getEnumeration(inUnit.unit().getSymbol());
    }

    public static Unit<Pressure> getBaseUnit(UnitsPressure inModelUnit) {
        Unit<Pressure> theResult = UNITS.PASCAL;
        if (UnitsPressure.YOTTAPASCAL.equals(inModelUnit)) {
            theResult = UNITS.YOTTAPASCAL;
        }
        if (UnitsPressure.ZETTAPASCAL.equals(inModelUnit)) {
            theResult = UNITS.ZETTAPASCAL;
        }
        if (UnitsPressure.EXAPASCAL.equals(inModelUnit)) {
            theResult = UNITS.EXAPASCAL;
        }
        if (UnitsPressure.PETAPASCAL.equals(inModelUnit)) {
            theResult = UNITS.PETAPASCAL;
        }
        if (UnitsPressure.TERAPASCAL.equals(inModelUnit)) {
            theResult = UNITS.TERAPASCAL;
        }
        if (UnitsPressure.GIGAPASCAL.equals(inModelUnit)) {
            theResult = UNITS.GIGAPASCAL;
        }
        if (UnitsPressure.MEGAPASCAL.equals(inModelUnit)) {
            theResult = UNITS.MEGAPASCAL;
        }
        if (UnitsPressure.KILOPASCAL.equals(inModelUnit)) {
            theResult = UNITS.KILOPASCAL;
        }
        if (UnitsPressure.HECTOPASCAL.equals(inModelUnit)) {
            theResult = UNITS.HECTOPASCAL;
        }
        if (UnitsPressure.DECAPASCAL.equals(inModelUnit)) {
            theResult = UNITS.DECAPASCAL;
        }
        if (UnitsPressure.PASCAL.equals(inModelUnit)) {
            theResult = UNITS.PASCAL;
        }
        if (UnitsPressure.DECIPASCAL.equals(inModelUnit)) {
            theResult = UNITS.DECIPASCAL;
        }
        if (UnitsPressure.CENTIPASCAL.equals(inModelUnit)) {
            theResult = UNITS.CENTIPASCAL;
        }
        if (UnitsPressure.MILLIPASCAL.equals(inModelUnit)) {
            theResult = UNITS.MILLIPASCAL;
        }
        if (UnitsPressure.MICROPASCAL.equals(inModelUnit)) {
            theResult = UNITS.MICROPASCAL;
        }
        if (UnitsPressure.NANOPASCAL.equals(inModelUnit)) {
            theResult = UNITS.NANOPASCAL;
        }
        if (UnitsPressure.PICOPASCAL.equals(inModelUnit)) {
            theResult = UNITS.PICOPASCAL;
        }
        if (UnitsPressure.FEMTOPASCAL.equals(inModelUnit)) {
            theResult = UNITS.FEMTOPASCAL;
        }
        if (UnitsPressure.ATTOPASCAL.equals(inModelUnit)) {
            theResult = UNITS.ATTOPASCAL;
        }
        if (UnitsPressure.ZEPTOPASCAL.equals(inModelUnit)) {
            theResult = UNITS.ZEPTOPASCAL;
        }
        if (UnitsPressure.YOCTOPASCAL.equals(inModelUnit)) {
            theResult = UNITS.YOCTOPASCAL;
        }
        if (UnitsPressure.BAR.equals(inModelUnit)) {
            theResult = UNITS.BAR;
        }
        if (UnitsPressure.MEGABAR.equals(inModelUnit)) {
            theResult = UNITS.MEGABAR;
        }
        if (UnitsPressure.KILOBAR.equals(inModelUnit)) {
            theResult = UNITS.KILOBAR;
        }
        if (UnitsPressure.DECIBAR.equals(inModelUnit)) {
            theResult = UNITS.DECIBAR;
        }
        if (UnitsPressure.CENTIBAR.equals(inModelUnit)) {
            theResult = UNITS.CENTIBAR;
        }
        if (UnitsPressure.MILLIBAR.equals(inModelUnit)) {
            theResult = UNITS.MILLIBAR;
        }
        if (UnitsPressure.ATMOSPHERE.equals(inModelUnit)) {
            theResult = UNITS.ATMOSPHERE;
        }
        if (UnitsPressure.PSI.equals(inModelUnit)) {
            theResult = UNITS.PSI;
        }
        if (UnitsPressure.TORR.equals(inModelUnit)) {
            theResult = UNITS.TORR;
        }
        if (UnitsPressure.MILLITORR.equals(inModelUnit)) {
            theResult = UNITS.MILLITORR;
        }
        if (UnitsPressure.MMHG.equals(inModelUnit)) {
            theResult = UNITS.MMHG;
        }
        return theResult;
    }

    public static <T extends PrimitiveNumber> Pressure getQuantity(T inValue, UnitsPressure inModelUnit) throws EnumerationException {
        if (inValue instanceof NonNegativeFloat) {
            NonNegativeFloat typedValue = (NonNegativeFloat)inValue;
            return new Pressure((Number)typedValue.getValue(), UnitsPressureEnumHandler.getBaseUnit(inModelUnit));
        }
        if (inValue instanceof NonNegativeInteger) {
            NonNegativeInteger typedValue = (NonNegativeInteger)inValue;
            return new Pressure((Number)typedValue.getValue(), UnitsPressureEnumHandler.getBaseUnit(inModelUnit));
        }
        if (inValue instanceof NonNegativeLong) {
            NonNegativeLong typedValue = (NonNegativeLong)inValue;
            return new Pressure((Number)typedValue.getValue(), UnitsPressureEnumHandler.getBaseUnit(inModelUnit));
        }
        if (inValue instanceof PercentFraction) {
            PercentFraction typedValue = (PercentFraction)inValue;
            return new Pressure((Number)typedValue.getValue(), UnitsPressureEnumHandler.getBaseUnit(inModelUnit));
        }
        if (inValue instanceof PositiveFloat) {
            PositiveFloat typedValue = (PositiveFloat)inValue;
            return new Pressure((Number)typedValue.getValue(), UnitsPressureEnumHandler.getBaseUnit(inModelUnit));
        }
        if (inValue instanceof PositiveInteger) {
            PositiveInteger typedValue = (PositiveInteger)inValue;
            return new Pressure((Number)typedValue.getValue(), UnitsPressureEnumHandler.getBaseUnit(inModelUnit));
        }
        if (inValue instanceof PositiveLong) {
            PositiveLong typedValue = (PositiveLong)inValue;
            return new Pressure((Number)typedValue.getValue(), UnitsPressureEnumHandler.getBaseUnit(inModelUnit));
        }
        LOGGER.warn("Unknown type '{}' cannot be used to create a 'Pressure' quantity", (Object)inValue.getClass().getName());
        throw new EnumerationException("UnitsPressureEnumHandler: type '" + inValue.getClass().getName() + "' cannot be used to create a quantity");
    }

    public static <T extends Number> Pressure getQuantity(T inValue, UnitsPressure inModelUnit) throws EnumerationException {
        if (inValue instanceof Double) {
            Double doubleValue = (Double)inValue;
            return new Pressure(doubleValue, UnitsPressureEnumHandler.getBaseUnit(inModelUnit));
        }
        if (inValue instanceof Integer) {
            Integer intValue = (Integer)inValue;
            return new Pressure(intValue, UnitsPressureEnumHandler.getBaseUnit(inModelUnit));
        }
        LOGGER.warn("Unknown type '{}' cannot be used to create a 'Pressure' quantity", (Object)inValue.getClass().getName());
        throw new EnumerationException("UnitsPressureEnumHandler: type '" + inValue.getClass().getName() + "' cannot be used to create a quantity");
    }

    @Override
    public Class<? extends Enumeration> getEntity() {
        return UnitsPressure.class;
    }
}

