/*
 * Decompiled with CFR 0.152.
 */
package icy.roi;

import icy.canvas.IcyCanvas;
import icy.common.CollapsibleEvent;
import icy.common.UpdateEventHandler;
import icy.common.listener.ChangeListener;
import icy.file.xml.XMLPersistent;
import icy.gui.inspector.RoisPanel;
import icy.main.Icy;
import icy.painter.Overlay;
import icy.painter.VtkPainter;
import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginROI;
import icy.preferences.GeneralPreferences;
import icy.resource.ResourceUtil;
import icy.roi.BooleanMask2D;
import icy.roi.ROI3D;
import icy.roi.ROI4D;
import icy.roi.ROI5D;
import icy.roi.ROIEvent;
import icy.roi.ROIListener;
import icy.roi.ROIUtil;
import icy.sequence.Sequence;
import icy.system.IcyExceptionHandler;
import icy.type.point.Point5D;
import icy.type.rectangle.Rectangle5D;
import icy.util.ClassUtil;
import icy.util.ColorUtil;
import icy.util.EventUtil;
import icy.util.ShapeUtil;
import icy.util.StringUtil;
import icy.util.XMLUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.kernel.canvas.VtkCanvas;
import plugins.kernel.roi.roi2d.ROI2DArea;
import plugins.kernel.roi.roi3d.ROI3DArea;
import plugins.kernel.roi.roi4d.ROI4DArea;
import plugins.kernel.roi.roi5d.ROI5DArea;
import vtk.vtkProp;

public abstract class ROI
implements ChangeListener,
XMLPersistent {
    public static final String ID_ROI = "roi";
    public static final String ID_CLASSNAME = "classname";
    public static final String ID_ID = "id";
    public static final String ID_NAME = "name";
    public static final String ID_COLOR = "color";
    public static final String ID_STROKE = "stroke";
    public static final String ID_OPACITY = "opacity";
    public static final String ID_SELECTED = "selected";
    public static final String ID_READONLY = "readOnly";
    public static final String ID_SHOWNAME = "showName";
    public static final String ID_PROPERTIES = "properties";
    public static final ROIIdComparator idComparator = new ROIIdComparator();
    public static final ROINameComparator nameComparator = new ROINameComparator();
    public static final double DEFAULT_STROKE = 2.0;
    public static final Color DEFAULT_COLOR = Color.GREEN;
    public static final float DEFAULT_OPACITY = 0.3f;
    public static Color defaultColor = null;
    public static Float defaultOpacity = null;
    public static Double defaultStroke = null;
    public static Boolean defaultShowName = null;
    @Deprecated
    public static final Color DEFAULT_NORMAL_COLOR = DEFAULT_COLOR;
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_ID = "id";
    public static final String PROPERTY_ICON = "icon";
    public static final String PROPERTY_CREATING = "creating";
    public static final String PROPERTY_READONLY = "readOnly";
    public static final String PROPERTY_SHOWNAME = "showName";
    public static final String PROPERTY_COLOR = "color";
    public static final String PROPERTY_STROKE = "stroke";
    public static final String PROPERTY_OPACITY = "opacity";
    public static final String ROI_CHANGED_POSITION = "position";
    public static final String ROI_CHANGED_ALL = "all";
    private static int id_generator = 1;
    protected final ROIPainter painter;
    protected int id = ROI.generateId();
    protected String name = "";
    protected boolean creating = false;
    protected boolean focused = false;
    protected boolean selected = false;
    protected boolean readOnly = false;
    protected final Map<String, String> properties;
    protected Image icon;
    protected Rectangle5D cachedBounds;
    protected double cachedNumberOfPoints = 0.0;
    protected double cachedNumberOfContourPoints = 0.0;
    protected boolean boundsInvalid = true;
    protected boolean numberOfContourPointsInvalid = true;
    protected boolean numberOfPointsInvalid = true;
    protected final List<ROIListener> listeners;
    protected final UpdateEventHandler updater;

    public static ROI create(String className) {
        ROI result;
        block7: {
            result = null;
            try {
                Class<?> clazz = ClassUtil.findClass(className);
                if (clazz == null) break block7;
                try {
                    Class<PluginROI> roiClazz = clazz.asSubclass(PluginROI.class);
                    PluginROI plugin = roiClazz.newInstance();
                    result = plugin.createROI();
                    Image icon = ((Plugin)((Object)plugin)).getDescriptor().getIconAsImage();
                    if (icon != null) {
                        result.setIcon(icon);
                    }
                }
                catch (ClassCastException e0) {
                    Class<ROI> roiClazz = clazz.asSubclass(ROI.class);
                    Constructor<ROI> constructor = roiClazz.getConstructor(new Class[0]);
                    result = constructor.newInstance(new Object[0]);
                }
            }
            catch (NoSuchMethodException e) {
                IcyExceptionHandler.handleException(new NoSuchMethodException("Default constructor not found in class '" + className + "', cannot create the ROI."), true);
            }
            catch (ClassNotFoundException e) {
                IcyExceptionHandler.handleException(new ClassNotFoundException("Cannot find '" + className + "' class, cannot create the ROI."), true);
            }
            catch (Exception e) {
                IcyExceptionHandler.handleException(e, true);
            }
        }
        return result;
    }

    public static ROI create(String className, Point5D imagePoint) {
        ROI result;
        block9: {
            if (imagePoint == null) {
                return ROI.create(className);
            }
            result = null;
            try {
                Class<?> clazz = ClassUtil.findClass(className);
                if (clazz == null) break block9;
                try {
                    Image icon;
                    Class<PluginROI> roiClazz = clazz.asSubclass(PluginROI.class);
                    PluginROI plugin = roiClazz.newInstance();
                    result = plugin.createROI(imagePoint);
                    if (result == null) {
                        result = plugin.createROI();
                    }
                    if ((icon = ((Plugin)((Object)plugin)).getDescriptor().getIconAsImage()) != null) {
                        result.setIcon(icon);
                    }
                }
                catch (ClassCastException e0) {
                    Class<ROI> roiClazz = clazz.asSubclass(ROI.class);
                    try {
                        Constructor<ROI> constructor = roiClazz.getConstructor(Point5D.class);
                        result = constructor.newInstance(imagePoint);
                    }
                    catch (NoSuchMethodException e1) {
                        Constructor<ROI> constructor = roiClazz.getConstructor(new Class[0]);
                        result = constructor.newInstance(new Object[0]);
                    }
                }
            }
            catch (Exception e) {
                IcyExceptionHandler.handleException(new NoSuchMethodException("Default constructor not found in class '" + className + "', cannot create the ROI."), true);
            }
        }
        return result;
    }

    @Deprecated
    public static ROI create(String className, Point2D imagePoint) {
        return ROI.create(className, new Point5D.Double(imagePoint.getX(), imagePoint.getY(), -1.0, -1.0, -1.0));
    }

    @Deprecated
    public static ROI create(String className, Sequence seq, Point2D imagePoint, boolean creation) {
        ROI result = ROI.create(className, imagePoint);
        if (seq != null && result != null) {
            seq.addROI(result, true);
        }
        return result;
    }

    public static ROI createFromXML(Node node) {
        if (node == null) {
            return null;
        }
        String className = XMLUtil.getElementValue(node, ID_CLASSNAME, "");
        if (StringUtil.isEmpty(className)) {
            return null;
        }
        ROI roi = ROI.create(className);
        if (roi != null) {
            if (!roi.loadFromXML(node)) {
                return null;
            }
            roi.setSelected(false);
        }
        return roi;
    }

    public static double getAdjustedStroke(IcyCanvas canvas, double stroke) {
        double adjStrkX = canvas.canvasToImageLogDeltaX((int)stroke);
        double adjStrkY = canvas.canvasToImageLogDeltaY((int)stroke);
        return Math.max(adjStrkX, adjStrkY);
    }

    public static List<ROI> getROIList(List<? extends ROI> rois, Class<? extends ROI> clazz) {
        ArrayList<ROI> result = new ArrayList<ROI>();
        for (ROI rOI : rois) {
            if (!clazz.isInstance(rOI)) continue;
            result.add(rOI);
        }
        return result;
    }

    @Deprecated
    public static ArrayList<ROI> getROIList(ArrayList<? extends ROI> rois, Class<? extends ROI> clazz) {
        ArrayList<ROI> result = new ArrayList<ROI>();
        for (ROI rOI : rois) {
            if (!clazz.isInstance(rOI)) continue;
            result.add(rOI);
        }
        return result;
    }

    @Deprecated
    public static List<ROI> getROIList(ROI[] rois, Class<? extends ROI> clazz) {
        ArrayList<ROI> result = new ArrayList<ROI>();
        ROI[] rOIArray = rois;
        int n = rois.length;
        int n2 = 0;
        while (n2 < n) {
            ROI roi = rOIArray[n2];
            if (clazz.isInstance(roi)) {
                result.add(roi);
            }
            ++n2;
        }
        return result;
    }

    public static int getROICount(Node node) {
        ArrayList<Node> nodesROI;
        if (node != null && (nodesROI = XMLUtil.getChildren(node, ID_ROI)) != null) {
            return nodesROI.size();
        }
        return 0;
    }

    public static List<ROI> loadROIsFromXML(Node node) {
        ArrayList<Node> nodesROI;
        ArrayList<ROI> result = new ArrayList<ROI>();
        if (node != null && (nodesROI = XMLUtil.getChildren(node, ID_ROI)) != null) {
            for (Node n : nodesROI) {
                ROI roi = ROI.createFromXML(n);
                if (roi == null) continue;
                result.add(roi);
            }
        }
        return result;
    }

    @Deprecated
    public static List<ROI> getROIsFromXML(Node node) {
        return ROI.loadROIsFromXML(node);
    }

    public static void saveROIsToXML(Node node, List<ROI> rois) {
        if (node != null) {
            for (ROI roi : rois) {
                Element nodeROI;
                if (roi.saveToXML(nodeROI = XMLUtil.addElement(node, ID_ROI))) continue;
                XMLUtil.removeNode(node, nodeROI);
                System.err.println("Error: the roi " + roi.getName() + " was not correctly saved to XML !");
            }
        }
    }

    @Deprecated
    public static void setROIsFromXML(Node node, List<ROI> rois) {
        ROI.saveROIsToXML(node, rois);
    }

    public static Color getDefaultColor() {
        if (defaultColor == null) {
            defaultColor = new Color(GeneralPreferences.getPreferencesRoiOverlay().getInt("color", DEFAULT_COLOR.getRGB()));
        }
        return defaultColor;
    }

    public static float getDefaultOpacity() {
        if (defaultOpacity == null) {
            defaultOpacity = Float.valueOf(GeneralPreferences.getPreferencesRoiOverlay().getFloat("opacity", 0.3f));
        }
        return defaultOpacity.floatValue();
    }

    public static double getDefaultStroke() {
        if (defaultStroke == null) {
            defaultStroke = GeneralPreferences.getPreferencesRoiOverlay().getDouble("stroke", 2.0);
        }
        return defaultStroke;
    }

    public static boolean getDefaultShowName() {
        if (defaultShowName == null) {
            defaultShowName = GeneralPreferences.getPreferencesRoiOverlay().getBoolean("showName", false);
        }
        return defaultShowName;
    }

    public static void setDefaultColor(Color value) {
        defaultColor = value;
        GeneralPreferences.getPreferencesRoiOverlay().putInt("color", value.getRGB());
    }

    public static void setDefaultOpacity(float value) {
        defaultOpacity = Float.valueOf(value);
        GeneralPreferences.getPreferencesRoiOverlay().putFloat("opacity", value);
    }

    public static void setDefaultStroke(double value) {
        defaultStroke = value;
        GeneralPreferences.getPreferencesRoiOverlay().putDouble("stroke", value);
    }

    public static void setDefaultShowName(boolean value) {
        defaultShowName = value;
        GeneralPreferences.getPreferencesRoiOverlay().putBoolean("showName", value);
    }

    @Deprecated
    public static double canvasToImageDeltaX(IcyCanvas canvas, int value) {
        return canvas.canvasToImageDeltaX(value);
    }

    @Deprecated
    public static double canvasToImageLogDeltaX(IcyCanvas canvas, double value, double logFactor) {
        return canvas.canvasToImageLogDeltaX((int)value, logFactor);
    }

    @Deprecated
    public static double canvasToImageLogDeltaX(IcyCanvas canvas, double value) {
        return canvas.canvasToImageLogDeltaX((int)value);
    }

    @Deprecated
    public static double canvasToImageLogDeltaX(IcyCanvas canvas, int value, double logFactor) {
        return canvas.canvasToImageLogDeltaX(value, logFactor);
    }

    @Deprecated
    public static double canvasToImageLogDeltaX(IcyCanvas canvas, int value) {
        return canvas.canvasToImageLogDeltaX(value);
    }

    @Deprecated
    public static double canvasToImageDeltaY(IcyCanvas canvas, int value) {
        return canvas.canvasToImageDeltaY(value);
    }

    @Deprecated
    public static double canvasToImageLogDeltaY(IcyCanvas canvas, double value, double logFactor) {
        return canvas.canvasToImageLogDeltaY((int)value, logFactor);
    }

    @Deprecated
    public static double canvasToImageLogDeltaY(IcyCanvas canvas, double value) {
        return canvas.canvasToImageLogDeltaY((int)value);
    }

    @Deprecated
    public static double canvasToImageLogDeltaY(IcyCanvas canvas, int value, double logFactor) {
        return canvas.canvasToImageLogDeltaY(value, logFactor);
    }

    @Deprecated
    public static double canvasToImageLogDeltaY(IcyCanvas canvas, int value) {
        return canvas.canvasToImageLogDeltaY(value);
    }

    public ROI() {
        this.painter = this.createPainter();
        this.properties = new HashMap<String, String>();
        this.cachedBounds = new Rectangle5D.Double();
        this.listeners = new ArrayList<ROIListener>();
        this.updater = new UpdateEventHandler(this, false);
        this.icon = ResourceUtil.ICON_ROI;
        this.name = this.getDefaultName();
    }

    protected abstract ROIPainter createPainter();

    public abstract int getDimension();

    private static synchronized int generateId() {
        return id_generator++;
    }

    @Deprecated
    public void attachTo(Sequence sequence) {
        if (sequence != null) {
            sequence.addROI(this);
        }
    }

    @Deprecated
    public void detachFrom(Sequence sequence) {
        if (sequence != null) {
            sequence.removeROI(this);
        }
    }

    @Deprecated
    public void detachFromAll(boolean canUndo) {
        this.remove(canUndo);
    }

    @Deprecated
    public void detachFromAll() {
        this.remove(false);
    }

    public boolean isAttached(Sequence sequence) {
        if (sequence != null) {
            return sequence.contains(this);
        }
        return false;
    }

    public Sequence getFirstSequence() {
        return Icy.getMainInterface().getFirstSequenceContaining(this);
    }

    public ArrayList<Sequence> getSequences() {
        return Icy.getMainInterface().getSequencesContaining(this);
    }

    public void remove(boolean canUndo) {
        ArrayList<Sequence> sequences = Icy.getMainInterface().getSequencesContaining(this);
        for (Sequence sequence : sequences) {
            sequence.removeROI(this, canUndo);
        }
    }

    public void remove() {
        this.remove(true);
    }

    @Deprecated
    public void delete(boolean canUndo) {
        this.remove(canUndo);
    }

    @Deprecated
    public void delete() {
        this.remove(true);
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    public String getSimpleClassName() {
        return ClassUtil.getSimpleClassName(this.getClassName());
    }

    public int getId() {
        return this.id;
    }

    @Deprecated
    public ROIPainter getPainter() {
        return this.getOverlay();
    }

    public ROIPainter getOverlay() {
        return this.painter;
    }

    public double getStroke() {
        return this.getOverlay().getStroke();
    }

    public double getAdjustedStroke(IcyCanvas canvas) {
        return this.getOverlay().getAdjustedStroke(canvas);
    }

    public void setStroke(double value) {
        this.getOverlay().setStroke(value);
    }

    public float getOpacity() {
        return this.getOverlay().getOpacity();
    }

    public void setOpacity(float value) {
        this.getOverlay().setOpacity(value);
    }

    public Color getFocusedColor() {
        return this.getOverlay().getFocusedColor();
    }

    @Deprecated
    public Color getSelectedColor() {
        return this.getOverlay().getSelectedColor();
    }

    public Color getDisplayColor() {
        return this.getOverlay().getDisplayColor();
    }

    public Color getColor() {
        return this.getOverlay().getColor();
    }

    public void setColor(Color value) {
        this.getOverlay().setColor(value);
    }

    @Deprecated
    public void setSelectedColor(Color value) {
    }

    public Image getIcon() {
        return this.icon;
    }

    public void setIcon(Image value) {
        if (this.icon != value) {
            this.icon = value;
            this.propertyChanged(PROPERTY_ICON);
        }
    }

    public String getDefaultName() {
        return "ROI";
    }

    public boolean isDefaultName() {
        return this.getName().equals(this.getDefaultName());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        if (this.name != value) {
            this.name = value;
            this.propertyChanged("name");
            this.painter.propertyChanged("name");
        }
    }

    public Map<String, String> getProperties() {
        return new HashMap<String, String>(this.properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProperty(String name) {
        if (name == null) {
            return null;
        }
        String adjName = name.toLowerCase();
        if (StringUtil.equals(adjName, PROPERTY_CREATING)) {
            return Boolean.toString(this.isCreating());
        }
        if (StringUtil.equals(adjName, "name")) {
            return this.getName();
        }
        if (StringUtil.equals(adjName, "opacity")) {
            return Float.toString(this.getOpacity());
        }
        if (StringUtil.equals(adjName, "readOnly")) {
            return Boolean.toString(this.isReadOnly());
        }
        if (StringUtil.equals(adjName, "showName")) {
            return Boolean.toString(this.getShowName());
        }
        if (StringUtil.equals(adjName, "stroke")) {
            return Double.toString(this.getStroke());
        }
        if (StringUtil.equals(adjName, "color") || StringUtil.equals(adjName, PROPERTY_ICON)) {
            throw new IllegalArgumentException("Cannot return value of property '" + adjName + "' as String");
        }
        Map<String, String> map = this.properties;
        synchronized (map) {
            return this.properties.get(adjName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String name, String value) {
        if (name == null) {
            return;
        }
        String adjName = name.toLowerCase();
        if (StringUtil.equals(adjName, PROPERTY_CREATING)) {
            this.setCreating(Boolean.valueOf(value));
        }
        if (StringUtil.equals(adjName, "name")) {
            this.setName(value);
        }
        if (StringUtil.equals(adjName, "opacity")) {
            this.setOpacity(Float.valueOf(value).floatValue());
        }
        if (StringUtil.equals(adjName, "readOnly")) {
            this.setReadOnly(Boolean.valueOf(value));
        }
        if (StringUtil.equals(adjName, "showName")) {
            this.setShowName(Boolean.valueOf(value));
        }
        if (StringUtil.equals(adjName, "stroke")) {
            this.setStroke(Double.valueOf(value));
        }
        if (StringUtil.equals(adjName, "color") || StringUtil.equals(adjName, PROPERTY_ICON)) {
            throw new IllegalArgumentException("Cannot set value of property '" + adjName + "' as String");
        }
        Map<String, String> map = this.properties;
        synchronized (map) {
            this.properties.put(adjName, value);
        }
        this.propertyChanged(adjName);
    }

    @Deprecated
    public Object getPropertyValue(String propertyName) {
        if (StringUtil.equals(propertyName, "color")) {
            return this.getColor();
        }
        if (StringUtil.equals(propertyName, PROPERTY_CREATING)) {
            return this.isCreating();
        }
        if (StringUtil.equals(propertyName, PROPERTY_ICON)) {
            return this.getIcon();
        }
        if (StringUtil.equals(propertyName, "name")) {
            return this.getName();
        }
        if (StringUtil.equals(propertyName, "opacity")) {
            return Float.valueOf(this.getOpacity());
        }
        if (StringUtil.equals(propertyName, "readOnly")) {
            return this.isReadOnly();
        }
        if (StringUtil.equals(propertyName, "showName")) {
            return this.getShowName();
        }
        if (StringUtil.equals(propertyName, "stroke")) {
            return this.getStroke();
        }
        return null;
    }

    @Deprecated
    public void setPropertyValue(String propertyName, Object value) {
        if (StringUtil.equals(propertyName, "color")) {
            this.setColor((Color)value);
        }
        if (StringUtil.equals(propertyName, PROPERTY_CREATING)) {
            this.setCreating((Boolean)value);
        }
        if (StringUtil.equals(propertyName, PROPERTY_ICON)) {
            this.setIcon((Image)value);
        }
        if (StringUtil.equals(propertyName, "name")) {
            this.setName((String)value);
        }
        if (StringUtil.equals(propertyName, "opacity")) {
            this.setOpacity(((Float)value).floatValue());
        }
        if (StringUtil.equals(propertyName, "readOnly")) {
            this.setReadOnly((Boolean)value);
        }
        if (StringUtil.equals(propertyName, "showName")) {
            this.setShowName((Boolean)value);
        }
        if (StringUtil.equals(propertyName, "stroke")) {
            this.setStroke((Double)value);
        }
    }

    public boolean isCreating() {
        return this.creating;
    }

    public void setCreating(boolean value) {
        if (this.creating != value) {
            this.creating = value;
            this.propertyChanged(PROPERTY_CREATING);
        }
    }

    public abstract boolean hasSelectedPoint();

    public void unselectAllPoints() {
    }

    public boolean isFocused() {
        return this.focused;
    }

    public void setFocused(boolean value) {
        boolean done = false;
        if (value) {
            ArrayList<Sequence> attachedSeqs = Icy.getMainInterface().getSequencesContaining(this);
            for (Sequence seq : attachedSeqs) {
                done |= seq.setFocusedROI(this);
            }
        }
        if (!done) {
            if (value) {
                this.internalFocus();
            } else {
                this.internalUnfocus();
            }
        }
    }

    public void internalFocus() {
        if (!this.focused) {
            this.focused = true;
            this.focusChanged();
        }
    }

    public void internalUnfocus() {
        if (this.focused) {
            this.focused = false;
            this.focusChanged();
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean value) {
        if (this.selected != value) {
            this.selected = value;
            if (!value) {
                this.setCreating(false);
            }
            this.selectionChanged();
        }
    }

    @Deprecated
    public void setSelected(boolean value, boolean exclusive) {
        if (exclusive) {
            ArrayList<Sequence> attachedSeqs = Icy.getMainInterface().getSequencesContaining(this);
            for (Sequence seq : attachedSeqs) {
                seq.setSelectedROI(value ? this : null);
            }
        } else {
            this.setSelected(value);
        }
    }

    @Deprecated
    public void internalUnselect() {
        if (this.selected) {
            this.selected = false;
            this.setCreating(false);
            this.selectionChanged();
        }
    }

    @Deprecated
    public void internalSelect() {
        if (!this.selected) {
            this.selected = true;
            this.selectionChanged();
        }
    }

    @Deprecated
    public boolean isEditable() {
        return !this.isReadOnly();
    }

    @Deprecated
    public void setEditable(boolean value) {
        this.setReadOnly(!value);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean value) {
        if (this.readOnly != value) {
            this.readOnly = value;
            this.propertyChanged("readOnly");
        }
    }

    public boolean getShowName() {
        return this.getOverlay().getShowName();
    }

    public void setShowName(boolean value) {
        this.getOverlay().setShowName(value);
    }

    public abstract boolean isActiveFor(IcyCanvas var1);

    public abstract Rectangle5D computeBounds5D();

    public Rectangle5D getBounds5D() {
        if (this.boundsInvalid) {
            this.cachedBounds = this.computeBounds5D();
            this.boundsInvalid = false;
        }
        return (Rectangle5D)this.cachedBounds.clone();
    }

    public Point5D getPosition5D() {
        return this.getBounds5D().getPosition();
    }

    public abstract boolean canSetBounds();

    public abstract boolean canSetPosition();

    public abstract void setBounds5D(Rectangle5D var1);

    public abstract void setPosition5D(Point5D var1);

    public boolean isEmpty() {
        return this.getBounds5D().isEmpty();
    }

    public abstract boolean contains(double var1, double var3, double var5, double var7, double var9);

    public boolean contains(Point5D p) {
        if (p == null) {
            return false;
        }
        return this.contains(p.getX(), p.getY(), p.getZ(), p.getT(), p.getC());
    }

    public abstract boolean contains(double var1, double var3, double var5, double var7, double var9, double var11, double var13, double var15, double var17, double var19);

    public boolean contains(Rectangle5D r) {
        if (r == null) {
            return false;
        }
        return this.contains(r.getX(), r.getY(), r.getZ(), r.getT(), r.getC(), r.getSizeX(), r.getSizeY(), r.getSizeZ(), r.getSizeT(), r.getSizeC());
    }

    public boolean contains(ROI roi) {
        Rectangle5D.Integer bounds = this.getBounds5D().toInteger();
        Rectangle5D.Integer roiBounds = roi.getBounds5D().toInteger();
        if (bounds.isEmpty()) {
            return false;
        }
        if (roiBounds.isEmpty()) {
            return this.contains(roiBounds.getPosition());
        }
        if (bounds.contains(roiBounds)) {
            int maxC;
            int minC;
            int maxT;
            int minT;
            int maxZ;
            int minZ;
            Rectangle5D.Integer containedBounds = bounds.createIntersection(roiBounds).toInteger();
            if (containedBounds.isInfiniteZ()) {
                minZ = -1;
                maxZ = -1;
            } else {
                minZ = (int)containedBounds.getMinZ();
                maxZ = (int)containedBounds.getMaxZ();
            }
            if (containedBounds.isInfiniteT()) {
                minT = -1;
                maxT = -1;
            } else {
                minT = (int)containedBounds.getMinT();
                maxT = (int)containedBounds.getMaxT();
            }
            if (containedBounds.isInfiniteC()) {
                minC = -1;
                maxC = -1;
            } else {
                minC = (int)containedBounds.getMinC();
                maxC = (int)containedBounds.getMaxC();
            }
            Rectangle containedBounds2D = (Rectangle)containedBounds.toRectangle2D();
            int c = minC;
            while (c <= maxC) {
                int t = minT;
                while (t <= maxT) {
                    int z = minZ;
                    while (z <= maxZ) {
                        BooleanMask2D roiMask;
                        BooleanMask2D mask = new BooleanMask2D(containedBounds2D, this.getBooleanMask2D(containedBounds2D, z, t, c, false));
                        if (!mask.contains(roiMask = new BooleanMask2D(containedBounds2D, roi.getBooleanMask2D(containedBounds2D, z, t, c, false)))) {
                            return false;
                        }
                        mask = new BooleanMask2D(containedBounds2D, this.getBooleanMask2D(containedBounds2D, z, t, c, true));
                        if (!mask.contains(roiMask = new BooleanMask2D(containedBounds2D, roi.getBooleanMask2D(containedBounds2D, z, t, c, true)))) {
                            return false;
                        }
                        ++z;
                    }
                    ++t;
                }
                ++c;
            }
            return true;
        }
        return false;
    }

    public abstract boolean intersects(double var1, double var3, double var5, double var7, double var9, double var11, double var13, double var15, double var17, double var19);

    public boolean intersects(Rectangle5D r) {
        if (r == null) {
            return false;
        }
        return this.intersects(r.getX(), r.getY(), r.getZ(), r.getT(), r.getC(), r.getSizeX(), r.getSizeY(), r.getSizeZ(), r.getSizeT(), r.getSizeC());
    }

    public boolean intersects(ROI roi) {
        int maxC;
        int minC;
        int maxT;
        int minT;
        int maxZ;
        int minZ;
        Rectangle5D.Integer roiBounds;
        Rectangle5D.Integer bounds = this.getBounds5D().toInteger();
        Rectangle5D.Integer intersection = bounds.createIntersection(roiBounds = roi.getBounds5D().toInteger()).toInteger();
        if (intersection.isInfiniteZ()) {
            minZ = -1;
            maxZ = -1;
        } else {
            minZ = (int)intersection.getMinZ();
            maxZ = (int)intersection.getMaxZ();
        }
        if (intersection.isInfiniteT()) {
            minT = -1;
            maxT = -1;
        } else {
            minT = (int)intersection.getMinT();
            maxT = (int)intersection.getMaxT();
        }
        if (intersection.isInfiniteC()) {
            minC = -1;
            maxC = -1;
        } else {
            minC = (int)intersection.getMinC();
            maxC = (int)intersection.getMaxC();
        }
        int c = minC;
        while (c <= maxC) {
            int t = minT;
            while (t <= maxT) {
                int z = minZ;
                while (z <= maxZ) {
                    if (this.getBooleanMask2D(z, t, c, true).intersects(roi.getBooleanMask2D(z, t, c, true))) {
                        return true;
                    }
                    ++z;
                }
                ++t;
            }
            ++c;
        }
        return false;
    }

    public boolean[] getBooleanMask2D(int x, int y, int width, int height, int z, int t, int c, boolean inclusive) {
        boolean[] result = new boolean[Math.max(0, width) * Math.max(0, height)];
        int offset = 0;
        int j = 0;
        while (j < height) {
            int i = 0;
            while (i < width) {
                result[offset] = inclusive ? this.intersects(x + i, y + j, z, t, c, 1.0, 1.0, 1.0, 1.0, 1.0) : this.contains(x + i, y + j, z, t, c, 1.0, 1.0, 1.0, 1.0, 1.0);
                ++offset;
                ++i;
            }
            ++j;
        }
        return result;
    }

    public boolean[] getBooleanMask2D(Rectangle rect, int z, int t, int c, boolean inclusive) {
        return this.getBooleanMask2D(rect.x, rect.y, rect.width, rect.height, z, t, c, inclusive);
    }

    public BooleanMask2D getBooleanMask2D(int z, int t, int c, boolean inclusive) {
        Rectangle bounds2D = this.getBounds5D().toRectangle2D().getBounds();
        if (bounds2D.isEmpty()) {
            return new BooleanMask2D(new Rectangle(), new boolean[0]);
        }
        return new BooleanMask2D(bounds2D, this.getBooleanMask2D(bounds2D.x, bounds2D.y, bounds2D.width, bounds2D.height, z, t, c, inclusive));
    }

    @Deprecated
    protected ROI computeOperation(ROI roi, ShapeUtil.BooleanOperator op) throws UnsupportedOperationException {
        System.out.println("Deprecated method " + this.getClassName() + ".computeOperation(ROI, BooleanOperator) called !");
        return null;
    }

    public ROI mergeWith(ROI roi, ShapeUtil.BooleanOperator op, boolean allowCreate) throws UnsupportedOperationException {
        switch (op) {
            case AND: {
                return this.intersect(roi, allowCreate);
            }
            case OR: {
                return this.add(roi, allowCreate);
            }
            case XOR: {
                return this.exclusiveAdd(roi, allowCreate);
            }
        }
        return this;
    }

    public ROI add(ROI roi, boolean allowCreate) throws UnsupportedOperationException {
        if (roi == null) {
            return this;
        }
        if (allowCreate) {
            return this.getUnion(roi);
        }
        throw new UnsupportedOperationException(String.valueOf(this.getClassName()) + " does not support add(ROI) operation !");
    }

    public ROI intersect(ROI roi, boolean allowCreate) throws UnsupportedOperationException {
        if (roi == null) {
            return this;
        }
        if (allowCreate) {
            return this.getIntersection(roi);
        }
        throw new UnsupportedOperationException(String.valueOf(this.getClassName()) + " does not support intersect(ROI) operation !");
    }

    public ROI exclusiveAdd(ROI roi, boolean allowCreate) throws UnsupportedOperationException {
        if (roi == null) {
            return this;
        }
        if (allowCreate) {
            return this.getExclusiveUnion(roi);
        }
        throw new UnsupportedOperationException(String.valueOf(this.getClassName()) + " does not support exclusiveAdd(ROI) operation !");
    }

    public ROI subtract(ROI roi, boolean allowCreate) throws UnsupportedOperationException {
        if (roi == null) {
            return this;
        }
        if (allowCreate) {
            return this.getSubtraction(roi);
        }
        throw new UnsupportedOperationException(String.valueOf(this.getClassName()) + " does not support subtract(ROI) operation !");
    }

    public ROI merge(ROI roi, ShapeUtil.BooleanOperator op) throws UnsupportedOperationException {
        switch (op) {
            case AND: {
                return this.getIntersection(roi);
            }
            case OR: {
                return this.getUnion(roi);
            }
            case XOR: {
                return this.getExclusiveUnion(roi);
            }
        }
        return null;
    }

    public ROI getUnion(ROI roi) throws UnsupportedOperationException {
        return ROIUtil.getUnion(this, roi);
    }

    public ROI getIntersection(ROI roi) throws UnsupportedOperationException {
        return ROIUtil.getIntersection(this, roi);
    }

    public ROI getExclusiveUnion(ROI roi) throws UnsupportedOperationException {
        return ROIUtil.getExclusiveUnion(this, roi);
    }

    public ROI getSubtraction(ROI roi) throws UnsupportedOperationException {
        return ROIUtil.getSubtraction(this, roi);
    }

    public abstract double computeNumberOfContourPoints();

    public double getNumberOfContourPoints() {
        if (this.numberOfContourPointsInvalid) {
            this.cachedNumberOfContourPoints = this.computeNumberOfContourPoints();
            this.numberOfContourPointsInvalid = false;
        }
        return this.cachedNumberOfContourPoints;
    }

    public abstract double computeNumberOfPoints();

    public double getNumberOfPoints() {
        if (this.numberOfPointsInvalid) {
            this.cachedNumberOfPoints = this.computeNumberOfPoints();
            this.numberOfPointsInvalid = false;
        }
        return this.cachedNumberOfPoints;
    }

    public double getLength(Sequence sequence) throws UnsupportedOperationException {
        return sequence.calculateSize(this.getNumberOfContourPoints(), this.getDimension(), 1);
    }

    @Deprecated
    public double getPerimeter() {
        return this.getNumberOfContourPoints();
    }

    @Deprecated
    public double getVolume() {
        return this.getNumberOfPoints();
    }

    @Deprecated
    public void setMousePos(Point2D pos) {
        if (pos != null) {
            this.getOverlay().setMousePos(new Point5D.Double(pos.getX(), pos.getY(), -1.0, -1.0, -1.0));
        }
    }

    public ROI getCopy() {
        Element node = XMLUtil.createDocument(true).getDocumentElement();
        int retry = 3;
        while (retry > 0 && !this.saveToXML(node)) {
            --retry;
        }
        if (retry <= 0) {
            System.err.println("Cannot get a copy of roi " + this.getName() + ": XML save operation failed.");
            return null;
        }
        retry = 3;
        ROI result = null;
        while (retry > 0 && result == null) {
            result = ROI.createFromXML(node);
            --retry;
        }
        if (result == null) {
            System.err.println("Cannot get a copy of roi " + this.getName() + ": creation from XML failed.");
            return null;
        }
        result.id = ROI.generateId();
        return result;
    }

    public static String getNameSuffix(int z, int t, int c) {
        String result = "";
        if (z != -1) {
            result = StringUtil.isEmpty(result) ? " [" : String.valueOf(result) + ", ";
            result = String.valueOf(result) + "Z=" + z;
        }
        if (t != -1) {
            result = StringUtil.isEmpty(result) ? " [" : String.valueOf(result) + ", ";
            result = String.valueOf(result) + "T=" + t;
        }
        if (c != -1) {
            result = StringUtil.isEmpty(result) ? " [" : String.valueOf(result) + ", ";
            result = String.valueOf(result) + "C=" + c;
        }
        if (!StringUtil.isEmpty(result)) {
            result = String.valueOf(result) + "]";
        }
        return result;
    }

    public ROI getSubROI(int z, int t, int c) {
        ROI result;
        switch (this.getDimension()) {
            default: {
                result = new ROI2DArea(this.getBooleanMask2D(z, t, c, false));
                break;
            }
            case 3: {
                if (z == -1) {
                    result = new ROI3DArea(((ROI3D)this).getBooleanMask3D(z, t, c, false));
                    break;
                }
                result = new ROI2DArea(((ROI3D)this).getBooleanMask2D(z, t, c, false));
                break;
            }
            case 4: {
                if (z == -1) {
                    if (t == -1) {
                        result = new ROI4DArea(((ROI4D)this).getBooleanMask4D(z, t, c, false));
                        break;
                    }
                    result = new ROI3DArea(((ROI4D)this).getBooleanMask3D(z, t, c, false));
                    break;
                }
                if (t == -1) {
                    result = new ROI4DArea(((ROI4D)this).getBooleanMask4D(z, t, c, false));
                    break;
                }
                result = new ROI2DArea(((ROI4D)this).getBooleanMask2D(z, t, c, false));
                break;
            }
            case 5: {
                if (z == -1) {
                    if (t == -1) {
                        if (c == -1) {
                            result = new ROI5DArea(((ROI5D)this).getBooleanMask5D(z, t, c, false));
                            break;
                        }
                        result = new ROI4DArea(((ROI5D)this).getBooleanMask4D(z, t, c, false));
                        break;
                    }
                    if (c == -1) {
                        result = new ROI5DArea(((ROI5D)this).getBooleanMask5D(z, t, c, false));
                        break;
                    }
                    result = new ROI3DArea(((ROI5D)this).getBooleanMask3D(z, t, c, false));
                    break;
                }
                if (t == -1) {
                    if (c == -1) {
                        result = new ROI5DArea(((ROI5D)this).getBooleanMask5D(z, t, c, false));
                        break;
                    }
                    result = new ROI4DArea(((ROI5D)this).getBooleanMask4D(z, t, c, false));
                    break;
                }
                result = c == -1 ? new ROI5DArea(((ROI5D)this).getBooleanMask5D(z, t, c, false)) : new ROI2DArea(((ROI5D)this).getBooleanMask2D(z, t, c, false));
            }
        }
        result.beginUpdate();
        try {
            if (result.canSetPosition()) {
                Point5D pos = result.getPosition5D();
                if (z != -1) {
                    pos.setZ(z);
                }
                if (t != -1) {
                    pos.setT(t);
                }
                if (c != -1) {
                    pos.setC(c);
                }
                result.setPosition5D(pos);
            }
            result.setColor(this.getColor());
            result.setName(String.valueOf(this.getName()) + ROI.getNameSuffix(z, t, c));
            result.setOpacity(this.getOpacity());
            result.setStroke(this.getStroke());
            result.setShowName(this.getShowName());
        }
        finally {
            result.endUpdate();
        }
        return result;
    }

    public boolean copyFrom(ROI roi, boolean copyId) {
        Element node = XMLUtil.createDocument(true).getDocumentElement();
        if (!roi.saveToXML(node)) {
            return false;
        }
        if (!this.loadFromXML(node)) {
            return false;
        }
        if (copyId) {
            this.id = roi.id;
        }
        return true;
    }

    public boolean copyFrom(ROI roi) {
        return this.copyFrom(roi, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean loadFromXML(Node node) {
        if (node == null) {
            return false;
        }
        this.beginUpdate();
        try {
            this.id = XMLUtil.getElementIntValue(node, "id", 0);
            this.propertyChanged("id");
            Class<ROI> clazz = ROI.class;
            synchronized (ROI.class) {
                if (id_generator <= this.id) {
                    id_generator = this.id + 1;
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                this.setName(XMLUtil.getElementValue(node, "name", ""));
                this.setSelected(XMLUtil.getElementBooleanValue(node, ID_SELECTED, false));
                this.setReadOnly(XMLUtil.getElementBooleanValue(node, "readOnly", false));
                this.properties.clear();
                Element propertiesNode = XMLUtil.getElement(node, ID_PROPERTIES);
                if (propertiesNode != null) {
                    Map<String, String> map = this.properties;
                    synchronized (map) {
                        for (Element element : XMLUtil.getElements(propertiesNode)) {
                            this.properties.put(element.getNodeName(), XMLUtil.getValue(element, ""));
                        }
                    }
                }
                boolean bl = this.painter.loadFromXML(node);
                return bl;
            }
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveToXML(Node node) {
        if (node == null) {
            return false;
        }
        XMLUtil.setElementValue(node, ID_CLASSNAME, this.getClassName());
        XMLUtil.setElementIntValue(node, "id", this.id);
        XMLUtil.setElementValue(node, "name", this.getName());
        XMLUtil.setElementBooleanValue(node, ID_SELECTED, this.isSelected());
        XMLUtil.setElementBooleanValue(node, "readOnly", this.isReadOnly());
        Element propertiesNode = XMLUtil.setElement(node, ID_PROPERTIES);
        Set<Map.Entry<String, String>> entries = this.properties.entrySet();
        Map<String, String> map = this.properties;
        synchronized (map) {
            for (Map.Entry<String, String> entry : entries) {
                XMLUtil.setElementValue(propertiesNode, entry.getKey(), entry.getValue());
            }
        }
        return this.painter.saveToXML(node);
    }

    @Deprecated
    public void roiChanged(ROIEvent.ROIPointEventType pointEventType, Object point) {
        this.updater.changed(new ROIEvent(this, ROIEvent.ROIEventType.ROI_CHANGED, pointEventType, point));
    }

    public void roiChanged(boolean contentChanged) {
        if (contentChanged) {
            this.updater.changed(new ROIEvent(this, ROIEvent.ROIEventType.ROI_CHANGED, ROI_CHANGED_ALL));
        } else {
            this.updater.changed(new ROIEvent(this, ROIEvent.ROIEventType.ROI_CHANGED, ROI_CHANGED_POSITION));
        }
    }

    @Deprecated
    public void roiChanged() {
        this.roiChanged(true);
    }

    public void selectionChanged() {
        this.updater.changed(new ROIEvent(this, ROIEvent.ROIEventType.SELECTION_CHANGED));
    }

    public void focusChanged() {
        this.updater.changed(new ROIEvent(this, ROIEvent.ROIEventType.FOCUS_CHANGED));
    }

    @Deprecated
    public void painterChanged() {
        this.updater.changed(new ROIEvent(this, ROIEvent.ROIEventType.PAINTER_CHANGED));
    }

    @Deprecated
    public void nameChanged() {
        this.updater.changed(new ROIEvent(this, ROIEvent.ROIEventType.NAME_CHANGED));
    }

    public void propertyChanged(String propertyName) {
        this.updater.changed(new ROIEvent(this, propertyName));
        if (StringUtil.equals(propertyName, "name")) {
            this.updater.changed(new ROIEvent(this, ROIEvent.ROIEventType.NAME_CHANGED));
        }
    }

    public void addListener(ROIListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(ROIListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    private void fireChangedEvent(ROIEvent event) {
        for (ROIListener listener : new ArrayList<ROIListener>(this.listeners)) {
            listener.roiChanged(event);
        }
    }

    public void beginUpdate() {
        this.updater.beginUpdate();
        this.painter.beginUpdate();
    }

    public void endUpdate() {
        this.painter.endUpdate();
        this.updater.endUpdate();
    }

    public boolean isUpdating() {
        return this.updater.isUpdating();
    }

    @Override
    public void onChanged(CollapsibleEvent object) {
        ROIEvent event = (ROIEvent)object;
        switch (event.getType()) {
            case ROI_CHANGED: {
                this.boundsInvalid = true;
                if (StringUtil.equals(event.getPropertyName(), ROI_CHANGED_ALL)) {
                    this.numberOfContourPointsInvalid = true;
                    this.numberOfPointsInvalid = true;
                }
                this.painter.painterChanged();
                break;
            }
            case FOCUS_CHANGED: 
            case SELECTION_CHANGED: {
                this.painter.computePriority();
                this.painter.painterChanged();
                break;
            }
            case PROPERTY_CHANGED: {
                String property = event.getPropertyName();
                if (!StringUtil.isEmpty(property) && !StringUtil.equals(property, "name") && !StringUtil.equals(property, "showName") && !StringUtil.equals(property, "color") && !StringUtil.equals(property, "opacity") && !StringUtil.equals(property, "showName") && !StringUtil.equals(property, "stroke")) break;
                this.painter.painterChanged();
                break;
            }
        }
        this.fireChangedEvent(event);
    }

    public static enum ROIGroupId {
        A,
        B;

    }

    public static class ROIIdComparator
    implements Comparator<ROI> {
        @Override
        public int compare(ROI roi1, ROI roi2) {
            if (roi1 == roi2) {
                return 0;
            }
            if (roi1 == null) {
                return -1;
            }
            if (roi2 == null) {
                return 1;
            }
            if (roi1.id < roi2.id) {
                return -1;
            }
            if (roi1.id > roi2.id) {
                return 1;
            }
            return 0;
        }
    }

    public static class ROINameComparator
    implements Comparator<ROI> {
        @Override
        public int compare(ROI roi1, ROI roi2) {
            if (roi1 == roi2) {
                return 0;
            }
            if (roi1 == null) {
                return -1;
            }
            if (roi2 == null) {
                return 1;
            }
            return roi1.getName().compareTo(roi2.getName());
        }
    }

    public abstract class ROIPainter
    extends Overlay
    implements VtkPainter {
        protected double stroke;
        protected Color color;
        protected float opacity;
        protected boolean showName;
        protected final Point5D.Double mousePos;

        public ROIPainter() {
            super("ROI painter", Overlay.OverlayPriority.SHAPE_NORMAL);
            this.stroke = ROI.getDefaultStroke();
            this.color = ROI.getDefaultColor();
            this.opacity = ROI.getDefaultOpacity();
            this.showName = ROI.getDefaultShowName();
            this.mousePos = new Point5D.Double();
            this.canBeRemoved = false;
        }

        public double getStroke() {
            return ROI.this.painter.stroke;
        }

        public double getAdjustedStroke(IcyCanvas canvas) {
            return ROI.getAdjustedStroke(canvas, this.getStroke());
        }

        public void setStroke(double value) {
            if (this.stroke != value) {
                this.stroke = value;
                ROI.this.propertyChanged("stroke");
            }
        }

        public float getOpacity() {
            return this.opacity;
        }

        public void setOpacity(float value) {
            if (this.opacity != value) {
                this.opacity = value;
                ROI.this.propertyChanged("opacity");
            }
        }

        public Color getFocusedColor() {
            int lum = ColorUtil.getLuminance(this.getColor());
            if (lum < 224) {
                return Color.white;
            }
            return Color.gray;
        }

        @Deprecated
        public Color getSelectedColor() {
            return this.getColor();
        }

        public Color getDisplayColor() {
            if (ROI.this.isFocused()) {
                return this.getFocusedColor();
            }
            return this.getColor();
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color value) {
            if (this.color != null && this.color != value) {
                this.color = value;
                ROI.this.propertyChanged("color");
            }
        }

        public boolean getShowName() {
            return this.showName;
        }

        public void setShowName(boolean value) {
            if (this.showName != value) {
                this.showName = value;
                ROI.this.propertyChanged("showName");
            }
        }

        @Deprecated
        public void setSelectedColor(Color value) {
        }

        @Deprecated
        public Point5D.Double getMousePos() {
            return this.mousePos;
        }

        @Deprecated
        public void setMousePos(Point5D pos) {
            if (!this.mousePos.equals(pos)) {
                this.mousePos.setLocation(pos);
            }
        }

        public void computePriority() {
            if (ROI.this.isFocused()) {
                this.setPriority(Overlay.OverlayPriority.SHAPE_TOP);
            } else if (ROI.this.isSelected()) {
                this.setPriority(Overlay.OverlayPriority.SHAPE_HIGH);
            } else {
                this.setPriority(Overlay.OverlayPriority.SHAPE_LOW);
            }
        }

        @Override
        public boolean isReadOnly() {
            return ROI.this.isReadOnly();
        }

        @Override
        public void setReadOnly(boolean readOnly) {
            super.setReadOnly(readOnly);
            ROI.this.setReadOnly(readOnly);
        }

        @Override
        public String getName() {
            return ROI.this.getName();
        }

        @Override
        public void setName(String name) {
            ROI.this.setName(name);
        }

        protected boolean updateFocus(InputEvent e, Point5D imagePoint, IcyCanvas canvas) {
            return false;
        }

        protected boolean updateSelect(InputEvent e, Point5D imagePoint, IcyCanvas canvas) {
            if (!ROI.this.isFocused()) {
                return false;
            }
            if (EventUtil.isShiftDown(e)) {
                if (!ROI.this.isSelected()) {
                    ROI.this.setSelected(true);
                    return true;
                }
            } else {
                if (EventUtil.isControlDown(e)) {
                    ROI.this.setSelected(!ROI.this.isSelected());
                    return true;
                }
                if (!ROI.this.isSelected()) {
                    if (!canvas.getSequence().setSelectedROI(ROI.this)) {
                        ROI.this.setSelected(true);
                    }
                    return true;
                }
            }
            return false;
        }

        protected boolean updateDrag(InputEvent e, Point5D imagePoint, IcyCanvas canvas) {
            return false;
        }

        @Override
        public void keyPressed(KeyEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            block42: {
                if (e.isConsumed()) break block42;
                Sequence seq = canvas.getSequence();
                switch (e.getKeyCode()) {
                    case 27: {
                        if (!seq.getSelectedROIs().isEmpty()) {
                            seq.setSelectedROI(null);
                        }
                        e.consume();
                        break;
                    }
                    case 8: 
                    case 127: {
                        if (!seq.getSelectedROIs().isEmpty()) {
                            canvas.getSequence().removeSelectedROIs(true, true);
                        } else if (ROI.this.isFocused()) {
                            canvas.getSequence().removeROI(ROI.this, true);
                        }
                        e.consume();
                        break;
                    }
                    case 75: {
                        ArrayList<ROI> selectedROIs = seq.getSelectedROIs();
                        if (!selectedROIs.isEmpty()) {
                            int numRO = 0;
                            for (ROI roi : selectedROIs) {
                                if (!roi.isReadOnly()) continue;
                                ++numRO;
                            }
                            boolean ro = numRO > selectedROIs.size() / 2;
                            seq.beginUpdate();
                            try {
                                for (ROI roi : selectedROIs) {
                                    roi.setReadOnly(!ro);
                                }
                            }
                            finally {
                                seq.endUpdate();
                            }
                        }
                        e.consume();
                    }
                }
                if (ROI.this.isActiveFor(canvas) && EventUtil.isMenuControlDown(e) && ROI.this.isSelected() && !this.isReadOnly()) {
                    switch (e.getKeyCode()) {
                        case 37: {
                            Rectangle5D bnd;
                            if (EventUtil.isAltDown(e)) {
                                if (!ROI.this.canSetBounds()) break;
                                bnd = ROI.this.getBounds5D();
                                if (EventUtil.isShiftDown(e)) {
                                    bnd.setSizeX(Math.max(1.0, bnd.getSizeX() - 10.0));
                                } else {
                                    bnd.setSizeX(Math.max(1.0, bnd.getSizeX() - 1.0));
                                }
                                ROI.this.setBounds5D(bnd);
                                e.consume();
                                break;
                            }
                            if (!ROI.this.canSetPosition()) break;
                            Point5D pos = ROI.this.getPosition5D();
                            if (EventUtil.isShiftDown(e)) {
                                pos.setX(pos.getX() - 10.0);
                            } else {
                                pos.setX(pos.getX() - 1.0);
                            }
                            ROI.this.setPosition5D(pos);
                            e.consume();
                            break;
                        }
                        case 39: {
                            Rectangle5D bnd;
                            if (EventUtil.isAltDown(e)) {
                                if (!ROI.this.canSetBounds()) break;
                                bnd = ROI.this.getBounds5D();
                                if (EventUtil.isShiftDown(e)) {
                                    bnd.setSizeX(Math.max(1.0, bnd.getSizeX() + 10.0));
                                } else {
                                    bnd.setSizeX(Math.max(1.0, bnd.getSizeX() + 1.0));
                                }
                                ROI.this.setBounds5D(bnd);
                                e.consume();
                                break;
                            }
                            if (!ROI.this.canSetPosition()) break;
                            Point5D pos = ROI.this.getPosition5D();
                            if (EventUtil.isShiftDown(e)) {
                                pos.setX(pos.getX() + 10.0);
                            } else {
                                pos.setX(pos.getX() + 1.0);
                            }
                            ROI.this.setPosition5D(pos);
                            e.consume();
                            break;
                        }
                        case 38: {
                            Rectangle5D bnd;
                            if (EventUtil.isAltDown(e)) {
                                if (!ROI.this.canSetBounds()) break;
                                bnd = ROI.this.getBounds5D();
                                if (EventUtil.isShiftDown(e)) {
                                    bnd.setSizeY(Math.max(1.0, bnd.getSizeY() - 10.0));
                                } else {
                                    bnd.setSizeY(Math.max(1.0, bnd.getSizeY() - 1.0));
                                }
                                ROI.this.setBounds5D(bnd);
                                e.consume();
                                break;
                            }
                            if (!ROI.this.canSetPosition()) break;
                            Point5D pos = ROI.this.getPosition5D();
                            if (EventUtil.isShiftDown(e)) {
                                pos.setY(pos.getY() - 10.0);
                            } else {
                                pos.setY(pos.getY() - 1.0);
                            }
                            ROI.this.setPosition5D(pos);
                            e.consume();
                            break;
                        }
                        case 40: {
                            Rectangle5D bnd;
                            if (EventUtil.isAltDown(e)) {
                                if (!ROI.this.canSetBounds()) break;
                                bnd = ROI.this.getBounds5D();
                                if (EventUtil.isShiftDown(e)) {
                                    bnd.setSizeY(Math.max(1.0, bnd.getSizeY() + 10.0));
                                } else {
                                    bnd.setSizeY(Math.max(1.0, bnd.getSizeY() + 1.0));
                                }
                                ROI.this.setBounds5D(bnd);
                                e.consume();
                                break;
                            }
                            if (!ROI.this.canSetPosition()) break;
                            Point5D pos = ROI.this.getPosition5D();
                            if (EventUtil.isShiftDown(e)) {
                                pos.setY(pos.getY() + 10.0);
                            } else {
                                pos.setY(pos.getY() + 1.0);
                            }
                            ROI.this.setPosition5D(pos);
                            e.consume();
                        }
                    }
                }
            }
            super.keyPressed(e, imagePoint, canvas);
        }

        @Override
        public void keyReleased(KeyEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            super.keyReleased(e, imagePoint, canvas);
            if (ROI.this.isActiveFor(canvas) && !this.isReadOnly()) {
                this.updateDrag(e, imagePoint, canvas);
            }
        }

        @Override
        public void mousePressed(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            super.mousePressed(e, imagePoint, canvas);
            if (!e.isConsumed() && ROI.this.isActiveFor(canvas) && EventUtil.isLeftMouseButton(e)) {
                ROI.this.beginUpdate();
                try {
                    if (this.updateSelect(e, imagePoint, canvas)) {
                        e.consume();
                    } else if (ROI.this.isFocused()) {
                        e.consume();
                    }
                }
                finally {
                    ROI.this.endUpdate();
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            super.mouseReleased(e, imagePoint, canvas);
        }

        @Override
        public void mouseClick(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            super.mouseClick(e, imagePoint, canvas);
            if (!e.isConsumed() && ROI.this.isActiveFor(canvas)) {
                RoisPanel roiPanel;
                int clickCount = e.getClickCount();
                if (clickCount == 1) {
                    if (EventUtil.isRightMouseButton(e) && ROI.this.isSelected()) {
                        ROI.this.setSelected(false);
                    }
                } else if (clickCount == 2 && ROI.this.isFocused() && (roiPanel = Icy.getMainInterface().getRoisPanel()) != null) {
                    roiPanel.scrollTo(ROI.this);
                    e.consume();
                }
            }
        }

        @Override
        public void mouseDrag(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            super.mouseDrag(e, imagePoint, canvas);
        }

        @Override
        public void mouseMove(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            super.mouseMove(e, imagePoint, canvas);
            if (!e.isConsumed() && ROI.this.isActiveFor(canvas) && this.updateFocus(e, imagePoint, canvas)) {
                e.consume();
            }
        }

        @Override
        public void paint(Graphics2D g, Sequence sequence, IcyCanvas canvas) {
            if (canvas instanceof VtkCanvas && !ROI.this.isActiveFor(canvas)) {
                this.hideVtkObjects();
            }
        }

        @Override
        public boolean loadFromXML(Node node) {
            if (node == null) {
                return false;
            }
            this.beginUpdate();
            try {
                this.setColor(new Color(XMLUtil.getElementIntValue(node, "color", ROI.getDefaultColor().getRGB())));
                this.setStroke(XMLUtil.getElementDoubleValue(node, "stroke", ROI.getDefaultStroke()));
                this.setOpacity(XMLUtil.getElementFloatValue(node, "opacity", ROI.getDefaultOpacity()));
                this.setShowName(XMLUtil.getElementBooleanValue(node, "showName", ROI.getDefaultShowName()));
            }
            finally {
                this.endUpdate();
            }
            return true;
        }

        @Override
        public boolean saveToXML(Node node) {
            if (node == null) {
                return false;
            }
            XMLUtil.setElementIntValue(node, "color", this.color.getRGB());
            XMLUtil.setElementDoubleValue(node, "stroke", this.stroke);
            XMLUtil.setElementFloatValue(node, "opacity", this.opacity);
            XMLUtil.setElementBooleanValue(node, "showName", this.showName);
            return true;
        }

        @Override
        public vtkProp[] getProps() {
            return new vtkProp[0];
        }

        public void hideVtkObjects() {
            vtkProp[] vtkPropArray = this.getProps();
            int n = vtkPropArray.length;
            int n2 = 0;
            while (n2 < n) {
                vtkProp prop = vtkPropArray[n2];
                prop.SetVisibility(0);
                ++n2;
            }
        }
    }
}

