/*
 * Decompiled with CFR 0.152.
 */
package plugins.ylemontag.mathoperations.variants;

import icy.util.StringUtil;
import plugins.ylemontag.mathoperations.Functor;
import plugins.ylemontag.mathoperations.Variant;
import plugins.ylemontag.mathoperations.variants.DimensionArray;

public class VariantArray
extends Variant {
    private double[] _value;

    public VariantArray(long length) {
        super(Variant.Type.ARRAY);
        if (length >= Integer.MAX_VALUE) {
            throw new Functor.UnsupportedArguments("Data exceeding maximum size (" + length + " >=  Integer.MAX_VALUE) !");
        }
        this._value = new double[(int)length];
    }

    public VariantArray(double[] value) {
        super(Variant.Type.ARRAY);
        if (value == null) {
            throw new IllegalArgumentException("Cannot wrap a null double array in a Variant object.");
        }
        this._value = value;
    }

    @Override
    public double[] getAsArray() {
        return this._value;
    }

    @Override
    public String getRepresentation(boolean addParenthesisIfFragile) {
        String retVal = "[";
        boolean first = true;
        for (double v : this._value) {
            if (first) {
                first = false;
            } else {
                retVal = retVal + " ";
            }
            retVal = retVal + StringUtil.toString((double)v);
        }
        retVal = retVal + "]";
        return retVal;
    }

    @Override
    public Variant.Dimension getDimension() {
        return new DimensionArray(this._value.length);
    }

    @Override
    public boolean isReadable() {
        return true;
    }

    @Override
    public boolean isWritable() {
        return true;
    }

    @Override
    protected Variant.ReadIterator implGetReadIterator() {
        return new ReadArrayIterator(this._value);
    }

    @Override
    protected Variant.WriteIterator implGetWriteIterator() {
        return new WriteArrayIterator(this._value);
    }

    @Override
    protected void implBeginUpdate() {
    }

    @Override
    protected void implEndUpdate() {
    }

    private static class WriteArrayIterator
    extends ArrayIterator
    implements Variant.WriteIterator {
        public WriteArrayIterator(double[] buffer) {
            super(buffer);
        }

        @Override
        public void set(double value) {
            this._buffer[this._k] = value;
        }
    }

    private static class ReadArrayIterator
    extends ArrayIterator
    implements Variant.ReadIterator {
        public ReadArrayIterator(double[] buffer) {
            super(buffer);
        }

        @Override
        public double get() {
            return this._buffer[this._k];
        }
    }

    private static abstract class ArrayIterator
    implements Variant.Iterator {
        protected double[] _buffer;
        protected int _k;

        protected ArrayIterator(double[] buffer) {
            this._buffer = buffer;
            this._k = 0;
        }

        @Override
        public boolean valid() {
            return this._k < this._buffer.length;
        }

        @Override
        public void next() {
            ++this._k;
        }

        @Override
        public void startAt(long num) {
            if ((long)this._k + num >= Integer.MAX_VALUE) {
                throw new Functor.UnsupportedArguments("Data exceeding maximum size (" + ((long)this._k + num) + " >=  Integer.MAX_VALUE) !");
            }
            this._k = (int)((long)this._k + num);
        }
    }
}

