/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.frame.progress;

import icy.gui.frame.progress.TaskFrame;
import icy.system.thread.ThreadUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JButton;
import javax.swing.JLabel;

public class AnnounceFrame
extends TaskFrame
implements ActionListener {
    JButton button;
    JLabel label;
    Timer timer;
    Runnable action;

    public AnnounceFrame(String message) {
        this(message, "Ok", null, 0);
    }

    public AnnounceFrame(String message, Runnable btnAction) {
        this(message, "Ok", btnAction, 0);
    }

    public AnnounceFrame(String message, int liveTime) {
        this(message, "Ok", null, liveTime);
    }

    public AnnounceFrame(String message, Runnable btnAction, int liveTime) {
        this(message, "Ok", btnAction, liveTime);
    }

    public AnnounceFrame(final String message, final String buttonText, final Runnable btnAction, int liveTime) {
        super("");
        if (this.headless) {
            return;
        }
        if (liveTime != 0) {
            this.timer = new Timer("Announce timer");
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    AnnounceFrame.this.close();
                }
            }, liveTime * 1000);
        }
        ThreadUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                AnnounceFrame.this.button = new JButton();
                AnnounceFrame.this.label = new JLabel();
                AnnounceFrame.this.action = btnAction;
                AnnounceFrame.this.label.setText("   " + message + "   ");
                AnnounceFrame.this.button.setText(buttonText);
                AnnounceFrame.this.button.setFocusable(false);
                AnnounceFrame.this.button.addActionListener(AnnounceFrame.this);
                AnnounceFrame.this.mainPanel.setLayout(new BorderLayout());
                AnnounceFrame.this.mainPanel.add((Component)AnnounceFrame.this.label, "Center");
                AnnounceFrame.this.mainPanel.add((Component)AnnounceFrame.this.button, "East");
                AnnounceFrame.this.pack();
            }
        });
    }

    public Runnable getAction() {
        return this.action;
    }

    public void setAction(Runnable action) {
        this.action = action;
    }

    @Override
    public void internalClose() {
        if (this.headless) {
            return;
        }
        if (this.timer != null) {
            this.timer.cancel();
        }
        super.internalClose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.headless) {
            return;
        }
        if (e.getSource() == this.button && this.action != null) {
            this.action.run();
        }
        this.close();
    }
}

