/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.newt;

import com.jogamp.common.util.IOUtil;
import com.jogamp.common.util.PropertyAccess;
import com.jogamp.nativewindow.AbstractGraphicsConfiguration;
import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.AbstractGraphicsScreen;
import com.jogamp.nativewindow.CapabilitiesImmutable;
import com.jogamp.nativewindow.NativeWindow;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.NativeWindowFactory;
import com.jogamp.newt.Display;
import com.jogamp.newt.Screen;
import com.jogamp.newt.Window;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import jogamp.newt.Debug;
import jogamp.newt.DisplayImpl;
import jogamp.newt.ScreenImpl;
import jogamp.newt.WindowImpl;

public class NewtFactory {
    public static final boolean DEBUG_IMPLEMENTATION = Debug.debug("Window");
    public static final String DRIVER_DEFAULT_ROOT_PACKAGE = "jogamp.newt.driver";
    private static IOUtil.ClassResources defaultWindowIcons;
    private static String sysPaths;
    private static boolean useEDT;

    public static IOUtil.ClassResources getWindowIcons() {
        return defaultWindowIcons;
    }

    public static void setWindowIcons(IOUtil.ClassResources classResources) {
        defaultWindowIcons = classResources;
    }

    public static Class<?> getCustomClass(String string, String string2) {
        String string3;
        Class<?> clazz = null;
        if (string != null && string2 != null) {
            string3 = string.startsWith(".") ? DRIVER_DEFAULT_ROOT_PACKAGE + string + "." + string2 : string + "." + string2;
            try {
                clazz = Class.forName(string3);
            }
            catch (Throwable throwable) {
                throw new NativeWindowException("Failed to find or initialize class <" + string + "." + string2 + "> -> <" + string3 + ">: " + throwable.getMessage(), throwable);
            }
        } else {
            string3 = null;
        }
        if (null == clazz) {
            throw new NativeWindowException("Failed to determine class <" + string + "." + string2 + "> -> <" + string3 + ">");
        }
        return clazz;
    }

    public static synchronized void setUseEDT(boolean bl) {
        useEDT = bl;
    }

    public static boolean useEDT() {
        return useEDT;
    }

    public static Display createDisplay(String string) {
        return NewtFactory.createDisplay(string, true);
    }

    public static Display createDisplay(String string, boolean bl) {
        return DisplayImpl.create(NativeWindowFactory.getNativeWindowType(true), string, 0L, bl);
    }

    public static Display createDisplay(String string, String string2) {
        return NewtFactory.createDisplay(string, string2, true);
    }

    public static Display createDisplay(String string, String string2, boolean bl) {
        return DisplayImpl.create(string, string2, 0L, bl);
    }

    public static Screen createScreen(Display display, int n) {
        return ScreenImpl.create(display, n);
    }

    public static Window createWindow(CapabilitiesImmutable capabilitiesImmutable) {
        return NewtFactory.createWindowImpl(NativeWindowFactory.getNativeWindowType(true), capabilitiesImmutable);
    }

    public static Window createWindow(Screen screen, CapabilitiesImmutable capabilitiesImmutable) {
        return WindowImpl.create(null, 0L, screen, capabilitiesImmutable);
    }

    public static Window createWindow(NativeWindow nativeWindow, CapabilitiesImmutable capabilitiesImmutable) {
        Object object;
        String string = NativeWindowFactory.getNativeWindowType(true);
        if (null == nativeWindow) {
            return NewtFactory.createWindowImpl(string, capabilitiesImmutable);
        }
        Screen screen = null;
        Window window = null;
        if (nativeWindow instanceof Window) {
            window = (Window)nativeWindow;
            screen = window.getScreen();
        } else {
            object = nativeWindow.getGraphicsConfiguration();
            if (null != object) {
                AbstractGraphicsScreen abstractGraphicsScreen = object.getScreen();
                AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsScreen.getDevice();
                Display display = NewtFactory.createDisplay(string, abstractGraphicsDevice.getHandle(), true);
                screen = NewtFactory.createScreen(display, abstractGraphicsScreen.getIndex());
            } else {
                Display display = NewtFactory.createDisplay(string, null, true);
                screen = NewtFactory.createScreen(display, 0);
            }
        }
        object = WindowImpl.create(nativeWindow, 0L, screen, capabilitiesImmutable);
        object.setSize(nativeWindow.getWidth(), nativeWindow.getHeight());
        if (null != window) {
            window.addChild((NativeWindow)object);
            object.setVisible(window.isVisible());
        }
        return object;
    }

    private static Window createWindowImpl(String string, CapabilitiesImmutable capabilitiesImmutable) {
        Display display = NewtFactory.createDisplay(string, null, true);
        Screen screen = NewtFactory.createScreen(display, 0);
        return WindowImpl.create(null, 0L, screen, capabilitiesImmutable);
    }

    public static Window createWindow(String string, int n, long l, CapabilitiesImmutable capabilitiesImmutable) {
        String string2 = NativeWindowFactory.getNativeWindowType(true);
        Display display = NewtFactory.createDisplay(string2, string, true);
        Screen screen = NewtFactory.createScreen(display, n);
        return WindowImpl.create(null, l, screen, capabilitiesImmutable);
    }

    public static Window createWindow(Object[] objectArray, Screen screen, CapabilitiesImmutable capabilitiesImmutable) {
        return WindowImpl.create(objectArray, screen, capabilitiesImmutable);
    }

    public static Display createDisplay(String string, long l, boolean bl) {
        return DisplayImpl.create(string, null, l, bl);
    }

    public static boolean isScreenCompatible(NativeWindow nativeWindow, Screen screen) {
        String string;
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = nativeWindow.getGraphicsConfiguration();
        AbstractGraphicsScreen abstractGraphicsScreen = abstractGraphicsConfiguration.getScreen();
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsScreen.getDevice();
        DisplayImpl displayImpl = (DisplayImpl)screen.getDisplay();
        String string2 = displayImpl.validateDisplayName(null, abstractGraphicsDevice.getHandle());
        if (!string2.equals(string = displayImpl.getName())) {
            return false;
        }
        return abstractGraphicsScreen.getIndex() == screen.getIndex();
    }

    public static Screen createCompatibleScreen(NativeWindow nativeWindow) {
        return NewtFactory.createCompatibleScreen(nativeWindow, null);
    }

    public static Screen createCompatibleScreen(NativeWindow nativeWindow, Screen screen) {
        Object object;
        Object object2;
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = nativeWindow.getGraphicsConfiguration();
        AbstractGraphicsScreen abstractGraphicsScreen = abstractGraphicsConfiguration.getScreen();
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsScreen.getDevice();
        if (null != screen) {
            boolean bl;
            object2 = (DisplayImpl)screen.getDisplay();
            object = ((DisplayImpl)object2).validateDisplayName(null, abstractGraphicsDevice.getHandle());
            String string = ((DisplayImpl)object2).getName();
            boolean bl2 = ((String)object).equals(string);
            boolean bl3 = bl = abstractGraphicsScreen.getIndex() == screen.getIndex();
            if (DEBUG_IMPLEMENTATION) {
                System.err.println("NewtFactory.createCompatibleScreen: Display: " + (String)object + " =? " + string + " : " + bl2 + "; Screen: " + abstractGraphicsScreen.getIndex() + " =? " + screen.getIndex() + " : " + bl);
            }
            if (bl2 && bl) {
                return screen;
            }
        }
        object2 = NativeWindowFactory.getNativeWindowType(true);
        object = NewtFactory.createDisplay((String)object2, abstractGraphicsDevice.getHandle(), true);
        return NewtFactory.createScreen((Display)object, abstractGraphicsScreen.getIndex());
    }

    static {
        sysPaths = "newt/data/jogamp-16x16.png newt/data/jogamp-32x32.png";
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                NativeWindowFactory.initSingleton();
                Object[] objectArray = PropertyAccess.getProperty((String)"newt.window.icons", (boolean)true, (String)sysPaths).split("[\\s,]");
                if (objectArray.length < 2) {
                    throw new IllegalArgumentException("Property 'newt.window.icons' did not specify at least two PNG icons, but " + Arrays.toString(objectArray));
                }
                defaultWindowIcons = new IOUtil.ClassResources((String[])objectArray, NewtFactory.class.getClassLoader(), null);
                return null;
            }
        });
        useEDT = true;
    }
}

