/*
 * Decompiled with CFR 0.152.
 */
package plugins.nchenouard.particletracking.filtering;

public class LikelihoodMap {
    final double[] likelihoods;
    final int width;
    final int height;
    final int depth;
    final int widthXheight;
    final int offsetX;
    final int offsetY;
    final int offsetZ;

    public LikelihoodMap(int width, int height, int depth, int offsetX, int offsetY, int offsetZ, double[] likelihoods) {
        this.width = width;
        this.height = height;
        this.depth = depth;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.offsetZ = offsetZ;
        this.likelihoods = likelihoods;
        this.widthXheight = height * width;
    }

    public LikelihoodMap(int width, int height, int depth, int offsetX, int offsetY, int offsetZ) {
        this(width, height, depth, offsetX, offsetY, offsetZ, new double[width * height * depth]);
    }

    public LikelihoodMap(int width, int height, int depth) {
        this(width, height, depth, 0, 0, 0);
    }

    public LikelihoodMap(int width, int height) {
        this(width, height, 1, 0, 0, 0);
    }

    public LikelihoodMap(int width, int height, int offsetX, int offsetY) {
        this(width, height, 1, offsetX, offsetY, 0);
    }

    public LikelihoodMap copy() {
        double[] dataCopy = new double[this.likelihoods.length];
        System.arraycopy(this.likelihoods, 0, dataCopy, 0, dataCopy.length);
        return new LikelihoodMap(this.width, this.height, this.depth, this.offsetX, this.offsetY, this.offsetZ, dataCopy);
    }

    public double getLikelihood(int x, int y, int z) {
        return this.likelihoods[x - this.offsetX + (y - this.offsetY) * this.width + (z - this.offsetZ) * this.widthXheight];
    }

    public double getLikelihoodLocalCoord(int i, int j, int k) {
        return this.likelihoods[i + j * this.width + k * this.widthXheight];
    }

    public void setLikelihood(int x, int y, int z, double value) {
        this.likelihoods[x - this.offsetX + (y - this.offsetY) * this.width + (z - this.offsetZ) * this.widthXheight] = value;
    }

    public void setLikelihoodLocalCoord(int i, int j, int k, double value) {
        this.likelihoods[i + j * this.width + k * this.widthXheight] = value;
    }

    public void addLikelihood(int x, int y, int z, double value) {
        this.likelihoods[x - this.offsetX + (y - this.offsetY) * this.width + (z - this.offsetZ) * this.widthXheight] = value + this.likelihoods[x - this.offsetX + (y - this.offsetY) * this.width + (z - this.offsetZ) * this.widthXheight];
    }

    public void addLikelihoodLocalCoord(int i, int j, int k, double value) {
        this.likelihoods[i + j * this.width + k * this.widthXheight] = value + this.likelihoods[i + j * this.width + k * this.widthXheight];
    }

    public double getLikelihood(int x, int y) {
        return this.likelihoods[x - this.offsetX + (y - this.offsetY) * this.width];
    }

    public double getLikelihoodLocalCoord(int i, int j) {
        return this.likelihoods[i + j * this.width];
    }

    public void setLikelihood(int x, int y, double value) {
        this.likelihoods[x - this.offsetX + (y - this.offsetY) * this.width] = value;
    }

    public void setLikelihoodLocalCoord(int i, int j, double value) {
        this.likelihoods[i + j * this.width] = value;
    }

    public void addLikelihood(int x, int y, double value) {
        this.likelihoods[x - this.offsetX + (y - this.offsetY) * this.width] = value + this.likelihoods[x - this.offsetX + (y - this.offsetY) * this.width];
    }

    public void addLikelihoodLocalCoord(int i, int j, double value) {
        this.likelihoods[i + j * this.width] = value + this.likelihoods[i + j * this.width];
    }

    public int getDepth() {
        return this.depth;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public int getOffsetZ() {
        return this.offsetZ;
    }
}

