/*
 * Decompiled with CFR 0.152.
 */
package vtk.rendering.awt;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import vtk.rendering.awt.vtkInternalAwtComponent;
import vtk.rendering.vtkAbstractComponent;
import vtk.vtkObject;
import vtk.vtkRenderWindow;

public class vtkAwtComponent
extends vtkAbstractComponent<Canvas> {
    protected vtkInternalAwtComponent uiComponent = new vtkInternalAwtComponent(this);
    protected boolean isWindowCreated = false;
    protected Runnable onWindowCreatedCallback;

    public vtkAwtComponent() {
        this(new vtkRenderWindow());
    }

    public vtkAwtComponent(vtkRenderWindow vtkRenderWindow2) {
        super(vtkRenderWindow2);
        this.uiComponent.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                Dimension dimension = vtkAwtComponent.this.uiComponent.getSize();
                vtkAwtComponent.this.setSize(dimension.width, dimension.height);
            }
        });
    }

    @Override
    public void Render() {
        if (this.inRenderCall || this.renderer == null || this.renderWindow == null) {
            return;
        }
        try {
            this.lock.lockInterruptibly();
            this.inRenderCall = true;
            if (!this.isWindowCreated) {
                this.uiComponent.RenderCreate(this.renderWindow);
                this.setSize(this.uiComponent.getWidth(), this.uiComponent.getHeight());
                this.isWindowCreated = true;
            }
            this.renderWindow.Render();
            if (this.onWindowCreatedCallback != null) {
                this.onWindowCreatedCallback.run();
                this.onWindowCreatedCallback = null;
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.lock.unlock();
            this.inRenderCall = false;
        }
    }

    @Override
    public Canvas getComponent() {
        return this.uiComponent;
    }

    @Override
    public void Delete() {
        this.lock.lock();
        this.inRenderCall = true;
        if (this.uiComponent.getParent() != null) {
            this.uiComponent.getParent().remove(this.uiComponent);
        }
        super.Delete();
        if (!this.renderWindow.GetClassName().equals("vtkXOpenGLRenderWindow")) {
            this.renderWindow = null;
        } else {
            System.out.println("The renderwindow has been kept arount to prevent a crash");
        }
        this.lock.unlock();
        vtkObject.JAVA_OBJECT_MANAGER.gc(false);
    }

    public boolean isWindowSet() {
        return this.isWindowCreated;
    }

    public void setWindowReadyCallback(Runnable runnable) {
        this.onWindowCreatedCallback = runnable;
    }

    protected void updateInRenderCall(boolean bl) {
        this.inRenderCall = bl;
    }
}

