/*
 * Decompiled with CFR 0.152.
 */
package ucar.httpservices;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.message.BasicNameValuePair;
import ucar.httpservices.HTTPException;
import ucar.httpservices.HTTPUtil;

public class HTTPFormBuilder {
    public static final Charset DFALTCHARSET = HTTPUtil.UTF8;
    protected Map<String, Field> parts = new HashMap<String, Field>();
    protected Charset charset = DFALTCHARSET;
    protected boolean usemultipart = false;

    public String getCharset() {
        return this.charset.displayName();
    }

    public HTTPFormBuilder setCharset(String charset) {
        this.charset = Charset.forName(charset);
        return this;
    }

    public HTTPFormBuilder setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public HTTPFormBuilder add(String fieldname, String text) throws HTTPException {
        if (fieldname == null || text == null || fieldname.length() == 0) {
            throw new IllegalArgumentException();
        }
        Field f = new Field(Sort.TEXT, fieldname, text, null);
        this.parts.put(fieldname, f);
        return this;
    }

    public HTTPFormBuilder add(String fieldname, byte[] content, String filename) throws HTTPException {
        if (this.isempty(fieldname)) {
            throw new IllegalArgumentException();
        }
        if (content == null) {
            content = new byte[]{};
        }
        if (this.isempty(filename)) {
            filename = "";
        }
        Field f = new Field(Sort.BYTES, fieldname, content, filename);
        this.parts.put(fieldname, f);
        this.usemultipart = true;
        return this;
    }

    public HTTPFormBuilder add(String fieldname, InputStream content, String filename) throws HTTPException {
        if (this.isempty(fieldname) || content == null || this.isempty(filename)) {
            throw new IllegalArgumentException();
        }
        Field f = new Field(Sort.STREAM, fieldname, content, filename);
        this.parts.put(fieldname, f);
        this.usemultipart = true;
        return this;
    }

    public HTTPFormBuilder add(String fieldname, File content) throws HTTPException {
        if (this.isempty(fieldname) || content == null) {
            throw new IllegalArgumentException();
        }
        Field f = new Field(Sort.FILE, fieldname, content, content.getName());
        this.parts.put(fieldname, f);
        this.usemultipart = true;
        return this;
    }

    public HttpEntity build() throws HTTPException {
        if (this.usemultipart) {
            return this.buildmultipart();
        }
        return this.buildsimple();
    }

    protected HttpEntity buildsimple() throws HTTPException {
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        for (Map.Entry<String, Field> mapentry : this.parts.entrySet()) {
            Field field = mapentry.getValue();
            params.add(new BasicNameValuePair(field.fieldname, field.value.toString()));
        }
        try {
            return new UrlEncodedFormEntity((List<? extends NameValuePair>)params);
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    protected HttpEntity buildmultipart() throws HTTPException {
        MultipartEntityBuilder mpb = MultipartEntityBuilder.create();
        mpb.setCharset(this.charset);
        mpb.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        for (Map.Entry<String, Field> mapentry : this.parts.entrySet()) {
            Field field = mapentry.getValue();
            Sort sort = field.sort;
            ContentType ct = Sort.contenttype(sort);
            StringBody body = null;
            switch (sort) {
                case TEXT: {
                    body = new StringBody(field.value.toString(), ct);
                    break;
                }
                case BYTES: {
                    body = new ByteArrayBody((byte[])field.value, field.name);
                    break;
                }
                case STREAM: {
                    try {
                        byte[] tmp = HTTPUtil.readbinaryfile((InputStream)field.value);
                        body = new ByteArrayBody(tmp, field.name);
                        break;
                    }
                    catch (IOException ioe) {
                        throw new HTTPException(ioe);
                    }
                }
                case FILE: {
                    body = new FileBody((File)field.value, ct, field.name);
                }
            }
            mpb.addPart(field.fieldname, body);
        }
        return mpb.build();
    }

    protected boolean isempty(String x) {
        return x == null || x.length() == 0;
    }

    protected static class Field {
        public Sort sort;
        public String fieldname = null;
        public Object value = null;
        public String name = null;

        public Field(Sort sort, String fieldname, Object value, String name) {
            this.sort = sort;
            this.fieldname = fieldname;
            this.value = value;
            this.name = name;
        }
    }

    protected static enum Sort {
        TEXT,
        BYTES,
        STREAM,
        FILE;


        public static ContentType contenttype(Sort sort) {
            switch (sort) {
                case TEXT: {
                    return ContentType.TEXT_PLAIN;
                }
            }
            return ContentType.APPLICATION_OCTET_STREAM;
        }

        public static String mimetype(Sort sort) {
            return Sort.contenttype(sort).getMimeType();
        }
    }
}

