/*
 * Decompiled with CFR 0.152.
 */
package mitiv.jobs;

import mitiv.array.ShapedArray;
import mitiv.conv.WeightedConvolutionCost;
import mitiv.cost.DifferentiableCostFunction;
import mitiv.invpb.Deconvolution;
import mitiv.optim.OptimTask;
import mitiv.utils.TiPiHook;

public class DeconvolutionJob {
    protected Deconvolution solver = new Deconvolution();
    protected TiPiHook iterHook;
    protected TiPiHook finalHook;
    protected boolean run = true;

    public DeconvolutionJob(DifferentiableCostFunction fdata, double mu, DifferentiableCostFunction fprior, boolean positivity, int nbIterDeconv, TiPiHook iterHook, TiPiHook finalHook) {
        this.solver.setLikelihood(fdata);
        this.solver.setRegularization(fprior);
        this.solver.setRegularizationLevel(mu);
        this.solver.setSaveBest(true);
        this.solver.setLowerBound(positivity ? 0.0 : Double.NEGATIVE_INFINITY);
        this.solver.setUpperBound(Double.POSITIVE_INFINITY);
        this.solver.setMaximumIterations(nbIterDeconv);
        this.solver.setMaximumEvaluations(2 * nbIterDeconv);
        this.iterHook = iterHook;
        this.finalHook = finalHook;
    }

    public ShapedArray deconv(ShapedArray objArray) {
        int iter = 0;
        this.run = true;
        this.solver.setInitialSolution(objArray);
        OptimTask task = this.solver.start();
        while (this.run) {
            task = this.solver.getTask();
            if (task == OptimTask.ERROR) {
                System.err.format("Error: %s\n", this.solver.getReason());
                break;
            }
            if (task == OptimTask.NEW_X || task == OptimTask.FINAL_X) {
                if (this.iterHook != null) {
                    this.iterHook.run(this.solver, iter++);
                }
                if (task == OptimTask.FINAL_X) break;
            }
            if (task == OptimTask.WARNING) break;
            this.solver.iterate();
        }
        objArray = this.solver.getBestSolution().asShapedArray();
        this.finalHook.run(this.solver, iter);
        return objArray;
    }

    public void abort() {
        this.run = false;
    }

    public boolean isRunning() {
        return this.run;
    }

    public void updatePsf(ShapedArray psfArray) {
        WeightedConvolutionCost fdata = (WeightedConvolutionCost)this.solver.getLikelihood();
        fdata.setPSF(psfArray);
    }

    public void updateWeight(ShapedArray wgtArray) {
        WeightedConvolutionCost fdata = (WeightedConvolutionCost)this.solver.getLikelihood();
        fdata.setWeights(wgtArray, true);
    }

    public ShapedArray getModel() {
        return this.solver.getModel();
    }
}

