/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataStore;

public class PCXReader
extends FormatReader {
    public static final byte PCX_MAGIC_BYTE = 10;
    private long offset;
    private int bytesPerLine;
    private int nColorPlanes;
    private byte[][] lut;

    public PCXReader() {
        super("PCX", "pcx");
        this.domains = new String[]{"Graphics"};
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        boolean blockLen = true;
        if (!FormatTools.validStream(stream, 1, false)) {
            return false;
        }
        return stream.read() == 10;
    }

    @Override
    public byte[][] get8BitLookupTable() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.lut;
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        this.in.seek(this.offset);
        byte[] b = new byte[this.bytesPerLine * this.getSizeY() * this.nColorPlanes];
        int pt = 0;
        block0: while (pt < b.length) {
            int val = this.in.read() & 0xFF;
            if ((val & 0xC0) >> 6 == 3) {
                int len = val & 0x3F;
                val = this.in.read() & 0xFF;
                for (int q = 0; q < len; ++q) {
                    b[pt++] = (byte)val;
                    if (pt % this.bytesPerLine == 0) continue block0;
                }
                continue;
            }
            b[pt++] = (byte)(val & 0xFF);
        }
        int src = y * this.nColorPlanes * this.bytesPerLine;
        for (int row = 0; row < h2; ++row) {
            int rowOffset = row * this.nColorPlanes * this.bytesPerLine;
            for (int c = 0; c < this.nColorPlanes; ++c) {
                System.arraycopy(b, src + rowOffset + x, buf, c * w * h2 + row * w, w);
                rowOffset += this.bytesPerLine;
            }
        }
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.offset = 0L;
            this.bytesPerLine = 0;
            this.nColorPlanes = 0;
            this.lut = null;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        LOGGER.info("Reading file header");
        CoreMetadata m3 = (CoreMetadata)this.core.get(0);
        m3.littleEndian = true;
        this.in.order(this.isLittleEndian());
        this.in.seek(1L);
        int version = this.in.read();
        this.in.skipBytes(1);
        int bitsPerPixel = this.in.read();
        short xMin = this.in.readShort();
        short yMin = this.in.readShort();
        short xMax = this.in.readShort();
        short yMax = this.in.readShort();
        m3.sizeX = xMax - xMin;
        m3.sizeY = yMax - yMin;
        this.in.skipBytes(version == 5 ? 53 : 51);
        this.nColorPlanes = this.in.read();
        this.bytesPerLine = this.in.readShort();
        short paletteType = this.in.readShort();
        this.offset = this.in.getFilePointer() + 58L;
        if (version == 5 && this.nColorPlanes == 1) {
            this.in.seek(this.in.length() - 768L);
            this.lut = new byte[3][256];
            for (int i = 0; i < this.lut[0].length; ++i) {
                for (int j = 0; j < this.lut.length; ++j) {
                    this.lut[j][i] = this.in.readByte();
                }
            }
            m3.indexed = true;
        }
        this.addGlobalMeta("Palette type", (int)paletteType);
        m3.sizeZ = 1;
        m3.sizeT = 1;
        m3.sizeC = this.nColorPlanes;
        m3.rgb = this.nColorPlanes > 1;
        m3.imageCount = 1;
        m3.pixelType = 1;
        m3.dimensionOrder = "XYCZT";
        m3.interleaved = false;
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
    }
}

