/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.component;

import icy.gui.component.ExternalizablePanel;
import icy.gui.component.button.IcyButton;
import icy.resource.ResourceUtil;
import icy.resource.icon.IcyIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class ExtTabbedPanel
extends JTabbedPane {
    private static final long serialVersionUID = -1217212007327960771L;
    private final ArrayList<TabComponent> tabComponents = new ArrayList();

    public ExtTabbedPanel() {
        this(1, 0);
    }

    public ExtTabbedPanel(int tabPlacement) {
        this(tabPlacement, 0);
    }

    public ExtTabbedPanel(int tabPlacement, int tabLayoutPolicy) {
        super(tabPlacement, tabLayoutPolicy);
    }

    protected TabComponent getTabComponent(ExternalizablePanel panel) {
        for (TabComponent extTabComp : this.tabComponents) {
            if (extTabComp.extPanel != panel) continue;
            return extTabComp;
        }
        return null;
    }

    @Override
    public Component add(Component component) {
        TabComponent tabComp;
        if (component instanceof ExternalizablePanel && (tabComp = this.getTabComponent((ExternalizablePanel)component)) != null) {
            this.insertTab(tabComp.getTitle(), tabComp.getIcon(), component, tabComp.tip, Math.min(tabComp.index, this.getTabCount()));
            return component;
        }
        return super.add(component);
    }

    @Override
    public void setIconAt(int index, Icon icon) {
        super.setIconAt(index, icon);
        Component comp = this.getTabComponentAt(index);
        if (comp instanceof TabComponent) {
            ((TabComponent)comp).setIcon(icon);
        }
    }

    @Override
    public void setDisabledIconAt(int index, Icon disabledIcon) {
        super.setDisabledIconAt(index, disabledIcon);
        Component comp = this.getTabComponentAt(index);
        if (comp instanceof TabComponent) {
            ((TabComponent)comp).setDisabledIcon(disabledIcon);
        }
    }

    @Override
    public void setBackgroundAt(int index, Color background) {
        super.setBackgroundAt(index, background);
        Component comp = this.getTabComponentAt(index);
        if (comp instanceof TabComponent) {
            ((TabComponent)comp).setBackgroundAll(background);
        }
    }

    @Override
    public void setForegroundAt(int index, Color foreground) {
        super.setForegroundAt(index, foreground);
        Component comp = this.getTabComponentAt(index);
        if (comp instanceof TabComponent) {
            ((TabComponent)comp).setForegroundAll(foreground);
        }
    }

    @Override
    public void setTitleAt(int index, String title) {
        super.setTitleAt(index, title);
        Component comp = this.getTabComponentAt(index);
        if (comp instanceof TabComponent) {
            ((TabComponent)comp).setTitle(title);
        }
    }

    @Override
    public void insertTab(String title, Icon icon, Component component, String tip, int index) {
        TabComponent tabComp;
        if (component instanceof ExternalizablePanel) {
            ExternalizablePanel panel = (ExternalizablePanel)component;
            tabComp = this.getTabComponent(panel);
            if (tabComp == null) {
                tabComp = new TabComponent(title, icon, panel, tip, index);
                this.tabComponents.add(tabComp);
            }
            if (panel.isExternalized()) {
                panel.setParent(this);
                return;
            }
        } else {
            tabComp = null;
        }
        super.insertTab(title, icon, component, tip, index);
        if (tabComp != null) {
            this.setTabComponentAt(index, tabComp);
        }
    }

    private class TabComponent
    extends JPanel {
        private static final long serialVersionUID = 4841789742300589373L;
        final ExternalizablePanel extPanel;
        private final IcyButton externButton;
        final JLabel label;
        final int index;
        final String tip;

        public TabComponent(String title, Icon icon, ExternalizablePanel panel, String tip, int index) {
            this.setLayout(new BoxLayout(this, 2));
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setOpaque(false);
            this.index = index;
            this.tip = tip;
            this.extPanel = panel;
            this.label = new JLabel(String.valueOf(title) + " ", icon, 0);
            this.label.setOpaque(false);
            this.externButton = new IcyButton(new IcyIcon(ResourceUtil.ICON_WINDOW_EXPAND, 16));
            this.externButton.setFlat(true);
            this.externButton.setOpaque(false);
            this.externButton.setContentAreaFilled(false);
            this.externButton.setToolTipText("Externalize panel");
            this.externButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TabComponent.this.extPanel.externalize();
                }
            });
            this.add(this.label);
            this.add(this.externButton);
            this.validate();
        }

        public String getTitle() {
            return this.label.getText().trim();
        }

        public Icon getIcon() {
            return this.label.getIcon();
        }

        public void setTitle(String title) {
            this.label.setText(String.valueOf(title) + " ");
        }

        public void setIcon(Icon icon) {
            this.label.setIcon(icon);
        }

        public void setDisabledIcon(Icon disabledIcon) {
            this.label.setDisabledIcon(disabledIcon);
        }

        public void setBackgroundAll(Color background) {
            this.externButton.setBackground(background);
            this.label.setBackground(background);
        }

        public void setForegroundAll(Color foreground) {
            this.externButton.setForeground(foreground);
            this.label.setForeground(foreground);
        }
    }
}

