/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.Plot;
import ij.gui.ProfilePlot;
import ij.plugin.PlugIn;
import java.awt.Dimension;

public class StackPlotter
implements PlugIn {
    private int channel = 1;
    private int slice = 1;
    private int frame = 1;
    private int frames = 1;

    @Override
    public void run(String arg) {
        ImagePlus imp = IJ.getImage();
        if (imp.getRoi() == null) {
            IJ.error("Stack Plotter", "Line or rectangular selection required");
            return;
        }
        int dim = imp.getNDimensions();
        if (dim < 3) {
            IJ.error("Stack Plotter", "This plugin requires a stack");
            return;
        }
        int length = 0;
        if (dim == 3) {
            length = imp.getImageStackSize();
        }
        boolean plotFrames = true;
        if (dim > 3) {
            this.channel = imp.getChannel();
            this.slice = imp.getSlice();
            this.frame = imp.getFrame();
            length = this.frames = imp.getNFrames();
            if (dim == 4 && length == 1) {
                plotFrames = false;
                length = imp.getNSlices();
            }
        } else {
            this.slice = imp.getCurrentSlice();
        }
        ProfilePlot[] pPlot = new ProfilePlot[length];
        double ymin = 0.0;
        double ymax = 0.0;
        for (int i = 0; i < length; ++i) {
            if (dim == 3) {
                imp.setPosition(i + 1);
            }
            if (dim > 3) {
                if (plotFrames) {
                    imp.setPosition(this.channel, this.slice, i + 1);
                } else {
                    imp.setPosition(this.channel, i + 1, this.frame);
                }
            }
            pPlot[i] = new ProfilePlot(imp);
            if (pPlot[i] == null) {
                return;
            }
            if (pPlot[i].getMin() < ymin) {
                ymin = pPlot[i].getMin();
            }
            if (!(pPlot[i].getMax() > ymax)) continue;
            ymax = pPlot[i].getMax();
        }
        double pp_min = ProfilePlot.getFixedMin();
        double pp_max = ProfilePlot.getFixedMax();
        ProfilePlot.setMinAndMax(ymin, ymax);
        Plot plot = pPlot[0].getPlot();
        Dimension size = plot.getSize();
        ImageStack stack = new ImageStack(size.width, size.height);
        for (int i = 0; i < length; ++i) {
            plot = pPlot[i].getPlot();
            stack.addSlice(plot.getProcessor());
        }
        ImagePlus output = new ImagePlus("Profile Plots", stack);
        output.show();
        output.setSlice(this.slice);
        if (dim == 3) {
            imp.setPosition(this.slice);
        }
        if (dim > 3) {
            imp.setPosition(this.channel, this.slice, this.frame);
        }
        ProfilePlot.setMinAndMax(pp_min, pp_max);
    }
}

