/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.component;

import icy.util.ColorUtil;
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JPanel;

public class ColorComponent
extends JPanel {
    private static final long serialVersionUID = 2883762420253112984L;
    private Color color;

    public ColorComponent(Color color) {
        super(true);
        this.color = color;
        this.setOpaque(true);
        this.setVisible(true);
    }

    public ColorComponent() {
        this((Color)null);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
        if (color != null) {
            this.setToolTipText(ColorUtil.toString(color.getRGB(), false, " : "));
        } else {
            this.setToolTipText("");
        }
        this.repaint();
    }

    public void setColor(int rgb) {
        this.setColor(new Color(rgb));
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.color == null) {
            super.paintComponent(g);
        } else {
            int w = this.getWidth();
            int h = this.getHeight();
            g.setColor(this.color);
            g.fillRect(0, 0, w, h);
            g.setColor(Color.black);
            g.drawRect(0, 0, w, h);
        }
    }
}

