/*
 * Decompiled with CFR 0.152.
 */
package icy.system.audit;

import icy.file.FileUtil;
import icy.file.xml.XMLPersistent;
import icy.file.xml.XMLPersistentHelper;
import icy.network.NetworkUtil;
import icy.plugin.PluginDescriptor;
import icy.plugin.PluginLoader;
import icy.plugin.abstract_.Plugin;
import icy.system.IcyExceptionHandler;
import icy.util.DateUtil;
import icy.util.XMLUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AuditStorage
implements XMLPersistent {
    private static final String ID_PLUGIN = "plugin";
    private static final String AUDIT_FILENAME = "icy_usage.xml";
    private static final long SAVE_INTERVAL = 60000L;
    private final Map<PluginDescriptor.PluginIdent, PluginStorage> pluginStats = new HashMap<PluginDescriptor.PluginIdent, PluginStorage>();
    private long lastSaveTime;

    public AuditStorage() {
        try {
            XMLPersistentHelper.loadFromXML((XMLPersistent)this, String.valueOf(FileUtil.getTempDirectory()) + "/" + AUDIT_FILENAME);
            this.clean();
        }
        catch (Exception e) {
            System.out.println("Warning: can't reload usage statistics data.");
            IcyExceptionHandler.showErrorMessage(e, false, false);
        }
        this.lastSaveTime = System.currentTimeMillis();
    }

    public void save() {
        try {
            XMLPersistentHelper.saveToXML((XMLPersistent)this, String.valueOf(FileUtil.getTempDirectory()) + "/" + AUDIT_FILENAME);
        }
        catch (Exception e) {
            System.out.println("Warning: can't save usage statistics data.");
            IcyExceptionHandler.showErrorMessage(e, false, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clean() {
        ArrayList<PluginDescriptor.PluginIdent> empties = new ArrayList<PluginDescriptor.PluginIdent>();
        Map<PluginDescriptor.PluginIdent, PluginStorage> map = this.pluginStats;
        synchronized (map) {
            for (Map.Entry<PluginDescriptor.PluginIdent, PluginStorage> entry : this.pluginStats.entrySet()) {
                entry.getValue().clean();
                if (!entry.getValue().isEmpty()) continue;
                empties.add(entry.getKey());
            }
            for (PluginDescriptor.PluginIdent ident : empties) {
                this.pluginStats.remove(ident);
            }
        }
    }

    private void autoSave() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastSaveTime > 60000L) {
            this.save();
            this.lastSaveTime = currentTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PluginStorage getStorage(PluginDescriptor.PluginIdent ident, boolean autoCreate) {
        PluginStorage result;
        Map<PluginDescriptor.PluginIdent, PluginStorage> map = this.pluginStats;
        synchronized (map) {
            result = this.pluginStats.get(ident);
            if (result == null && autoCreate) {
                result = new PluginStorage();
                this.pluginStats.put(ident, result);
            }
        }
        return result;
    }

    public void pluginLaunched(Plugin plugin) {
        PluginDescriptor descriptor = null;
        try {
            descriptor = plugin.isBundled() ? PluginLoader.getPlugin(plugin.getOwnerClassName()) : plugin.getDescriptor();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (descriptor == null) {
            return;
        }
        if (descriptor.getVersion().isEmpty()) {
            return;
        }
        if (descriptor.isKernelPlugin()) {
            return;
        }
        this.getStorage(descriptor.getIdent(), true).incLaunch(DateUtil.keepDay(System.currentTimeMillis()));
        this.autoSave();
    }

    public void pluginInstanced(Plugin plugin) {
        PluginDescriptor descriptor = null;
        try {
            descriptor = plugin.isBundled() ? PluginLoader.getPlugin(plugin.getOwnerClassName()) : plugin.getDescriptor();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (descriptor == null) {
            return;
        }
        if (descriptor.getVersion().isEmpty()) {
            return;
        }
        if (descriptor.isKernelPlugin()) {
            return;
        }
        this.getStorage(descriptor.getIdent(), true).incInstance(DateUtil.keepDay(System.currentTimeMillis()));
        this.autoSave();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean upload(int id) {
        ArrayList<PluginDescriptor.PluginIdent> dones;
        block16: {
            ArrayList<Map.Entry<PluginDescriptor.PluginIdent, PluginStorage>> entries;
            dones = new ArrayList<PluginDescriptor.PluginIdent>();
            Map<PluginDescriptor.PluginIdent, PluginStorage> map = this.pluginStats;
            synchronized (map) {
                entries = new ArrayList<Map.Entry<PluginDescriptor.PluginIdent, PluginStorage>>(this.pluginStats.entrySet());
            }
            try {
                for (Map.Entry entry : entries) {
                    if (((PluginStorage)entry.getValue()).upload(id, (PluginDescriptor.PluginIdent)entry.getKey())) {
                        dones.add((PluginDescriptor.PluginIdent)entry.getKey());
                    }
                    if (!Thread.interrupted()) {
                        continue;
                    }
                    break block16;
                }
                break block16;
            }
            catch (Throwable throwable) {
                Map<PluginDescriptor.PluginIdent, PluginStorage> map2 = this.pluginStats;
                synchronized (map2) {
                    for (PluginDescriptor.PluginIdent ident : dones) {
                        this.pluginStats.remove(ident);
                    }
                }
            }
            throw throwable;
        }
        Map<PluginDescriptor.PluginIdent, PluginStorage> map = this.pluginStats;
        synchronized (map) {
            for (PluginDescriptor.PluginIdent ident : dones) {
                this.pluginStats.remove(ident);
            }
        }
        return this.pluginStats.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean loadFromXML(Node node) {
        if (node == null) {
            return false;
        }
        Map<PluginDescriptor.PluginIdent, PluginStorage> map = this.pluginStats;
        synchronized (map) {
            this.pluginStats.clear();
            for (Node n : XMLUtil.getChildren(node, ID_PLUGIN)) {
                PluginDescriptor.PluginIdent ident = new PluginDescriptor.PluginIdent();
                PluginStorage storage = new PluginStorage();
                ident.loadFromXMLShort(n);
                storage.loadFromXML(n);
                this.pluginStats.put(ident, storage);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveToXML(Node node) {
        if (node == null) {
            return false;
        }
        XMLUtil.removeAllChildren(node);
        Map<PluginDescriptor.PluginIdent, PluginStorage> map = this.pluginStats;
        synchronized (map) {
            for (Map.Entry<PluginDescriptor.PluginIdent, PluginStorage> entry : this.pluginStats.entrySet()) {
                Element n = XMLUtil.addElement(node, ID_PLUGIN);
                entry.getKey().saveToXMLShort(n);
                entry.getValue().saveToXML(n);
            }
        }
        return true;
    }

    private class PluginStorage
    implements XMLPersistent {
        private static final String ID_CLASSNAME = "classname";
        private static final String ID_VERSION = "version";
        private static final String ID_LAUNCH = "launch";
        private static final String ID_INSTANCE = "instance";
        private static final String ID_STATS_LAUNCH = "stats_launch";
        private static final String ID_STATS_INSTANCE = "stats_instance";
        private static final String ID_DATE = "date";
        private static final String ID_VALUE = "value";
        private static final long DAY_TO_KEEP = 30L;
        private final Map<Long, Long> launchStats = new HashMap<Long, Long>();
        private final Map<Long, Long> instanceStats = new HashMap<Long, Long>();

        public void clean() {
            ArrayList<Long> olds = new ArrayList<Long>();
            long dayInterval = 86400000L;
            long timeLimit = System.currentTimeMillis() - 2592000000L;
            olds.clear();
            for (Long date : this.launchStats.keySet()) {
                if (date >= timeLimit) continue;
                olds.add(date);
            }
            for (Long date : olds) {
                this.launchStats.remove(date);
            }
            olds.clear();
            for (Long date : this.instanceStats.keySet()) {
                if (date >= timeLimit) continue;
                olds.add(date);
            }
            for (Long date : olds) {
                this.instanceStats.remove(date);
            }
        }

        public boolean isEmpty() {
            return this.launchStats.isEmpty() && this.instanceStats.isEmpty();
        }

        public long getLaunch(Long date) {
            Long result = this.launchStats.get(date);
            if (result == null) {
                return 0L;
            }
            return result;
        }

        public long getInstance(Long date) {
            Long result = this.instanceStats.get(date);
            if (result == null) {
                return 0L;
            }
            return result;
        }

        public void incLaunch(long date) {
            Long key = date;
            this.launchStats.put(key, this.getLaunch(key) + 1L);
        }

        public void incInstance(long date) {
            Long key = date;
            this.instanceStats.put(key, this.getInstance(key) + 1L);
        }

        private Map<String, String> getIdParam(int id) {
            if (id != -1) {
                HashMap<String, String> values = new HashMap<String, String>();
                values.put("IcyId", Integer.toString(id));
                return values;
            }
            return null;
        }

        public boolean upload(int id, PluginDescriptor.PluginIdent ident) {
            Map<String, String> params = this.getIdParam(id);
            params.put(ID_CLASSNAME, ident.getClassName());
            params.put(ID_VERSION, ident.getVersion().toString());
            int offset = 0;
            for (Map.Entry<Long, Long> entry : this.launchStats.entrySet()) {
                params.put("stats_launch[" + offset + "][" + ID_DATE + "]", entry.getKey().toString());
                params.put("stats_launch[" + offset + "][" + ID_VALUE + "]", entry.getValue().toString());
                ++offset;
            }
            offset = 0;
            for (Map.Entry<Long, Long> entry : this.instanceStats.entrySet()) {
                params.put("stats_instance[" + offset + "][" + ID_DATE + "]", entry.getKey().toString());
                params.put("stats_instance[" + offset + "][" + ID_VALUE + "]", entry.getValue().toString());
                ++offset;
            }
            try {
                if (NetworkUtil.postData("http://icy.bioimageanalysis.org/register/auditPlugin.php?", params) == null) {
                    return false;
                }
            }
            catch (IOException e) {
                return false;
            }
            this.launchStats.clear();
            this.instanceStats.clear();
            return true;
        }

        @Override
        public boolean loadFromXML(Node node) {
            long value;
            long date;
            if (node == null) {
                return false;
            }
            this.launchStats.clear();
            for (Node n : XMLUtil.getChildren(node, ID_LAUNCH)) {
                date = XMLUtil.getElementLongValue(n, ID_DATE, 0L);
                value = XMLUtil.getElementLongValue(n, ID_VALUE, 0L);
                this.launchStats.put(date, value);
            }
            this.instanceStats.clear();
            for (Node n : XMLUtil.getChildren(node, ID_INSTANCE)) {
                date = XMLUtil.getElementLongValue(n, ID_DATE, 0L);
                value = XMLUtil.getElementLongValue(n, ID_VALUE, 0L);
                this.instanceStats.put(date, value);
            }
            return true;
        }

        @Override
        public boolean saveToXML(Node node) {
            Element n;
            if (node == null) {
                return false;
            }
            for (Map.Entry<Long, Long> entry : this.launchStats.entrySet()) {
                n = XMLUtil.addElement(node, ID_LAUNCH);
                XMLUtil.setElementLongValue(n, ID_DATE, entry.getKey());
                XMLUtil.setElementLongValue(n, ID_VALUE, entry.getValue());
            }
            for (Map.Entry<Long, Long> entry : this.instanceStats.entrySet()) {
                n = XMLUtil.addElement(node, ID_INSTANCE);
                XMLUtil.setElementLongValue(n, ID_DATE, entry.getKey());
                XMLUtil.setElementLongValue(n, ID_VALUE, entry.getValue());
            }
            return true;
        }
    }
}

