/*
 * Decompiled with CFR 0.152.
 */
package icy.type;

import icy.math.MathUtil;
import icy.type.ArrayTypeInfo;
import icy.type.DataType;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.geom.Point2D;
import ome.xml.model.enums.PixelType;

public class TypeUtil {
    @Deprecated
    public static final int TYPE_BYTE = 0;
    @Deprecated
    public static final int TYPE_SHORT = 2;
    @Deprecated
    public static final int TYPE_INT = 3;
    @Deprecated
    public static final int TYPE_FLOAT = 4;
    @Deprecated
    public static final int TYPE_DOUBLE = 5;
    @Deprecated
    public static final int TYPE_UNDEFINED = 32;

    @Deprecated
    public static int sizeOf(int dataType) {
        switch (dataType) {
            case 0: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 8;
            }
        }
        return 0;
    }

    @Deprecated
    public static boolean isFloat(int dataType) {
        return dataType == 4 || dataType == 5;
    }

    @Deprecated
    public static String toLongString(int dataType) {
        switch (dataType) {
            case 0: {
                return "byte (8 bpp)";
            }
            case 2: {
                return "short (16 bpp)";
            }
            case 3: {
                return "int (32 bpp)";
            }
            case 4: {
                return "float (32 bbp)";
            }
            case 5: {
                return "double (64 bbp)";
            }
        }
        return "undefined";
    }

    @Deprecated
    public static String toString(int dataType) {
        switch (dataType) {
            case 0: {
                return "byte";
            }
            case 2: {
                return "short";
            }
            case 3: {
                return "int";
            }
            case 4: {
                return "float";
            }
            case 5: {
                return "double";
            }
        }
        return "undefined";
    }

    public static String toLongString(int dataType, boolean signed) {
        if (TypeUtil.isFloat(dataType)) {
            return TypeUtil.toLongString(dataType);
        }
        return String.valueOf(TypeUtil.toString(signed)) + " " + TypeUtil.toLongString(dataType);
    }

    public static String toString(int dataType, boolean signed) {
        if (TypeUtil.isFloat(dataType)) {
            return TypeUtil.toString(dataType);
        }
        return String.valueOf(TypeUtil.toString(signed)) + " " + TypeUtil.toString(dataType);
    }

    public static String toString(boolean signed) {
        if (signed) {
            return "signed";
        }
        return "unsigned";
    }

    @Deprecated
    public static String[] getItems(boolean longString, boolean wantUndef) {
        String[] result = wantUndef ? new String[6] : new String[5];
        if (longString) {
            result[0] = TypeUtil.toLongString(0);
            result[1] = TypeUtil.toLongString(2);
            result[2] = TypeUtil.toLongString(3);
            result[3] = TypeUtil.toLongString(4);
            result[4] = TypeUtil.toLongString(5);
            if (wantUndef) {
                result[5] = TypeUtil.toLongString(32);
            }
        } else {
            result[0] = TypeUtil.toString(0);
            result[1] = TypeUtil.toString(2);
            result[2] = TypeUtil.toString(3);
            result[3] = TypeUtil.toString(4);
            result[4] = TypeUtil.toString(5);
            if (wantUndef) {
                result[5] = TypeUtil.toString(32);
            }
        }
        return result;
    }

    @Deprecated
    public static ArrayTypeInfo getTypeInfo(Object value) {
        ArrayTypeInfo result = new ArrayTypeInfo(32, 0);
        if (value instanceof byte[]) {
            result.type = 0;
            result.dim = 1;
        } else if (value instanceof short[]) {
            result.type = 2;
            result.dim = 1;
        } else if (value instanceof int[]) {
            result.type = 3;
            result.dim = 1;
        } else if (value instanceof float[]) {
            result.type = 4;
            result.dim = 1;
        } else if (value instanceof double[]) {
            result.type = 5;
            result.dim = 1;
        } else if (value instanceof byte[][]) {
            result.type = 0;
            result.dim = 2;
        } else if (value instanceof short[][]) {
            result.type = 2;
            result.dim = 2;
        } else if (value instanceof int[][]) {
            result.type = 3;
            result.dim = 2;
        } else if (value instanceof float[][]) {
            result.type = 4;
            result.dim = 2;
        } else if (value instanceof double[][]) {
            result.type = 5;
            result.dim = 2;
        } else if (value instanceof byte[][][]) {
            result.type = 0;
            result.dim = 3;
        } else if (value instanceof short[][][]) {
            result.type = 2;
            result.dim = 3;
        } else if (value instanceof int[][][]) {
            result.type = 3;
            result.dim = 3;
        } else if (value instanceof float[][][]) {
            result.type = 4;
            result.dim = 3;
        } else if (value instanceof double[][][]) {
            result.type = 5;
            result.dim = 3;
        } else if (value instanceof byte[][][][]) {
            result.type = 0;
            result.dim = 4;
        } else if (value instanceof short[][][][]) {
            result.type = 2;
            result.dim = 4;
        } else if (value instanceof int[][][][]) {
            result.type = 3;
            result.dim = 4;
        } else if (value instanceof float[][][][]) {
            result.type = 4;
            result.dim = 4;
        } else if (value instanceof double[][][][]) {
            result.type = 5;
            result.dim = 4;
        } else if (value instanceof byte[][][][][]) {
            result.type = 0;
            result.dim = 5;
        } else if (value instanceof short[][][][][]) {
            result.type = 2;
            result.dim = 5;
        } else if (value instanceof int[][][][][]) {
            result.type = 3;
            result.dim = 5;
        } else if (value instanceof float[][][][][]) {
            result.type = 4;
            result.dim = 5;
        } else if (value instanceof double[][][][][]) {
            result.type = 5;
            result.dim = 5;
        }
        return result;
    }

    @Deprecated
    public static int getDataType(Object value) {
        return TypeUtil.getTypeInfo((Object)value).type;
    }

    @Deprecated
    public static int getNumDimension(Object value) {
        return TypeUtil.getTypeInfo((Object)value).dim;
    }

    @Deprecated
    public static int getDataType(String value) {
        String s = value.toLowerCase();
        if (TypeUtil.toString(0).equals(s) || TypeUtil.toLongString(0).equals(s)) {
            return 0;
        }
        if (TypeUtil.toString(2).equals(s) || TypeUtil.toLongString(2).equals(s)) {
            return 2;
        }
        if (TypeUtil.toString(3).equals(s) || TypeUtil.toLongString(3).equals(s)) {
            return 3;
        }
        if (TypeUtil.toString(4).equals(s) || TypeUtil.toLongString(4).equals(s)) {
            return 4;
        }
        if (TypeUtil.toString(5).equals(s) || TypeUtil.toLongString(5).equals(s)) {
            return 5;
        }
        return 32;
    }

    @Deprecated
    public static int dataBufferTypeToDataType(int dataBufferType) {
        switch (dataBufferType) {
            case 0: {
                return 0;
            }
            case 1: 
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
        }
        return 32;
    }

    public static boolean isSignedDataBufferType(int type) {
        switch (type) {
            case 0: {
                return false;
            }
            case 2: {
                return true;
            }
            case 1: {
                return false;
            }
            case 3: {
                return false;
            }
            case 4: {
                return true;
            }
            case 5: {
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public static int formatToolsTypeToDataType(int type) {
        switch (type) {
            case 0: 
            case 1: {
                return 0;
            }
            case 2: 
            case 3: {
                return 2;
            }
            case 4: 
            case 5: {
                return 3;
            }
            case 6: {
                return 4;
            }
            case 7: {
                return 5;
            }
        }
        return 32;
    }

    public static boolean isSignedFormatToolsType(int type) {
        switch (type) {
            case 0: 
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                return true;
            }
            case 1: 
            case 3: 
            case 5: {
                return false;
            }
        }
        return false;
    }

    @Deprecated
    public static int pixelTypeToDataType(PixelType type) {
        switch (type) {
            case INT8: 
            case UINT8: {
                return 0;
            }
            case INT16: 
            case UINT16: {
                return 2;
            }
            case INT32: 
            case UINT32: {
                return 3;
            }
            case FLOAT: {
                return 4;
            }
            case DOUBLE: {
                return 5;
            }
        }
        return 32;
    }

    public static boolean isSignedPixelType(PixelType type) {
        switch (type) {
            case INT8: 
            case INT16: 
            case INT32: 
            case FLOAT: 
            case DOUBLE: {
                return true;
            }
            case UINT8: 
            case UINT16: 
            case UINT32: {
                return false;
            }
        }
        return false;
    }

    @Deprecated
    public static PixelType dataTypeToPixelType(int dataType, boolean signed) {
        switch (dataType) {
            case 0: {
                if (signed) {
                    return PixelType.INT8;
                }
                return PixelType.UINT8;
            }
            case 2: {
                if (signed) {
                    return PixelType.INT16;
                }
                return PixelType.UINT16;
            }
            case 4: {
                return PixelType.FLOAT;
            }
            case 5: {
                return PixelType.DOUBLE;
            }
        }
        if (signed) {
            return PixelType.INT32;
        }
        return PixelType.UINT32;
    }

    public static int unsign(byte value) {
        return value & 0xFF;
    }

    public static int unsign(short value) {
        return value & 0xFFFF;
    }

    public static long unsignL(byte value) {
        return (long)value & 0xFFL;
    }

    public static long unsignL(short value) {
        return (long)value & 0xFFFFL;
    }

    public static long unsign(int value) {
        return (long)value & 0xFFFFFFFFL;
    }

    public static double unsign(long value) {
        double result = value;
        if (result < 0.0) {
            return MathUtil.POW2_64_DOUBLE + result;
        }
        return result;
    }

    public static float unsignF(long value) {
        float result = value;
        if (result < 0.0f) {
            return MathUtil.POW2_64_FLOAT + result;
        }
        return result;
    }

    public static int toShort(byte value, boolean signed) {
        if (signed) {
            return value;
        }
        return TypeUtil.unsign(value);
    }

    public static int toInt(byte value, boolean signed) {
        if (signed) {
            return value;
        }
        return TypeUtil.unsign(value);
    }

    public static int toInt(short value, boolean signed) {
        if (signed) {
            return value;
        }
        return TypeUtil.unsign(value);
    }

    public static int toInt(float value) {
        return (int)value;
    }

    public static int toInt(double value) {
        return (int)value;
    }

    public static long toLong(byte value, boolean signed) {
        if (signed) {
            return value;
        }
        return TypeUtil.unsignL(value);
    }

    public static long toLong(short value, boolean signed) {
        if (signed) {
            return value;
        }
        return TypeUtil.unsignL(value);
    }

    public static long toLong(int value, boolean signed) {
        if (signed) {
            return value;
        }
        return TypeUtil.unsign(value);
    }

    public static long toLong(float value) {
        if (value > 9.223372E18f) {
            return (long)(value - 9.223372E18f) + Long.MIN_VALUE;
        }
        return (long)value;
    }

    public static long toLong(double value) {
        if (value > 9.223372036854776E18) {
            return (long)(value - 9.223372036854776E18) + Long.MIN_VALUE;
        }
        return (long)value;
    }

    public static float toFloat(byte value, boolean signed) {
        if (signed) {
            return value;
        }
        return TypeUtil.unsign(value);
    }

    public static float toFloat(short value, boolean signed) {
        if (signed) {
            return value;
        }
        return TypeUtil.unsign(value);
    }

    public static float toFloat(int value, boolean signed) {
        if (signed) {
            return value;
        }
        return TypeUtil.unsign(value);
    }

    public static float toFloat(long value, boolean signed) {
        if (signed) {
            return value;
        }
        return TypeUtil.unsignF(value);
    }

    public static double toDouble(byte value, boolean signed) {
        if (signed) {
            return value;
        }
        return TypeUtil.unsign(value);
    }

    public static double toDouble(short value, boolean signed) {
        if (signed) {
            return value;
        }
        return TypeUtil.unsign(value);
    }

    public static double toDouble(int value, boolean signed) {
        if (signed) {
            return value;
        }
        return TypeUtil.unsign(value);
    }

    public static double toDouble(long value, boolean signed) {
        if (signed) {
            return value;
        }
        return TypeUtil.unsign(value);
    }

    public static int getInt(Integer obj, int defaultValue) {
        if (obj == null) {
            return defaultValue;
        }
        return obj;
    }

    public static float getFloat(Float obj, float defaultValue) {
        if (obj == null) {
            return defaultValue;
        }
        return obj.floatValue();
    }

    public static double getDouble(Double obj, double defaultValue, boolean allowInfinite) {
        if (obj == null) {
            return defaultValue;
        }
        double result = obj;
        if (!allowInfinite && Double.isInfinite(result)) {
            return defaultValue;
        }
        return result;
    }

    public static double getDouble(Double obj, double defaultValue) {
        return TypeUtil.getDouble(obj, defaultValue, true);
    }

    public static Point toPoint(Point2D p) {
        return new Point((int)p.getX(), (int)p.getY());
    }

    public static Point2D.Double toPoint2D(Point p) {
        return new Point2D.Double(p.x, p.y);
    }

    public static Point toPoint(Dimension d) {
        return new Point(d.width, d.height);
    }

    public static Point2D.Double toPoint2D(Dimension d) {
        return new Point2D.Double(d.width, d.height);
    }

    public static Dimension toDimension(Point p) {
        return new Dimension(p.x, p.y);
    }

    public static Point[] toPoint(int[] input) {
        Point[] result = new Point[input.length / 2];
        int pt = 0;
        int i = 0;
        while (i < input.length) {
            result[pt++] = new Point(input[i + 0], input[i + 1]);
            i += 2;
        }
        return result;
    }

    @Deprecated
    public static double getMinValue(int dataType, boolean signed) {
        return TypeUtil.getDefaultBounds(dataType, signed)[0];
    }

    @Deprecated
    public static double getMaxValue(int dataType, boolean signed) {
        return TypeUtil.getDefaultBounds(dataType, signed)[1];
    }

    @Deprecated
    public static double[] getDefaultBounds(int dataType, boolean signed) {
        return DataType.getDataType(dataType, signed).getDefaultBounds();
    }
}

