/*
 * Decompiled with CFR 0.152.
 */
package icy.type.point;

import icy.type.point.Point3D;
import java.awt.Point;
import java.awt.geom.Point2D;

public abstract class Point4D
implements Cloneable {
    public abstract double getX();

    public abstract double getY();

    public abstract double getZ();

    public abstract double getT();

    public abstract void setX(double var1);

    public abstract void setY(double var1);

    public abstract void setZ(double var1);

    public abstract void setT(double var1);

    public void setLocation(double x, double y, double z, double t) {
        this.setX(x);
        this.setY(y);
        this.setZ(z);
        this.setT(t);
    }

    public void setLocation(Point4D p) {
        this.setLocation(p.getX(), p.getY(), p.getZ(), p.getT());
    }

    public abstract Point2D toPoint2D();

    public abstract Point3D toPoint3D();

    public boolean equals(Object obj) {
        if (obj instanceof Point4D) {
            Point4D pt = (Point4D)obj;
            return this.getX() == pt.getX() && this.getY() == pt.getY() && this.getZ() == pt.getZ() && this.getT() == pt.getT();
        }
        return super.equals(obj);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.getX() + "," + this.getY() + "," + this.getZ() + "," + this.getT() + "]";
    }

    public static class Double
    extends Point4D {
        public double x;
        public double y;
        public double z;
        public double t;

        public static Double[] toPoint4D(double[] input) {
            Double[] result = new Double[input.length / 4];
            int pt = 0;
            int i = 0;
            while (i < input.length) {
                result[pt++] = new Double(input[i + 0], input[i + 1], input[i + 2], input[i + 3]);
                i += 4;
            }
            return result;
        }

        public static double[] toDoubleArray(Double[] input) {
            double[] result = new double[input.length * 4];
            int off = 0;
            Double[] doubleArray = input;
            int n = input.length;
            int n2 = 0;
            while (n2 < n) {
                Double pt = doubleArray[n2];
                result[off++] = pt.x;
                result[off++] = pt.y;
                result[off++] = pt.z;
                result[off++] = pt.t;
                ++n2;
            }
            return result;
        }

        public Double(double x, double y, double z, double t) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.t = t;
        }

        public Double(double[] xyzt) {
            int len = xyzt.length;
            if (len > 0) {
                this.x = xyzt[0];
            }
            if (len > 1) {
                this.y = xyzt[1];
            }
            if (len > 2) {
                this.z = xyzt[2];
            }
            if (len > 3) {
                this.t = xyzt[3];
            }
        }

        public Double() {
            this(0.0, 0.0, 0.0, 0.0);
        }

        @Override
        public double getX() {
            return this.x;
        }

        @Override
        public void setX(double x) {
            this.x = x;
        }

        @Override
        public double getY() {
            return this.y;
        }

        @Override
        public void setY(double y) {
            this.y = y;
        }

        @Override
        public double getZ() {
            return this.z;
        }

        @Override
        public void setZ(double z) {
            this.z = z;
        }

        @Override
        public double getT() {
            return this.t;
        }

        @Override
        public void setT(double t) {
            this.t = t;
        }

        @Override
        public void setLocation(double x, double y, double z, double t) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.t = t;
        }

        @Override
        public Point2D toPoint2D() {
            return new Point2D.Double(this.x, this.y);
        }

        @Override
        public Point3D toPoint3D() {
            return new Point3D.Double(this.x, this.y, this.z);
        }
    }

    public static class Float
    extends Point4D {
        public float x;
        public float y;
        public float z;
        public float t;

        public static Float[] toPoint4D(float[] input) {
            Float[] result = new Float[input.length / 4];
            int pt = 0;
            int i = 0;
            while (i < input.length) {
                result[pt++] = new Float(input[i + 0], input[i + 1], input[i + 2], input[i + 3]);
                i += 4;
            }
            return result;
        }

        public static float[] toFloatArray(Float[] input) {
            float[] result = new float[input.length * 4];
            int off = 0;
            Float[] floatArray = input;
            int n = input.length;
            int n2 = 0;
            while (n2 < n) {
                Float pt = floatArray[n2];
                result[off++] = pt.x;
                result[off++] = pt.y;
                result[off++] = pt.z;
                result[off++] = pt.t;
                ++n2;
            }
            return result;
        }

        public Float(float x, float y, float z, float t) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.t = t;
        }

        public Float(float[] xyzt) {
            int len = xyzt.length;
            if (len > 0) {
                this.x = xyzt[0];
            }
            if (len > 1) {
                this.y = xyzt[1];
            }
            if (len > 2) {
                this.z = xyzt[2];
            }
            if (len > 3) {
                this.t = xyzt[3];
            }
        }

        public Float() {
            this(0.0f, 0.0f, 0.0f, 0.0f);
        }

        @Override
        public double getX() {
            return this.x;
        }

        @Override
        public void setX(double x) {
            this.x = (float)x;
        }

        @Override
        public double getY() {
            return this.y;
        }

        @Override
        public void setY(double y) {
            this.y = (float)y;
        }

        @Override
        public double getZ() {
            return this.z;
        }

        @Override
        public void setZ(double z) {
            this.z = (float)z;
        }

        @Override
        public double getT() {
            return this.t;
        }

        @Override
        public void setT(double t) {
            this.t = (float)t;
        }

        @Override
        public void setLocation(double x, double y, double z, double t) {
            this.x = (float)x;
            this.y = (float)y;
            this.z = (float)z;
            this.t = (float)t;
        }

        @Override
        public Point2D toPoint2D() {
            return new Point2D.Float(this.x, this.y);
        }

        @Override
        public Point3D toPoint3D() {
            return new Point3D.Float(this.x, this.y, this.z);
        }
    }

    public static class Integer
    extends Point4D {
        public int x;
        public int y;
        public int z;
        public int t;

        public static Integer[] toPoint4D(int[] input) {
            Integer[] result = new Integer[input.length / 4];
            int pt = 0;
            int i = 0;
            while (i < input.length) {
                result[pt++] = new Integer(input[i + 0], input[i + 1], input[i + 2], input[i + 3]);
                i += 4;
            }
            return result;
        }

        public static int[] toIntegerArray(Integer[] input) {
            int[] result = new int[input.length * 4];
            int off = 0;
            Integer[] integerArray = input;
            int n = input.length;
            int n2 = 0;
            while (n2 < n) {
                Integer pt = integerArray[n2];
                result[off++] = pt.x;
                result[off++] = pt.y;
                result[off++] = pt.z;
                result[off++] = pt.t;
                ++n2;
            }
            return result;
        }

        public Integer(int x, int y, int z, int t) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.t = t;
        }

        public Integer(int[] xyzt) {
            int len = xyzt.length;
            if (len > 0) {
                this.x = xyzt[0];
            }
            if (len > 1) {
                this.y = xyzt[1];
            }
            if (len > 2) {
                this.z = xyzt[2];
            }
            if (len > 3) {
                this.t = xyzt[3];
            }
        }

        public Integer() {
            this(0, 0, 0, 0);
        }

        @Override
        public double getX() {
            return this.x;
        }

        @Override
        public void setX(double x) {
            this.x = (int)x;
        }

        @Override
        public double getY() {
            return this.y;
        }

        @Override
        public void setY(double y) {
            this.y = (int)y;
        }

        @Override
        public double getZ() {
            return this.z;
        }

        @Override
        public void setZ(double z) {
            this.z = (int)z;
        }

        @Override
        public double getT() {
            return this.t;
        }

        @Override
        public void setT(double t) {
            this.t = (int)t;
        }

        @Override
        public void setLocation(double x, double y, double z, double t) {
            this.x = (int)x;
            this.y = (int)y;
            this.z = (int)z;
            this.t = (int)t;
        }

        @Override
        public Point2D toPoint2D() {
            return new Point(this.x, this.y);
        }

        @Override
        public Point3D toPoint3D() {
            return new Point3D.Integer(this.x, this.y, this.z);
        }
    }
}

