/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.sequence.tools;

import icy.gui.component.IcyTextField;
import icy.gui.component.sequence.SequencePreviewPanel;
import icy.image.IcyBufferedImage;
import icy.image.IcyBufferedImageUtil;
import icy.math.UnitUtil;
import icy.resource.ResourceUtil;
import icy.sequence.AbstractSequenceModel;
import icy.sequence.Sequence;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class SequenceBaseResizePanel
extends JPanel {
    private static final long serialVersionUID = -9220345511598410844L;
    final Sequence sequence;
    protected JCheckBox keepRatioCheckBox;
    protected JSpinner heightSpinner;
    protected JSpinner widthSpinner;
    protected SequencePreviewPanel originalPreview;
    protected SequencePreviewPanel resultPreview;
    protected JPanel infoPanel;
    protected IcyTextField widthField;
    protected IcyTextField heightField;
    protected IcyTextField sizeField;
    protected JComboBox sizeUnitComboBox;
    protected JLabel accolLeftLabel;
    protected JPanel panel;
    protected Component horizontalGlue;
    protected Component horizontalGlue_1;
    protected JPanel settingPanel;

    public SequenceBaseResizePanel(Sequence sequence) {
        this.sequence = sequence;
        this.initialize();
        this.setNewWidth(sequence.getSizeX());
        this.setNewHeight(sequence.getSizeY());
        this.accolLeftLabel.setIcon(ResourceUtil.getImageIcon(ResourceUtil.IMAGE_ACCOLADE_LEFT));
        this.accolLeftLabel.setText(null);
        this.originalPreview.setFitToView(false);
        this.resultPreview.setFitToView(false);
        this.originalPreview.setModel(new OriginalModel());
        this.resultPreview.setModel(new ResultModel());
        this.updatePreview();
        ChangeListener spinnerChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (SequenceBaseResizePanel.this.keepRatioCheckBox.isSelected()) {
                    Sequence seq = SequenceBaseResizePanel.this.sequence;
                    if (e.getSource() == SequenceBaseResizePanel.this.widthSpinner) {
                        double ratio = (double)SequenceBaseResizePanel.this.getNewWidth() / (double)seq.getWidth();
                        SequenceBaseResizePanel.this.setNewHeight((int)Math.round((double)seq.getHeight() * ratio));
                    } else {
                        double ratio = (double)SequenceBaseResizePanel.this.getNewHeight() / (double)seq.getHeight();
                        SequenceBaseResizePanel.this.setNewWidth((int)Math.round((double)seq.getWidth() * ratio));
                    }
                }
                SequenceBaseResizePanel.this.updatePreview();
            }
        };
        this.heightSpinner.addChangeListener(spinnerChangeListener);
        this.widthSpinner.addChangeListener(spinnerChangeListener);
        this.sizeUnitComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int w = Integer.parseInt(SequenceBaseResizePanel.this.widthField.getText());
                int h = Integer.parseInt(SequenceBaseResizePanel.this.heightField.getText());
                SequenceBaseResizePanel.this.setNewWidth(w);
                SequenceBaseResizePanel.this.setNewHeight(h);
            }
        });
    }

    protected void initialize() {
        this.setLayout(new BorderLayout(0, 0));
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 3));
        this.add((Component)this.panel, "North");
        this.infoPanel = new JPanel();
        this.panel.add(this.infoPanel);
        this.infoPanel.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "Size in pixel", 4, 2, null, new Color(0, 0, 0)));
        GridBagLayout gbl_infoPanel = new GridBagLayout();
        int[] nArray = new int[8];
        nArray[0] = 20;
        nArray[1] = 100;
        nArray[2] = 20;
        nArray[3] = 100;
        nArray[4] = 20;
        nArray[5] = 100;
        nArray[6] = 20;
        gbl_infoPanel.columnWidths = nArray;
        gbl_infoPanel.rowHeights = new int[3];
        gbl_infoPanel.columnWeights = new double[]{1.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, Double.MIN_VALUE};
        gbl_infoPanel.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        this.infoPanel.setLayout(gbl_infoPanel);
        JLabel lblOriginalWidth = new JLabel("Width");
        GridBagConstraints gbc_lblOriginalWidth = new GridBagConstraints();
        gbc_lblOriginalWidth.fill = 1;
        gbc_lblOriginalWidth.insets = new Insets(0, 0, 5, 5);
        gbc_lblOriginalWidth.gridx = 1;
        gbc_lblOriginalWidth.gridy = 0;
        this.infoPanel.add((Component)lblOriginalWidth, gbc_lblOriginalWidth);
        lblOriginalWidth.setToolTipText("");
        JLabel lblNewLabel_3 = new JLabel("Height");
        GridBagConstraints gbc_lblNewLabel_3 = new GridBagConstraints();
        gbc_lblNewLabel_3.fill = 1;
        gbc_lblNewLabel_3.insets = new Insets(0, 0, 5, 5);
        gbc_lblNewLabel_3.gridx = 3;
        gbc_lblNewLabel_3.gridy = 0;
        this.infoPanel.add((Component)lblNewLabel_3, gbc_lblNewLabel_3);
        lblNewLabel_3.setToolTipText("");
        JLabel lblNewLabel_2 = new JLabel("Memory size");
        GridBagConstraints gbc_lblNewLabel_2 = new GridBagConstraints();
        gbc_lblNewLabel_2.fill = 1;
        gbc_lblNewLabel_2.insets = new Insets(0, 0, 5, 5);
        gbc_lblNewLabel_2.gridx = 5;
        gbc_lblNewLabel_2.gridy = 0;
        this.infoPanel.add((Component)lblNewLabel_2, gbc_lblNewLabel_2);
        lblNewLabel_2.setToolTipText("");
        this.widthField = new IcyTextField();
        this.widthField.setToolTipText("Width in pixel");
        this.widthField.setText("0000");
        this.widthField.setEditable(false);
        GridBagConstraints gbc_widthField = new GridBagConstraints();
        gbc_widthField.fill = 1;
        gbc_widthField.insets = new Insets(0, 0, 0, 5);
        gbc_widthField.gridx = 1;
        gbc_widthField.gridy = 1;
        this.infoPanel.add((Component)this.widthField, gbc_widthField);
        this.widthField.setColumns(5);
        this.heightField = new IcyTextField();
        this.heightField.setToolTipText("Height in pixel");
        this.heightField.setText("0");
        this.heightField.setEditable(false);
        GridBagConstraints gbc_heightField = new GridBagConstraints();
        gbc_heightField.fill = 1;
        gbc_heightField.insets = new Insets(0, 0, 0, 5);
        gbc_heightField.gridx = 3;
        gbc_heightField.gridy = 1;
        this.infoPanel.add((Component)this.heightField, gbc_heightField);
        this.heightField.setColumns(5);
        this.sizeField = new IcyTextField();
        this.sizeField.setToolTipText("Memory size");
        this.sizeField.setText("0.0B");
        this.sizeField.setEditable(false);
        GridBagConstraints gbc_sizeField = new GridBagConstraints();
        gbc_sizeField.insets = new Insets(0, 0, 0, 5);
        gbc_sizeField.fill = 1;
        gbc_sizeField.gridx = 5;
        gbc_sizeField.gridy = 1;
        this.infoPanel.add((Component)this.sizeField, gbc_sizeField);
        this.sizeField.setColumns(5);
        this.settingPanel = new JPanel();
        this.panel.add(this.settingPanel);
        this.settingPanel.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "Setting", 4, 2, null, new Color(0, 0, 0)));
        GridBagLayout gbl_settingPanel = new GridBagLayout();
        int[] nArray2 = new int[8];
        nArray2[0] = 20;
        nArray2[1] = 100;
        nArray2[2] = 20;
        nArray2[3] = 100;
        nArray2[4] = 20;
        nArray2[5] = 100;
        nArray2[6] = 20;
        gbl_settingPanel.columnWidths = nArray2;
        int[] nArray3 = new int[8];
        nArray3[4] = 10;
        gbl_settingPanel.rowHeights = nArray3;
        gbl_settingPanel.columnWeights = new double[]{1.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, Double.MIN_VALUE};
        gbl_settingPanel.rowWeights = new double[]{0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.settingPanel.setLayout(gbl_settingPanel);
        JLabel lblWidth = new JLabel("Width");
        GridBagConstraints gbc_lblWidth = new GridBagConstraints();
        gbc_lblWidth.fill = 1;
        gbc_lblWidth.insets = new Insets(0, 0, 5, 5);
        gbc_lblWidth.gridx = 1;
        gbc_lblWidth.gridy = 0;
        this.settingPanel.add((Component)lblWidth, gbc_lblWidth);
        this.widthSpinner = new JSpinner();
        this.widthSpinner.setModel(new SpinnerNumberModel(new Integer(1), new Integer(1), null, new Integer(1)));
        this.widthSpinner.setToolTipText("New width to set");
        GridBagConstraints gbc_widthSpinner = new GridBagConstraints();
        gbc_widthSpinner.fill = 1;
        gbc_widthSpinner.insets = new Insets(0, 0, 5, 5);
        gbc_widthSpinner.gridx = 1;
        gbc_widthSpinner.gridy = 1;
        this.settingPanel.add((Component)this.widthSpinner, gbc_widthSpinner);
        JLabel lblNewLabel = new JLabel("Height");
        GridBagConstraints gbc_lblNewLabel = new GridBagConstraints();
        gbc_lblNewLabel.fill = 1;
        gbc_lblNewLabel.insets = new Insets(0, 0, 5, 5);
        gbc_lblNewLabel.gridx = 1;
        gbc_lblNewLabel.gridy = 2;
        this.settingPanel.add((Component)lblNewLabel, gbc_lblNewLabel);
        this.accolLeftLabel = new JLabel("");
        this.accolLeftLabel.setHorizontalAlignment(0);
        GridBagConstraints gbc_accolLeftLabel = new GridBagConstraints();
        gbc_accolLeftLabel.fill = 1;
        gbc_accolLeftLabel.gridheight = 3;
        gbc_accolLeftLabel.insets = new Insets(0, 0, 5, 5);
        gbc_accolLeftLabel.gridx = 2;
        gbc_accolLeftLabel.gridy = 1;
        this.settingPanel.add((Component)this.accolLeftLabel, gbc_accolLeftLabel);
        lblNewLabel.setLabelFor(this.heightSpinner);
        this.sizeUnitComboBox = new JComboBox();
        this.sizeUnitComboBox.setMaximumRowCount(3);
        this.sizeUnitComboBox.setToolTipText("Width / Height unit");
        this.sizeUnitComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"pixel", "%", "um"}));
        this.sizeUnitComboBox.setSelectedIndex(0);
        GridBagConstraints gbc_sizeUnitComboBox = new GridBagConstraints();
        gbc_sizeUnitComboBox.fill = 2;
        gbc_sizeUnitComboBox.gridheight = 3;
        gbc_sizeUnitComboBox.insets = new Insets(0, 0, 5, 5);
        gbc_sizeUnitComboBox.gridx = 3;
        gbc_sizeUnitComboBox.gridy = 1;
        this.settingPanel.add((Component)this.sizeUnitComboBox, gbc_sizeUnitComboBox);
        this.heightSpinner = new JSpinner();
        this.heightSpinner.setModel(new SpinnerNumberModel(new Integer(1), new Integer(1), null, new Integer(1)));
        this.heightSpinner.setToolTipText("New height to set");
        GridBagConstraints gbc_heightSpinner = new GridBagConstraints();
        gbc_heightSpinner.fill = 1;
        gbc_heightSpinner.insets = new Insets(0, 0, 5, 5);
        gbc_heightSpinner.gridx = 1;
        gbc_heightSpinner.gridy = 3;
        this.settingPanel.add((Component)this.heightSpinner, gbc_heightSpinner);
        this.keepRatioCheckBox = new JCheckBox("Keep ratio");
        this.keepRatioCheckBox.setVerticalAlignment(1);
        this.keepRatioCheckBox.setToolTipText("Keep original aspect ratio");
        this.keepRatioCheckBox.setSelected(true);
        GridBagConstraints gbc_keepRatioCheckBox = new GridBagConstraints();
        gbc_keepRatioCheckBox.gridwidth = 3;
        gbc_keepRatioCheckBox.fill = 1;
        gbc_keepRatioCheckBox.insets = new Insets(0, 0, 5, 5);
        gbc_keepRatioCheckBox.gridx = 1;
        gbc_keepRatioCheckBox.gridy = 5;
        this.settingPanel.add((Component)this.keepRatioCheckBox, gbc_keepRatioCheckBox);
        this.horizontalGlue = Box.createHorizontalGlue();
        GridBagConstraints gbc_horizontalGlue = new GridBagConstraints();
        gbc_horizontalGlue.fill = 2;
        gbc_horizontalGlue.insets = new Insets(0, 0, 0, 5);
        gbc_horizontalGlue.gridx = 5;
        gbc_horizontalGlue.gridy = 6;
        this.settingPanel.add(this.horizontalGlue, gbc_horizontalGlue);
        this.horizontalGlue_1 = Box.createHorizontalGlue();
        GridBagConstraints gbc_horizontalGlue_1 = new GridBagConstraints();
        gbc_horizontalGlue_1.fill = 2;
        gbc_horizontalGlue_1.gridx = 6;
        gbc_horizontalGlue_1.gridy = 6;
        this.settingPanel.add(this.horizontalGlue_1, gbc_horizontalGlue_1);
        JPanel previewPanel = new JPanel();
        previewPanel.setBorder(new TitledBorder(null, "Preview", 4, 2, null, null));
        this.add((Component)previewPanel, "Center");
        previewPanel.setLayout(new BoxLayout(previewPanel, 2));
        this.originalPreview = new SequencePreviewPanel("Original");
        previewPanel.add(this.originalPreview);
        this.resultPreview = new SequencePreviewPanel("Result");
        previewPanel.add(this.resultPreview);
    }

    void updatePreview() {
        int w = this.getNewWidth();
        int h = this.getNewHeight();
        this.widthField.setText(Integer.toString(w));
        this.heightField.setText(Integer.toString(h));
        this.sizeField.setText(UnitUtil.getBytesString(w * h * this.sequence.getSizeC() * this.sequence.getSizeZ() * this.sequence.getSizeT() * this.sequence.getDataType_().getSize()));
        this.originalPreview.imageChanged();
        this.resultPreview.imageChanged();
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public double getPixelSizeX() {
        if (this.sequence != null) {
            return this.sequence.getPixelSizeX();
        }
        return 1.0;
    }

    public double getPixelSizeY() {
        if (this.sequence != null) {
            return this.sequence.getPixelSizeY();
        }
        return 1.0;
    }

    public SizeUnit getSizeUnit() {
        switch (this.sizeUnitComboBox.getSelectedIndex()) {
            default: {
                return SizeUnit.PIXEL;
            }
            case 1: {
                return SizeUnit.PERCENT;
            }
            case 2: 
        }
        return SizeUnit.MICRON;
    }

    public int unitToPixel(double value, int originPixel, SizeUnit unit, double micronPerPixel) {
        switch (unit) {
            default: {
                return (int)Math.round(value);
            }
            case PERCENT: {
                return (int)Math.round((double)originPixel * value / 100.0);
            }
            case MICRON: 
        }
        return (int)Math.round(value / micronPerPixel);
    }

    public int unitToPixelX(double value, int originPixel, SizeUnit unit) {
        return this.unitToPixel(value, originPixel, unit, this.getPixelSizeX());
    }

    public int unitToPixelY(double value, int originPixel, SizeUnit unit) {
        return this.unitToPixel(value, originPixel, unit, this.getPixelSizeY());
    }

    public double pixelToUnit(int value, int originPixel, SizeUnit unit, double micronPerPixel) {
        switch (unit) {
            default: {
                return value;
            }
            case PERCENT: {
                return (int)Math.round((double)value * 100.0 / (double)originPixel);
            }
            case MICRON: 
        }
        return (int)((double)value * micronPerPixel);
    }

    public double pixelXToUnit(int value, int originPixel, SizeUnit unit) {
        return this.pixelToUnit(value, originPixel, unit, this.getPixelSizeX());
    }

    public double pixelYToUnit(int value, int originPixel, SizeUnit unit) {
        return this.pixelToUnit(value, originPixel, unit, this.getPixelSizeY());
    }

    public double getSpinnerSizeValue(JSpinner spinner) {
        switch (this.getSizeUnit()) {
            default: {
                return ((Integer)spinner.getValue()).intValue();
            }
            case PERCENT: 
            case MICRON: 
        }
        return (Double)spinner.getValue();
    }

    public int getNewWidth() {
        int result = this.unitToPixelX(this.getSpinnerSizeValue(this.widthSpinner), this.sequence.getSizeX(), this.getSizeUnit());
        return Math.min(65535, Math.max(1, result));
    }

    public int getNewHeight() {
        int result = this.unitToPixelY(this.getSpinnerSizeValue(this.heightSpinner), this.sequence.getSizeY(), this.getSizeUnit());
        return Math.min(Math.max(1, result), 65535);
    }

    void setSpinnerSizeValue(JSpinner spinner, double value) {
        switch (this.getSizeUnit()) {
            default: {
                spinner.setModel(new SpinnerNumberModel((int)value, 0, 65535, 1));
                ((JSpinner.DefaultEditor)spinner.getEditor()).getTextField().setColumns(1);
                break;
            }
            case PERCENT: {
                spinner.setModel(new SpinnerNumberModel(value, 0.0, Double.MAX_VALUE, 1.0));
                ((JSpinner.DefaultEditor)spinner.getEditor()).getTextField().setColumns(1);
                break;
            }
            case MICRON: {
                spinner.setModel(new SpinnerNumberModel(value, 0.0, Double.MAX_VALUE, 0.01));
                ((JSpinner.DefaultEditor)spinner.getEditor()).getTextField().setColumns(1);
            }
        }
    }

    void setNewWidth(int value) {
        this.setSpinnerSizeValue(this.widthSpinner, this.pixelXToUnit(value, this.sequence.getSizeX(), this.getSizeUnit()));
    }

    void setNewHeight(int value) {
        this.setSpinnerSizeValue(this.heightSpinner, this.pixelYToUnit(value, this.sequence.getSizeY(), this.getSizeUnit()));
    }

    public int getMaxSizeX() {
        return Math.max(this.getNewWidth(), this.sequence.getSizeX());
    }

    public int getMaxSizeY() {
        return Math.max(this.getNewHeight(), this.sequence.getSizeY());
    }

    public abstract IcyBufferedImageUtil.FilterType getFilterType();

    public abstract boolean getResizeContent();

    public abstract int getXAlign();

    public abstract int getYAlign();

    protected class OriginalModel
    extends AbstractSequenceModel {
        @Override
        public int getSizeX() {
            return SequenceBaseResizePanel.this.getMaxSizeX();
        }

        @Override
        public int getSizeY() {
            return SequenceBaseResizePanel.this.getMaxSizeY();
        }

        @Override
        public int getSizeZ() {
            return SequenceBaseResizePanel.this.sequence.getSizeZ();
        }

        @Override
        public int getSizeT() {
            return SequenceBaseResizePanel.this.sequence.getSizeT();
        }

        @Override
        public int getSizeC() {
            return SequenceBaseResizePanel.this.sequence.getSizeC();
        }

        @Override
        public BufferedImage getImage(int t, int z) {
            return SequenceBaseResizePanel.this.sequence.getImage(t, z);
        }

        @Override
        public BufferedImage getImage(int t, int z, int c) {
            return SequenceBaseResizePanel.this.sequence.getImage(t, z, c);
        }
    }

    protected class ResultModel
    extends AbstractSequenceModel {
        @Override
        public int getSizeX() {
            return SequenceBaseResizePanel.this.getMaxSizeX();
        }

        @Override
        public int getSizeY() {
            return SequenceBaseResizePanel.this.getMaxSizeY();
        }

        @Override
        public int getSizeZ() {
            return SequenceBaseResizePanel.this.sequence.getSizeZ();
        }

        @Override
        public int getSizeT() {
            return SequenceBaseResizePanel.this.sequence.getSizeT();
        }

        @Override
        public int getSizeC() {
            return SequenceBaseResizePanel.this.sequence.getSizeC();
        }

        @Override
        public BufferedImage getImage(int t, int z) {
            try {
                return IcyBufferedImageUtil.scale(SequenceBaseResizePanel.this.sequence.getImage(t, z), SequenceBaseResizePanel.this.getNewWidth(), SequenceBaseResizePanel.this.getNewHeight(), SequenceBaseResizePanel.this.getResizeContent(), SequenceBaseResizePanel.this.getXAlign(), SequenceBaseResizePanel.this.getYAlign(), SequenceBaseResizePanel.this.getFilterType());
            }
            catch (OutOfMemoryError e) {
                return null;
            }
        }

        @Override
        public BufferedImage getImage(int t, int z, int c) {
            return ((IcyBufferedImage)this.getImage(t, z)).getImage(c);
        }
    }

    protected static enum SizeUnit {
        PIXEL,
        PERCENT,
        MICRON;

    }
}

