/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.gui.NonBlockingGenericDialog;
import ij.macro.Interpreter;
import ij.macro.Program;
import ij.macro.Tokenizer;
import ij.plugin.filter.Analyzer;
import ij.plugin.filter.ExtendedPlugInFilter;
import ij.plugin.filter.PlugInFilterRunner;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.AWTEvent;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;

public class ImageMath
implements ExtendedPlugInFilter,
DialogListener {
    public static final String MACRO_KEY = "math.macro";
    private int flags = 16777311;
    private String arg;
    private ImagePlus imp;
    private boolean canceled;
    private double lower = -1.0;
    private double upper = -1.0;
    private String macro2;
    private PlugInFilterRunner pfr;
    private GenericDialog gd;
    private static double defaultAddValue = 25.0;
    private static double defaultMulValue = 1.25;
    private static double defaultMinValue = 0.0;
    private static double defaultMaxValue = 255.0;
    private static String defaultAndValue = "11110000";
    private static double defaultGammaValue = 0.5;
    private static String defaultMacro = Prefs.get("math.macro", "v=v+50*sin(d/10)");
    private static double lastAddValue = defaultAddValue;
    private static double lastMulValue = defaultMulValue;
    private static double lastMinValue = defaultMinValue;
    private static double lastMaxValue = defaultMaxValue;
    private static String lastAndValue = defaultAndValue;
    private static double lastGammaValue = defaultGammaValue;
    private static String lastMacro = defaultMacro;
    private double addValue = defaultAddValue;
    private double mulValue = defaultMulValue;
    private double minValue = defaultMinValue;
    private double maxValue = defaultMaxValue;
    private String andValue = defaultAndValue;
    private double gammaValue = defaultGammaValue;
    private String macro = defaultMacro;

    @Override
    public int setup(String arg, ImagePlus imp) {
        this.arg = arg;
        this.imp = imp;
        IJ.register(ImageMath.class);
        if (!arg.equals("macro") || Interpreter.getInstance() == null) {
            this.flags |= 0x8000;
        }
        return this.flags;
    }

    @Override
    public void run(ImageProcessor ip) {
        if (this.canceled) {
            return;
        }
        if (this.arg.equals("add")) {
            ip.add(this.addValue);
        } else if (this.arg.equals("sub")) {
            ip.subtract(this.addValue);
        } else if (this.arg.equals("mul")) {
            ip.multiply(this.mulValue);
        } else if (this.arg.equals("div")) {
            if (this.mulValue == 0.0 && this.imp.getBitDepth() != 32) {
                return;
            }
            ip.multiply(1.0 / this.mulValue);
        } else if (this.arg.equals("and")) {
            try {
                ip.and(Integer.parseInt(this.andValue, 2));
            }
            catch (NumberFormatException e) {
                this.andValue = defaultAndValue;
                IJ.error("Binary number required");
            }
        } else if (this.arg.equals("or")) {
            try {
                ip.or(Integer.parseInt(this.andValue, 2));
            }
            catch (NumberFormatException e) {
                this.andValue = defaultAndValue;
                IJ.error("Binary number required");
            }
        } else if (this.arg.equals("xor")) {
            try {
                ip.xor(Integer.parseInt(this.andValue, 2));
            }
            catch (NumberFormatException e) {
                this.andValue = defaultAndValue;
                IJ.error("Binary number required");
            }
        } else if (this.arg.equals("min")) {
            ip.min(this.minValue);
            if (!(ip instanceof ByteProcessor)) {
                ip.resetMinAndMax();
            }
        } else if (this.arg.equals("max")) {
            ip.max(this.maxValue);
            if (!(ip instanceof ByteProcessor)) {
                ip.resetMinAndMax();
            }
        } else if (this.arg.equals("gamma")) {
            if (this.gammaValue < 0.05 || this.gammaValue > 5.0) {
                if (!this.previewing() && !this.canceled) {
                    this.canceled = true;
                    IJ.error("Gamma must be between 0.05 and 5.0");
                }
                this.gammaValue = defaultGammaValue;
            } else {
                ip.gamma(this.gammaValue);
            }
        } else if (this.arg.equals("set")) {
            ip.set(this.addValue);
        } else if (this.arg.equals("log")) {
            ip.log();
        } else if (this.arg.equals("exp")) {
            ip.exp();
        } else if (this.arg.equals("sqr")) {
            ip.sqr();
        } else if (this.arg.equals("sqrt")) {
            ip.sqrt();
        } else if (this.arg.equals("reciprocal")) {
            if (!this.isFloat(ip)) {
                return;
            }
            float[] pixels = (float[])ip.getPixels();
            for (int i = 0; i < ip.getWidth() * ip.getHeight(); ++i) {
                pixels[i] = pixels[i] == 0.0f ? Float.NaN : 1.0f / pixels[i];
            }
            ip.resetMinAndMax();
        } else if (this.arg.equals("nan")) {
            this.setBackgroundToNaN(ip);
        } else if (this.arg.equals("abs")) {
            if (!(ip instanceof FloatProcessor) && !this.imp.getCalibration().isSigned16Bit()) {
                IJ.error("32-bit or signed 16-bit image required");
                this.canceled = true;
            } else {
                ip.abs();
                ip.resetMinAndMax();
            }
        } else if (this.arg.equals("macro")) {
            this.applyMacro(ip);
        }
    }

    boolean previewing() {
        return this.gd != null && this.gd.isPreviewActive();
    }

    boolean isFloat(ImageProcessor ip) {
        if (!(ip instanceof FloatProcessor)) {
            IJ.error("32-bit float image required");
            this.canceled = true;
            return false;
        }
        return true;
    }

    void getValue(String title, String prompt, double defaultValue, int digits) {
        int places = Analyzer.getPrecision();
        if (digits > 0 || (double)((int)defaultValue) != defaultValue) {
            digits = Math.max(places, 1);
        }
        this.gd = NonBlockingGenericDialog.newDialog(title, this.imp);
        this.gd.addNumericField(prompt, defaultValue, digits, 8, null);
        this.gd.addPreviewCheckbox(this.pfr);
        this.gd.addDialogListener(this);
        this.gd.showDialog();
    }

    void getBinaryValue(String title, String prompt, String defaultValue) {
        this.gd = NonBlockingGenericDialog.newDialog(title, this.imp);
        this.gd.addStringField(prompt, defaultValue);
        this.gd.addPreviewCheckbox(this.pfr);
        this.gd.addDialogListener(this);
        this.gd.showDialog();
    }

    void getGammaValue(double defaultValue) {
        this.gd = NonBlockingGenericDialog.newDialog("Gamma", this.imp);
        if (GraphicsEnvironment.isHeadless()) {
            this.gd.addNumericField("Value:", defaultValue, 2);
        } else {
            this.gd.addSlider("Value:", 0.0, 5.0, defaultValue, 0.02);
        }
        this.gd.addPreviewCheckbox(this.pfr);
        this.gd.addDialogListener(this);
        this.gd.showDialog();
    }

    void setBackgroundToNaN(ImageProcessor ip) {
        if (this.lower == -1.0 && this.upper == -1.0) {
            this.lower = ip.getMinThreshold();
            this.upper = ip.getMaxThreshold();
            if (this.lower == -808080.0 || !(ip instanceof FloatProcessor)) {
                String title = this.imp != null ? "\n\"" + this.imp.getTitle() + "\"" : "";
                IJ.error("NaN Backround", "Thresholded 32-bit float image required:" + title);
                this.canceled = true;
                return;
            }
        }
        if (!(ip instanceof FloatProcessor)) {
            return;
        }
        float[] pixels = (float[])ip.getPixels();
        int width = ip.getWidth();
        int height = ip.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                double v = pixels[y * width + x];
                if (!(v < this.lower) && !(v > this.upper)) continue;
                pixels[y * width + x] = Float.NaN;
            }
        }
        ip.resetMinAndMax();
    }

    private void applyMacro(ImageProcessor ip) {
        if (this.macro2 == null) {
            return;
        }
        this.macro = this.macro2;
        ip.setSliceNumber(this.pfr.getSliceNumber());
        boolean showProgress = this.pfr.getSliceNumber() == 1 && !Interpreter.isBatchMode();
        ImageMath.applyMacro(ip, this.macro, showProgress);
        if (this.pfr.getSliceNumber() == 1) {
            ip.resetMinAndMax();
        }
    }

    public static void applyMacro(ImageProcessor ip, String macro, boolean showProgress) {
        if (!macro.contains("=")) {
            macro = "v=" + macro;
        }
        ImagePlus temp = WindowManager.getTempCurrentImage();
        WindowManager.setTempCurrentImage(new ImagePlus("", ip));
        int PCStart = 23;
        Program pgm = new Tokenizer().tokenize(macro);
        boolean hasX = pgm.hasWord("x");
        boolean hasA = pgm.hasWord("a");
        boolean hasD = pgm.hasWord("d");
        boolean hasGetPixel = pgm.hasWord("getPixel");
        int w = ip.getWidth();
        int h = ip.getHeight();
        int w2 = w / 2;
        int h2 = h / 2;
        String code = "var v,x,y,z,w,h,d,a;\nfunction dummy() {}\n" + macro + ";\n";
        Interpreter interp = new Interpreter();
        interp.run(code, null);
        if (interp.wasError()) {
            WindowManager.setTempCurrentImage(temp);
            return;
        }
        Prefs.set(MACRO_KEY, macro);
        interp.setVariable("w", w);
        interp.setVariable("h", h);
        interp.setVariable("z", ip.getSliceNumber() - 1);
        int bitDepth = ip.getBitDepth();
        Rectangle r = ip.getRoi();
        int inc = r.height / 50;
        if (inc < 1) {
            inc = 1;
        }
        if (bitDepth == 8) {
            byte[] pixels1;
            byte[] pixels2 = pixels1 = (byte[])ip.getPixels();
            if (hasGetPixel) {
                pixels2 = new byte[w * h];
            }
            for (int y = r.y; y < r.y + r.height; ++y) {
                if (showProgress && y % inc == 0) {
                    IJ.showProgress(y - r.y, r.height);
                }
                interp.setVariable("y", y);
                for (int x = r.x; x < r.x + r.width; ++x) {
                    int index = y * w + x;
                    double v = pixels1[index] & 0xFF;
                    interp.setVariable("v", v);
                    if (hasX) {
                        interp.setVariable("x", x);
                    }
                    if (hasA) {
                        interp.setVariable("a", ImageMath.getA(h - y - 1 - h2, x - w2));
                    }
                    if (hasD) {
                        interp.setVariable("d", ImageMath.getD(x - w2, y - h2));
                    }
                    interp.run(PCStart);
                    int v2 = (int)interp.getVariable("v");
                    if (v2 < 0) {
                        v2 = 0;
                    }
                    if (v2 > 255) {
                        v2 = 255;
                    }
                    pixels2[index] = (byte)v2;
                }
            }
            if (hasGetPixel) {
                System.arraycopy(pixels2, 0, pixels1, 0, w * h);
            }
        } else if (bitDepth == 24) {
            int[] pixels1;
            int[] pixels2 = pixels1 = (int[])ip.getPixels();
            if (hasGetPixel) {
                pixels2 = new int[w * h];
            }
            for (int y = r.y; y < r.y + r.height; ++y) {
                if (showProgress && y % inc == 0) {
                    IJ.showProgress(y - r.y, r.height);
                }
                interp.setVariable("y", y);
                for (int x = r.x; x < r.x + r.width; ++x) {
                    if (hasX) {
                        interp.setVariable("x", x);
                    }
                    if (hasA) {
                        interp.setVariable("a", ImageMath.getA(h - y - 1 - h2, x - w2));
                    }
                    if (hasD) {
                        interp.setVariable("d", ImageMath.getD(x - w2, y - h2));
                    }
                    int index = y * w + x;
                    int rgb = pixels1[index];
                    if (hasGetPixel) {
                        interp.setVariable("v", rgb);
                        interp.run(PCStart);
                        rgb = (int)interp.getVariable("v");
                    } else {
                        int red = (rgb & 0xFF0000) >> 16;
                        int green = (rgb & 0xFF00) >> 8;
                        int blue = rgb & 0xFF;
                        interp.setVariable("v", red);
                        interp.run(PCStart);
                        red = (int)interp.getVariable("v");
                        if (red < 0) {
                            red = 0;
                        }
                        if (red > 255) {
                            red = 255;
                        }
                        interp.setVariable("v", green);
                        interp.run(PCStart);
                        green = (int)interp.getVariable("v");
                        if (green < 0) {
                            green = 0;
                        }
                        if (green > 255) {
                            green = 255;
                        }
                        interp.setVariable("v", blue);
                        interp.run(PCStart);
                        blue = (int)interp.getVariable("v");
                        if (blue < 0) {
                            blue = 0;
                        }
                        if (blue > 255) {
                            blue = 255;
                        }
                        rgb = 0xFF000000 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
                    }
                    pixels2[index] = rgb;
                }
            }
            if (hasGetPixel) {
                System.arraycopy(pixels2, 0, pixels1, 0, w * h);
            }
        } else if (ip.isSigned16Bit()) {
            for (int y = r.y; y < r.y + r.height; ++y) {
                if (showProgress && y % inc == 0) {
                    IJ.showProgress(y - r.y, r.height);
                }
                interp.setVariable("y", y);
                for (int x = r.x; x < r.x + r.width; ++x) {
                    double v = ip.getPixelValue(x, y);
                    interp.setVariable("v", v);
                    if (hasX) {
                        interp.setVariable("x", x);
                    }
                    if (hasA) {
                        interp.setVariable("a", ImageMath.getA(h - y - 1 - h2, x - w2));
                    }
                    if (hasD) {
                        interp.setVariable("d", ImageMath.getD(x - w2, y - h2));
                    }
                    interp.run(PCStart);
                    ip.putPixelValue(x, y, interp.getVariable("v"));
                }
            }
        } else if (bitDepth == 16) {
            short[] pixels1;
            short[] pixels2 = pixels1 = (short[])ip.getPixels();
            if (hasGetPixel) {
                pixels2 = new short[w * h];
            }
            for (int y = r.y; y < r.y + r.height; ++y) {
                if (showProgress && y % inc == 0) {
                    IJ.showProgress(y - r.y, r.height);
                }
                interp.setVariable("y", y);
                for (int x = r.x; x < r.x + r.width; ++x) {
                    int index = y * w + x;
                    double v = pixels1[index] & 0xFFFF;
                    interp.setVariable("v", v);
                    if (hasX) {
                        interp.setVariable("x", x);
                    }
                    if (hasA) {
                        interp.setVariable("a", ImageMath.getA(h - y - 1 - h2, x - w2));
                    }
                    if (hasD) {
                        interp.setVariable("d", ImageMath.getD(x - w2, y - h2));
                    }
                    interp.run(PCStart);
                    int v2 = (int)interp.getVariable("v");
                    if (v2 < 0) {
                        v2 = 0;
                    }
                    if (v2 > 65535) {
                        v2 = 65535;
                    }
                    pixels2[index] = (short)v2;
                }
            }
            if (hasGetPixel) {
                System.arraycopy(pixels2, 0, pixels1, 0, w * h);
            }
        } else {
            float[] pixels1;
            float[] pixels2 = pixels1 = (float[])ip.getPixels();
            if (hasGetPixel) {
                pixels2 = new float[w * h];
            }
            for (int y = r.y; y < r.y + r.height; ++y) {
                if (showProgress && y % inc == 0) {
                    IJ.showProgress(y - r.y, r.height);
                }
                interp.setVariable("y", y);
                for (int x = r.x; x < r.x + r.width; ++x) {
                    int index = y * w + x;
                    double v = pixels1[index];
                    interp.setVariable("v", v);
                    if (hasX) {
                        interp.setVariable("x", x);
                    }
                    if (hasA) {
                        interp.setVariable("a", ImageMath.getA(h - y - 1 - h2, x - w2));
                    }
                    if (hasD) {
                        interp.setVariable("d", ImageMath.getD(x - w2, y - h2));
                    }
                    interp.run(PCStart);
                    pixels2[index] = (float)interp.getVariable("v");
                }
            }
            if (hasGetPixel) {
                System.arraycopy(pixels2, 0, pixels1, 0, w * h);
            }
        }
        if (showProgress) {
            IJ.showProgress(1.0);
        }
        WindowManager.setTempCurrentImage(temp);
    }

    private static final double getD(int dx, int dy) {
        return Math.sqrt(dx * dx + dy * dy);
    }

    private static final double getA(int y, int x) {
        double angle = Math.atan2(y, x);
        if (angle < 0.0) {
            angle += Math.PI * 2;
        }
        return angle;
    }

    void getMacro(String macro) {
        String options = Macro.getOptions();
        if (options != null && options.startsWith("v=")) {
            Macro.setOptions("code=" + options);
        }
        this.gd = NonBlockingGenericDialog.newDialog("Expression Evaluator", this.imp);
        this.gd.addStringField("Code:", macro, 42);
        this.gd.setInsets(0, 40, 0);
        this.gd.addMessage("v=pixel value, x,y&z=pixel coordinates, w=image width,\nh=image height, a=angle, d=distance from center\n");
        this.gd.setInsets(5, 40, 0);
        this.gd.addPreviewCheckbox(this.pfr);
        this.gd.addDialogListener(this);
        this.gd.addHelp("http://imagej.nih.gov/ij/docs/menus/process.html#math-macro");
        this.gd.showDialog();
    }

    @Override
    public int showDialog(ImagePlus imp, String command, PlugInFilterRunner pfr) {
        boolean interactive;
        this.pfr = pfr;
        boolean bl = interactive = Macro.getOptions() == null;
        if (interactive) {
            this.addValue = lastAddValue;
            this.mulValue = lastMulValue;
            this.minValue = lastMinValue;
            this.maxValue = lastMaxValue;
            this.andValue = lastAndValue;
            this.gammaValue = lastGammaValue;
            this.macro = lastMacro;
        }
        if (this.arg.equals("macro")) {
            this.getMacro(this.macro);
        } else if (this.arg.equals("add")) {
            this.getValue("Add", "Value: ", this.addValue, 0);
        } else if (this.arg.equals("sub")) {
            this.getValue("Subtract", "Value: ", this.addValue, 0);
        } else if (this.arg.equals("mul")) {
            this.getValue("Multiply", "Value: ", this.mulValue, 2);
        } else if (this.arg.equals("div")) {
            this.getValue("Divide", "Value: ", this.mulValue, 2);
        } else if (this.arg.equals("and")) {
            this.getBinaryValue("AND", "Value (binary): ", this.andValue);
        } else if (this.arg.equals("or")) {
            this.getBinaryValue("OR", "Value (binary): ", this.andValue);
        } else if (this.arg.equals("xor")) {
            this.getBinaryValue("XOR", "Value (binary): ", this.andValue);
        } else if (this.arg.equals("min")) {
            this.getValue("Min", "Value: ", this.minValue, 0);
        } else if (this.arg.equals("max")) {
            this.getValue("Max", "Value: ", this.maxValue, 0);
        } else if (this.arg.equals("gamma")) {
            this.getGammaValue(this.gammaValue);
        } else if (this.arg.equals("set")) {
            boolean rgb = imp.getBitDepth() == 24;
            String prompt = rgb ? "Value (0-255): " : "Value: ";
            this.getValue("Set", prompt, this.addValue, 0);
        }
        if (this.gd != null && this.gd.wasCanceled()) {
            return 4096;
        }
        if (interactive) {
            lastAddValue = this.addValue;
            lastMulValue = this.mulValue;
            lastMinValue = this.minValue;
            lastMaxValue = this.maxValue;
            lastAndValue = this.andValue;
            lastGammaValue = this.gammaValue;
            lastMacro = this.macro;
        }
        return IJ.setupDialog(imp, this.flags);
    }

    @Override
    public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
        if (this.arg.equals("macro")) {
            String str = gd.getNextString();
            if (this.previewing() && this.macro2 != null && !str.equals(this.macro2)) {
                gd.getPreviewCheckbox().setState(false);
            }
            this.macro2 = str;
        } else if (this.arg.equals("add") || this.arg.equals("sub") || this.arg.equals("set")) {
            this.addValue = gd.getNextNumber();
        } else if (this.arg.equals("mul") || this.arg.equals("div")) {
            this.mulValue = gd.getNextNumber();
        } else if (this.arg.equals("and") || this.arg.equals("or") || this.arg.equals("xor")) {
            this.andValue = gd.getNextString();
        } else if (this.arg.equals("min")) {
            this.minValue = gd.getNextNumber();
        } else if (this.arg.equals("max")) {
            this.maxValue = gd.getNextNumber();
        } else if (this.arg.equals("gamma")) {
            this.gammaValue = gd.getNextNumber();
            if ((this.gammaValue < 0.05 || this.gammaValue > 5.0) && this.previewing()) {
                IJ.showStatus("Gamma must be between 0.05 and 5.0");
                this.gammaValue = defaultGammaValue;
                return false;
            }
        }
        this.canceled = gd.invalidNumber();
        if (gd.wasOKed() && this.canceled) {
            IJ.error("Value is invalid.");
            return false;
        }
        return true;
    }

    @Override
    public void setNPasses(int nPasses) {
    }
}

