package plugins.tprovoost.painting.shapes;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;

import plugins.tprovoost.painting.PaintingTools;

public class ArrowShape extends PaintingShape
{
    private int x1;
    private int y1;
    private int x2;
    private int y2;
    private double headSideSize = 0.2D;

    public ArrowShape(PaintingTools tools, int x1, int y1, int x2, int y2)
    {
        super(tools);

        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
        this.fill = false;

        headSideSize = getThickness() * 1.5D;
        double dx = x2 - x1;
        double dy = y2 - y1;
        int len = (int) Math.sqrt(dx * dx + dy * dy);
        if (len < headSideSize)
            len = (int) headSideSize;

        int xcoords[] = new int[] {0, (int) (len - headSideSize), (int) (len - headSideSize), len,
                (int) (len - headSideSize), (int) (len - headSideSize)};
        int ycoords[] = new int[] {0, 0, (int) (headSideSize), 0, -(int) (headSideSize), 0};
        shape = new Polygon(xcoords, ycoords, xcoords.length);
    }

    @Override
    public void drawShape(Graphics2D g)
    {
        drawArrow(g, x1, y1, x2, y2, getThickness() * 1.5D);
    }

    public static void drawArrow(Graphics g1, int x1, int y1, int x2, int y2, double frac)
    {
        Graphics2D g = (Graphics2D) g1.create();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);

        double dx = x2 - x1, dy = y2 - y1;
        double angle = Math.atan2(dy, dx);
        int len = (int) Math.sqrt(dx * dx + dy * dy);
        if (len < frac)
            len = (int) frac;

        AffineTransform at = AffineTransform.getTranslateInstance(x1, y1);
        at.concatenate(AffineTransform.getRotateInstance(angle));
        g.transform(at);

        // Draw horizontal arrow starting in (0, 0)
        int xcoords[] = new int[] {0, (int) (len - frac), (int) (len - frac), len, (int) (len - frac),
                (int) (len - frac)};
        int ycoords[] = new int[] {0, 0, (int) (frac), 0, -(int) (frac), 0};
        g.drawPolygon(xcoords, ycoords, xcoords.length);
        g.fillPolygon(xcoords, ycoords, xcoords.length);

        g.dispose();
    }

    @Override
    public void update(Point p)
    {
        x2 = p.x;
        y2 = p.y;

        // headSideSize = getThickness() * 1.5D;
        // double dx = x2 - x1;
        // double dy = y2 - y1;
        // int len = (int) Math.sqrt(dx * dx + dy * dy);
        // double angle = Math.atan2(dy, dx);
        // if (len < headSideSize)
        // len = (int) headSideSize;
        //
        // int xcoords[] = new int[] { 0, (int) (len - headSideSize), (int) (len
        // - headSideSize), len, (int) (len - headSideSize), (int) (len -
        // headSideSize) };
        // int ycoords[] = new int[] { 0, 0, (int) (headSideSize), 0, -(int)
        // (headSideSize), 0 };
        // shape = new Polygon(xcoords, ycoords, xcoords.length);
    }
}
