/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.frame.error;

import icy.gui.frame.IcyFrame;
import icy.gui.frame.TitledFrame;
import icy.gui.frame.error.ErrorReportPanel;
import icy.gui.frame.progress.ProgressFrame;
import icy.system.IcyExceptionHandler;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.text.BadLocationException;

public class ErrorReportFrame
extends TitledFrame
implements ActionListener {
    protected ErrorReportPanel panel;
    protected ActionListener reportAction;

    public static boolean hasErrorFrameOpened() {
        return !IcyFrame.getAllFrames(ErrorReportFrame.class).isEmpty();
    }

    public ErrorReportFrame(Icon icon, String title, String message) {
        super("Bug report", true, true, true, true);
        this.panel = new ErrorReportPanel(icon, title, message);
        this.panel.reportButton.addActionListener(this);
        this.panel.closeButton.addActionListener(this);
        this.reportAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try (ProgressFrame progressFrame = new ProgressFrame("Sending report...");){
                    try {
                        IcyExceptionHandler.report(ErrorReportFrame.this.panel.getReportMessage());
                    }
                    catch (BadLocationException ex) {
                        System.err.println("Error while reporting error :");
                        IcyExceptionHandler.showErrorMessage(ex, true);
                        progressFrame.close();
                    }
                }
            }
        };
        this.mainPanel.add((Component)this.panel, "Center");
        this.addToDesktopPane();
        this.setSize(new Dimension(640, 450));
        this.setVisible(true);
        this.requestFocus();
        this.center();
    }

    public String getReportMessage() throws BadLocationException {
        return this.panel.getReportMessage();
    }

    public void setReportAction(ActionListener action) {
        this.reportAction = action;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.panel.reportButton && this.reportAction != null) {
            this.reportAction.actionPerformed(e);
        }
        this.close();
    }
}

