/*
 * Decompiled with CFR 0.152.
 */
package plugins.fab.spotDetector.detector.wavelets.UDWT;

import java.util.ArrayList;
import plugins.fab.spotDetector.detector.UDWTScale;
import plugins.fab.spotDetector.detector.wavelets.UDWT.WaveletConfigException;

public class B3SplineUDWT {
    public int computeMaximumScale(int width, int height, int depth) {
        int minSize = width;
        if (height < minSize) {
            minSize = height;
        }
        if (depth < minSize) {
            minSize = depth;
        }
        if (minSize < 5) {
            return 0;
        }
        int maxScale = 1;
        while (5.0 + (Math.pow(2.0, maxScale + 1 - 1) - 1.0) * 4.0 < (double)minSize) {
            ++maxScale;
        }
        return maxScale;
    }

    public int computeMaximumScale2D(int width, int height) {
        int minSize = width;
        if (height < minSize) {
            minSize = height;
        }
        if (minSize < 5) {
            return 0;
        }
        int maxScale = 1;
        while (5.0 + Math.pow(2.0, maxScale + 1 - 1) * 4.0 < (double)minSize) {
            ++maxScale;
        }
        return maxScale;
    }

    public boolean isNumberOfScaleOkForImage2D(int width, int height, int numScales) {
        int minSize = this.getMinSize(numScales);
        return width >= minSize && height >= minSize;
    }

    public boolean isNumberOfScaleOkForImage3D(int width, int height, int depth, int numScales) {
        int minSize = this.getMinSize(numScales);
        return width >= minSize && height >= minSize && depth >= minSize;
    }

    public int getMinSize(int numScales) {
        return 5 + (int)Math.pow(2.0, numScales - 1) * 4;
    }

    private void checkImageDimensions(int width, int height, int depth, int numScales) throws WaveletConfigException {
        int minSize = this.getMinSize(numScales);
        if (width < minSize || height < minSize || depth < minSize) {
            String message = "Number of scales too large for the size of the image. These settings require: width>" + (minSize - 1) + ", height >" + (minSize - 1) + " and depth >" + (minSize - 1);
            throw new WaveletConfigException(message);
        }
    }

    private void checkImageDimensions2D(int width, int height, int numScales) throws WaveletConfigException {
        int minSize = 5 + (int)(Math.pow(2.0, numScales - 1) - 1.0) * 4;
        if (width < minSize || height < minSize) {
            String message = "Number of scales too large for the size of the image. These settings require: width>" + (minSize - 1) + ", height >" + (minSize - 1);
            throw new WaveletConfigException(message);
        }
    }

    public float[][][] b3WaveletCoefficients3D(float[][][] scaleCoefficients, float[][] originalImage, int numScales, int numPixels, int depth) {
        int z;
        float[][][] waveletCoefficients = new float[numScales + 1][depth][];
        float[][] iterPrev = originalImage;
        for (int j = 0; j < numScales; ++j) {
            for (z = 0; z < depth; ++z) {
                float[] iterCurrent = scaleCoefficients[j][z];
                float[] wCoefficients = new float[numPixels];
                for (int i = 0; i < numPixels; ++i) {
                    wCoefficients[i] = iterPrev[z][i] - iterCurrent[i];
                }
                waveletCoefficients[j][z] = wCoefficients;
                iterPrev[z] = iterCurrent;
            }
        }
        for (z = 0; z < depth; ++z) {
            waveletCoefficients[numScales][z] = new float[numPixels];
            System.arraycopy(scaleCoefficients[numScales - 1][z], 0, waveletCoefficients[numScales][z], 0, numPixels);
        }
        return waveletCoefficients;
    }

    public void b3WaveletReconstruction3D(double[][][] inputCoefficients, double[][] lowPassResidual, double[][] output, int numScales, int numPixels, int depth) {
        for (int z = 0; z < depth; ++z) {
            for (int i = 0; i < numPixels; ++i) {
                double v = lowPassResidual[z][i];
                for (int j = 0; j < numScales; ++j) {
                    v += inputCoefficients[j][z][i];
                }
                output[z][i] = v;
            }
        }
    }

    public void b3SpotConstruction3D(float[][][] inputCoefficients, float[][] output, int numScales, int numPixels, int depth, ArrayList<UDWTScale> UDWTScaleArrayList) {
        for (int z = 0; z < depth; ++z) {
            for (int i = 0; i < numPixels; ++i) {
                float v = 0.0f;
                boolean allNotNull = true;
                for (int j = 0; j < numScales; ++j) {
                    if (!UDWTScaleArrayList.get(j).isEnabled()) continue;
                    if (inputCoefficients[j][z][i] == 0.0f) {
                        allNotNull = false;
                    }
                    v += inputCoefficients[j][z][i];
                }
                output[z][i] = allNotNull ? v : 0.0f;
            }
        }
    }

    public float[][] b3WaveletCoefficients2D(float[][] scaleCoefficients, float[] originalImage, int numScales, int numPixels) {
        float[][] waveletCoefficients = new float[numScales + 1][];
        float[] iterPrev = originalImage;
        for (int j = 0; j < numScales; ++j) {
            float[] iterCurrent = scaleCoefficients[j];
            float[] wCoefficients = new float[numPixels];
            for (int i = 0; i < numPixels; ++i) {
                wCoefficients[i] = iterPrev[i] - iterCurrent[i];
            }
            waveletCoefficients[j] = wCoefficients;
            iterPrev = iterCurrent;
        }
        waveletCoefficients[numScales] = new float[numPixels];
        System.arraycopy(scaleCoefficients[numScales - 1], 0, waveletCoefficients[numScales], 0, numPixels);
        return waveletCoefficients;
    }

    public void b3WaveletReconstruction2D(float[][] inputCoefficients, float[] lowPassResidual, float[] output, int numScales, int numVoxels) {
        for (int i = 0; i < numVoxels; ++i) {
            float v = lowPassResidual[i];
            for (int j = 0; j < numScales; ++j) {
                v += inputCoefficients[j][i];
            }
            output[i] = v;
        }
    }

    public void b3SpotConstruction2D(float[][] inputCoefficients, float[] output, int numScales, int numVoxels, ArrayList<UDWTScale> UDWTScaleArrayList) {
        for (int i = 0; i < numVoxels; ++i) {
            boolean allNotNull = true;
            float v = 0.0f;
            for (int j = 0; j < numScales; ++j) {
                if (!UDWTScaleArrayList.get(j).isEnabled()) continue;
                if (inputCoefficients[j][i] == 0.0f) {
                    allNotNull = false;
                }
                v += inputCoefficients[j][i];
            }
            output[i] = allNotNull ? v : 0.0f;
        }
    }

    private void filterAndSwap2D(float[] arrayIn, float[] arrayOut, int width, int height, int stepS) {
        float w2 = 0.0625f;
        float w1 = 0.25f;
        float w0 = 0.375f;
        int w0idx = 0;
        for (int y = 0; y < height; ++y) {
            int cntX;
            int arrayOutIter = 0 + y;
            int w1idx1 = w0idx + stepS - 1;
            int w2idx1 = w1idx1 + stepS;
            int w1idx2 = w0idx + stepS;
            int w2idx2 = w1idx2 + stepS;
            for (cntX = 0; cntX < stepS; ++cntX) {
                arrayOut[arrayOutIter] = w2 * (arrayIn[w2idx1] + arrayIn[w2idx2]) + w1 * (arrayIn[w1idx1] + arrayIn[w1idx2]) + w0 * arrayIn[w0idx];
                --w1idx1;
                --w2idx1;
                ++w1idx2;
                ++w2idx2;
                ++w0idx;
                arrayOutIter += height;
            }
            ++w1idx1;
            while (cntX < 2 * stepS) {
                arrayOut[arrayOutIter] = w2 * (arrayIn[w2idx1] + arrayIn[w2idx2]) + w1 * (arrayIn[w1idx1] + arrayIn[w1idx2]) + w0 * arrayIn[w0idx];
                ++w1idx1;
                --w2idx1;
                ++w1idx2;
                ++w2idx2;
                ++w0idx;
                arrayOutIter += height;
                ++cntX;
            }
            ++w2idx1;
            while (cntX < width - 2 * stepS) {
                arrayOut[arrayOutIter] = w2 * (arrayIn[w2idx1] + arrayIn[w2idx2]) + w1 * (arrayIn[w1idx1] + arrayIn[w1idx2]) + w0 * arrayIn[w0idx];
                ++w1idx1;
                ++w2idx1;
                ++w1idx2;
                ++w2idx2;
                ++w0idx;
                arrayOutIter += height;
                ++cntX;
            }
            --w2idx2;
            while (cntX < width - stepS) {
                arrayOut[arrayOutIter] = w2 * (arrayIn[w2idx1] + arrayIn[w2idx2]) + w1 * (arrayIn[w1idx1] + arrayIn[w1idx2]) + w0 * arrayIn[w0idx];
                ++w1idx1;
                ++w2idx1;
                ++w1idx2;
                --w2idx2;
                ++w0idx;
                arrayOutIter += height;
                ++cntX;
            }
            --w1idx2;
            while (cntX < width) {
                arrayOut[arrayOutIter] = w2 * (arrayIn[w2idx1] + arrayIn[w2idx2]) + w1 * (arrayIn[w1idx1] + arrayIn[w1idx2]) + w0 * arrayIn[w0idx];
                ++w1idx1;
                ++w2idx1;
                --w1idx2;
                --w2idx2;
                ++w0idx;
                arrayOutIter += height;
                ++cntX;
            }
        }
    }

    public float[][] b3WaveletScales2D(float[] dataIn, int width, int height, int numScales) throws WaveletConfigException {
        if (numScales < 1) {
            throw new WaveletConfigException("Invalid number of wavelet scales. Number of scales should be an integer >=1");
        }
        this.checkImageDimensions2D(width, height, numScales);
        int wh = width * height;
        float[][] resArray = new float[numScales][];
        float[] prevArray = dataIn;
        float[] currentArray = new float[wh];
        for (int s = 1; s <= numScales; ++s) {
            float[] tmp;
            int stepS = (int)Math.pow(2.0, s - 1);
            this.filterAndSwap2D(prevArray, currentArray, width, height, stepS);
            if (s == 1) {
                prevArray = currentArray;
                currentArray = new float[wh];
            } else {
                tmp = currentArray;
                currentArray = prevArray;
                prevArray = tmp;
            }
            this.filterAndSwap2D(prevArray, currentArray, height, width, stepS);
            tmp = currentArray;
            currentArray = prevArray;
            prevArray = tmp;
            resArray[s - 1] = new float[wh];
            System.arraycopy(prevArray, 0, resArray[s - 1], 0, wh);
        }
        return resArray;
    }

    private void filterZdirection(float[][] arrayIn, float[][] arrayOut, int width, int height, int depth, int stepS) {
        float w2 = 0.0625f;
        float w1 = 0.25f;
        float w0 = 0.375f;
        float[] bufferArrayIn = new float[depth];
        float[] bufferArrayOut = new float[depth];
        for (int i = 0; i < width * height; ++i) {
            int cntZ;
            for (int z = 0; z < depth; ++z) {
                bufferArrayIn[z] = arrayIn[z][i];
            }
            int arrayOutIter = 0;
            int w0idx = 0;
            int w1idx1 = w0idx + stepS - 1;
            int w2idx1 = w1idx1 + stepS;
            int w1idx2 = w0idx + stepS;
            int w2idx2 = w1idx2 + stepS;
            for (cntZ = 0; cntZ < stepS; ++cntZ) {
                bufferArrayOut[arrayOutIter] = w2 * (bufferArrayIn[w2idx1] + bufferArrayIn[w2idx2]) + w1 * (bufferArrayIn[w1idx1] + bufferArrayIn[w1idx2]) + w0 * bufferArrayIn[w0idx];
                --w1idx1;
                --w2idx1;
                ++w1idx2;
                ++w2idx2;
                ++w0idx;
                ++arrayOutIter;
            }
            ++w1idx1;
            while (cntZ < 2 * stepS) {
                bufferArrayOut[arrayOutIter] = w2 * (bufferArrayIn[w2idx1] + bufferArrayIn[w2idx2]) + w1 * (bufferArrayIn[w1idx1] + bufferArrayIn[w1idx2]) + w0 * bufferArrayIn[w0idx];
                ++w1idx1;
                --w2idx1;
                ++w1idx2;
                ++w2idx2;
                ++w0idx;
                ++arrayOutIter;
                ++cntZ;
            }
            ++w2idx1;
            while (cntZ < depth - 2 * stepS) {
                bufferArrayOut[arrayOutIter] = w2 * (bufferArrayIn[w2idx1] + bufferArrayIn[w2idx2]) + w1 * (bufferArrayIn[w1idx1] + bufferArrayIn[w1idx2]) + w0 * bufferArrayIn[w0idx];
                ++w1idx1;
                ++w2idx1;
                ++w1idx2;
                ++w2idx2;
                ++w0idx;
                ++arrayOutIter;
                ++cntZ;
            }
            --w2idx2;
            while (cntZ < depth - stepS) {
                bufferArrayOut[arrayOutIter] = w2 * (bufferArrayIn[w2idx1] + bufferArrayIn[w2idx2]) + w1 * (bufferArrayIn[w1idx1] + bufferArrayIn[w1idx2]) + w0 * bufferArrayIn[w0idx];
                ++w1idx1;
                ++w2idx1;
                ++w1idx2;
                --w2idx2;
                ++w0idx;
                ++arrayOutIter;
                ++cntZ;
            }
            --w1idx2;
            while (cntZ < depth) {
                bufferArrayOut[arrayOutIter] = w2 * (bufferArrayIn[w2idx1] + bufferArrayIn[w2idx2]) + w1 * (bufferArrayIn[w1idx1] + bufferArrayIn[w1idx2]) + w0 * bufferArrayIn[w0idx];
                ++w1idx1;
                ++w2idx1;
                --w1idx2;
                --w2idx2;
                ++w0idx;
                ++arrayOutIter;
                ++cntZ;
            }
            for (int z = 0; z < depth; ++z) {
                arrayOut[z][i] = bufferArrayOut[z];
            }
        }
    }

    public float[][][] b3WaveletScales3D(float[][] dataIn, int width, int height, int depth, int numScales) throws WaveletConfigException {
        if (numScales < 1) {
            throw new WaveletConfigException("Invalid number of wavelet scales. Number of scales should be an integer >=1");
        }
        this.checkImageDimensions(width, height, depth, numScales);
        int wh = width * height;
        float[][][] resArray = new float[numScales][][];
        float[][] currentArray3D = dataIn;
        for (int s = 1; s <= numScales; ++s) {
            float[][] prevArray = new float[depth][];
            int stepS = (int)Math.pow(2.0, s - 1);
            for (int z = 0; z < depth; ++z) {
                prevArray[z] = currentArray3D[z];
                float[] currentArray = new float[wh];
                this.filterAndSwap2D(prevArray[z], currentArray, width, height, stepS);
                prevArray[z] = currentArray;
                currentArray = new float[wh];
                this.filterAndSwap2D(prevArray[z], currentArray, height, width, stepS);
                prevArray[z] = currentArray;
            }
            currentArray3D = new float[depth][wh];
            this.filterZdirection(prevArray, currentArray3D, width, height, depth, stepS);
            resArray[s - 1] = currentArray3D;
        }
        return resArray;
    }
}

