// This macro converts a 16x16 8-bit image to a tool macro icon
// string. Ideally, the image should have no more than 16 colors.
// Includes seven examples that, with the exception of the 
// "Lena Tool", were created by converting website favicons
// (http://en.wikipedia.org/wiki/Favicon).

macro "Convert Image to Tool Icon..." {
  if (bitDepth!=8 || getWidth>16 || getHeight>16)
     exit("This macro requires 16x16 8-bit image");
  Dialog.create("Image 2 Tool");
  Dialog.addString("Tool name", "myTool");
  Dialog.addCheckbox("Transparent Color", true);
  Dialog.addNumber("Value", 0);
  Dialog.show();
  mytool = Dialog.getString();
  allPixels = !Dialog.getCheckbox();
  transparent = Dialog.getNumber();
  getLut(r,g,b);
  getRawStatistics(area, mean, min, max);
  ts='macro "'+mytool+' Tool - ';
  for (i=0; i<=max; i++) {
      if (allPixels || i!=transparent) {
          r2=floor(r[i]/256*16);
          g2=floor(g[i]/256*16);
          b2=floor(b[i]/256*16);
          color = "C"+toHex(r2)+toHex(g2)+toHex(b2);
          if (!endsWith(ts, color)) ts=ts+color;
          for (x=0; x<getWidth; x++) {
              for (y=0; y<getHeight; y++) {
                  if (getPixel(x,y)==i)
                      ts=ts+"D"+toHex(x)+toHex(y);
              }
          }
      }
  }
  ts=ts+'"{\n\n}';
  macrodir = getDirectory("macros");
  if (!endsWith(mytool,".txt")) mytool = mytool+".txt";
  f = File.open(macrodir+mytool);
  print (f, ts);
  File.close(f);
  open(macrodir+mytool);
}

// Examples

macro "Lena Tool - C313DceDcfDdcDddDdeDdfDeaDebDecDedDeeDf3Df4Df7Df8Df9DfaCc77D35D3fD41D44D45D50D55D64D69D6dD76DafDbdDc4Dc6DcaCb55D04D0fD1fD2fD6eD72D73D74D79D88D89D9aD9bD9eDdaDe6De7Cd99D10D11D56D60D65D95D9cDabDb5Db6Db7Db8Db9DbaDd3Dd4C634D13D22D33D43D61D62D63D71Db3Dc2De9Df1Df2DfdDfeDffCd87D16D17D29D39D3aD3bD4aD4bD4cD5aD5bD5cD67D68D6bD77D7fD96D97Dc7Cc66D05D06D14D31D34D51D75D78D83D84D85D99Dc5Dd6Dd8Dd9CdbaD00D01D03D12D20D30D90D9dDa1Da9DaaDadDb1Db2Dc1C413D23D32D42D52Dc3Dd2De2De3De4DefDf0Df5Df6DfbDfcCd77D15D18D19D25D2aD2bD2cD3cD3eD4dD5dD6cD7cD7dDbcDc8Dc9Cd65D07D09D0aD0bD0cD0dD0eD1dD1eD5fD6fD7aD7bD87D8bCe99D26D27D36D37D38D46D47D48D57D70D80D81D8dD8fD91D94D9fCa45D24D40D4eD5eD7eD8eDaeDb4DbfDcdDd1Dd5DdbDe1De5De8Cd98D28D49D58D59D66D8cD92D93DbbDe0Cd66D08D1aD1bD1cD2dD2eD3dD4fD6aD82D86D8aD98DbeDcbDccDd7CedcD02D21D53D54Da0Da2Da3Da4Da5Da6Da7Da8DacDb0Dc0Dd0"{
}

macro "Home Tool - Cff9Cff0D27D36D45D54D63D72D7aD7bD7cD7dD82D8aD8bD8cD8dD93Da4Db5Dc6Dd7Cfc0Cf90Cf06Cf00Dc2Dc3Dc4CfffCeeeCdddCcccCc90CcccCbbbC960C900C888C888C666C000D17D26D28D29D2aD2bD2cD2dD2eD35D37D3eD44D46D4eD53D55D5eD62D64D69D6aD6bD6cD6dD6eD71D73D79D7eD81D83D89D8eD92D94D99D9aD9bD9cD9dD9eDa3Da5DaeDb1Db2Db3Db4Db6DbeDc1Dc5Dc7DceDd1Dd2Dd3Dd4Dd5Dd6Dd8Dd9DdaDdbDdcDddDdeDe7"{
}

macro "Mac Tool - C999D00D01D02D03D04D05D06D07D08D09D0aD0bD0cD0dD0eD0fD10D11D12D13D14D15D16D17D18D19D1aD1bD1cD1dD1eD1fD20D21D22D23D24D26D2aD2cD2dD2eD2fD30D31D32D33D34D3cD3dD3eD3fD40D41D42D43D4eD4fD50D51D52D5eD5fD60D61D62D6fD70D71D7eD7fD80D81D8fD9fDa3DafDb0Db1Db3DbeDbfDc0Dc1Dc2Dc3Dc4Dc9DceDcfDd0Dd1Dd2Dd3Dd4Dd5Dd6Dd7Dd8Dd9DdbDdcDddDdeDdfDe0De1De2De3De4De5De6De7De8De9DeaDebDecDedDeeDefDf0Df1Df2Df3Df4Df5Df6Df7Df8Df9DfaDfbDfcDfdDfeDffCfffD37D38D39D46D47D48D49D4aD4bD55D56D57D58D59D5aD5bD5cD65D66D67D68D69D6aD6bD6cD6dD75D76D77D78D79D7aD7bD7cD83D85D86D87D88D89D8aD8bD8cD92D95D96D97D98D99D9aD9bD9cDa5Da6Da7Da8Da9DaaDabDacDadDb5Db6DbaDbbDbcC999D25D2bD53D63D72D8eD90Da0Db2Dc7Dc8DcdCcccD54D64D82D94Da2Da4Db7Db8DbdDc5CaaaD28D29D6eD9eDaeDdaCeeeD36D4cD93Db9DcbCbbbD35D74Da1Dc6CaaaD27D44D4dD73CfffD45D5dD9dCeeeD3aD7dDcaCbbbDb4DccCdddD84D8dCcccD3bD91"{
}

macro "Cube Tool - CfffCfc9D25D26D27D28D29D2aD2bD34D36D37D38D39D3aD3bD3cD44D46D47D48D49D4aD4bD4cD53D54D55D57D58D59D5aD5bD5cD5dD63D64D65D67D68D69D6aD6bD6cD6dD73D74D75D76D83D84D85D93D94D95Da4Db4C000D15D16D17D18D19D1aD1bD24D2cD33D35D3dD43D45D4dD52D56D5eD62D66D6eD72D77D78D79D7aD7bD7cD7dD7eD82D86D8eD92D96D9eDa3Da5DadDb3Db5DbdDc4DccDd5Dd6Dd7Dd8Dd9DdaDdbCc96D87D88D89D8aD8bD8cD8dD97D98D99D9aD9bD9cD9dDa6Da7Da8Da9DaaDabDacDb6Db7Db8Db9DbaDbbDbcDc5Dc6Dc7Dc8Dc9DcaDcbCbbbDaeDbeDcdDceDdcDddDdeDebDecDedDeeDfcDfd"{
}

macro "Man Tool - CfffD47D48D49D56D63D66D67D68D69D6aD6bD6cD6dD6eD72D73D74D76D77D78D79D83D86D87D88D89D8aD8bD8cD8dD8eD96Da7Da8Da9C17eD17D27D37D57Db7Dc7Dd7De7C048D84D94C05bD1fD2fD3fD4fD5fD6fD7fD8fD9fDafDbfDcfDdfDefDf1Df2Df3Df4Df5Df6Df7Df8Df9DfaDfbDfcDfdDfeC39fD01D02D03D04D05D06D07D08D09D0aD0bD0cD0dD0eD10D1eD20D2eD30D3eD40D4eD50D5eD60D70D80D90Da0DaeDb0DbeDc0DceDd0DdeDe0DeeC26aD7eD9eC06dD12D22D32D42D52D62D82D92Da2Db2Dc2Dd2De2C28fD1aD2aD3aD4aDaaDcaDdaDeaC159D59D99Db9C07dD14D24D34D44D54D64Da4Db4Dc4Dd4De4C17dD15D16D25D26D35D36D45D46D55D65D75D95Da5Da6Db5Db6Dc5Dc6Dd5Dd6De5De6C29fD1cD2cD3cD4cD5cDacDbcDccDdcDecC159D7bD9bC159D97C28eD19D29D39Dc9Dd9De9C049D85C28fD1bD2bD3bD4bD5bDabDbbDcbDdbDebC06dD13D23D33D43D53D93Da3Db3Dc3Dd3De3C18eD18D28D38Dc8Dd8De8C159D5aD7aD9aDbaC16aD7cD9cC39fD1dD2dD3dD4dD5dDadDbdDcdDddDedC159D58D98Db8C06cD11D21D31D41D51D61D71D81D91Da1Db1Dc1Dd1De1C16aD7dD9d"{
}

macro "Face Tool - CfffCff0Cf0fCf00C0ffC0f0C00fC000De9C322D01D09D0bD0eD16D17D18D1dD21D26D28D34D36D3aD44D45D5dD6dD7aD9eDadDbcDbdDbeDccDdaDeaDf8DfaC112D07D08D0fD1cD1eD1fD2cD2dD2eD2fD35D39D3bD3cD3dD3eD3fD4dD4eD4fD5eD5fD6aD6bD6fD7bD7fD8bD8fD9fDaeDafDbfDcdDceDcfDdbDdcDddDdeDdfDebDecDedDeeDefDf9DfbDfcDfdDfeDffCcd7D43D57D61D67D74D77D79D88D89D90D99Da0Da9DaaDb1Db3Db5Db9Dc5Dc6Dc7Dc8De1De4De7Df4Cef9D51D52D53D62D63D71D72D73D75D76D81D82D83D86D87D91D92D93D96D97D98Da1Da2Da3Da4Da6Da7Da8Db2Db4Db6Db7Db8Dd8De0Df0Df1Df2Df3Df5Df6Caa6D04D05D10D14D41D42D47D48D56D58D59D64D66D6cD7cD80D8cD8eD94D9aD9cD9dDa5DabDd7De3De6C885D11D13D20D25D65D69D7eD84D85D8dD9bDacDb0DbaDc1Dc4Dc9Dd4Dd6Dd9De2De5De8C664D02D03D0dD12D19D30D40D46D49D50D6eD70D78D7dD8aD95DbbDc0Dc2Dc3Dd2Dd3Df7C443D00D06D0aD0cD15D1aD1bD22D23D24D27D29D2aD2bD31D32D33D37D38D4aD4bD4cD54D55D5aD5bD5cD60D68DcaDcbDd0Dd1Dd5"{
}

macro "20 Tool - C200D84D85D95DacDe9DebDecDf4Df5Df6Df9DfaDfbDfcDfdDfeCc73D1fD25D47D57D5cD7eD92D9bDabDb8DbbDbcDbdDc8DcbDccDd8C953D4eD55D56D68D6fD8eD9eDa4Da5DaaDaeDb7Db9DbaDbeDc5Dc7DcaDcdDd5Dd7DdbDf7C236D00D01D02D03D04D10D11D12D13D20D21D22D30D31D40D41D50D51D52D60D61D62D70D80Db0Dc0Dd0Dd1De2Df3C742D4dD54D7dD7fD83D8fD93D9fDafDbfDc3Dc4DceDcfDd6Dd9DdeDdfDe5De6DeaDedDeeDefCfb5D19D1aD2aD34D38D48D4fD58D59D65D69D6eD72D73D79D82D87D88D91D97D98Da1Da6Da7Db2Db5C235Dc1Dd2C977D0cD0dD0eD0fD18C569D05D06D07D08D09D0bD16D17D71De0De1Df0Df1Df2Cdb5D15D2cD2dD2eD3aD3bD3dD4aD5aD5bD64D6dD76D78D7cD8cDa2C531D86D94D96D9cD9dDadDc2Dc6Dc9Dd3Dd4DdcDe3De4De8Df8DffCb73D2bD5eD6aD74D75D7aD8aD99D9aDa3Da9Db1DdaDddDe7Cd95D1dD1eD2fD35D3fD46D5fD67D7bD89D8bD8dDa8Cb95D0aD14D1bD1cD23D27D3eD4bD4cD5dD63D6bD81Db6Cfd5D24D28D29D33D36D37D39D3cD43D44D45D49D66D6cD77Db3Db4C555D26D32D42D53D90Da0"{
}

