/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.viewer;

import icy.canvas.IcyCanvas;
import icy.gui.component.ColorComponent;
import icy.gui.util.ComponentUtil;
import icy.gui.util.GuiUtil;
import icy.image.IcyBufferedImage;
import icy.math.MathUtil;
import icy.sequence.Sequence;
import icy.type.collection.array.ArrayUtil;
import icy.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MouseImageInfosPanel
extends JPanel {
    private static final long serialVersionUID = -5994107451349072824L;
    private static final int SIGNIFICANT_DIGIT = 5;
    private final JLabel xLabel;
    private final JLabel yLabel;
    private final JLabel zLabel;
    private final JLabel tLabel;
    private final JLabel cLabel;
    private final JLabel dataLabel;
    private final JLabel xValue;
    private final JLabel yValue;
    private final JLabel zValue;
    private final JLabel tValue;
    private final JLabel cValue;
    private final JLabel dataValue;
    private final ColorComponent colorComp = new ColorComponent();
    private boolean infoXVisible = true;
    private boolean infoYVisible = true;
    private boolean infoZVisible = true;
    private boolean infoTVisible = true;
    private boolean infoCVisible = true;
    private boolean infoDataVisible = true;
    private boolean infoColorVisible = true;

    public MouseImageInfosPanel() {
        super(true);
        ComponentUtil.setFixedSize(this.colorComp, new Dimension(30, 14));
        this.xValue = new JLabel();
        ComponentUtil.setFixedWidth(this.xValue, 58);
        this.yValue = new JLabel();
        ComponentUtil.setFixedWidth(this.yValue, 58);
        this.zValue = new JLabel();
        ComponentUtil.setFixedWidth(this.zValue, 40);
        this.tValue = new JLabel();
        ComponentUtil.setFixedWidth(this.tValue, 40);
        this.cValue = new JLabel();
        ComponentUtil.setFixedWidth(this.cValue, 40);
        this.dataValue = new JLabel();
        ComponentUtil.setFixedWidth(this.dataValue, 200);
        this.xLabel = GuiUtil.createBoldLabel(" X  ");
        this.yLabel = GuiUtil.createBoldLabel(" Y  ");
        this.zLabel = GuiUtil.createBoldLabel(" Z  ");
        this.tLabel = GuiUtil.createBoldLabel(" T  ");
        this.cLabel = GuiUtil.createBoldLabel(" C  ");
        this.dataLabel = GuiUtil.createBoldLabel(" Value  ");
        JPanel infosPanel = new JPanel();
        infosPanel.setLayout(new BoxLayout(infosPanel, 2));
        infosPanel.add(this.colorComp);
        infosPanel.add(Box.createHorizontalStrut(10));
        infosPanel.add(this.xLabel);
        infosPanel.add(this.xValue);
        infosPanel.add(this.yLabel);
        infosPanel.add(this.yValue);
        infosPanel.add(this.zLabel);
        infosPanel.add(this.zValue);
        infosPanel.add(this.tLabel);
        infosPanel.add(this.tValue);
        infosPanel.add(this.cLabel);
        infosPanel.add(this.cValue);
        infosPanel.add(this.dataLabel);
        infosPanel.add(this.dataValue);
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.setLayout(new BorderLayout());
        this.add((Component)infosPanel, "West");
        this.add((Component)new JPanel(), "Center");
        this.validate();
        this.updateInfos(null);
    }

    public boolean isInfoXVisible() {
        return this.infoXVisible;
    }

    public void setInfoXVisible(boolean value) {
        if (this.infoXVisible != value) {
            this.infoXVisible = value;
            this.xLabel.setVisible(value);
            this.xValue.setVisible(value);
        }
    }

    public boolean isInfoYVisible() {
        return this.infoYVisible;
    }

    public void setInfoYVisible(boolean value) {
        if (this.infoYVisible != value) {
            this.infoYVisible = value;
            this.yLabel.setVisible(value);
            this.yValue.setVisible(value);
        }
    }

    public boolean isInfoZVisible() {
        return this.infoZVisible;
    }

    public void setInfoZVisible(boolean value) {
        if (this.infoZVisible != value) {
            this.infoZVisible = value;
            this.zLabel.setVisible(value);
            this.zValue.setVisible(value);
        }
    }

    public boolean isInfoTVisible() {
        return this.infoTVisible;
    }

    public void setInfoTVisible(boolean value) {
        if (this.infoTVisible != value) {
            this.infoTVisible = value;
            this.tLabel.setVisible(value);
            this.tValue.setVisible(value);
        }
    }

    public boolean isInfoCVisible() {
        return this.infoCVisible;
    }

    public void setInfoCVisible(boolean value) {
        if (this.infoCVisible != value) {
            this.infoCVisible = value;
            this.cLabel.setVisible(value);
            this.cValue.setVisible(value);
        }
    }

    public boolean isInfoDataVisible() {
        return this.infoDataVisible;
    }

    public void setInfoDataVisible(boolean value) {
        if (this.infoDataVisible != value) {
            this.infoDataVisible = value;
            this.dataLabel.setVisible(value);
            this.dataValue.setVisible(value);
        }
    }

    public boolean isInfoColorVisible() {
        return this.infoColorVisible;
    }

    public void setInfoColorVisible(boolean value) {
        if (this.infoColorVisible != value) {
            this.infoColorVisible = value;
            this.colorComp.setVisible(value);
        }
    }

    public void updateInfos(IcyCanvas canvas) {
        Sequence seq = canvas != null ? canvas.getSequence() : null;
        if (seq != null) {
            double x = canvas.getMouseImagePosX();
            double y = canvas.getMouseImagePosY();
            double z = canvas.getMouseImagePosZ();
            double t = canvas.getMouseImagePosT();
            double c = canvas.getMouseImagePosC();
            int xi = (int)x;
            int yi = (int)y;
            int zi = (int)z;
            int ti = (int)t;
            int ci = (int)c;
            String xs = x == (double)xi ? StringUtil.toString(xi) : StringUtil.toStringEx(x, 5);
            String ys = y == (double)yi ? StringUtil.toString(yi) : StringUtil.toStringEx(y, 5);
            String zs = z == (double)zi ? StringUtil.toString(zi) : StringUtil.toStringEx(z, 5);
            String ts = t == (double)ti ? StringUtil.toString(ti) : StringUtil.toStringEx(t, 5);
            String cs = c == (double)ci ? StringUtil.toString(ci) : StringUtil.toStringEx(c, 5);
            this.xValue.setText(xs);
            this.yValue.setText(ys);
            this.zValue.setText(zs);
            this.tValue.setText(ts);
            this.cValue.setText(cs);
            this.xValue.setToolTipText(this.xValue.getText());
            this.yValue.setToolTipText(this.yValue.getText());
            this.zValue.setToolTipText(this.zValue.getText());
            this.tValue.setToolTipText(this.tValue.getText());
            this.cValue.setToolTipText(this.cValue.getText());
            IcyBufferedImage image = seq.getImage(ti, zi);
            if (image != null && image.isInside(xi, yi)) {
                try {
                    this.colorComp.setColor(image.getRGB(xi, yi, canvas.getLut()));
                    if (ci == -1) {
                        this.dataValue.setText(ArrayUtil.array1DToString(image.getDataCopyC(xi, yi), image.getDataType_().isSigned(), false, " : ", 5));
                    } else {
                        int vi;
                        double v = image.getData(xi, yi, ci);
                        String vs = v == (double)(vi = (int)v) ? Integer.toString(vi) : Double.toString(MathUtil.roundSignificant(v, 5, true));
                        this.dataValue.setText(vs);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.dataValue.setToolTipText(this.dataValue.getText());
            } else {
                this.dataValue.setText("-");
                this.colorComp.setColor(null);
                this.dataValue.setToolTipText(null);
            }
        } else {
            this.xValue.setText("-");
            this.yValue.setText("-");
            this.zValue.setText("-");
            this.tValue.setText("-");
            this.cValue.setText("-");
            this.dataValue.setText("-");
            this.colorComp.setColor(null);
            this.xValue.setToolTipText(null);
            this.yValue.setToolTipText(null);
            this.zValue.setToolTipText(null);
            this.tValue.setToolTipText(null);
            this.cValue.setToolTipText(null);
            this.dataValue.setToolTipText(null);
        }
    }
}

