/*
 * Decompiled with CFR 0.152.
 */
package plugins.nchenouard.particletracking.MHTracker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import plugins.nchenouard.particletracking.MHTracker.Cluster;
import plugins.nchenouard.particletracking.MHTracker.Family;
import plugins.nchenouard.particletracking.MHTracker.GlobalHypothesis;
import plugins.nchenouard.particletracking.MHTracker.HMMMHTracker;
import plugins.nchenouard.particletracking.MHTracker.Hypothesis;
import plugins.nchenouard.particletracking.MHTracker.SolveMLAssociation;

public class ClusterSolveTree
extends Cluster {
    WaitingThreadCounter wtc = new WaitingThreadCounter();
    WaitingList waitingTasks;
    ArrayList<ExecutorThread> executorList = new ArrayList();
    int maxNumThread = 4;
    volatile GlobalHypothesis BH;
    int t;
    final ArrayList<Family> mandatoryFamilies = new ArrayList();
    final ArrayList<Family> optionalFamilies = new ArrayList();

    public ClusterSolveTree(HMMMHTracker tracker, int firstT, int lastT, int K) {
        super(tracker, firstT, lastT, K);
    }

    @Override
    public void buildAndApplyBestHypTree(int t2) {
        this.t = t2;
        int firstTtemp = -1;
        boolean buildAndApplyBestHyp = false;
        for (Integer i : this.concurrentFamilies.keySet()) {
            if (firstTtemp >= 0 && i >= firstTtemp) continue;
            firstTtemp = i;
        }
        buildAndApplyBestHyp = firstTtemp >= 0 && firstTtemp <= this.t - this.K;
        GlobalHypothesis test = null;
        int firstT = firstTtemp;
        if (buildAndApplyBestHyp) {
            TaskList tskList;
            GlobalHypothesis gh;
            boolean lastFamily;
            Family f;
            int familyIdx;
            this.println("-----build best Hyp");
            this.println("different root time for families " + this.concurrentFamilies.size());
            this.println("firstT " + firstT + " first time " + firstT + "  time " + this.t);
            for (Map.Entry e : this.concurrentFamilies.entrySet()) {
                this.println("time " + (Integer)e.getKey() + "numFamily " + ((ArrayList)e.getValue()).size());
            }
            int currentT = firstT;
            ArrayList fList = (ArrayList)this.concurrentFamilies.get(new Integer(currentT));
            this.mandatoryFamilies.clear();
            this.optionalFamilies.clear();
            for (Family f2 : fList) {
                if (f2.rootTrack == null) {
                    this.optionalFamilies.add(f2);
                    continue;
                }
                this.mandatoryFamilies.add(f2);
                this.println("mandatory family : begin = " + f2.rootTrack.associations.getFirst().t + " root time " + f2.rootTime);
            }
            this.println("mFamilies " + this.mandatoryFamilies.size() + " oFamilies " + this.optionalFamilies.size());
            SolveMLAssociation mlSolver = new SolveMLAssociation();
            long ml1 = System.currentTimeMillis();
            mlSolver.solve(firstT, this.t, this.concurrentFamilies, this.mandatoryFamilies, this.optionalFamilies);
            test = this.BH = mlSolver.getHypothesis(this, firstT, this.t, this.tracker);
            if (this.BH == null) {
                System.out.println("BH NULL, ML failed");
            }
            this.waitingTasks = new WaitingList();
            long ml2 = System.currentTimeMillis();
            HMMMHTracker.MLFormationTime += ml2 - ml1;
            if (this.mandatoryFamilies.size() > 0) {
                familyIdx = 0;
                f = this.mandatoryFamilies.get(familyIdx);
                lastFamily = familyIdx == this.mandatoryFamilies.size() - 1;
                gh = new GlobalHypothesis(firstT, this.t, this.tracker);
                tskList = new TaskList();
                for (Hypothesis htemp : f.hypotheses) {
                    tskList.addLast(new RecursHypTreeMandatoryTask(gh, htemp, currentT, familyIdx, lastFamily));
                }
                this.waitingTasks.insertAtStart(tskList);
            } else if (this.optionalFamilies.size() > 0) {
                TaskList tskList2;
                familyIdx = 0;
                f = this.optionalFamilies.get(0);
                lastFamily = 0 == this.optionalFamilies.size() - 1;
                gh = new GlobalHypothesis(firstT, this.t, this.tracker);
                tskList = new TaskList();
                for (Hypothesis htemp : f.hypotheses) {
                    tskList.addLast(new RecursHypTreeTask(gh, htemp, currentT, 0, lastFamily));
                }
                this.waitingTasks.insertAtStart(tskList);
                if (lastFamily) {
                    if (currentT < this.t) {
                        this.penalizeFD(gh, currentT);
                        this.penalizeNT(gh, currentT);
                        if (gh.score > this.BH.score && (tskList2 = this.recursBuildBestGlobalHypTree(gh, 0, currentT + 1)) != null) {
                            this.waitingTasks.insertAtStart(tskList2);
                        }
                    }
                } else {
                    tskList2 = this.recursBuildBestGlobalHypTree(gh, 1, currentT);
                    if (tskList2 != null) {
                        this.waitingTasks.insertAtStart(tskList2);
                    }
                }
            }
            for (int i = 0; i < this.maxNumThread; ++i) {
                this.executorList.add(new ExecutorThread());
            }
            for (ExecutorThread exe : this.executorList) {
                exe.start();
            }
            this.wtc.cntLock.lock();
            try {
                while (this.wtc.someRunning()) {
                    this.wtc.countWainting.await();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.wtc.cntLock.unlock();
            for (ExecutorThread e : this.executorList) {
                e.run = false;
            }
            this.waitingTasks.lock.lock();
            this.waitingTasks.emptyCondition.signalAll();
            this.waitingTasks.lock.unlock();
            for (ExecutorThread e : this.executorList) {
                try {
                    e.join();
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
            this.executorList.clear();
        } else {
            this.println("no need to build hyp");
        }
        if (test != null && test.score != this.BH.score && !(test.score < this.BH.score)) {
            System.out.println("decrease!");
            System.out.println(test.score + " | " + this.BH.score);
        }
        this.bestHypSafe.bestHyp = this.BH;
        this.applyBestHyp(this.t);
        for (Collection c : this.concurrentFamilies.values()) {
            for (Family f : c) {
                f.hypotheses.clear();
            }
        }
    }

    protected TaskList recursBuildBestGlobalHypTree(GlobalHypothesis ghPrev, int familyIdx, int currentT) {
        ArrayList fList = null;
        fList = currentT == this.firstTime ? this.optionalFamilies : (ArrayList)this.concurrentFamilies.get(currentT);
        if (fList != null && !fList.isEmpty()) {
            Family f = (Family)fList.get(familyIdx);
            boolean lastFamily = familyIdx == fList.size() - 1;
            double bestScore = this.BH.score;
            ArrayList<Hypothesis> compatibleHypothesis = f.getCompatibleHypothesisSingleThread(ghPrev, bestScore);
            TaskList tasks = new TaskList();
            for (Hypothesis htemp : compatibleHypothesis) {
                tasks.addLast(new RecursHypTreeTask(ghPrev, htemp, currentT, familyIdx, lastFamily));
            }
            return tasks;
        }
        if (currentT < this.t) {
            GlobalHypothesis ghCopy = ghPrev.copy();
            this.penalizeFD(ghCopy, currentT);
            this.penalizeNT(ghCopy, currentT);
            return this.recursBuildBestGlobalHypTree(ghCopy, 0, currentT + 1);
        }
        return null;
    }

    protected TaskList recursBuildBestGlobalHypWithMandatoryFamiliesTree(GlobalHypothesis ghPrev, int familyIdx, int currentT) {
        Family f = this.mandatoryFamilies.get(familyIdx);
        boolean lastFamily = familyIdx == this.mandatoryFamilies.size() - 1;
        double bestScore = this.BH.score;
        ArrayList<Hypothesis> compatibleHypothesis = f.getCompatibleHypothesisSingleThread(ghPrev, bestScore);
        TaskList tskList = new TaskList();
        for (Hypothesis htemp : compatibleHypothesis) {
            tskList.addLast(new RecursHypTreeMandatoryTask(ghPrev, htemp, currentT, familyIdx, lastFamily));
        }
        return tskList;
    }

    class WaitingList
    extends TaskList {
        public Lock lock;
        public final Condition emptyCondition;

        WaitingList() {
            this.lock = new ReentrantLock();
            this.emptyCondition = this.lock.newCondition();
        }

        @Override
        public void insertAtStart(TaskList tList) {
            if (tList != null && !tList.isEmpty) {
                this.lock.lock();
                super.insertAtStart(tList);
                this.emptyCondition.signalAll();
                this.lock.unlock();
            }
        }

        @Override
        public void addLast(TLinked t) {
            this.lock.lock();
            super.addLast(t);
            this.emptyCondition.signalAll();
            this.lock.unlock();
        }

        @Override
        public void addLast(Task t) {
            this.lock.lock();
            super.addLast(t);
            this.emptyCondition.signalAll();
            this.lock.unlock();
        }

        @Override
        public void addFirst(TLinked t) {
            this.lock.lock();
            super.addFirst(t);
            this.emptyCondition.signalAll();
            this.lock.unlock();
        }

        @Override
        public void addFirst(Task t) {
            this.lock.lock();
            super.addFirst(t);
            this.emptyCondition.signalAll();
            this.lock.unlock();
        }

        @Override
        public Task popTask() {
            this.lock.lock();
            Task tsk = super.popTask();
            this.lock.unlock();
            return tsk;
        }
    }

    class RecursHypTreeMandatoryTask
    implements Task {
        final boolean lastFamily;
        final GlobalHypothesis gh;
        final int currentT;
        final int familyIdx;

        public RecursHypTreeMandatoryTask(GlobalHypothesis ghPrev, Hypothesis hyp, int currentT, int familyIdx, boolean lastFamily) {
            this.gh = ghPrev.copy();
            this.gh.addHypothesis(hyp);
            this.lastFamily = lastFamily;
            this.currentT = currentT;
            this.familyIdx = familyIdx;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TaskList run() {
            TaskList tskList = null;
            if (this.lastFamily) {
                GlobalHypothesis ghCopy = this.gh.copy();
                for (int time = this.currentT; time <= ClusterSolveTree.this.t; ++time) {
                    ClusterSolveTree.this.penalizeFD(ghCopy, time);
                    ClusterSolveTree.this.penalizeNT(ghCopy, time);
                }
                GlobalHypothesis globalHypothesis = ClusterSolveTree.this.BH;
                synchronized (globalHypothesis) {
                    if (ghCopy.score > ClusterSolveTree.this.BH.score) {
                        ClusterSolveTree.this.BH = ghCopy;
                    }
                }
                if (this.gh.realAssociations.size() < ClusterSolveTree.this.realAssociations.size()) {
                    int currentTimeFD = ClusterSolveTree.this.getRealSpotsNum(this.currentT) - this.gh.getRealSpotsNumAtT(this.currentT);
                    if (currentTimeFD > 0 && ClusterSolveTree.this.optionalFamilies.size() > 0) {
                        tskList = ClusterSolveTree.this.recursBuildBestGlobalHypTree(this.gh, 0, this.currentT);
                    } else if (this.currentT < ClusterSolveTree.this.t) {
                        ClusterSolveTree.this.penalizeFD(this.gh, currentTimeFD, this.currentT);
                        ClusterSolveTree.this.penalizeNT(this.gh, this.currentT);
                        if (this.gh.score > ClusterSolveTree.this.BH.score) {
                            tskList = ClusterSolveTree.this.recursBuildBestGlobalHypTree(this.gh, 0, this.currentT + 1);
                        }
                    }
                }
            } else {
                tskList = ClusterSolveTree.this.recursBuildBestGlobalHypWithMandatoryFamiliesTree(this.gh, this.familyIdx + 1, this.currentT);
            }
            return tskList;
        }
    }

    class RecursHypTreeTask
    implements Task {
        final GlobalHypothesis gh;
        final int currentT;
        final boolean lastFamily;
        final int familyIdx;

        public RecursHypTreeTask(GlobalHypothesis ghPrev, Hypothesis hyp, int currentT, int familyIdx, boolean lastFamily) {
            this.gh = ghPrev.copy();
            this.gh.addHypothesis(hyp);
            this.currentT = currentT;
            this.lastFamily = lastFamily;
            this.familyIdx = familyIdx;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TaskList run() {
            TaskList tskList = null;
            GlobalHypothesis ghCopy = this.gh.copy();
            for (int time = this.currentT; time <= ClusterSolveTree.this.t; ++time) {
                ClusterSolveTree.this.penalizeFD(ghCopy, time);
                ClusterSolveTree.this.penalizeNT(ghCopy, time);
            }
            GlobalHypothesis globalHypothesis = ClusterSolveTree.this.BH;
            synchronized (globalHypothesis) {
                if (ghCopy.score > ClusterSolveTree.this.BH.score) {
                    ClusterSolveTree.this.BH = ghCopy;
                }
            }
            if (this.gh.realAssociations.size() < ClusterSolveTree.this.realAssociations.size()) {
                int currentTimeFD = ClusterSolveTree.this.getRealSpotsNum(this.currentT) - this.gh.getRealSpotsNumAtT(this.currentT);
                if (!this.lastFamily && currentTimeFD > 0) {
                    tskList = ClusterSolveTree.this.recursBuildBestGlobalHypTree(this.gh, this.familyIdx + 1, this.currentT);
                } else if (this.currentT < ClusterSolveTree.this.t) {
                    ClusterSolveTree.this.penalizeFD(this.gh, currentTimeFD, this.currentT);
                    ClusterSolveTree.this.penalizeNT(this.gh, this.currentT);
                    if (this.gh.score > ClusterSolveTree.this.BH.score) {
                        tskList = ClusterSolveTree.this.recursBuildBestGlobalHypTree(this.gh, 0, this.currentT + 1);
                    }
                }
            }
            return tskList;
        }
    }

    class TaskList {
        boolean isEmpty = true;
        TLinked firstT = null;
        TLinked lastT = null;

        public TaskList() {
        }

        public TaskList(TLinked t) {
            if (t != null && t.t != null) {
                this.isEmpty = false;
                this.firstT = t;
                this.lastT = t;
                t.nextT = null;
            }
        }

        public void addLast(TLinked t) {
            if (t != null && t.t != null) {
                if (this.isEmpty) {
                    this.firstT = t;
                    this.lastT = t;
                    this.isEmpty = false;
                } else {
                    this.lastT.nextT = t;
                    this.lastT = t;
                }
                t.nextT = null;
            }
        }

        public void addLast(Task task) {
            if (task != null) {
                TLinked t = new TLinked(task);
                this.addLast(t);
            }
        }

        public void addFirst(TLinked t) {
            if (t != null && t.t != null) {
                if (this.isEmpty) {
                    this.firstT = t;
                    this.lastT = t;
                    t.nextT = null;
                    this.isEmpty = false;
                } else {
                    t.nextT = this.firstT;
                    this.firstT = t;
                }
            }
        }

        public void addFirst(Task task) {
            if (task != null) {
                TLinked t = new TLinked(task);
                this.addFirst(t);
            }
        }

        public void insertAtStart(TaskList tList) {
            if (!tList.isEmpty) {
                if (this.isEmpty) {
                    this.firstT = tList.firstT;
                    this.lastT = tList.lastT;
                    this.isEmpty = false;
                } else {
                    tList.lastT.nextT = this.firstT;
                    this.firstT = tList.firstT;
                }
            }
        }

        public Task popTask() {
            Task t = this.firstT.t;
            this.firstT = this.firstT.nextT;
            if (this.firstT == null) {
                if (this.lastT.t != t) {
                    if (this.lastT == null) {
                        System.out.println("ERROR lastT null");
                    } else {
                        System.out.println("ERROR ");
                    }
                }
                this.lastT = null;
                this.isEmpty = true;
            }
            return t;
        }
    }

    class TLinked {
        Task t;
        TLinked nextT = null;

        TLinked(Task t) {
            this.t = t;
        }
    }

    static interface Task {
        public TaskList run();
    }

    class ExecutorThread
    extends Thread {
        public boolean run = true;

        public ExecutorThread() {
            this.setPriority(10);
        }

        @Override
        public void run() {
            Task tsk = this.getTask();
            while (this.run) {
                TaskList taskList = tsk.run();
                if (taskList == null || taskList.isEmpty) {
                    tsk = this.getTask();
                    continue;
                }
                tsk = taskList.popTask();
                ClusterSolveTree.this.waitingTasks.insertAtStart(taskList);
            }
        }

        private Task getTask() {
            ClusterSolveTree.this.waitingTasks.lock.lock();
            if (ClusterSolveTree.this.waitingTasks.isEmpty) {
                ClusterSolveTree.this.wtc.increaseCount();
                while (ClusterSolveTree.this.waitingTasks.isEmpty && this.run) {
                    try {
                        ClusterSolveTree.this.waitingTasks.emptyCondition.await();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                ClusterSolveTree.this.wtc.decreaseCount();
                if (!this.run) {
                    ClusterSolveTree.this.waitingTasks.lock.unlock();
                    return null;
                }
            }
            Task tsk = ClusterSolveTree.this.waitingTasks.popTask();
            ClusterSolveTree.this.waitingTasks.lock.unlock();
            return tsk;
        }
    }

    public class WaitingThreadCounter {
        public Lock cntLock = new ReentrantLock();
        public final Condition countWainting = this.cntLock.newCondition();
        int cntThreads = 0;

        public void increaseCount() {
            this.cntLock.lock();
            ++this.cntThreads;
            if (this.cntThreads == ClusterSolveTree.this.maxNumThread && ClusterSolveTree.this.waitingTasks.isEmpty) {
                this.countWainting.signalAll();
            }
            this.cntLock.unlock();
        }

        public void decreaseCount() {
            this.cntLock.lock();
            --this.cntThreads;
            this.cntLock.unlock();
        }

        public void reset() {
            this.cntLock.lock();
            this.cntThreads = 0;
            this.cntLock.unlock();
        }

        public boolean someRunning() {
            boolean someRunning = true;
            this.cntLock.lock();
            someRunning = this.cntThreads != ClusterSolveTree.this.maxNumThread;
            this.cntLock.unlock();
            return someRunning;
        }
    }
}

