/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.image.filtering.selection;

import icy.image.IcyBufferedImage;
import icy.sequence.Sequence;
import icy.system.thread.Processor;
import icy.type.DataType;
import icy.type.collection.array.Array1DUtil;
import icy.util.OMEUtil;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import ome.xml.meta.MetadataRetrieve;
import plugins.kernel.image.filtering.selection.SelectionFilter;

public abstract class ThreadedSelectionFilter
implements SelectionFilter {
    private static final Processor service = new Processor(Runtime.getRuntime().availableProcessors());

    static {
        service.setThreadName("ThreadedFilter");
    }

    /*
     * Could not resolve type clashes
     */
    @Override
    public Sequence processSequence(Sequence sequence, int ... radius) throws RuntimeException, InterruptedException {
        int kHeight;
        Sequence out = new Sequence(OMEUtil.createOMEXMLMetadata((MetadataRetrieve)sequence.getOMEXMLMetadata(), true));
        out.setName(String.valueOf(sequence.getName()) + "_" + this.getFilterName());
        if (radius.length == 0) {
            throw new IllegalArgumentException("Provide at least one filter radius");
        }
        final int width = sequence.getSizeX();
        int height = sequence.getSizeY();
        int depth = sequence.getSizeZ();
        int channels = sequence.getSizeC();
        final DataType type = sequence.getDataType_();
        final boolean signed = sequence.isSignedDataType();
        final int kWidth = radius[0];
        int n = kHeight = radius.length == 1 ? kWidth : radius[1];
        int kDepth = radius.length == 1 ? kWidth : (radius.length == 2 ? 0 : radius[2]);
        final Object[] in_Z_XY = new Object[depth];
        final double[] cache = new double[width * height];
        ArrayList tasks = new ArrayList(height);
        int t = 0;
        while (t < sequence.getSizeT()) {
            int z = 0;
            while (z < depth) {
                out.setImage(t, z, (BufferedImage)new IcyBufferedImage(width, height, channels, type));
                ++z;
            }
            int c = 0;
            while (c < channels) {
                int z2 = 0;
                while (z2 < depth) {
                    in_Z_XY[z2] = sequence.getImage(t, z2, c).getDataXY(0);
                    ++z2;
                }
                z2 = 0;
                while (z2 < depth) {
                    final int minZinclusive = Math.max(z2 - kDepth, 0);
                    final int maxZexclusive = Math.min(z2 + kDepth + 1, depth);
                    final Object _inXY = in_Z_XY[z2];
                    final Object _outXY = out.getDataXY(t, z2, c);
                    tasks.clear();
                    int y = 0;
                    while (y < height) {
                        final int minYinclusive = Math.max(y - kHeight, 0);
                        final int maxYexclusive = Math.min(y + kHeight + 1, height);
                        final int lineOffset = y * width;
                        final int maxNeighbors = (1 + (maxZexclusive - minZinclusive) * 2) * (1 + (maxYexclusive - minYinclusive) * 2) * (1 + kWidth * 2);
                        tasks.add(this.submitTask(new Runnable(){

                            @Override
                            public void run() {
                                double[] neighborhood = new double[maxNeighbors];
                                int outXY = lineOffset;
                                int x = 0;
                                while (x < width) {
                                    double currentPixel = Array1DUtil.getValue(_inXY, outXY, type);
                                    int localNeighborHoodSize = 0;
                                    int minXinclusive = Math.max(x - kWidth, 0);
                                    int maxXexclusive = Math.min(x + kWidth + 1, width);
                                    int inZ = minZinclusive;
                                    while (inZ < maxZexclusive) {
                                        Object neighborSlice = in_Z_XY[inZ];
                                        int inY = minYinclusive;
                                        while (inY < maxYexclusive) {
                                            int inXY = inY * width + minXinclusive;
                                            int inX = minXinclusive;
                                            while (inX < maxXexclusive) {
                                                neighborhood[localNeighborHoodSize] = Array1DUtil.getValue(neighborSlice, inXY, type);
                                                ++inX;
                                                ++inXY;
                                                ++localNeighborHoodSize;
                                            }
                                            ++inY;
                                        }
                                        ++inZ;
                                    }
                                    cache[outXY] = ThreadedSelectionFilter.this.processNeighborhood(currentPixel, neighborhood, localNeighborHoodSize);
                                    ++x;
                                    ++outXY;
                                }
                                Array1DUtil.doubleArrayToSafeArray(cache, lineOffset, _outXY, lineOffset, width, signed);
                            }
                        }));
                        if (Thread.interrupted()) {
                            throw new InterruptedException();
                        }
                        ++y;
                    }
                    try {
                        try {
                            for (Future f : tasks) {
                                f.get();
                            }
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            Sequence sequence2 = out;
                            out.setDataXY(t, z2, c, _outXY);
                            return sequence2;
                        }
                        catch (ExecutionException e) {
                            Thread.currentThread().interrupt();
                            Sequence sequence3 = out;
                            out.setDataXY(t, z2, c, _outXY);
                            return sequence3;
                        }
                    }
                    finally {
                        out.setDataXY(t, z2, c, _outXY);
                    }
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    ++z2;
                }
                ++c;
            }
            ++t;
        }
        return out;
    }

    private Future<?> submitTask(Runnable task) {
        return service.submit(task);
    }
}

