/*
 * Decompiled with CFR 0.152.
 */
package mitiv.linalg.shaped;

import mitiv.array.ShapedArray;
import mitiv.base.ArrayDescriptor;
import mitiv.base.Shape;
import mitiv.base.Shaped;
import mitiv.base.Typed;
import mitiv.linalg.Vector;
import mitiv.linalg.shaped.ShapedVectorSpace;

public abstract class ShapedVector
extends Vector
implements Shaped,
Typed {
    final ArrayDescriptor descr;

    ShapedVector(ShapedVectorSpace owner) {
        super(owner);
        this.descr = owner.descr;
    }

    @Override
    public ShapedVectorSpace getOwner() {
        return (ShapedVectorSpace)this.space;
    }

    @Override
    public ShapedVectorSpace getSpace() {
        return this.getOwner();
    }

    @Override
    public final int getType() {
        return this.descr.getType();
    }

    @Override
    public final int getRank() {
        return this.descr.getRank();
    }

    @Override
    public final int getOrder() {
        return this.descr.getOrder();
    }

    @Override
    public final Shape getShape() {
        return this.descr.getShape();
    }

    @Override
    public final int getDimension(int k) {
        return this.descr.getDimension(k);
    }

    @Override
    public ShapedVector create() {
        return this.getSpace().create();
    }

    @Override
    public ShapedVector clone() {
        return this.getSpace()._clone(this);
    }

    public abstract void assign(ShapedArray var1);

    public abstract ShapedArray asShapedArray();

    @Override
    public String toString() {
        int len = this.getNumber();
        String str = "ShapedVector: " + this.descr.toString() + " = {";
        if (len < 9) {
            for (int i = 0; i < len; ++i) {
                str = str + String.format(i > 0 ? ", %g" : " %g", this.get(i));
            }
        } else {
            int i;
            for (i = 0; i < 3; ++i) {
                str = str + String.format(i > 0 ? ", %g" : " %g", this.get(i));
            }
            str = str + ", ...";
            for (i = len - 3; i < len; ++i) {
                str = str + String.format(", %g", this.get(i));
            }
        }
        return str + "}";
    }
}

