/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.gui.GUI;
import ij.gui.MultiLineLabel;
import ij.plugin.frame.RoiManager;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class WaitForUserDialog
extends Dialog
implements ActionListener,
KeyListener {
    protected Button button;
    protected MultiLineLabel label;
    protected static int xloc = -1;
    protected static int yloc = -1;
    private boolean escPressed;

    public WaitForUserDialog(String title, String text) {
        super(IJ.getInstance(), title, false);
        RoiManager rm;
        if (text != null && text.startsWith("IJ: ")) {
            text = text.substring(4);
        }
        this.label = new MultiLineLabel(text, 175);
        if (!IJ.isLinux()) {
            this.label.setFont(new Font("SansSerif", 0, 14));
        }
        if (IJ.isMacOSX() && (rm = RoiManager.getInstance()) != null) {
            rm.runCommand("enable interrupts");
        }
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridbag);
        c.insets = new Insets(6, 6, 0, 6);
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        this.add((Component)this.label, c);
        this.button = new Button("  OK  ");
        this.button.addActionListener(this);
        this.button.addKeyListener(this);
        c.insets = new Insets(2, 6, 6, 6);
        c.gridx = 0;
        c.gridy = 2;
        c.anchor = 13;
        this.add((Component)this.button, c);
        this.setResizable(false);
        this.addKeyListener(this);
        this.pack();
        if (xloc == -1) {
            GUI.centerOnImageJScreen(this);
        } else {
            this.setLocation(xloc, yloc);
        }
        this.setAlwaysOnTop(true);
    }

    public WaitForUserDialog(String text) {
        this("Action Required", text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void show() {
        super.show();
        WaitForUserDialog waitForUserDialog = this;
        synchronized (waitForUserDialog) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        WaitForUserDialog waitForUserDialog = this;
        synchronized (waitForUserDialog) {
            this.notify();
        }
        xloc = this.getLocation().x;
        yloc = this.getLocation().y;
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.close();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        IJ.setKeyDown(keyCode);
        if (keyCode == 10 || keyCode == 27) {
            this.escPressed = keyCode == 27;
            this.close();
        }
    }

    public boolean escPressed() {
        return this.escPressed;
    }

    @Override
    public void keyReleased(KeyEvent e) {
        int keyCode = e.getKeyCode();
        IJ.setKeyUp(keyCode);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public Button getButton() {
        return this.button;
    }

    public static void setNextLocation(int x, int y) {
        xloc = x;
        yloc = y;
    }
}

