/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.fmrc;

import java.io.FileNotFoundException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.featurecollection.FeatureCollectionConfig;
import ucar.nc2.ft.fmrc.FmrInv;
import ucar.nc2.ft.fmrc.FmrcInv;
import ucar.nc2.ft.fmrc.GridDatasetInv;
import ucar.nc2.ft.fmrc.TimeCoord;
import ucar.nc2.ft.fmrc.TimeInventory;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.util.Misc;

public class FmrcInvLite
implements Serializable {
    private static Logger log = LoggerFactory.getLogger(FmrcInvLite.class);
    private static final String BEST = "Best";
    public String collectionName;
    public CalendarDate base;
    public int nruns;
    public double[] runOffset;
    public double[] forecastOffset;
    public double[] offsets;
    public List<String> locationList = new ArrayList<String>();
    public Map<String, Integer> locationMap = new HashMap<String, Integer>();
    public List<Gridset> gridSets = new ArrayList<Gridset>();
    public List<Gridset.GridInventory> invList = new ArrayList<Gridset.GridInventory>();

    public FmrcInvLite(FmrcInv fmrcInv) {
        this.collectionName = fmrcInv.getName();
        this.base = fmrcInv.getBaseDate();
        List<CalendarDate> forecasts = fmrcInv.getForecastTimes();
        this.forecastOffset = new double[forecasts.size()];
        for (int i = 0; i < forecasts.size(); ++i) {
            CalendarDate f = forecasts.get(i);
            this.forecastOffset[i] = FmrcInv.getOffsetInHours(this.base, f);
        }
        List<FmrInv> fmrList = fmrcInv.getFmrInv();
        this.nruns = fmrList.size();
        this.runOffset = new double[this.nruns];
        int countIndex = 0;
        for (int run = 0; run < this.nruns; ++run) {
            FmrInv fmrInv = fmrList.get(run);
            this.runOffset[run] = FmrcInv.getOffsetInHours(this.base, fmrInv.getRunDate());
            for (GridDatasetInv inv : fmrInv.getInventoryList()) {
                this.locationList.add(inv.getLocation());
                this.locationMap.put(inv.getLocation(), countIndex);
                ++countIndex;
            }
        }
        for (FmrcInv.RunSeq runSeq : fmrcInv.getRunSeqs()) {
            this.gridSets.add(new Gridset(runSeq));
        }
        TreeSet<Double> tree = new TreeSet<Double>();
        for (Gridset gridset : this.gridSets) {
            for (int run = 0; run < this.nruns; ++run) {
                double baseOffset = this.runOffset[run];
                for (int time = 0; time < gridset.noffsets; ++time) {
                    double offset = gridset.timeOffset[run * gridset.noffsets + time];
                    if (Double.isNaN(offset)) continue;
                    tree.add(offset - baseOffset);
                }
            }
        }
        this.offsets = new double[tree.size()];
        Iterator iterator = tree.iterator();
        for (int i = 0; i < tree.size(); ++i) {
            this.offsets[i] = (Double)iterator.next();
        }
    }

    public int findRunIndex(CalendarDate want) {
        for (int i = 0; i < this.runOffset.length; ++i) {
            if (!want.equals(FmrcInv.makeOffsetDate(this.base, this.runOffset[i]))) continue;
            return i;
        }
        return -1;
    }

    public List<CalendarDate> getRunDates() {
        ArrayList<CalendarDate> result = new ArrayList<CalendarDate>(this.runOffset.length);
        for (double off : this.runOffset) {
            result.add(FmrcInv.makeOffsetDate(this.base, off));
        }
        return result;
    }

    public List<CalendarDate> getForecastDates() {
        ArrayList<CalendarDate> result = new ArrayList<CalendarDate>(this.forecastOffset.length);
        for (double f : this.forecastOffset) {
            result.add(FmrcInv.makeOffsetDate(this.base, f));
        }
        return result;
    }

    public double[] getForecastOffsets() {
        return this.offsets;
    }

    public Gridset.Grid findGrid(String gridName) {
        for (Gridset gridset : this.gridSets) {
            for (Gridset.Grid grid : gridset.grids) {
                if (!gridName.equals(grid.name)) continue;
                return grid;
            }
        }
        return null;
    }

    public Gridset findGridset(String gridName) {
        for (Gridset gridset : this.gridSets) {
            for (Gridset.Grid grid : gridset.grids) {
                if (!gridName.equals(grid.name)) continue;
                return gridset;
            }
        }
        return null;
    }

    public void showGridInfo(String gridName, Formatter out) {
        Gridset.Grid grid = this.findGrid(gridName);
        if (grid == null) {
            out.format("Cant find grid = %s%n", gridName);
            return;
        }
        Gridset gridset = grid.getGridset();
        out.format("%n=======================================%nFmrcLite.Grid%n", new Object[0]);
        out.format("2D%n   run%n time  ", new Object[0]);
        for (int i = 0; i < gridset.noffsets; ++i) {
            out.format("%6d ", i);
        }
        out.format("%n", new Object[0]);
        for (int run = 0; run < this.nruns; ++run) {
            out.format("%6d", run);
            for (int time = 0; time < gridset.noffsets; ++time) {
                out.format(" %6.0f", gridset.getTimeCoord(run, time));
            }
            out.format("%n", new Object[0]);
        }
        out.format("%n", new Object[0]);
        Gridset.GridInventory gridInv = grid.inv;
        out.format("%n=======================================%nFmrcLite.GridInventory Missing Data%n", new Object[0]);
        for (int run = 0; run < this.nruns; ++run) {
            int time;
            boolean hasMissing = false;
            for (time = 0; time < gridset.noffsets; ++time) {
                if (gridInv.getLocation(run, time) != 0) continue;
                hasMissing = true;
            }
            if (!hasMissing) continue;
            out.format("run %6d timeIdx=", run);
            for (time = 0; time < gridset.noffsets; ++time) {
                if (gridInv.getLocation(run, time) != 0) continue;
                out.format(" %6d", time);
            }
            out.format("%n", new Object[0]);
        }
        out.format("%n", new Object[0]);
        out.format("%n=======================================%nFmrcLite.TimeInv Best%n", new Object[0]);
        BestDatasetInventory best = new BestDatasetInventory(null);
        List bestInv = gridset.timeCoordMap.get(BEST);
        if (bestInv == null) {
            bestInv = gridset.makeBest(null);
        }
        ValueB coords = best.getTimeCoords(gridset);
        out.format("        ", new Object[0]);
        for (int i = 0; i < bestInv.size(); ++i) {
            out.format(" %6d", i);
        }
        out.format("%n", new Object[0]);
        out.format(" coord =", new Object[0]);
        for (TimeInv inv : bestInv) {
            out.format(" %6.0f", inv.offset);
        }
        out.format("%n", new Object[0]);
        out.format(" run   =", new Object[0]);
        for (TimeInv inv : bestInv) {
            out.format(" %6d", inv.runIdx);
        }
        out.format("%n", new Object[0]);
        out.format(" idx   =", new Object[0]);
        for (TimeInv inv : bestInv) {
            out.format(" %6d", inv.timeIdx);
        }
        out.format("%n", new Object[0]);
    }

    public TimeInventory makeBestDatasetInventory() {
        return new BestDatasetInventory(null);
    }

    TimeInventory makeBestDatasetInventory(FeatureCollectionConfig.BestDataset bd) {
        return new BestDatasetInventory(bd);
    }

    public TimeInventory makeRunTimeDatasetInventory(CalendarDate run) throws FileNotFoundException {
        return new RunTimeDatasetInventory(run);
    }

    public TimeInventory getConstantForecastDataset(CalendarDate time) throws FileNotFoundException {
        return new ConstantForecastDataset(time);
    }

    public TimeInventory getConstantOffsetDataset(double hour) throws FileNotFoundException {
        return new ConstantOffsetDataset(hour);
    }

    class ConstantOffsetDataset
    implements TimeInventory {
        double offset;

        ConstantOffsetDataset(double offset) throws FileNotFoundException {
            this.offset = offset;
            boolean ok = false;
            double[] offsets = FmrcInvLite.this.getForecastOffsets();
            for (int i = 0; i < offsets.length; ++i) {
                if (!Misc.closeEnough(offsets[i], offset)) continue;
                ok = true;
            }
            if (!ok) {
                throw new FileNotFoundException("No constant offset dataset for = " + offset);
            }
        }

        @Override
        public String getName() {
            return "Constant Offset " + this.offset + " hours";
        }

        @Override
        public int getTimeLength(Gridset gridset) {
            List coords = gridset.timeCoordMap.get("offset" + this.offset);
            if (coords == null) {
                coords = gridset.makeConstantOffset(this.offset);
            }
            return coords.size();
        }

        @Override
        public ValueB getTimeCoords(Gridset gridset) {
            List coords = gridset.timeCoordMap.get("offset" + this.offset);
            if (coords == null) {
                coords = gridset.makeConstantOffset(this.offset);
            }
            return new ValueB(coords);
        }

        @Override
        public double[] getRunTimeCoords(Gridset gridset) {
            List coords = gridset.timeCoordMap.get("offset" + this.offset);
            if (coords == null) {
                coords = gridset.makeConstantOffset(this.offset);
            }
            double[] result = new double[coords.size()];
            for (int i = 0; i < coords.size(); ++i) {
                TimeInv b = (TimeInv)coords.get(i);
                result[i] = gridset.getTimeCoord(b.runIdx, 0);
            }
            return result;
        }

        @Override
        public double[] getOffsetCoords(Gridset gridset) {
            return null;
        }

        @Override
        public TimeInventory.Instance getInstance(Gridset.Grid grid, int timeIdx) {
            Gridset gridset = grid.getGridset();
            List coords = gridset.timeCoordMap.get("offset" + this.offset);
            if (coords == null) {
                coords = gridset.makeConstantOffset(this.offset);
            }
            TimeInv b = coords.get(timeIdx);
            return grid.getInstance(b.runIdx, b.timeIdx);
        }
    }

    class ConstantForecastDataset
    implements TimeInventory {
        double offset;

        ConstantForecastDataset(CalendarDate time) throws FileNotFoundException {
            this.offset = FmrcInv.getOffsetInHours(FmrcInvLite.this.base, time);
            for (CalendarDate d : FmrcInvLite.this.getForecastDates()) {
                if (!d.equals(time)) continue;
                return;
            }
            throw new FileNotFoundException("No forecast date of " + time);
        }

        @Override
        public String getName() {
            return "Constant Forecast " + FmrcInv.makeOffsetDate(FmrcInvLite.this.base, this.offset);
        }

        @Override
        public int getTimeLength(Gridset gridset) {
            List coords = gridset.timeCoordMap.get("forecast" + this.offset);
            if (coords == null) {
                coords = gridset.makeConstantForecast(this.offset);
            }
            return coords.size();
        }

        @Override
        public ValueB getTimeCoords(Gridset gridset) {
            return null;
        }

        @Override
        public double[] getRunTimeCoords(Gridset gridset) {
            List coords = gridset.timeCoordMap.get("forecast" + this.offset);
            if (coords == null) {
                coords = gridset.makeConstantForecast(this.offset);
            }
            double[] result = new double[coords.size()];
            for (int i = 0; i < coords.size(); ++i) {
                TimeInv b = (TimeInv)coords.get(i);
                result[i] = gridset.getTimeCoord(b.runIdx, 0);
            }
            return result;
        }

        @Override
        public double[] getOffsetCoords(Gridset gridset) {
            List coords = gridset.timeCoordMap.get("forecast" + this.offset);
            if (coords == null) {
                coords = gridset.makeConstantForecast(this.offset);
            }
            double[] result = new double[coords.size()];
            for (int i = 0; i < coords.size(); ++i) {
                TimeInv b = (TimeInv)coords.get(i);
                result[i] = b.offset;
            }
            return result;
        }

        @Override
        public TimeInventory.Instance getInstance(Gridset.Grid grid, int timeIdx) {
            Gridset gridset = grid.getGridset();
            List coords = gridset.timeCoordMap.get("forecast" + this.offset);
            if (coords == null) {
                coords = gridset.makeConstantForecast(this.offset);
            }
            TimeInv b = coords.get(timeIdx);
            return grid.getInstance(b.runIdx, b.timeIdx);
        }
    }

    class RunTimeDatasetInventory
    implements TimeInventory {
        int runIdx = -1;

        RunTimeDatasetInventory(CalendarDate run) throws FileNotFoundException {
            double offset = FmrcInv.getOffsetInHours(FmrcInvLite.this.base, run);
            for (int i = 0; i < FmrcInvLite.this.runOffset.length; ++i) {
                if (!Misc.closeEnough(FmrcInvLite.this.runOffset[i], offset)) continue;
                this.runIdx = i;
                break;
            }
            if (this.runIdx < 0) {
                throw new FileNotFoundException("No run date of " + run);
            }
        }

        @Override
        public String getName() {
            return "Run " + FmrcInv.makeOffsetDate(FmrcInvLite.this.base, FmrcInvLite.this.runOffset[this.runIdx]);
        }

        @Override
        public int getTimeLength(Gridset gridset) {
            List coords = gridset.timeCoordMap.get("run" + this.runIdx);
            if (coords == null) {
                coords = gridset.makeRun(this.runIdx);
            }
            return coords.size();
        }

        @Override
        public ValueB getTimeCoords(Gridset gridset) {
            List coords = gridset.timeCoordMap.get("run" + this.runIdx);
            if (coords == null) {
                coords = gridset.makeRun(this.runIdx);
            }
            return new ValueB(coords);
        }

        @Override
        public double[] getRunTimeCoords(Gridset gridset) {
            return null;
        }

        @Override
        public double[] getOffsetCoords(Gridset gridset) {
            List coords = gridset.timeCoordMap.get("run" + this.runIdx);
            if (coords == null) {
                coords = gridset.makeRun(this.runIdx);
            }
            double startRun = gridset.getTimeCoord(this.runIdx, 0);
            double[] result = new double[coords.size()];
            for (int i = 0; i < coords.size(); ++i) {
                TimeInv b = (TimeInv)coords.get(i);
                result[i] = b.offset - startRun;
            }
            return result;
        }

        @Override
        public TimeInventory.Instance getInstance(Gridset.Grid grid, int timeIdx) {
            Gridset gridset = grid.getGridset();
            List coords = gridset.timeCoordMap.get("run" + this.runIdx);
            if (coords == null) {
                coords = gridset.makeRun(this.runIdx);
            }
            TimeInv b = coords.get(timeIdx);
            return grid.getInstance(b.runIdx, b.timeIdx);
        }
    }

    class BestDatasetInventory
    implements TimeInventory {
        FeatureCollectionConfig.BestDataset bd;

        BestDatasetInventory(FeatureCollectionConfig.BestDataset bd) {
            this.bd = bd;
        }

        @Override
        public String getName() {
            return this.bd == null ? FmrcInvLite.BEST : this.bd.name;
        }

        @Override
        public int getTimeLength(Gridset gridset) {
            List best = gridset.timeCoordMap.get(this.getName());
            if (best == null) {
                best = gridset.makeBest(this.bd);
            }
            return best.size();
        }

        @Override
        public ValueB getTimeCoords(Gridset gridset) {
            List best = gridset.timeCoordMap.get(this.getName());
            if (best == null) {
                best = gridset.makeBest(this.bd);
            }
            return new ValueB(best);
        }

        @Override
        public double[] getRunTimeCoords(Gridset gridset) {
            List best = gridset.timeCoordMap.get(this.getName());
            if (best == null) {
                best = gridset.makeBest(this.bd);
            }
            double[] result = new double[best.size()];
            for (int i = 0; i < best.size(); ++i) {
                TimeInv b = (TimeInv)best.get(i);
                result[i] = gridset.getTimeCoord(b.runIdx, 0);
            }
            return result;
        }

        @Override
        public double[] getOffsetCoords(Gridset gridset) {
            List best = gridset.timeCoordMap.get(this.getName());
            if (best == null) {
                best = gridset.makeBest(this.bd);
            }
            double[] result = new double[best.size()];
            for (int i = 0; i < best.size(); ++i) {
                TimeInv b = (TimeInv)best.get(i);
                result[i] = b.offset - gridset.getTimeCoord(b.runIdx, 0);
            }
            return result;
        }

        @Override
        public TimeInventory.Instance getInstance(Gridset.Grid grid, int timeIdx) {
            Gridset gridset = grid.getGridset();
            List best = gridset.timeCoordMap.get(this.getName());
            if (best == null) {
                best = gridset.makeBest(this.bd);
            }
            TimeInv b = best.get(timeIdx);
            int locIdx = grid.inv.getLocation(b.runIdx, b.timeIdx);
            if (locIdx == 0) {
                return null;
            }
            int invIndex = grid.inv.getInvIndex(b.runIdx, b.timeIdx);
            return new TimeInstance(FmrcInvLite.this.locationList.get(locIdx - 1), invIndex);
        }
    }

    public static class ValueB {
        public double[] offset;
        public double[] bounds;

        public ValueB(List<TimeInv> invs) {
            boolean isInterval = invs.size() > 0 && invs.get((int)0).isInterval;
            this.offset = new double[invs.size()];
            if (isInterval) {
                this.bounds = new double[2 * invs.size()];
                for (int i = 0; i < invs.size(); ++i) {
                    TimeInv b = invs.get(i);
                    this.offset[i] = b.offset;
                    this.bounds[2 * i] = b.startIntv;
                    this.bounds[2 * i + 1] = b.offset;
                }
            } else {
                for (int i = 0; i < invs.size(); ++i) {
                    TimeInv b = invs.get(i);
                    this.offset[i] = b.offset;
                }
            }
        }
    }

    private static class TimeInv
    implements Comparable<TimeInv> {
        int runIdx;
        int timeIdx;
        double offset;
        double startIntv = Double.NaN;
        boolean isInterval = false;

        TimeInv(int runIdx, int timeIdx, double b1, double b2) {
            this.runIdx = runIdx;
            this.timeIdx = timeIdx;
            this.startIntv = b1;
            this.offset = b2;
            this.isInterval = true;
        }

        TimeInv(int runIdx, int timeIdx, double offset) {
            this.runIdx = runIdx;
            this.timeIdx = timeIdx;
            this.offset = offset;
        }

        @Override
        public int compareTo(TimeInv o) {
            if (Misc.closeEnough(this.offset, o.offset)) {
                return 0;
            }
            if (!this.isInterval) {
                return Double.compare(this.offset, o.offset);
            }
            if (Misc.closeEnough(this.startIntv, o.startIntv)) {
                return 0;
            }
            return Double.compare(this.startIntv, o.startIntv);
        }
    }

    static class TimeInstance
    implements TimeInventory.Instance {
        String location;
        int index;

        TimeInstance(String location, int index) {
            this.location = location;
            this.index = index;
        }

        @Override
        public String getDatasetLocation() {
            return this.location;
        }

        @Override
        public int getDatasetIndex() {
            return this.index;
        }

        public String toString() {
            return "TimeInstance{location='" + this.location + '\'' + ", index=" + this.index + '}';
        }
    }

    public class Gridset
    implements Serializable {
        String gridsetName;
        List<Grid> grids = new ArrayList<Grid>();
        int noffsets;
        double[] timeOffset;
        double[] timeBounds;
        Map<String, List<TimeInv>> timeCoordMap = new HashMap<String, List<TimeInv>>();

        Gridset(FmrcInv.RunSeq runseq) {
            int i;
            this.gridsetName = runseq.getName();
            List<TimeCoord> timeList = runseq.getTimes();
            boolean hasMissingTimes = FmrcInvLite.this.nruns != timeList.size();
            this.noffsets = 0;
            for (TimeCoord tc : timeList) {
                this.noffsets = Math.max(this.noffsets, tc.getNCoords());
            }
            this.timeOffset = new double[FmrcInvLite.this.nruns * this.noffsets];
            for (i = 0; i < this.timeOffset.length; ++i) {
                this.timeOffset[i] = Double.NaN;
            }
            if (runseq.isInterval()) {
                this.timeBounds = new double[FmrcInvLite.this.nruns * this.noffsets * 2];
                for (i = 0; i < this.timeBounds.length; ++i) {
                    this.timeBounds[i] = Double.NaN;
                }
            }
            int runIdx = 0;
            for (int seqIdx = 0; seqIdx < timeList.size(); ++seqIdx) {
                TimeCoord tc = null;
                if (hasMissingTimes) {
                    double run_offset;
                    tc = timeList.get(seqIdx);
                    double tc_offset = FmrcInv.getOffsetInHours(FmrcInvLite.this.base, tc.getRunDate());
                    while (!Misc.closeEnough(run_offset = FmrcInvLite.this.runOffset[runIdx], tc_offset)) {
                        ++runIdx;
                        if (!log.isDebugEnabled()) continue;
                        String missingDate = FmrcInv.makeOffsetDate(FmrcInvLite.this.base, run_offset).toString();
                        String wantDate = tc.getRunDate().toString();
                        log.debug(FmrcInvLite.this.collectionName + ": runseq missing time " + missingDate + " looking for " + wantDate + " for var = " + runseq.getUberGrids().get(0).getName());
                    }
                } else {
                    tc = timeList.get(runIdx);
                }
                double run_offset = FmrcInv.getOffsetInHours(FmrcInvLite.this.base, tc.getRunDate());
                double[] offsets = tc.getOffsetTimes();
                int ntimes = offsets.length;
                for (int time = 0; time < ntimes; ++time) {
                    this.timeOffset[runIdx * this.noffsets + time] = run_offset + offsets[time];
                }
                if (runseq.isInterval()) {
                    double[] bound1 = tc.getBound1();
                    double[] bound2 = tc.getBound2();
                    for (int time = 0; time < ntimes; ++time) {
                        this.timeBounds[2 * (runIdx * this.noffsets + time)] = run_offset + bound1[time];
                        this.timeBounds[2 * (runIdx * this.noffsets + time) + 1] = run_offset + bound2[time];
                    }
                }
                ++runIdx;
            }
            for (FmrcInv.UberGrid ugrid : runseq.getUberGrids()) {
                this.grids.add(new Grid(ugrid.getName(), this.getInventory(ugrid)));
            }
        }

        private GridInventory getInventory(FmrcInv.UberGrid ugrid) {
            GridInventory result = null;
            GridInventory need = new GridInventory(ugrid);
            for (GridInventory got : FmrcInvLite.this.invList) {
                if (!got.equalData(need)) continue;
                result = got;
                break;
            }
            if (result == null) {
                FmrcInvLite.this.invList.add(need);
                result = need;
            }
            return result;
        }

        double getTimeCoord(int run, int time) {
            return this.timeOffset[run * this.noffsets + time];
        }

        private List<TimeInv> makeBest(FeatureCollectionConfig.BestDataset bd) {
            HashMap<TimeCoord.Tinv, TimeInv> map = new HashMap<TimeCoord.Tinv, TimeInv>();
            for (int run = 0; run < FmrcInvLite.this.nruns; ++run) {
                for (int time = 0; time < this.noffsets; ++time) {
                    double baseOffset = this.timeOffset[run * this.noffsets + time];
                    if (Double.isNaN(baseOffset)) continue;
                    double orgOffset = baseOffset - FmrcInvLite.this.runOffset[run];
                    if (bd != null && orgOffset < bd.greaterThan) continue;
                    if (this.timeBounds == null) {
                        map.put(new TimeCoord.Tinv(baseOffset), new TimeInv(run, time, baseOffset));
                        continue;
                    }
                    double b1 = this.timeBounds[2 * (run * this.noffsets + time)];
                    double b2 = this.timeBounds[2 * (run * this.noffsets + time) + 1];
                    map.put(new TimeCoord.Tinv(b1, b2), new TimeInv(run, time, b1, b2));
                }
            }
            Collection values = map.values();
            int n = values.size();
            List<TimeInv> best = Arrays.asList(values.toArray(new TimeInv[n]));
            Collections.sort(best);
            this.timeCoordMap.put(FmrcInvLite.BEST, best);
            return best;
        }

        private List<TimeInv> makeRun(int runIdx) {
            ArrayList<TimeInv> result = new ArrayList<TimeInv>(this.noffsets);
            for (int time = 0; time < this.noffsets; ++time) {
                double offset = this.timeOffset[runIdx * this.noffsets + time];
                if (Double.isNaN(offset)) continue;
                if (this.timeBounds == null) {
                    result.add(new TimeInv(runIdx, time, offset));
                    continue;
                }
                double b1 = this.timeBounds[2 * (runIdx * this.noffsets + time)];
                double b2 = this.timeBounds[2 * (runIdx * this.noffsets + time) + 1];
                result.add(new TimeInv(runIdx, time, b1, b2));
            }
            this.timeCoordMap.put("run" + runIdx, result);
            return result;
        }

        private List<TimeInv> makeConstantForecast(double offset) {
            ArrayList<TimeInv> result = new ArrayList<TimeInv>(this.noffsets);
            for (int run = 0; run < FmrcInvLite.this.nruns; ++run) {
                for (int time = 0; time < this.noffsets; ++time) {
                    double baseOffset = this.timeOffset[run * this.noffsets + time];
                    if (Double.isNaN(baseOffset) || !Misc.closeEnough(baseOffset, offset)) continue;
                    result.add(new TimeInv(run, time, offset - this.timeOffset[run * this.noffsets]));
                }
            }
            this.timeCoordMap.put("forecast" + offset, result);
            return result;
        }

        private List<TimeInv> makeConstantOffset(double offset) {
            ArrayList<TimeInv> result = new ArrayList<TimeInv>(FmrcInvLite.this.nruns);
            for (int run = 0; run < FmrcInvLite.this.nruns; ++run) {
                for (int time = 0; time < this.noffsets; ++time) {
                    double runOffset;
                    double baseOffset = this.getTimeCoord(run, time);
                    if (Double.isNaN(baseOffset) || !Misc.closeEnough(runOffset = baseOffset - FmrcInvLite.this.runOffset[run], offset)) continue;
                    result.add(new TimeInv(run, time, baseOffset));
                }
            }
            this.timeCoordMap.put("offset" + offset, result);
            return result;
        }

        public class GridInventory
        implements Serializable {
            int[] location;
            int[] invIndex;

            GridInventory(FmrcInv.UberGrid ugrid) {
                this.location = new int[FmrcInvLite.this.nruns * Gridset.this.noffsets];
                this.invIndex = new int[FmrcInvLite.this.nruns * Gridset.this.noffsets];
                int gridIdx = 0;
                List<FmrInv.GridVariable> grids = ugrid.getRuns();
                for (int runIdx = 0; runIdx < FmrcInvLite.this.nruns; ++runIdx) {
                    CalendarDate runDate = FmrcInv.makeOffsetDate(FmrcInvLite.this.base, FmrcInvLite.this.runOffset[runIdx]);
                    if (gridIdx >= grids.size()) {
                        log.debug(FmrcInvLite.this.collectionName + ": cant find " + ugrid.getName() + " for " + runDate);
                        break;
                    }
                    FmrInv.GridVariable grid = grids.get(gridIdx);
                    if (!grid.getRunDate().equals(runDate)) continue;
                    ++gridIdx;
                    for (GridDatasetInv.Grid inv : grid.getInventory()) {
                        double invOffset = FmrcInv.getOffsetInHours(FmrcInvLite.this.base, inv.tc.getRunDate());
                        for (int i = 0; i < inv.tc.getNCoords(); ++i) {
                            int timeIdx = Gridset.this.timeBounds == null ? this.findIndex(runIdx, invOffset + inv.tc.getOffsetTimes()[i]) : this.findBounds(runIdx, invOffset + inv.tc.getBound1()[i], invOffset + inv.tc.getBound2()[i]);
                            if (timeIdx < 0) continue;
                            this.location[runIdx * Gridset.this.noffsets + timeIdx] = this.findLocation(inv.getLocation()) + 1;
                            this.invIndex[runIdx * Gridset.this.noffsets + timeIdx] = i;
                        }
                    }
                }
            }

            private boolean equalData(Object oo) {
                int i;
                GridInventory o = (GridInventory)oo;
                if (o.location.length != this.location.length) {
                    return false;
                }
                if (o.invIndex.length != this.invIndex.length) {
                    return false;
                }
                for (i = 0; i < this.location.length; ++i) {
                    if (this.location[i] == o.location[i]) continue;
                    return false;
                }
                for (i = 0; i < this.invIndex.length; ++i) {
                    if (this.invIndex[i] == o.invIndex[i]) continue;
                    return false;
                }
                return true;
            }

            private int findIndex(int runIdx, double want) {
                for (int j = 0; j < Gridset.this.noffsets; ++j) {
                    if (!Misc.closeEnough(Gridset.this.timeOffset[runIdx * Gridset.this.noffsets + j], want)) continue;
                    return j;
                }
                return -1;
            }

            private int findBounds(int runIdx, double b1, double b2) {
                for (int j = 0; j < Gridset.this.noffsets; ++j) {
                    if (!Misc.closeEnough(Gridset.this.timeBounds[2 * (runIdx * Gridset.this.noffsets + j)], b1) || !Misc.closeEnough(Gridset.this.timeBounds[2 * (runIdx * Gridset.this.noffsets + j) + 1], b2)) continue;
                    return j;
                }
                return -1;
            }

            private int findLocation(String location) {
                return FmrcInvLite.this.locationMap.get(location);
            }

            int getLocation(int run, int time) {
                return this.location[run * Gridset.this.noffsets + time];
            }

            int getInvIndex(int run, int time) {
                return this.invIndex[run * Gridset.this.noffsets + time];
            }
        }

        public class Grid
        implements Serializable {
            String name;
            GridInventory inv;

            Grid(String name, GridInventory inv) {
                this.name = name;
                this.inv = inv;
            }

            Gridset getGridset() {
                return Gridset.this;
            }

            TimeInventory.Instance getInstance(int runIdx, int timeIdx) {
                int locIdx = this.inv.getLocation(runIdx, timeIdx);
                if (locIdx == 0) {
                    return null;
                }
                int invIndex = this.inv.getInvIndex(runIdx, timeIdx);
                return new TimeInstance(FmrcInvLite.this.locationList.get(locIdx - 1), invIndex);
            }
        }
    }
}

