/*
 * Decompiled with CFR 0.152.
 */
package icy.image.colorspace;

import icy.common.CollapsibleEvent;
import icy.image.colorspace.IcyColorSpace;

public class IcyColorSpaceEvent
implements CollapsibleEvent {
    private final IcyColorSpace colorSpace;
    private int component;

    public IcyColorSpaceEvent(IcyColorSpace colorSpace, int component) {
        this.colorSpace = colorSpace;
        this.component = component;
    }

    public IcyColorSpace getColorSpace() {
        return this.colorSpace;
    }

    public IcyColorSpaceEventType getType() {
        return IcyColorSpaceEventType.CHANGED;
    }

    public int getComponent() {
        return this.component;
    }

    @Override
    public boolean collapse(CollapsibleEvent event) {
        if (this.equals(event)) {
            IcyColorSpaceEvent e = (IcyColorSpaceEvent)event;
            if (e.getComponent() != this.component) {
                this.component = -1;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.colorSpace.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof IcyColorSpaceEvent) {
            IcyColorSpaceEvent e = (IcyColorSpaceEvent)obj;
            return this.colorSpace == e.getColorSpace();
        }
        return super.equals(obj);
    }

    @Deprecated
    public static enum IcyColorSpaceEventType {
        CHANGED;

    }
}

