package plugins.ylemontag.sequencecomparator.blocks;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JComponent;

import plugins.adufour.vars.gui.VarEditor;
import plugins.adufour.vars.gui.swing.SwingVarEditor;
import plugins.adufour.vars.lang.Var;
import plugins.ylemontag.sequencecomparator.GlobalComparatorFactory;
import plugins.ylemontag.sequencecomparator.gui.GlobalComparatorComponent;

/**
 * 
 * @author Yoann Le Montagner
 * 
 * Wrap a global comparator factory
 */
public class VarGlobalComparator extends Var<GlobalComparatorFactory>
{
	/**
	 * Editor
	 */
	private static class Editor extends SwingVarEditor<GlobalComparatorFactory>
	{
		private boolean _enableListeners;
		private GlobalComparatorComponent _component;
		
		public Editor(Var<GlobalComparatorFactory> variable)
		{
			super(variable);
		}
		
		@Override
		protected JComponent createEditorComponent()
		{
			_enableListeners = true;
			_component = new GlobalComparatorComponent();
			_component.addActionListener(new ActionListener()
			{
				@Override
				public void actionPerformed(ActionEvent e) {
					if(_enableListeners) {
						variable.setValue(_component.getSelectedObject());
					}
				}
			});
			return _component;
		}
		
		@Override
		protected void activateListeners()
		{
			_enableListeners = true;
		}
		
		@Override
		protected void deactivateListeners()
		{
			_enableListeners = false;
		}
		
		@Override
		protected void updateInterfaceValue()
		{
			GlobalComparatorFactory value = variable.getValue();
			if(value==null) {
				return;
			}
			_component.setSelectedObject(value);
		}
	}
	
	public VarGlobalComparator(String name, GlobalComparatorFactory defaultValue)
	{
		super(name, GlobalComparatorFactory.class, defaultValue);
	}
	
	@Override
	public VarEditor<GlobalComparatorFactory> createVarEditor()
	{
		return new Editor(this);
	}
	
	@Override
	public GlobalComparatorFactory parse(String text)
	{
		return Enum.valueOf(GlobalComparatorFactory.class, text);
	}
}
