/*
 * Decompiled with CFR 0.152.
 */
package plugins.fab.spotDetector.filtering;

import icy.gui.component.ComponentUtil;
import icy.gui.util.GuiUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import plugins.fab.spotDetector.filtering.IntervalSlider;

public class IntervalSliderValue
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = -2102078017554017686L;
    IntervalSlider intervalSlider = null;
    JTextField minTextField = new JTextField("");
    JTextField maxTextField = new JTextField("");
    JLabel titleLabel = new JLabel("", 0);
    ArrayList<ActionListener> actionListenerList = new ArrayList();

    public IntervalSliderValue(int min, int max, int lowValue, int highValue, String title) {
        this.intervalSlider = new IntervalSlider(min, max, lowValue, highValue);
        this.intervalSlider.addActionListener(this);
        ComponentUtil.setFixedHeight((Component)this.intervalSlider, (int)20);
        ComponentUtil.setFixedWidth((Component)this.minTextField, (int)50);
        ComponentUtil.setFixedWidth((Component)this.maxTextField, (int)50);
        this.titleLabel.setText(title);
        this.minTextField.setText("" + lowValue);
        this.maxTextField.setText("" + highValue);
        this.minTextField.addActionListener(this);
        this.maxTextField.addActionListener(this);
        this.setLayout(new BoxLayout(this, 3));
        this.add(GuiUtil.createLineBoxPanel((Component[])new Component[]{this.titleLabel}));
        this.add(GuiUtil.createLineBoxPanel((Component[])new Component[]{this.minTextField, this.intervalSlider, this.maxTextField}));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.intervalSlider) {
            this.minTextField.setText("" + this.intervalSlider.getCurrentLowValue());
            this.maxTextField.setText("" + this.intervalSlider.getCurrentHighValue());
        }
        if (e.getSource() == this.minTextField) {
            try {
                int min = Integer.parseInt(this.minTextField.getText());
                this.intervalSlider.setCurrentLowValue(min);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        if (e.getSource() == this.maxTextField) {
            try {
                int max = Integer.parseInt(this.maxTextField.getText());
                this.intervalSlider.setCurrentHighValue(max);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListenerList.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListenerList.remove(actionListener);
    }

    private void fireAction() {
        for (ActionListener al : this.actionListenerList) {
            al.actionPerformed(new ActionEvent(this, 0, ""));
        }
    }

    public int getCurrentLowValue() {
        return this.intervalSlider.currentLowValue;
    }

    public int getCurrentHighValue() {
        return this.intervalSlider.currentHighValue;
    }
}

