/*
 * Decompiled with CFR 0.152.
 */
package icy.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ReflectionUtil {
    public static Method getMethod(Class<?> objectClass, String methodName, boolean forceAccess, Class<?> ... parameterTypes) throws SecurityException, NoSuchMethodException {
        Class<?> clazz = objectClass;
        Method result = null;
        while (clazz != null && result == null) {
            try {
                result = clazz.getDeclaredMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            clazz = clazz.getSuperclass();
        }
        if (result == null) {
            throw new NoSuchMethodException("Method " + methodName + "(..) not found in class " + objectClass.getName());
        }
        if (forceAccess) {
            result.setAccessible(true);
        }
        return result;
    }

    @Deprecated
    public static Method getMethod(Object object, String methodName, boolean forceAccess, Class<?> ... parameterTypes) throws SecurityException, NoSuchMethodException {
        return ReflectionUtil.getMethod(object.getClass(), methodName, forceAccess, parameterTypes);
    }

    public static Object invokeMethod(Object object, String methodName, boolean forceAccess, Object ... args) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class[] parameterTypes = new Class[args.length];
        int i = 0;
        while (i < args.length) {
            parameterTypes[i] = args[i].getClass();
            ++i;
        }
        Method method = ReflectionUtil.getMethod(object, methodName, forceAccess, parameterTypes);
        return method.invoke(object, args);
    }

    public static Field getField(Class<?> objectClass, String fieldName, boolean forceAccess) throws SecurityException, NoSuchFieldException {
        Class<?> clazz = objectClass;
        Field result = null;
        while (clazz != null && result == null) {
            try {
                result = clazz.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            clazz = clazz.getSuperclass();
        }
        if (result == null) {
            throw new NoSuchFieldException(" Field " + fieldName + " not found in class " + objectClass.getName());
        }
        if (forceAccess) {
            result.setAccessible(true);
        }
        return result;
    }

    @Deprecated
    public static Field getField(Object object, String fieldName, boolean forceAccess) throws SecurityException, NoSuchFieldException {
        return ReflectionUtil.getField(object.getClass(), fieldName, forceAccess);
    }

    public static Object getFieldObject(Object object, String fieldName, boolean forceAccess) throws IllegalArgumentException, IllegalAccessException, SecurityException, NoSuchFieldException {
        return ReflectionUtil.getField(object.getClass(), fieldName, forceAccess).get(object);
    }
}

