/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.sequence.tools;

import icy.gui.sequence.tools.SequenceBaseResizePanel;
import icy.image.IcyBufferedImageUtil;
import icy.sequence.Sequence;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class SequenceResizePanel
extends SequenceBaseResizePanel {
    private static final long serialVersionUID = 5366610917009978874L;
    private JComboBox filterComboBox;
    private JLabel lblFilterType;

    public SequenceResizePanel(Sequence sequence) {
        super(sequence);
        this.keepRatioCheckBox.setSelected(true);
        this.filterComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SequenceResizePanel.this.updatePreview();
            }
        });
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.lblFilterType = new JLabel("Filter type");
        GridBagConstraints gbc_lblFilterType = new GridBagConstraints();
        gbc_lblFilterType.fill = 1;
        gbc_lblFilterType.insets = new Insets(0, 0, 5, 5);
        gbc_lblFilterType.gridx = 5;
        gbc_lblFilterType.gridy = 0;
        this.settingPanel.add((Component)this.lblFilterType, gbc_lblFilterType);
        this.filterComboBox = new JComboBox();
        this.filterComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Nearest", "Bilinear", "Bicubic"}));
        this.filterComboBox.setSelectedIndex(1);
        GridBagConstraints gbc_filterComboBox = new GridBagConstraints();
        gbc_filterComboBox.insets = new Insets(0, 0, 5, 5);
        gbc_filterComboBox.fill = 2;
        gbc_filterComboBox.gridx = 5;
        gbc_filterComboBox.gridy = 1;
        this.settingPanel.add((Component)this.filterComboBox, gbc_filterComboBox);
    }

    @Override
    public IcyBufferedImageUtil.FilterType getFilterType() {
        switch (this.filterComboBox.getSelectedIndex()) {
            default: {
                return IcyBufferedImageUtil.FilterType.NEAREST;
            }
            case 1: {
                return IcyBufferedImageUtil.FilterType.BILINEAR;
            }
            case 2: 
        }
        return IcyBufferedImageUtil.FilterType.BICUBIC;
    }

    @Override
    public boolean getResizeContent() {
        return true;
    }

    @Override
    public int getXAlign() {
        return 0;
    }

    @Override
    public int getYAlign() {
        return 0;
    }
}

