package plugins.adufour.trackprocessors;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.vecmath.Point3d;

import icy.gui.util.GuiUtil;
import plugins.adufour.vars.gui.swing.WorkbookEditor;
import plugins.adufour.vars.lang.VarWorkbook;
import plugins.adufour.workbooks.IcySpreadSheet;
import plugins.adufour.workbooks.Workbooks;
import plugins.fab.trackmanager.PluginTrackManagerProcessor;
import plugins.fab.trackmanager.TrackGroup;
import plugins.fab.trackmanager.TrackSegment;
import plugins.nchenouard.spot.Detection;

public class InteractionAnalysis extends PluginTrackManagerProcessor implements ActionListener
{
    @SuppressWarnings("serial")
    private class TrackGroupSelectionModel extends DefaultComboBoxModel
    {
        @Override
        public int getSize()
        {
            return trackPool == null ? 0 : trackPool.getTrackGroupList().size();
        }
        
        @Override
        public Object getElementAt(int index)
        {
            return trackPool.getTrackGroupList().get(index);
        }
        
        @Override
        public int getIndexOf(Object anObject)
        {
            return trackPool.getTrackGroupList().indexOf(anObject);
        }
    }
    
    JComboBox groupA   = new JComboBox(new TrackGroupSelectionModel());
    JComboBox groupB   = new JComboBox(new TrackGroupSelectionModel());
    JSpinner  distance = new JSpinner(new SpinnerNumberModel(5, 1, 1000, 1));
    JButton   action   = new JButton("Calculate");
    
    JPanel resultPanel = new JPanel(new BorderLayout());
    
    public InteractionAnalysis()
    {
        JPanel options = new JPanel();
        options.setLayout(new BoxLayout(options, BoxLayout.Y_AXIS));
        options.add(GuiUtil.besidesPanel(new JLabel("Group A:      "), groupA));
        options.add(GuiUtil.besidesPanel(new JLabel("Group B:      "), groupB));
        options.add(GuiUtil.besidesPanel(new JLabel("Distance (px):"), distance));
        options.add(action);
        
        panel.setLayout(new BorderLayout());
        panel.add(options, BorderLayout.NORTH);
        panel.add(resultPanel, BorderLayout.CENTER);
        
        action.addActionListener(this);
    }
    
    @Override
    public void Close()
    {
        action.removeActionListener(this);
    }
    
    @Override
    public void Compute()
    {
    }
    
    @Override
    public void displaySequenceChanged()
    {
    }
    
    @Override
    public void actionPerformed(ActionEvent arg0)
    {
        panel.setVisible(false);
        resultPanel.removeAll();
        resultPanel.setPreferredSize(new Dimension(0, 300));
        
        VarWorkbook wb = new VarWorkbook("Interaction analysis", "Interactions");
        IcySpreadSheet sheet = Workbooks.getSheet(wb.getValue(), "Interactions");
        
        sheet.setRow(0, "Group A", "Track ID", "Group B", "Track ID", "Start frame", "Nb. frames");
        
        TrackGroup a = (TrackGroup) groupA.getSelectedItem();
        TrackGroup b = (TrackGroup) groupB.getSelectedItem();
        
        int rowID = 1;
        for (int aTrackID = 0; aTrackID < a.getTrackSegmentList().size(); aTrackID++)
        {
            TrackSegment aTrack = a.getTrackSegmentList().get(aTrackID);
            
            for (int bTrackID = 0; bTrackID < b.getTrackSegmentList().size(); bTrackID++)
            {
                TrackSegment bTrack = b.getTrackSegmentList().get(bTrackID);
                
                if (aTrack == bTrack) continue;
                
                int minT = Math.max(aTrack.getFirstDetection().getT(), bTrack.getFirstDetection().getT());
                int maxT = 1 + Math.min(aTrack.getLastDetection().getT(), bTrack.getLastDetection().getT());
                
                int interactionStartT = -1;
                int interactionDuration = 0;
                
                if (minT <= maxT) for (int t = minT; t <= maxT; t++)
                {
                    Detection aDet = aTrack.getDetectionAtTime(t);
                    Detection bDet = bTrack.getDetectionAtTime(t);
                    
                    if (aDet != null && bDet != null)
                    {
                        Point3d aPos = new Point3d(aDet.getX(), aDet.getY(), aDet.getZ());
                        Point3d bPos = new Point3d(bDet.getX(), bDet.getY(), bDet.getZ());
                        
                        if (aPos.distance(bPos) < (Integer) distance.getValue())
                        {
                            if (interactionStartT == -1) interactionStartT = t;
                            interactionDuration++;
                            continue;
                        }
                    }
                    
                    // if code runs here, the interaction stopped (or never started)
                    if (interactionDuration > 0)
                    {
                        // store it
                        sheet.setRow(rowID++, a.getDescription(), aTrackID, b.getDescription(), bTrackID, interactionStartT, interactionDuration);
                        // reset
                        interactionStartT = -1;
                        interactionDuration = 0;
                    }
                }
            }
        }
        
        WorkbookEditor editor = (WorkbookEditor) wb.createVarViewer();
        editor.setEnabled(true);
        editor.setFirstRowAsHeader(true);
        resultPanel.add((JComponent) editor.getEditorComponent(), BorderLayout.CENTER);
        panel.setVisible(true);
    }
    
}
