/*
 * Decompiled with CFR 0.152.
 */
package icy.image.colormap;

import icy.image.colormap.IcyColorMap;
import java.awt.Color;

public class HSVColorMap
extends IcyColorMap {
    public HSVColorMap() {
        this(1.0f, 1.0f);
    }

    public HSVColorMap(float saturation, float value) throws IllegalArgumentException {
        super("HSV [" + saturation + "," + value + "]");
        if (saturation < 0.0f || saturation > 1.0f) {
            throw new IllegalArgumentException("HSV: Saturation must be in the range [0,1]");
        }
        if (value < 0.0f || value > 1.0f) {
            throw new IllegalArgumentException("HSV: Value must be in the range [0,1]");
        }
        float min = (1.0f - saturation) * value;
        this.beginUpdate();
        try {
            int index = Math.round(0.0f);
            this.setRGBControlPoint(index, new Color(value, min, min));
            index = Math.round(42.5f);
            this.setRGBControlPoint(index, new Color(value, value, min));
            index = Math.round(85.0f);
            this.setRGBControlPoint(index, new Color(min, value, min));
            index = Math.round(127.5f);
            this.setRGBControlPoint(index, new Color(min, value, value));
            index = Math.round(170.0f);
            this.setRGBControlPoint(index, new Color(min, min, value));
            index = Math.round(212.5f);
            this.setRGBControlPoint(index, new Color(value, min, value));
            index = Math.round(255.0f);
            this.setRGBControlPoint(index, new Color(value, min, min));
        }
        finally {
            this.endUpdate();
        }
    }
}

