/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.flamingo.ribbon;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.util.HashSet;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.pushingpixels.flamingo.api.ribbon.AbstractRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.JRibbon;
import org.pushingpixels.flamingo.api.ribbon.RibbonTask;
import org.pushingpixels.flamingo.internal.ui.ribbon.JRibbonTaskToggleButton;
import org.pushingpixels.lafwidget.LafWidgetUtilities;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceConstants;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.painter.border.SubstanceBorderPainter;
import org.pushingpixels.substance.api.painter.fill.SubstanceFillPainter;
import org.pushingpixels.substance.flamingo.ribbon.ui.RibbonBorderShaper;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.colorscheme.ShiftColorScheme;
import org.pushingpixels.substance.internal.utils.HashMapKey;
import org.pushingpixels.substance.internal.utils.LazyResettableHashMap;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceOutlineUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;

public class RibbonBackgroundDelegate {
    private static LazyResettableHashMap<BufferedImage> imageCache = new LazyResettableHashMap("Substance.Flamingo.RibbonBackgroundDelegate");

    private static synchronized BufferedImage getTaskToggleButtonBackground(JRibbonTaskToggleButton button, int width, int height) {
        JRibbon ribbon = (JRibbon)SwingUtilities.getAncestorOfClass(JRibbon.class, button);
        TransitionAwareUI transitionAwareUI = (TransitionAwareUI)((Object)button.getUI());
        StateTransitionTracker stateTransitionTracker = transitionAwareUI.getTransitionTracker();
        ComponentState currState = ComponentState.getState(button.getActionModel(), button);
        StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> activeStates = modelStateInfo.getStateContributionMap();
        SubstanceSkin skin = SubstanceCoreUtilities.getSkin(button);
        SubstanceColorScheme baseFillScheme = skin.getColorScheme(button, ColorSchemeAssociationKind.TAB, currState);
        SubstanceColorScheme baseBorderScheme = skin.getColorScheme(ribbon, ColorSchemeAssociationKind.TAB_BORDER, currState);
        SubstanceFillPainter fillPainter = skin.getFillPainter();
        SubstanceBorderPainter borderPainter = skin.getBorderPainter();
        JRibbon parent = (JRibbon)SwingUtilities.getAncestorOfClass(JRibbon.class, button);
        RibbonTask selectedTask = parent.getSelectedTask();
        AbstractRibbonBand<?> band = selectedTask.getBandCount() == 0 ? null : selectedTask.getBand(0);
        Color bgColor = band != null ? band.getBackground() : parent.getBackground();
        HashMapKey baseKey = SubstanceCoreUtilities.getHashKey(width, height, baseFillScheme.getDisplayName(), baseBorderScheme.getDisplayName(), fillPainter.getDisplayName(), borderPainter.getDisplayName(), button.getParent().getBackground().getRGB(), button.getActionModel().isSelected(), button.getContextualGroupHueColor(), button.getActionModel().isSelected(), ribbon.isMinimized(), skin.getSelectedTabFadeStart(), skin.getSelectedTabFadeEnd(), bgColor);
        BufferedImage baseLayer = imageCache.get(baseKey);
        if (baseLayer == null) {
            baseLayer = RibbonBackgroundDelegate.getSingleLayer(button, width, height, ribbon, baseFillScheme, baseBorderScheme, fillPainter, borderPainter);
            imageCache.put(baseKey, baseLayer);
        }
        if (currState.isDisabled() || activeStates.size() == 1) {
            return baseLayer;
        }
        BufferedImage result = SubstanceCoreUtilities.getBlankImage(width, height);
        Graphics2D g2d = result.createGraphics();
        g2d.drawImage((Image)baseLayer, 0, 0, null);
        for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> activeEntry : activeStates.entrySet()) {
            float contribution;
            ComponentState activeState = activeEntry.getKey();
            if (activeState == currState || (contribution = activeEntry.getValue().getContribution()) == 0.0f) continue;
            SubstanceColorScheme fillScheme = SubstanceColorSchemeUtilities.getColorScheme(button, ColorSchemeAssociationKind.TAB, activeState);
            SubstanceColorScheme borderScheme = SubstanceColorSchemeUtilities.getColorScheme(ribbon, ColorSchemeAssociationKind.TAB_BORDER, activeState);
            HashMapKey key = SubstanceCoreUtilities.getHashKey(width, height, fillScheme.getDisplayName(), borderScheme.getDisplayName(), fillPainter.getDisplayName(), borderPainter.getDisplayName(), button.getParent().getBackground().getRGB(), button.getActionModel().isSelected(), button.getContextualGroupHueColor(), button.getActionModel().isSelected(), ribbon.isMinimized(), skin.getSelectedTabFadeStart(), skin.getSelectedTabFadeEnd(), bgColor);
            BufferedImage layer = imageCache.get(key);
            if (layer == null) {
                layer = RibbonBackgroundDelegate.getSingleLayer(button, width, height, ribbon, fillScheme, borderScheme, fillPainter, borderPainter);
                imageCache.put(key, layer);
            }
            g2d.setComposite(AlphaComposite.SrcOver.derive(contribution));
            g2d.drawImage((Image)layer, 0, 0, null);
        }
        g2d.dispose();
        return result;
    }

    private static BufferedImage getSingleLayer(JRibbonTaskToggleButton button, int width, int height, JRibbon ribbon, SubstanceColorScheme fillScheme, SubstanceColorScheme borderScheme, SubstanceFillPainter fillPainter, SubstanceBorderPainter borderPainter) {
        HashSet<SubstanceConstants.Side> bottom = new HashSet<SubstanceConstants.Side>();
        bottom.add(SubstanceConstants.Side.BOTTOM);
        Color contextualGroupHueColor = button.getContextualGroupHueColor();
        if (contextualGroupHueColor != null) {
            fillScheme = ShiftColorScheme.getShiftedScheme(fillScheme, contextualGroupHueColor, 0.25, null, 0.0);
        }
        float radius = RibbonBorderShaper.getRibbonToggleButtonRadius(button);
        int borderDelta = (int)Math.ceil(2.0 * (double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(button)));
        int borderInsets = (int)Math.floor((double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(button)) / 2.0);
        GeneralPath contour = SubstanceOutlineUtilities.getBaseOutline(width, height + 2 + borderDelta, radius, bottom, borderInsets);
        BufferedImage result = SubstanceCoreUtilities.getBlankImage(width, height + 2);
        Graphics2D graphics = result.createGraphics();
        fillPainter.paintContourBackground(graphics, button, width, height + 2 + borderDelta, contour, false, fillScheme, true);
        int borderThickness = (int)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(button));
        GeneralPath contourInner = SubstanceOutlineUtilities.getBaseOutline(width, height + 2 + borderDelta, radius, bottom, borderThickness + borderInsets);
        borderPainter.paintBorder(graphics, button, width, height + 2, contour, contourInner, borderScheme);
        graphics.dispose();
        if (button.getActionModel().isSelected() && button.getContextualGroupHueColor() == null) {
            AbstractRibbonBand<?> band;
            int fw = result.getWidth();
            int fh = result.getHeight();
            BufferedImage fade = SubstanceCoreUtilities.getBlankImage(fw, fh);
            Graphics2D fadeGraphics = fade.createGraphics();
            JRibbon parent = (JRibbon)SwingUtilities.getAncestorOfClass(JRibbon.class, button);
            RibbonTask selectedTask = parent.getSelectedTask();
            AbstractRibbonBand<?> abstractRibbonBand = band = selectedTask.getBandCount() == 0 ? null : selectedTask.getBand(0);
            if (band != null) {
                fadeGraphics.setColor(band.getBackground());
            } else {
                fadeGraphics.setColor(parent.getBackground());
            }
            fadeGraphics.fillRect(0, 0, fw, fh);
            SubstanceSkin skin = SubstanceCoreUtilities.getSkin(button);
            if (skin.getWatermark() != null) {
                skin.getWatermark().drawWatermarkImage(fadeGraphics, button, 0, 0, fw, fh);
            }
            borderPainter.paintBorder(fadeGraphics, button, width, height + 2, contour, contourInner, borderScheme);
            result = SubstanceCoreUtilities.blendImagesVertical(result, fade, skin.getSelectedTabFadeStart(), skin.getSelectedTabFadeEnd());
        }
        return result;
    }

    public void updateTaskToggleButtonBackground(Graphics g, JRibbonTaskToggleButton button) {
        Graphics2D g2d = (Graphics2D)g.create();
        int width = button.getWidth();
        int height = button.getHeight();
        BufferedImage ribbonBackground = RibbonBackgroundDelegate.getTaskToggleButtonBackground(button, width, height);
        TransitionAwareUI ui = (TransitionAwareUI)((Object)button.getUI());
        StateTransitionTracker stateTransitionTracker = ui.getTransitionTracker();
        float extraActionAlpha = 0.0f;
        for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> activeEntry : stateTransitionTracker.getModelStateInfo().getStateContributionMap().entrySet()) {
            ComponentState activeState = activeEntry.getKey();
            if (activeState.isDisabled() || activeState == ComponentState.ENABLED) continue;
            extraActionAlpha += activeEntry.getValue().getContribution();
        }
        g2d.setComposite(LafWidgetUtilities.getAlphaComposite(button, extraActionAlpha, g));
        g2d.drawImage((Image)ribbonBackground, 0, 0, null);
        g2d.dispose();
    }
}

