/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.component;

import icy.action.RoiActions;
import icy.canvas.IcyCanvas;
import icy.canvas.IcyCanvas2D;
import icy.canvas.IcyCanvas3D;
import icy.gui.component.ExternalizablePanel;
import icy.gui.component.IcyTextField;
import icy.gui.component.button.IcyButton;
import icy.gui.component.renderer.ImageTableCellRenderer;
import icy.gui.inspector.RoiSettingFrame;
import icy.gui.main.ActiveSequenceListener;
import icy.gui.util.GuiUtil;
import icy.gui.util.LookAndFeelUtil;
import icy.gui.viewer.Viewer;
import icy.main.Icy;
import icy.math.MathUtil;
import icy.plugin.PluginLoader;
import icy.plugin.interface_.PluginROIDescriptor;
import icy.preferences.XMLPreferences;
import icy.roi.ROI;
import icy.roi.ROIDescriptor;
import icy.roi.ROIEvent;
import icy.roi.ROIListener;
import icy.roi.ROIUtil;
import icy.sequence.Sequence;
import icy.sequence.SequenceEvent;
import icy.system.IcyExceptionHandler;
import icy.system.thread.InstanceProcessor;
import icy.system.thread.ThreadUtil;
import icy.type.rectangle.Rectangle5D;
import icy.util.ClassUtil;
import icy.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.DefaultListSelectionModel;
import javax.swing.DefaultRowSorter;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.jdesktop.swingx.sort.DefaultSortController;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnExt;
import org.pushingpixels.substance.api.renderers.SubstanceDefaultTableCellRenderer;
import org.pushingpixels.substance.api.skin.SkinChangeListener;
import plugins.kernel.roi.descriptor.property.ROINameDescriptor;

public abstract class AbstractRoisPanel
extends ExternalizablePanel
implements ActiveSequenceListener,
IcyTextField.TextChangeListener,
ListSelectionListener,
PluginLoader.PluginLoaderListener {
    protected static final long serialVersionUID = -2870878233087117178L;
    protected static final String ID_VIEW = "view";
    protected static final String ID_EXPORT = "export";
    protected static final String ID_PROPERTY_MINSIZE = "minSize";
    protected static final String ID_PROPERTY_MAXSIZE = "maxSize";
    protected static final String ID_PROPERTY_DEFAULTSIZE = "defaultSize";
    protected static final String ID_PROPERTY_ORDER = "order";
    protected static final String ID_PROPERTY_VISIBLE = "visible";
    protected static Comparator<Object> comparator = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            Object obj1 = o1;
            Object obj2 = o2;
            if (o1 instanceof String) {
                if (o1.equals("-\u221e")) {
                    obj1 = Double.NEGATIVE_INFINITY;
                } else if (o1.equals("\u221e")) {
                    obj1 = Double.POSITIVE_INFINITY;
                }
            }
            if (o2 instanceof String) {
                if (o2.equals("-\u221e")) {
                    obj2 = Double.NEGATIVE_INFINITY;
                } else if (o2.equals("\u221e")) {
                    obj2 = Double.POSITIVE_INFINITY;
                }
            }
            if (obj1 instanceof Number && obj2 instanceof Number) {
                double d1 = ((Number)obj1).doubleValue();
                double d2 = ((Number)obj2).doubleValue();
                if (Double.isNaN(d1)) {
                    if (Double.isNaN(d2)) {
                        return 0;
                    }
                    return -1;
                }
                if (Double.isNaN(d2)) {
                    return 1;
                }
                if (d1 < d2) {
                    return -1;
                }
                if (d1 > d2) {
                    return 1;
                }
                return 0;
            }
            if (obj1 instanceof Comparable && obj1.getClass() == obj2.getClass()) {
                return ((Comparable)obj1).compareTo(obj2);
            }
            return o1.toString().compareTo(o2.toString());
        }
    };
    protected ROITableModel roiTableModel;
    protected ListSelectionModel roiSelectionModel;
    protected JXTable roiTable;
    protected IcyTextField nameFilter;
    protected JLabel roiNumberLabel;
    protected JLabel selectedRoiNumberLabel;
    protected Map<ROIDescriptor, PluginROIDescriptor> descriptorMap;
    protected List<ColumnInfo> columnInfoList;
    protected Set<ROI> roiSet;
    protected Map<ROI, ROIResults> roiResultsMap;
    protected List<ROI> filteredRoiList;
    protected List<ROIResults> filteredRoiResultsList;
    protected List<SequenceEvent> savedSequenceEvents;
    protected final XMLPreferences basePreferences;
    protected final XMLPreferences viewPreferences;
    protected final XMLPreferences exportPreferences;
    protected final Semaphore modifySelection;
    protected final Runnable roiListRefresher;
    protected final Runnable filteredRoiListRefresher;
    protected final Runnable descriptorsValueRefresher;
    protected final Runnable tableDataStructureRefresher;
    protected final Runnable tableDataRefresher;
    protected final Runnable tableSelectionRefresher;
    protected final Runnable columnInfoListRefresher;
    protected final InstanceProcessor processor;
    protected DescriptorComputer primaryDescriptorComputer;
    protected DescriptorComputer basicDescriptorComputer;
    protected DescriptorComputer advancedDescriptorComputer;
    protected long lastTableDataRefresh;

    public AbstractRoisPanel(XMLPreferences preferences) {
        super("ROI", "roiPanel", new Point(100, 100), new Dimension(400, 600));
        this.basePreferences = preferences;
        this.viewPreferences = this.basePreferences.node(ID_VIEW);
        this.exportPreferences = this.basePreferences.node(ID_EXPORT);
        this.roiSet = new HashSet<ROI>();
        this.roiResultsMap = new HashMap<ROI, ROIResults>();
        this.filteredRoiList = new ArrayList<ROI>();
        this.filteredRoiResultsList = new ArrayList<ROIResults>();
        this.savedSequenceEvents = new ArrayList<SequenceEvent>();
        this.modifySelection = new Semaphore(1);
        this.columnInfoList = new ArrayList<ColumnInfo>();
        this.lastTableDataRefresh = 0L;
        this.initialize();
        this.roiListRefresher = new Runnable(){

            @Override
            public void run() {
                AbstractRoisPanel.this.refreshRoisInternal();
            }
        };
        this.filteredRoiListRefresher = new Runnable(){

            @Override
            public void run() {
                AbstractRoisPanel.this.refreshFilteredRoisInternal();
            }
        };
        this.descriptorsValueRefresher = new Runnable(){

            @Override
            public void run() {
                AbstractRoisPanel.this.refreshDescriptorsValueInternal();
            }
        };
        this.tableDataStructureRefresher = new Runnable(){

            @Override
            public void run() {
                AbstractRoisPanel.this.refreshTableDataStructureInternal();
            }
        };
        this.tableDataRefresher = new Runnable(){

            @Override
            public void run() {
                AbstractRoisPanel.this.refreshTableDataInternal();
            }
        };
        this.tableSelectionRefresher = new Runnable(){

            @Override
            public void run() {
                AbstractRoisPanel.this.refreshTableSelectionInternal();
            }
        };
        this.columnInfoListRefresher = new Runnable(){

            @Override
            public void run() {
                AbstractRoisPanel.this.refreshColumnInfoListInternal();
            }
        };
        LookAndFeelUtil.addSkinChangeListener(new SkinChangeListener(){

            public void skinChanged() {
                AbstractRoisPanel.this.roiTable.setColumnModel((TableColumnModel)((Object)new ROITableColumnModel()));
                AbstractRoisPanel.this.roiTable.setHighlighters(new Highlighter[]{HighlighterFactory.createSimpleStriping()});
            }
        });
        this.processor = new InstanceProcessor();
        this.processor.setThreadName("ROI panel GUI refresher");
        this.processor.setKeepAliveTime(30L, TimeUnit.SECONDS);
        this.primaryDescriptorComputer = new DescriptorComputer(DescriptorType.PRIMARY);
        this.basicDescriptorComputer = new DescriptorComputer(DescriptorType.BASIC);
        this.advancedDescriptorComputer = new DescriptorComputer(DescriptorType.EXTERNAL);
        this.primaryDescriptorComputer.start();
        this.basicDescriptorComputer.start();
        this.advancedDescriptorComputer.start();
        this.refreshDescriptorList();
        this.buildActionMap();
        this.refreshRois();
        PluginLoader.addListener(this);
    }

    protected void initialize() {
        this.nameFilter = new IcyTextField();
        this.nameFilter.setToolTipText("Filter ROI by name");
        this.nameFilter.addTextChangeListener(this);
        this.selectedRoiNumberLabel = new JLabel("0");
        this.roiNumberLabel = new JLabel("0");
        this.roiTableModel = new ROITableModel();
        this.roiTable = new JXTable((TableModel)this.roiTableModel);
        this.roiTable.setAutoStartEditOnKeyStroke(false);
        this.roiTable.setAutoCreateRowSorter(false);
        this.roiTable.setAutoCreateColumnsFromModel(false);
        this.roiTable.setShowVerticalLines(false);
        this.roiTable.setColumnControlVisible(false);
        this.roiTable.setColumnSelectionAllowed(false);
        this.roiTable.setRowSelectionAllowed(true);
        this.roiTable.setSortable(true);
        this.roiTable.setHighlighters(new Highlighter[]{HighlighterFactory.createSimpleStriping()});
        this.roiTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                if (event.getClickCount() == 2) {
                    int c = AbstractRoisPanel.this.roiTable.columnAtPoint(event.getPoint());
                    TableColumn col = null;
                    if (c != -1) {
                        col = AbstractRoisPanel.this.roiTable.getColumn(c);
                    }
                    if (col == null || !col.getHeaderValue().equals(new ROINameDescriptor().getName())) {
                        AbstractRoisPanel.this.roiTableDoubleClicked();
                    }
                }
            }
        });
        JTableHeader tableHeader = this.roiTable.getTableHeader();
        tableHeader.setReorderingAllowed(false);
        tableHeader.setResizingAllowed(true);
        this.roiSelectionModel = this.roiTable.getSelectionModel();
        this.roiSelectionModel.addListSelectionListener(this);
        this.roiSelectionModel.setSelectionMode(2);
        this.roiTable.setRowSorter(new ROITableSortController());
        JPanel middlePanel = new JPanel(new BorderLayout(0, 0));
        middlePanel.add((Component)this.roiTable.getTableHeader(), "North");
        middlePanel.add((Component)new JScrollPane((Component)this.roiTable, 22, 31), "Center");
        IcyButton settingButton = new IcyButton(RoiActions.settingAction);
        settingButton.setHideActionText(true);
        settingButton.setFlat(true);
        IcyButton xlsExportButton = new IcyButton(RoiActions.xlsExportAction);
        xlsExportButton.setHideActionText(true);
        xlsExportButton.setFlat(true);
        this.setLayout(new BorderLayout());
        this.add((Component)GuiUtil.createLineBoxPanel(this.nameFilter, Box.createHorizontalStrut(8), this.selectedRoiNumberLabel, new JLabel(" / "), this.roiNumberLabel, Box.createHorizontalStrut(4), settingButton, xlsExportButton), "North");
        this.add((Component)middlePanel, "Center");
        this.validate();
    }

    protected void buildActionMap() {
        InputMap imap = this.roiTable.getInputMap(0);
        ActionMap amap = this.roiTable.getActionMap();
        imap.put(RoiActions.unselectAction.getKeyStroke(), RoiActions.unselectAction.getName());
        imap.put(RoiActions.deleteAction.getKeyStroke(), RoiActions.deleteAction.getName());
        imap.put(KeyStroke.getKeyStroke(8, 0), RoiActions.deleteAction.getName());
        imap.put(RoiActions.copyAction.getKeyStroke(), RoiActions.copyAction.getName());
        imap.put(RoiActions.pasteAction.getKeyStroke(), RoiActions.pasteAction.getName());
        imap.put(RoiActions.copyLinkAction.getKeyStroke(), RoiActions.copyLinkAction.getName());
        imap.put(RoiActions.pasteLinkAction.getKeyStroke(), RoiActions.pasteLinkAction.getName());
        amap.remove("find");
        amap.put(RoiActions.unselectAction.getName(), RoiActions.unselectAction);
        amap.put(RoiActions.deleteAction.getName(), RoiActions.deleteAction);
        amap.put(RoiActions.copyAction.getName(), RoiActions.copyAction);
        amap.put(RoiActions.pasteAction.getName(), RoiActions.pasteAction);
        amap.put(RoiActions.copyLinkAction.getName(), RoiActions.copyLinkAction);
        amap.put(RoiActions.pasteLinkAction.getName(), RoiActions.pasteLinkAction);
    }

    protected ROIResults createNewROIResults(ROI roi) {
        return new ROIResults(roi);
    }

    protected int getChannelCount() {
        Sequence sequence = this.getSequence();
        if (sequence != null) {
            return sequence.getSizeC();
        }
        return 1;
    }

    protected String getChannelNameSuffix(int ch) {
        Sequence sequence = this.getSequence();
        if (sequence != null && ch < this.getChannelCount()) {
            return " (" + sequence.getChannelName(ch) + ")";
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ROIDescriptor getROIDescriptor(String descriptorId) {
        ROIDescriptor[] descriptors;
        Map<ROIDescriptor, PluginROIDescriptor> map = this.descriptorMap;
        synchronized (map) {
            descriptors = this.descriptorMap.keySet().toArray(new ROIDescriptor[this.descriptorMap.size()]);
        }
        ROIDescriptor[] rOIDescriptorArray = descriptors;
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            ROIDescriptor descriptor = rOIDescriptorArray[n2];
            if (descriptor.getId().equals(descriptorId)) {
                return descriptor;
            }
            ++n2;
        }
        return null;
    }

    protected ColumnInfo getColumnInfo(List<ColumnInfo> columns, int column) {
        if (column < columns.size()) {
            return columns.get(column);
        }
        return null;
    }

    protected ColumnInfo getColumnInfo(int column) {
        return this.getColumnInfo(this.columnInfoList, column);
    }

    protected ColumnInfo getColumnInfo(List<ColumnInfo> columns, ROIDescriptor descriptor, int channel) {
        for (ColumnInfo ci : columns) {
            if (!ci.descriptor.equals(descriptor) || ci.channel != channel) continue;
            return ci;
        }
        return null;
    }

    protected ColumnInfo getColumnInfo(ROIDescriptor descriptor, int channel) {
        return this.getColumnInfo(this.columnInfoList, descriptor, channel);
    }

    protected abstract Sequence getSequence();

    public void setNameFilter(String name) {
        this.nameFilter.setText(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected boolean computeROIResults(ROIResults roiResults, Sequence seq, ColumnInfo columnInfo) {
        results = roiResults.descriptorResults;
        descriptor = columnInfo.descriptor;
        var7_6 = results;
        synchronized (var7_6) {
            result = results.get(columnInfo);
        }
        if (result != null && result.isOutdated()) {
            var8_8 = this.descriptorMap;
            synchronized (var8_8) {
                plugin = this.descriptorMap.get(descriptor);
            }
            if (plugin != null) {
                block22: {
                    try {
                        if (descriptor.separateChannel()) {
                            roi = roiResults.getRoiForChannel(columnInfo.channel);
                            if (roi == null) {
                                throw new UnsupportedOperationException("Can't retrieve sub ROI for channel " + columnInfo.channel);
                            }
                            newResults = plugin.compute(roi, seq);
                        } else {
                            newResults = plugin.compute(roiResults.roi, seq);
                        }
                        for (Map.Entry<ROIDescriptor, Object> entryNewResult : newResults.entrySet()) {
                            resultColumnInfo = this.getColumnInfo(entryNewResult.getKey(), columnInfo.channel);
                            var13_17 = results;
                            synchronized (var13_17) {
                                oResult = results.get(resultColumnInfo);
                            }
                            if (oResult == null) continue;
                            oResult.setValue(entryNewResult.getValue());
                            oResult.setOutdated(false);
                        }
                        break block22;
                    }
                    catch (Throwable t) {
                        if (!(t instanceof UnsupportedOperationException) && !(t instanceof InterruptedException)) {
                            IcyExceptionHandler.handleException(t, true);
                        }
                        if ((descriptors = plugin.getDescriptors()) == null) break block22;
                        ** for (desc : descriptors)
                    }
lbl-1000:
                    // 1 sources

                    {
                        resultColumnInfo = this.getColumnInfo(desc, columnInfo.channel);
                        var15_20 = results;
                        synchronized (var15_20) {
                            oResult = results.get(resultColumnInfo);
                        }
                        if (oResult == null) continue;
                        oResult.setValue(null);
                        oResult.setOutdated(false);
                        continue;
                    }
                }
                return true;
            }
        }
        return false;
    }

    protected int getRoiIndex(ROI roi) {
        int result = Collections.binarySearch(this.filteredRoiList, roi, ROI.idComparator);
        if (result >= 0) {
            return result;
        }
        return -1;
    }

    protected int getRoiModelIndex(ROI roi) {
        return this.getRoiIndex(roi);
    }

    protected int getRoiViewIndex(ROI roi) {
        int ind = this.getRoiModelIndex(roi);
        if (ind == -1) {
            return ind;
        }
        try {
            return this.roiTable.convertRowIndexToView(ind);
        }
        catch (IndexOutOfBoundsException e) {
            return -1;
        }
    }

    protected ROIResults getRoiResults(int rowModelIndex) {
        List<ROIResults> entries = this.filteredRoiResultsList;
        if (rowModelIndex >= 0 && rowModelIndex < entries.size()) {
            return entries.get(rowModelIndex);
        }
        return null;
    }

    public List<ROI> getVisibleRois() {
        return new ArrayList<ROI>(this.filteredRoiList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSelectedRoisCount() {
        int result = 0;
        ListSelectionModel listSelectionModel = this.roiSelectionModel;
        synchronized (listSelectionModel) {
            if (!this.roiSelectionModel.isSelectionEmpty()) {
                int i = this.roiSelectionModel.getMinSelectionIndex();
                while (i <= this.roiSelectionModel.getMaxSelectionIndex()) {
                    if (this.roiSelectionModel.isSelectedIndex(i)) {
                        ++result;
                    }
                    ++i;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ROI> getSelectedRois() {
        List<ROIResults> roiResults = this.filteredRoiResultsList;
        ArrayList<ROI> result = new ArrayList<ROI>(roiResults.size());
        ListSelectionModel listSelectionModel = this.roiSelectionModel;
        synchronized (listSelectionModel) {
            if (!this.roiSelectionModel.isSelectionEmpty()) {
                int i = this.roiSelectionModel.getMinSelectionIndex();
                while (i <= this.roiSelectionModel.getMaxSelectionIndex()) {
                    if (this.roiSelectionModel.isSelectedIndex(i)) {
                        try {
                            int index = this.roiTable.convertRowIndexToModel(i);
                            if (index >= 0 && index < roiResults.size()) {
                                result.add(roiResults.get((int)index).roi);
                            }
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            // empty catch block
                        }
                    }
                    ++i;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setSelectedRoisInternal(Set<ROI> newSelected) {
        ArrayList<Integer> selectedIndexes = new ArrayList<Integer>();
        List<ROI> roiList = this.filteredRoiList;
        int i = 0;
        while (i < roiList.size()) {
            ROI roi = roiList.get(i);
            if (newSelected.contains(roi)) {
                int ind;
                try {
                    ind = this.roiTable.convertRowIndexToView(i);
                }
                catch (IndexOutOfBoundsException e) {
                    ind = -1;
                }
                if (ind > -1) {
                    selectedIndexes.add(ind);
                }
            }
            ++i;
        }
        ListSelectionModel listSelectionModel = this.roiSelectionModel;
        synchronized (listSelectionModel) {
            this.roiSelectionModel.setValueIsAdjusting(true);
            try {
                this.roiSelectionModel.clearSelection();
                for (Integer index : selectedIndexes) {
                    this.roiSelectionModel.addSelectionInterval(index, index);
                }
            }
            finally {
                this.roiSelectionModel.setValueIsAdjusting(false);
            }
        }
    }

    protected Set<ROI> getFilteredSet(String filter) {
        Set<ROI> rois = this.roiSet;
        HashSet<ROI> result = new HashSet<ROI>();
        if (StringUtil.isEmpty(filter, true)) {
            result.addAll(rois);
        } else {
            String text = filter.trim().toLowerCase();
            for (ROI roi : rois) {
                if (roi.getName().toLowerCase().indexOf(text) == -1) continue;
                result.add(roi);
            }
        }
        return result;
    }

    public void scrollTo(ROI roi) {
        int index = this.getRoiViewIndex(roi);
        if (index != -1) {
            this.roiTable.scrollRowToVisible(index);
        }
    }

    protected void refreshRoiNumbers() {
        int selectedCount = this.getSelectedRoisCount();
        int roisCount = this.roiTable.getRowCount();
        this.selectedRoiNumberLabel.setText(Integer.toString(selectedCount));
        this.roiNumberLabel.setText(Integer.toString(roisCount));
        if (selectedCount == 0) {
            this.selectedRoiNumberLabel.setToolTipText("No selected ROI");
        } else if (selectedCount == 1) {
            this.selectedRoiNumberLabel.setToolTipText("1 selected ROI");
        } else {
            this.selectedRoiNumberLabel.setToolTipText(String.valueOf(selectedCount) + " selected ROIs");
        }
        if (roisCount == 0) {
            this.roiNumberLabel.setToolTipText("No ROI");
        } else if (roisCount == 1) {
            this.roiNumberLabel.setToolTipText("1 ROI");
        } else {
            this.roiNumberLabel.setToolTipText(String.valueOf(roisCount) + " ROIs");
        }
    }

    protected void refreshRois() {
        this.processor.submit(true, this.roiListRefresher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshRoisInternal() {
        Set<ROI> currentRoiSet = this.roiSet;
        Sequence sequence = this.getSequence();
        HashSet<ROI> newRoiSet = sequence != null ? sequence.getROISet() : new HashSet();
        if (newRoiSet.equals(currentRoiSet)) {
            return;
        }
        HashSet<ROI> removedSet = new HashSet<ROI>();
        for (ROI roi : currentRoiSet) {
            if (newRoiSet.contains(roi)) continue;
            removedSet.add(roi);
        }
        for (ROI roi : removedSet) {
            ROIResults roiResults;
            Map<ROI, ROIResults> map = this.roiResultsMap;
            synchronized (map) {
                roiResults = this.roiResultsMap.remove(roi);
            }
            if (roiResults == null) continue;
            this.cancelDescriptorComputation(roiResults);
        }
        this.primaryDescriptorComputer.interrupt();
        this.basicDescriptorComputer.interrupt();
        this.advancedDescriptorComputer.interrupt();
        this.primaryDescriptorComputer = new DescriptorComputer(DescriptorType.PRIMARY);
        this.basicDescriptorComputer = new DescriptorComputer(DescriptorType.BASIC);
        this.advancedDescriptorComputer = new DescriptorComputer(DescriptorType.EXTERNAL);
        this.primaryDescriptorComputer.start();
        this.basicDescriptorComputer.start();
        this.advancedDescriptorComputer.start();
        this.roiSet = newRoiSet;
        this.refreshFilteredRoisInternal();
    }

    protected void refreshFilteredRois() {
        this.processor.submit(true, this.filteredRoiListRefresher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshFilteredRoisInternal() {
        List<ROI> currentFilteredRoiList = this.filteredRoiList;
        Set<ROI> newFilteredRoiSet = this.getFilteredSet(this.nameFilter.getText());
        if (newFilteredRoiSet.equals(currentFilteredRoiList)) {
            return;
        }
        ArrayList<ROI> newFilteredRoiList = new ArrayList<ROI>(newFilteredRoiSet);
        ArrayList<ROIResults> newFilteredResultsList = new ArrayList<ROIResults>(newFilteredRoiList.size());
        Collections.sort(newFilteredRoiList, ROI.idComparator);
        for (ROI roi : newFilteredRoiList) {
            ROIResults roiResults;
            Map<ROI, ROIResults> map = this.roiResultsMap;
            synchronized (map) {
                roiResults = this.roiResultsMap.get(roi);
                if (roiResults == null) {
                    roiResults = this.createNewROIResults(roi);
                    this.roiResultsMap.put(roi, roiResults);
                }
            }
            newFilteredResultsList.add(roiResults);
        }
        this.filteredRoiList = newFilteredRoiList;
        this.filteredRoiResultsList = newFilteredResultsList;
        this.refreshTableDataStructureInternal();
    }

    public void refreshDescriptorsValue() {
        this.processor.submit(true, this.descriptorsValueRefresher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshDescriptorsValueInternal() {
        ArrayList<SequenceEvent> events;
        ROIResults[] allRoiResults;
        Object object = this.roiResultsMap;
        synchronized (object) {
            allRoiResults = this.roiResultsMap.values().toArray(new ROIResults[this.roiResultsMap.size()]);
        }
        object = this.savedSequenceEvents;
        synchronized (object) {
            events = new ArrayList<SequenceEvent>(this.savedSequenceEvents);
            this.savedSequenceEvents.clear();
        }
        ROIResults[] rOIResultsArray = allRoiResults;
        int n = allRoiResults.length;
        int n2 = 0;
        while (n2 < n) {
            ROIResults roiResults = rOIResultsArray[n2];
            for (SequenceEvent event : events) {
                roiResults.sequenceChanged(event);
            }
            ++n2;
        }
        this.refreshTableData();
    }

    public void refreshTableDataStructure() {
        this.processor.submit(true, this.tableDataStructureRefresher);
    }

    protected void refreshTableDataStructureInternal() {
        ThreadUtil.sleep(1);
        Sequence sequence = this.getSequence();
        final Set<ROI> newSelectedRois = sequence != null ? sequence.getSelectedROISet() : new HashSet<ROI>();
        ThreadUtil.invokeNow(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AbstractRoisPanel.this.modifySelection.acquireUninterruptibly();
                try {
                    ROITableModel rOITableModel = AbstractRoisPanel.this.roiTableModel;
                    synchronized (rOITableModel) {
                        try {
                            AbstractRoisPanel.this.roiTableModel.fireTableDataChanged();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (!newSelectedRois.isEmpty()) {
                        AbstractRoisPanel.this.setSelectedRoisInternal(newSelectedRois);
                    }
                }
                finally {
                    AbstractRoisPanel.this.modifySelection.release();
                }
            }
        });
        this.refreshRoiNumbers();
    }

    public void refreshTableData() {
        this.processor.submit(true, this.tableDataRefresher);
    }

    protected void refreshTableDataInternal() {
        boolean hasPendingTask;
        long time = System.currentTimeMillis();
        boolean bl = hasPendingTask = this.primaryDescriptorComputer.hasPendingComputation() && this.basicDescriptorComputer.hasPendingComputation() && this.advancedDescriptorComputer.hasPendingComputation();
        if (hasPendingTask && time - this.lastTableDataRefresh < 200L) {
            return;
        }
        this.lastTableDataRefresh = time;
        ThreadUtil.sleep(1);
        ThreadUtil.invokeNow(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int rowCount = AbstractRoisPanel.this.roiTable.getRowCount();
                if (rowCount > 0) {
                    int anchorInd = ((DefaultListSelectionModel)AbstractRoisPanel.this.roiSelectionModel).getAnchorSelectionIndex();
                    ROITableModel rOITableModel = AbstractRoisPanel.this.roiTableModel;
                    synchronized (rOITableModel) {
                        try {
                            AbstractRoisPanel.this.roiTableModel.fireTableRowsUpdated(0, rowCount - 1);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (anchorInd != -1) {
                        ((DefaultListSelectionModel)AbstractRoisPanel.this.roiSelectionModel).setAnchorSelectionIndex(anchorInd);
                    }
                }
            }
        });
        this.refreshRoiNumbers();
    }

    public void refreshTableSelection() {
        this.processor.submit(true, this.tableSelectionRefresher);
    }

    protected void refreshTableSelectionInternal() {
        ThreadUtil.sleep(1);
        Sequence sequence = this.getSequence();
        final Set<ROI> newSelectedRois = sequence != null ? sequence.getSelectedROISet() : new HashSet<ROI>();
        ThreadUtil.invokeNow(new Runnable(){

            @Override
            public void run() {
                AbstractRoisPanel.this.modifySelection.acquireUninterruptibly();
                try {
                    AbstractRoisPanel.this.setSelectedRoisInternal(newSelectedRois);
                }
                finally {
                    AbstractRoisPanel.this.modifySelection.release();
                }
            }
        });
        this.refreshRoiNumbers();
    }

    protected void refreshDescriptorList() {
        this.descriptorMap = ROIUtil.getROIDescriptors();
        this.refreshColumnInfoList();
    }

    public void refreshColumnInfoList() {
        this.processor.submit(true, this.columnInfoListRefresher);
    }

    protected void refreshColumnInfoListInternal() {
        ArrayList<ColumnInfo> newColumnInfos = new ArrayList<ColumnInfo>();
        int numChannel = this.getChannelCount();
        for (ROIDescriptor descriptor : this.descriptorMap.keySet()) {
            int ch = 0;
            while (ch < (descriptor.separateChannel() ? numChannel : 1)) {
                newColumnInfos.add(new ColumnInfo(descriptor, ch, this.viewPreferences, false));
                ++ch;
            }
        }
        Collections.sort(newColumnInfos);
        this.columnInfoList = newColumnInfos;
        ThreadUtil.invokeNow(new Runnable(){

            @Override
            public void run() {
                AbstractRoisPanel.this.roiTable.setColumnModel((TableColumnModel)((Object)new ROITableColumnModel()));
            }
        });
    }

    protected void requestDescriptorComputation(ROIResults results) {
        this.primaryDescriptorComputer.requestDescriptorComputation(results);
        this.basicDescriptorComputer.requestDescriptorComputation(results);
        this.advancedDescriptorComputer.requestDescriptorComputation(results);
    }

    protected void cancelDescriptorComputation(ROIResults results) {
        this.primaryDescriptorComputer.cancelDescriptorComputation(results);
        this.basicDescriptorComputer.cancelDescriptorComputation(results);
        this.advancedDescriptorComputer.cancelDescriptorComputation(results);
    }

    protected void cancelDescriptorComputation(ROI roi) {
        this.primaryDescriptorComputer.cancelDescriptorComputation(roi);
        this.basicDescriptorComputer.cancelDescriptorComputation(roi);
        this.advancedDescriptorComputer.cancelDescriptorComputation(roi);
    }

    protected void cancelAllDescriptorComputation() {
        this.primaryDescriptorComputer.cancelAllDescriptorComputation();
        this.basicDescriptorComputer.cancelAllDescriptorComputation();
        this.advancedDescriptorComputer.cancelAllDescriptorComputation();
    }

    @Deprecated
    public String getCSVFormattedInfosOfSelectedRois() {
        int numcols = this.roiTable.getColumnCount();
        int numrows = this.roiTable.getSelectedRowCount();
        if (numrows == 0) {
            return "";
        }
        StringBuffer sbf = new StringBuffer();
        int[] rowsselected = this.roiTable.getSelectedRows();
        int j = 1;
        while (j < numcols) {
            sbf.append(this.roiTable.getModel().getColumnName(j));
            if (j < numcols - 1) {
                sbf.append("\t");
            }
            ++j;
        }
        sbf.append("\r\n");
        int i = 0;
        while (i < numrows) {
            int j2 = 1;
            while (j2 < numcols) {
                Object value = this.roiTable.getModel().getValueAt(this.roiTable.convertRowIndexToModel(rowsselected[i]), j2);
                if (value instanceof double[]) {
                    double[] darray = (double[])value;
                    int l = 0;
                    while (l < darray.length) {
                        sbf.append(darray[l]);
                        if (l < darray.length - 1) {
                            sbf.append(" ");
                        }
                        ++l;
                    }
                } else {
                    sbf.append(value);
                }
                if (j2 < numcols - 1) {
                    sbf.append("\t");
                }
                ++j2;
            }
            sbf.append("\r\n");
            ++i;
        }
        return sbf.toString();
    }

    public String getCSVFormattedInfos() {
        ArrayList<ColumnInfo> exportColumnInfos = new ArrayList<ColumnInfo>();
        Sequence seq = this.getSequence();
        int numChannel = this.getChannelCount();
        for (ROIDescriptor descriptor : this.descriptorMap.keySet()) {
            int ch = 0;
            while (ch < (descriptor.separateChannel() ? numChannel : 1)) {
                exportColumnInfos.add(new ColumnInfo(descriptor, ch, this.exportPreferences, true));
                ++ch;
            }
        }
        Collections.sort(exportColumnInfos);
        StringBuffer sbf = new StringBuffer();
        for (ColumnInfo columnInfo : exportColumnInfos) {
            if (!columnInfo.visible) continue;
            sbf.append(columnInfo.name);
            sbf.append("\t");
        }
        sbf.append("\r\n");
        ArrayList<ROI> rois = new ArrayList<ROI>(this.filteredRoiList);
        for (ROI roi : rois) {
            DescriptorResult result;
            ROIResults results = this.createNewROIResults(roi);
            Map<ColumnInfo, DescriptorResult> descriptorResults = results.descriptorResults;
            for (ColumnInfo columnInfo : exportColumnInfos) {
                if (!columnInfo.visible || (result = descriptorResults.get(columnInfo)) != null) continue;
                descriptorResults.put(columnInfo, new DescriptorResult(columnInfo));
                this.computeROIResults(results, seq, columnInfo);
            }
            for (ColumnInfo columnInfo : exportColumnInfos) {
                if (!columnInfo.visible) continue;
                result = descriptorResults.get(columnInfo);
                String id = columnInfo.descriptor.getId();
                Object value = result != null ? results.formatValue(result.getValue(), id, false) : null;
                if (value != null) {
                    if (StringUtil.equals(id, "Icon")) {
                        sbf.append(roi.getSimpleClassName());
                    } else if (StringUtil.equals(id, "Color")) {
                        sbf.append(String.format("%06X", roi.getColor().getRGB() & 0xFFFFFF));
                    } else {
                        sbf.append(value);
                    }
                }
                sbf.append("\t");
            }
            sbf.append("\r\n");
        }
        return sbf.toString();
    }

    public void showSettingPanel() {
        new RoiSettingFrame(this.viewPreferences, this.exportPreferences, new Runnable(){

            @Override
            public void run() {
                AbstractRoisPanel.this.refreshColumnInfoListInternal();
            }
        });
    }

    @Override
    public void textChanged(IcyTextField source, boolean validate) {
        if (source == this.nameFilter) {
            this.refreshFilteredRois();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        if (this.roiSelectionModel.getValueIsAdjusting()) {
            return;
        }
        if (this.modifySelection.tryAcquire()) {
            try {
                List<ROI> selectedRois = this.getSelectedRois();
                Sequence sequence = this.getSequence();
                if (sequence != null) {
                    sequence.setSelectedROIs(selectedRois);
                }
            }
            finally {
                this.modifySelection.release();
            }
        }
        this.refreshRoiNumbers();
    }

    protected void roiTableDoubleClicked() {
        List<ROI> selectedRois = this.getSelectedRois();
        if (selectedRois.size() > 0) {
            ROI selected = selectedRois.get(0);
            Viewer v = Icy.getMainInterface().getActiveViewer();
            if (v != null && selected != null) {
                IcyCanvas canvas = v.getCanvas();
                if (canvas instanceof IcyCanvas2D) {
                    ((IcyCanvas2D)canvas).centerOn(selected.getBounds5D().toRectangle2D().getBounds());
                } else if (canvas instanceof IcyCanvas3D) {
                    ((IcyCanvas3D)canvas).centerOn(selected.getBounds5D().toRectangle3D().toInteger());
                }
                Rectangle5D bnd = selected.getBounds5D();
                int t = (int)(bnd.isInfiniteT() ? -1.0 : bnd.getCenterT());
                int z = (int)(bnd.isInfiniteZ() ? -1.0 : bnd.getCenterZ());
                if (t != -1) {
                    v.setPositionT(t);
                }
                if (z != -1) {
                    v.setPositionZ(z);
                }
            }
        }
    }

    @Override
    public void sequenceActivated(Sequence value) {
        this.refreshColumnInfoList();
        this.refreshRois();
    }

    @Override
    public void sequenceDeactivated(Sequence sequence) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void activeSequenceChanged(SequenceEvent event) {
        SequenceEvent.SequenceEventSourceType sourceType = event.getSourceType();
        switch (sourceType) {
            case SEQUENCE_ROI: {
                switch (event.getType()) {
                    case ADDED: 
                    case REMOVED: {
                        this.refreshRois();
                        break;
                    }
                }
                List<SequenceEvent> list = this.savedSequenceEvents;
                synchronized (list) {
                    this.savedSequenceEvents.add(event);
                }
                this.refreshDescriptorsValue();
                break;
            }
            case SEQUENCE_META: {
                for (ColumnInfo col : this.columnInfoList) {
                    col.refreshName();
                }
                TableColumnModel model = this.roiTable.getColumnModel();
                if (model instanceof ROITableColumnModel) {
                    ((ROITableColumnModel)((Object)model)).updateHeaders();
                }
            }
            case SEQUENCE_DATA: {
                List<SequenceEvent> list = this.savedSequenceEvents;
                synchronized (list) {
                    this.savedSequenceEvents.add(event);
                }
                this.refreshDescriptorsValue();
                break;
            }
            case SEQUENCE_TYPE: {
                this.refreshColumnInfoList();
            }
        }
    }

    @Override
    public void pluginLoaderChanged(PluginLoader.PluginLoaderEvent e) {
        this.refreshDescriptorList();
    }

    public static class BaseColumnInfo
    implements Comparable<BaseColumnInfo> {
        public final ROIDescriptor descriptor;
        public int minSize;
        public int maxSize;
        public int defaultSize;
        public int order;
        public boolean visible;

        public BaseColumnInfo(ROIDescriptor descriptor, XMLPreferences preferences, boolean export) {
            this.descriptor = descriptor;
            this.load(preferences, export);
        }

        public boolean load(XMLPreferences preferences, boolean export) {
            XMLPreferences p = preferences.node(this.descriptor.getId());
            if (p != null) {
                this.minSize = p.getInt(AbstractRoisPanel.ID_PROPERTY_MINSIZE, this.getDefaultMinSize());
                this.maxSize = p.getInt(AbstractRoisPanel.ID_PROPERTY_MAXSIZE, this.getDefaultMaxSize());
                this.defaultSize = p.getInt(AbstractRoisPanel.ID_PROPERTY_DEFAULTSIZE, this.getDefaultDefaultSize());
                this.order = p.getInt(AbstractRoisPanel.ID_PROPERTY_ORDER, this.getDefaultOrder());
                this.visible = p.getBoolean(AbstractRoisPanel.ID_PROPERTY_VISIBLE, this.getDefaultVisible(export));
                return true;
            }
            return false;
        }

        public boolean save(XMLPreferences preferences) {
            XMLPreferences p = preferences.node(this.descriptor.getId());
            if (p != null) {
                p.putInt(AbstractRoisPanel.ID_PROPERTY_ORDER, this.order);
                p.putBoolean(AbstractRoisPanel.ID_PROPERTY_VISIBLE, this.visible);
                return true;
            }
            return false;
        }

        protected boolean getDefaultVisible(boolean export) {
            if (this.descriptor == null) {
                return false;
            }
            String id = this.descriptor.getId();
            if (export) {
                if (StringUtil.equals(id, "Opacity")) {
                    return false;
                }
                Class<?> type = this.descriptor.getType();
                return ClassUtil.isSubClass(type, String.class) || ClassUtil.isSubClass(type, Number.class);
            }
            if (StringUtil.equals(id, "Icon")) {
                return true;
            }
            if (StringUtil.equals(id, "Name")) {
                return true;
            }
            if (StringUtil.equals(id, "Contour")) {
                return true;
            }
            return StringUtil.equals(id, "Interior");
        }

        protected int getDefaultOrder() {
            if (this.descriptor == null) {
                return Integer.MAX_VALUE;
            }
            String id = this.descriptor.getId();
            int order = -1;
            ++order;
            if (StringUtil.equals(id, "Icon")) {
                return order;
            }
            ++order;
            if (StringUtil.equals(id, "Color")) {
                return order;
            }
            ++order;
            if (StringUtil.equals(id, "Name")) {
                return order;
            }
            ++order;
            if (StringUtil.equals(id, "Position X")) {
                return order;
            }
            ++order;
            if (StringUtil.equals(id, "Position Y")) {
                return order;
            }
            ++order;
            if (StringUtil.equals(id, "Position Z")) {
                return order;
            }
            ++order;
            if (StringUtil.equals(id, "Position T")) {
                return order;
            }
            ++order;
            if (StringUtil.equals(id, "Position C")) {
                return order;
            }
            ++order;
            if (StringUtil.equals(id, "Size X")) {
                return order;
            }
            ++order;
            if (StringUtil.equals(id, "Size Y")) {
                return order;
            }
            ++order;
            if (StringUtil.equals(id, "Size Z")) {
                return order;
            }
            ++order;
            if (StringUtil.equals(id, "Size T")) {
                return order;
            }
            ++order;
            if (StringUtil.equals(id, "Size C")) {
                return order;
            }
            ++order;
            if (StringUtil.equals(id, "Mass center X")) {
                return order;
            }
            ++order;
            if (StringUtil.equals(id, "Mass center Y")) {
                return order;
            }
            ++order;
            if (StringUtil.equals(id, "Mass center Z")) {
                return order;
            }
            ++order;
            if (StringUtil.equals(id, "Mass center T")) {
                return order;
            }
            ++order;
            if (StringUtil.equals(id, "Mass center C")) {
                return order;
            }
            ++order;
            if (StringUtil.equals(id, "Contour")) {
                return order;
            }
            ++order;
            if (StringUtil.equals(id, "Interior")) {
                return order;
            }
            ++order;
            if (StringUtil.equals(id, "Perimeter")) {
                return order;
            }
            ++order;
            if (StringUtil.equals(id, "Area")) {
                return order;
            }
            ++order;
            if (StringUtil.equals(id, "Surface area")) {
                return order;
            }
            ++order;
            if (StringUtil.equals(id, "Volume")) {
                return order;
            }
            ++order;
            if (StringUtil.equals(id, "Min intensity")) {
                return order;
            }
            ++order;
            if (StringUtil.equals(id, "Mean intensity")) {
                return order;
            }
            ++order;
            if (StringUtil.equals(id, "Max intensity")) {
                return order;
            }
            ++order;
            if (StringUtil.equals(id, "Sum intensity")) {
                return order;
            }
            return Integer.MAX_VALUE;
        }

        protected int getDefaultMinSize() {
            if (this.descriptor == null) {
                return Integer.MAX_VALUE;
            }
            String id = this.descriptor.getId();
            if (StringUtil.equals(id, "Icon")) {
                return 22;
            }
            if (StringUtil.equals(id, "Color")) {
                return 18;
            }
            if (StringUtil.equals(id, "Name")) {
                return 60;
            }
            Class<?> type = this.descriptor.getType();
            if (type == Integer.class) {
                return 30;
            }
            if (type == Float.class) {
                return 40;
            }
            if (type == Double.class) {
                return 40;
            }
            if (type == String.class) {
                return 50;
            }
            return 40;
        }

        protected int getDefaultMaxSize() {
            if (this.descriptor == null) {
                return Integer.MAX_VALUE;
            }
            String id = this.descriptor.getId();
            if (StringUtil.equals(id, "Icon")) {
                return 22;
            }
            if (StringUtil.equals(id, "Color")) {
                return 18;
            }
            return Integer.MAX_VALUE;
        }

        protected int getDefaultDefaultSize() {
            int maxSize = this.getDefaultMaxSize();
            int minSize = this.getDefaultMinSize();
            if (maxSize == Integer.MAX_VALUE) {
                return minSize * 2;
            }
            return (minSize + maxSize) / 2;
        }

        protected boolean isPrimaryDescriptor() {
            if (this.descriptor == null) {
                return false;
            }
            String id = this.descriptor.getId();
            return StringUtil.equals(id, "Icon") || StringUtil.equals(id, "Color") || StringUtil.equals(id, "Name") || StringUtil.equals(id, "Position X") || StringUtil.equals(id, "Position Y") || StringUtil.equals(id, "Position Z") || StringUtil.equals(id, "Position T") || StringUtil.equals(id, "Position C") || StringUtil.equals(id, "Size X") || StringUtil.equals(id, "Size Y") || StringUtil.equals(id, "Size Z") || StringUtil.equals(id, "Size T") || StringUtil.equals(id, "Size C");
        }

        protected boolean isBasicDescriptor() {
            if (this.descriptor == null) {
                return false;
            }
            String id = this.descriptor.getId();
            return this.isPrimaryDescriptor() || StringUtil.equals(id, "Mass center X") || StringUtil.equals(id, "Mass center Y") || StringUtil.equals(id, "Mass center Z") || StringUtil.equals(id, "Mass center T") || StringUtil.equals(id, "Mass center C") || StringUtil.equals(id, "Contour") || StringUtil.equals(id, "Interior") || StringUtil.equals(id, "Perimeter") || StringUtil.equals(id, "Area") || StringUtil.equals(id, "Surface area") || StringUtil.equals(id, "Volume") || StringUtil.equals(id, "Min intensity") || StringUtil.equals(id, "Mean intensity") || StringUtil.equals(id, "Max intensity");
        }

        protected boolean isExtendedDescriptor() {
            if (this.descriptor == null) {
                return false;
            }
            return !this.isBasicDescriptor();
        }

        public DescriptorType getDescriptorType() {
            if (this.descriptor == null) {
                return null;
            }
            if (this.isPrimaryDescriptor()) {
                return DescriptorType.PRIMARY;
            }
            if (this.isBasicDescriptor()) {
                return DescriptorType.BASIC;
            }
            return DescriptorType.EXTERNAL;
        }

        @Override
        public int compareTo(BaseColumnInfo obj) {
            return Integer.valueOf(this.order).compareTo(obj.order);
        }

        public int hashCode() {
            return this.descriptor.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof BaseColumnInfo) {
                return ((BaseColumnInfo)obj).descriptor.equals(this.descriptor);
            }
            return super.equals(obj);
        }
    }

    protected class ColumnInfo
    extends BaseColumnInfo {
        boolean showName;
        String name;
        final int channel;

        public ColumnInfo(ROIDescriptor descriptor, int channel, XMLPreferences prefs, boolean export) {
            super(descriptor, prefs, export);
            this.channel = channel;
            this.refreshName();
        }

        protected String getSuffix() {
            String result = "";
            String unit = this.descriptor.getUnit(AbstractRoisPanel.this.getSequence());
            if (!StringUtil.isEmpty(unit)) {
                result = String.valueOf(result) + " (" + unit + ")";
            }
            if (this.descriptor.separateChannel()) {
                result = String.valueOf(result) + AbstractRoisPanel.this.getChannelNameSuffix(this.channel);
            }
            return result;
        }

        protected void refreshName() {
            this.name = String.valueOf(this.descriptor.getName()) + this.getSuffix();
            String id = this.descriptor.getId();
            this.showName = !StringUtil.equals(id, "Icon") && !StringUtil.equals(id, "Color");
        }

        @Override
        public int hashCode() {
            return this.descriptor.hashCode() ^ this.channel;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof ColumnInfo) {
                ColumnInfo ci = (ColumnInfo)obj;
                return ci.descriptor.equals(this.descriptor) && ci.channel == ci.channel;
            }
            return super.equals(obj);
        }
    }

    protected class DescriptorComputer
    extends Thread {
        protected final LinkedHashSet<ROIResults> resultsToCompute;
        protected final DescriptorType type;

        public DescriptorComputer(DescriptorType type) {
            super("ROI " + type.toString() + " descriptor calculator");
            this.resultsToCompute = new LinkedHashSet(256);
            this.type = type;
            this.setPriority(1);
        }

        public boolean hasPendingComputation() {
            return this.resultsToCompute.size() > 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasPendingComputation(ROIResults results) {
            LinkedHashSet<ROIResults> linkedHashSet = this.resultsToCompute;
            synchronized (linkedHashSet) {
                return this.resultsToCompute.contains(results);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestDescriptorComputation(ROIResults results) {
            LinkedHashSet<ROIResults> linkedHashSet = this.resultsToCompute;
            synchronized (linkedHashSet) {
                this.resultsToCompute.add(results);
                this.resultsToCompute.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancelDescriptorComputation(ROIResults roiResults) {
            LinkedHashSet<ROIResults> linkedHashSet = this.resultsToCompute;
            synchronized (linkedHashSet) {
                this.resultsToCompute.remove(roiResults);
                this.resultsToCompute.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancelDescriptorComputation(ROI roi) {
            LinkedHashSet<ROIResults> linkedHashSet = this.resultsToCompute;
            synchronized (linkedHashSet) {
                Iterator it = this.resultsToCompute.iterator();
                while (it.hasNext()) {
                    ROIResults roiResults = (ROIResults)it.next();
                    if (roiResults.roi != roi) continue;
                    it.remove();
                }
                this.resultsToCompute.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancelAllDescriptorComputation() {
            LinkedHashSet<ROIResults> linkedHashSet = this.resultsToCompute;
            synchronized (linkedHashSet) {
                this.resultsToCompute.clear();
                this.resultsToCompute.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (!DescriptorComputer.interrupted()) {
                    ROIResults roiResults;
                    LinkedHashSet<ROIResults> linkedHashSet = this.resultsToCompute;
                    synchronized (linkedHashSet) {
                        while (this.resultsToCompute.isEmpty()) {
                            this.resultsToCompute.wait();
                        }
                        roiResults = (ROIResults)this.resultsToCompute.iterator().next();
                        this.resultsToCompute.remove(roiResults);
                    }
                    Sequence seq = AbstractRoisPanel.this.getSequence();
                    if (seq == null) continue;
                    this.computeROIResults(roiResults, seq);
                }
            }
            catch (InterruptedException roiResults) {
            }
            catch (Throwable t) {
                System.err.println("Error while computing ROI descriptors:");
                System.err.println(t.getMessage());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void computeROIResults(ROIResults roiResults, Sequence seq) {
            ColumnInfo[] columnInfos;
            Map<ColumnInfo, DescriptorResult> results;
            Map<ColumnInfo, DescriptorResult> map = results = roiResults.descriptorResults;
            synchronized (map) {
                columnInfos = results.keySet().toArray(new ColumnInfo[results.size()]);
            }
            boolean needUpdate = false;
            ColumnInfo[] columnInfoArray = columnInfos;
            int n = columnInfos.length;
            int n2 = 0;
            while (n2 < n) {
                ColumnInfo columnInfo = columnInfoArray[n2];
                if (columnInfo.getDescriptorType() == this.type) {
                    needUpdate |= AbstractRoisPanel.this.computeROIResults(roiResults, seq, columnInfo);
                }
                ++n2;
            }
            if (needUpdate) {
                AbstractRoisPanel.this.refreshTableData();
            }
        }
    }

    protected class DescriptorResult {
        private Object value = null;
        private boolean outdated = true;

        public DescriptorResult(ColumnInfo column) {
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public boolean isOutdated() {
            return this.outdated;
        }

        public void setOutdated(boolean value) {
            this.outdated = value;
        }
    }

    public static enum DescriptorType {
        PRIMARY,
        BASIC,
        EXTERNAL;

    }

    protected class ROIResults
    implements ROIListener {
        public final Map<ColumnInfo, DescriptorResult> descriptorResults;
        public final ROI roi;
        private final Map<Integer, WeakReference<ROI>> channelRois;

        protected ROIResults(ROI roi) {
            this.roi = roi;
            this.descriptorResults = new HashMap<ColumnInfo, DescriptorResult>();
            this.channelRois = new HashMap<Integer, WeakReference<ROI>>();
            roi.addListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void clearChannelRois() {
            Map<Integer, WeakReference<ROI>> map = this.channelRois;
            synchronized (map) {
                this.channelRois.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ROI getRoiForChannel(int channel) {
            WeakReference<ROI> reference;
            Integer key = channel;
            Map<Integer, WeakReference<ROI>> map = this.channelRois;
            synchronized (map) {
                reference = this.channelRois.get(key);
            }
            ROI result = reference != null ? (ROI)reference.get() : null;
            if (result == null) {
                result = this.roi.getSubROI(-1, -1, channel);
                if (result == null) {
                    result = this.roi.getSubROI(-1, -1, channel);
                }
                if (result != null) {
                    map = this.channelRois;
                    synchronized (map) {
                        this.channelRois.put(key, new WeakReference<ROI>(result));
                    }
                }
            }
            return result;
        }

        public boolean isEditable(int column) {
            ColumnInfo ci = AbstractRoisPanel.this.getColumnInfo(column);
            if (ci != null) {
                ROIDescriptor descriptor = ci.descriptor;
                String id = descriptor.getId();
                return id.equals("Name") || id.equals("Color");
            }
            return false;
        }

        public Object formatValue(Object value, String id) {
            return this.formatValue(value, id, true);
        }

        public Object formatValue(Object value, String id, boolean truncateDouble) {
            Object result = value;
            if (result instanceof Number) {
                double doubleValue = ((Number)result).doubleValue();
                if (doubleValue == Double.POSITIVE_INFINITY) {
                    result = id.equals("Position Z") || id.equals("Position T") || id.equals("Position C") ? "ALL" : "\u221e";
                } else if (doubleValue == Double.NEGATIVE_INFINITY) {
                    result = id.equals("Position X") || id.equals("Position Y") || id.equals("Position Z") || id.equals("Position T") || id.equals("Position C") || id.equals("Mass center X") || id.equals("Mass center Y") || id.equals("Mass center Z") || id.equals("Mass center T") || id.equals("Mass center C") ? "ALL" : "-\u221e";
                } else if (doubleValue == -1.0) {
                    if (id.equals("Position X") || id.equals("Position Y") || id.equals("Position Z") || id.equals("Position T") || id.equals("Position C") || id.equals("Mass center X") || id.equals("Mass center Y") || id.equals("Mass center Z") || id.equals("Mass center T") || id.equals("Mass center C")) {
                        result = "ALL";
                    }
                } else {
                    result = truncateDouble ? (Number)(Math.abs(doubleValue) < 1.0E7 ? (Number)(doubleValue == (double)((int)doubleValue) ? (Number)((int)doubleValue) : (Number)(Math.abs(doubleValue) < 100.0 ? (Number)MathUtil.roundSignificant(doubleValue, 5) : (Number)(Math.abs(doubleValue) < 10000.0 ? (Number)MathUtil.round(doubleValue, 2) : (Number)(Math.abs(doubleValue) < 1000000.0 ? (Number)MathUtil.round(doubleValue, 1) : (Number)((int)Math.round(doubleValue)))))) : (Number)MathUtil.roundSignificant(doubleValue, 5)) : (Number)(value instanceof Long || value instanceof Integer || value instanceof Short || value instanceof Byte ? (Number)((Number)value).longValue() : (Number)doubleValue);
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DescriptorResult getDescriptorResult(ColumnInfo column) {
            DescriptorResult result;
            Map<ColumnInfo, DescriptorResult> map = this.descriptorResults;
            synchronized (map) {
                result = this.descriptorResults.get(column);
                if (result == null) {
                    result = new DescriptorResult(column);
                    this.descriptorResults.put(column, result);
                }
            }
            return result;
        }

        public Object getValue(ColumnInfo column) {
            DescriptorResult result = this.getDescriptorResult(column);
            if (result.isOutdated()) {
                AbstractRoisPanel.this.requestDescriptorComputation(this);
            }
            return this.formatValue(result.getValue(), column.descriptor.getId());
        }

        public Object getValueAt(int column) {
            ColumnInfo ci = AbstractRoisPanel.this.getColumnInfo(column);
            if (ci != null) {
                return this.getValue(ci);
            }
            return null;
        }

        public void setValueAt(Object aValue, int column) {
            ColumnInfo ci = AbstractRoisPanel.this.getColumnInfo(column);
            if (ci != null) {
                ROIDescriptor descriptor = ci.descriptor;
                String id = descriptor.getId();
                if (id.equals("Name")) {
                    this.roi.setName((String)aValue);
                } else if (id.equals("Color")) {
                    this.roi.setColor((Color)aValue);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void roiChanged(ROIEvent event) {
            switch (event.getType()) {
                case ROI_CHANGED: 
                case PROPERTY_CHANGED: {
                    Object[] entries;
                    Map<ColumnInfo, DescriptorResult> map = this.descriptorResults;
                    synchronized (map) {
                        entries = this.descriptorResults.entrySet().toArray();
                    }
                    Object[] objectArray = entries;
                    int n = entries.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DescriptorResult result;
                        Object entryObj = objectArray[n2];
                        Map.Entry entry = (Map.Entry)entryObj;
                        ColumnInfo key = (ColumnInfo)entry.getKey();
                        ROIDescriptor descriptor = key.descriptor;
                        if (descriptor.needRecompute(event) && (result = (DescriptorResult)entry.getValue()) != null) {
                            result.setOutdated(true);
                        }
                        ++n2;
                    }
                    if (event.getType() == ROIEvent.ROIEventType.ROI_CHANGED) {
                        this.clearChannelRois();
                    }
                    AbstractRoisPanel.this.refreshTableData();
                    break;
                }
                case SELECTION_CHANGED: {
                    if (AbstractRoisPanel.this.modifySelection.availablePermits() <= 0) break;
                    AbstractRoisPanel.this.refreshTableSelection();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sequenceChanged(SequenceEvent event) {
            Object[] entries;
            Map<ColumnInfo, DescriptorResult> map = this.descriptorResults;
            synchronized (map) {
                entries = this.descriptorResults.entrySet().toArray();
            }
            Object[] objectArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                DescriptorResult result;
                Object entryObj = objectArray[n2];
                Map.Entry entry = (Map.Entry)entryObj;
                ColumnInfo key = (ColumnInfo)entry.getKey();
                ROIDescriptor descriptor = key.descriptor;
                if (descriptor.needRecompute(event) && (result = (DescriptorResult)entry.getValue()) != null) {
                    result.setOutdated(true);
                }
                ++n2;
            }
        }
    }

    protected class ROITableColumnModel
    extends DefaultTableColumnModelExt {
        private static final long serialVersionUID = -8024047283485991234L;

        public ROITableColumnModel() {
            List<ColumnInfo> columnInfos = AbstractRoisPanel.this.columnInfoList;
            int index = 0;
            for (ColumnInfo ci : columnInfos) {
                ROIDescriptor descriptor = ci.descriptor;
                TableColumnExt column = new TableColumnExt(index++);
                column.setIdentifier((Object)descriptor.getId());
                column.setMinWidth(ci.minSize);
                column.setPreferredWidth(ci.defaultSize);
                if (ci.maxSize != Integer.MAX_VALUE) {
                    column.setMaxWidth(ci.maxSize);
                }
                if (ci.minSize == ci.maxSize) {
                    column.setResizable(false);
                }
                column.setHeaderValue((Object)(ci.showName ? ci.name : ""));
                column.setToolTipText(String.valueOf(descriptor.getDescription()) + ci.getSuffix());
                column.setVisible(ci.visible);
                column.setSortable(true);
                Class<?> type = descriptor.getType();
                if (type == Image.class) {
                    column.setCellRenderer((TableCellRenderer)((Object)new ImageTableCellRenderer(18)));
                } else if (type == Color.class) {
                    column.setCellRenderer((TableCellRenderer)((Object)new ImageTableCellRenderer(16)));
                } else if (ClassUtil.isSubClass(type, Number.class)) {
                    column.setCellRenderer((TableCellRenderer)new SubstanceDefaultTableCellRenderer.NumberRenderer());
                }
                this.addColumn((TableColumn)column);
            }
            this.setColumnSelectionAllowed(false);
        }

        public void updateHeaders() {
            List<ColumnInfo> columnInfos = AbstractRoisPanel.this.columnInfoList;
            List columns = this.getColumns(true);
            for (TableColumn column : columns) {
                ColumnInfo ci = AbstractRoisPanel.this.getColumnInfo(columnInfos, column.getModelIndex());
                if (ci == null) continue;
                ROIDescriptor descriptor = ci.descriptor;
                if (!StringUtil.equals((String)column.getIdentifier(), descriptor.getId())) continue;
                column.setHeaderValue(ci.showName ? ci.name : "");
                if (!(column instanceof TableColumnExt)) continue;
                ((TableColumnExt)column).setToolTipText(String.valueOf(descriptor.getDescription()) + ci.getSuffix());
            }
        }
    }

    protected class ROITableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -6537163170625368503L;

        @Override
        public int getColumnCount() {
            return AbstractRoisPanel.this.columnInfoList.size();
        }

        @Override
        public String getColumnName(int column) {
            ColumnInfo ci = AbstractRoisPanel.this.getColumnInfo(column);
            if (ci != null && ci.showName) {
                return ci.name;
            }
            return "";
        }

        @Override
        public Class<?> getColumnClass(int column) {
            ColumnInfo ci = AbstractRoisPanel.this.getColumnInfo(column);
            if (ci != null) {
                return ci.descriptor.getType();
            }
            return String.class;
        }

        @Override
        public int getRowCount() {
            return AbstractRoisPanel.this.filteredRoiResultsList.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            ROIResults roiResults = AbstractRoisPanel.this.getRoiResults(row);
            if (roiResults != null) {
                return roiResults.getValueAt(column);
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            ROIResults roiResults = AbstractRoisPanel.this.getRoiResults(row);
            if (roiResults != null) {
                roiResults.setValueAt(value, column);
            }
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            ROIResults roiResults = AbstractRoisPanel.this.getRoiResults(row);
            if (roiResults != null) {
                return roiResults.isEditable(column);
            }
            return false;
        }
    }

    protected class ROITableSortController<M extends TableModel>
    extends DefaultSortController<M> {
        public ROITableSortController() {
            this.cachedModelRowCount = AbstractRoisPanel.this.roiTableModel.getRowCount();
            this.setModelWrapper(new TableRowSorterModelWrapper());
        }

        public void sort() {
            try {
                super.sort();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public int convertRowIndexToModel(int index) {
            try {
                return super.convertRowIndexToModel(index);
            }
            catch (Exception e) {
                return 0;
            }
        }

        public Comparator<?> getComparator(int column) {
            return comparator;
        }

        protected boolean useToString(int column) {
            return false;
        }

        private class TableRowSorterModelWrapper
        extends DefaultRowSorter.ModelWrapper<M, Integer> {
            @Override
            public M getModel() {
                return ((ROITableSortController)ROITableSortController.this).AbstractRoisPanel.this.roiTableModel;
            }

            @Override
            public int getColumnCount() {
                return ((ROITableSortController)ROITableSortController.this).AbstractRoisPanel.this.roiTableModel.getColumnCount();
            }

            @Override
            public int getRowCount() {
                return ((ROITableSortController)ROITableSortController.this).AbstractRoisPanel.this.roiTableModel.getRowCount();
            }

            @Override
            public Object getValueAt(int row, int column) {
                return ((ROITableSortController)ROITableSortController.this).AbstractRoisPanel.this.roiTableModel.getValueAt(row, column);
            }

            @Override
            public String getStringValueAt(int row, int column) {
                return ROITableSortController.this.getStringValueProvider().getStringValue(row, column).getString(this.getValueAt(row, column));
            }

            @Override
            public Integer getIdentifier(int index) {
                return index;
            }
        }
    }
}

