/*
 * Decompiled with CFR 0.152.
 */
package plugins.ylemontag.mathoperations.operations;

import icy.sequence.Sequence;
import plugins.ylemontag.mathoperations.Controller;
import plugins.ylemontag.mathoperations.Functor;
import plugins.ylemontag.mathoperations.Operation;
import plugins.ylemontag.mathoperations.SubSequence;
import plugins.ylemontag.mathoperations.functors.Functor1;

public enum Operation1 implements Operation
{
    ABS("Absolute value", "abs(%s)", new Functor.FunPtr(){

        @Override
        public double apply(double[] in) {
            return Math.abs(in[0]);
        }
    }),
    SIGN("Sign", "sign(%s)", new Functor.FunPtr(){

        @Override
        public double apply(double[] in) {
            return Math.signum(in[0]);
        }
    }),
    SQRT("Square root", "sqrt(%s)", new Functor.FunPtr(){

        @Override
        public double apply(double[] in) {
            return Math.sqrt(in[0]);
        }
    }),
    EXP("Exponent", "exp(%s)", new Functor.FunPtr(){

        @Override
        public double apply(double[] in) {
            return Math.exp(in[0]);
        }
    }),
    LOG("Natural logarithm", "log(%s)", new Functor.FunPtr(){

        @Override
        public double apply(double[] in) {
            return Math.log(in[0]);
        }
    }),
    LOG10("Base 10 logarithm", "log10(%s)", new Functor.FunPtr(){

        @Override
        public double apply(double[] in) {
            return Math.log10(in[0]);
        }
    }),
    COS("Cosine", "cos(%s)", new Functor.FunPtr(){

        @Override
        public double apply(double[] in) {
            return Math.cos(in[0]);
        }
    }),
    SIN("Sine", "sin(%s)", new Functor.FunPtr(){

        @Override
        public double apply(double[] in) {
            return Math.sin(in[0]);
        }
    }),
    TAN("Tangent", "tan(%s)", new Functor.FunPtr(){

        @Override
        public double apply(double[] in) {
            return Math.tan(in[0]);
        }
    }),
    ACOS("Arc cosine", "acos(%s)", new Functor.FunPtr(){

        @Override
        public double apply(double[] in) {
            return Math.acos(in[0]);
        }
    }),
    ASIN("Arc sine", "asin(%s)", new Functor.FunPtr(){

        @Override
        public double apply(double[] in) {
            return Math.asin(in[0]);
        }
    }),
    ATAN("Arc tangent", "atan(%s)", new Functor.FunPtr(){

        @Override
        public double apply(double[] in) {
            return Math.atan(in[0]);
        }
    }),
    COSH("Hyperbolic cosine", "cosh(%s)", new Functor.FunPtr(){

        @Override
        public double apply(double[] in) {
            return Math.cosh(in[0]);
        }
    }),
    SINH("Hyperbolic sine", "sinh(%s)", new Functor.FunPtr(){

        @Override
        public double apply(double[] in) {
            return Math.sinh(in[0]);
        }
    }),
    TANH("Hyperbolic tangent", "tanh(%s)", new Functor.FunPtr(){

        @Override
        public double apply(double[] in) {
            return Math.tanh(in[0]);
        }
    }),
    ROUND("Round", "round(%s)", new Functor.FunPtr(){

        @Override
        public double apply(double[] in) {
            return Math.round(in[0]);
        }
    }),
    FLOOR("Floor", "floor(%s)", new Functor.FunPtr(){

        @Override
        public double apply(double[] in) {
            return Math.floor(in[0]);
        }
    }),
    CEIL("Ceiling", "ceil(%s)", new Functor.FunPtr(){

        @Override
        public double apply(double[] in) {
            return Math.ceil(in[0]);
        }
    }),
    COPY("Copy", "copy(%s)", new Functor.FunPtr(){

        @Override
        public double apply(double[] in) {
            return in[0];
        }
    });

    private String _functionName;
    private Functor1 _functor;

    private Operation1(String functionName, String describePattern, Functor.FunPtr functionPointer) {
        this._functionName = functionName;
        this._functor = new Functor1(describePattern, functionPointer);
    }

    public String toString() {
        return this._functionName;
    }

    @Override
    public String getFunctionName() {
        return this._functionName;
    }

    @Override
    public Functor getRawFunctor() {
        return this._functor;
    }

    public Functor1 getFunctor() {
        return this._functor;
    }

    public String describeOperation(String in1) {
        return this._functor.describeOperation(in1);
    }

    public double apply(double in1) {
        return this._functor.apply(in1);
    }

    public double[] apply(double[] in1) {
        return this._functor.apply(in1);
    }

    public Sequence apply(Sequence in1) {
        return this._functor.apply(in1);
    }

    public Sequence apply(SubSequence in1) {
        return this._functor.apply(in1);
    }

    public void apply(double[] out, double[] in1) {
        this._functor.apply(out, in1);
    }

    public void apply(Sequence out, Sequence in1) {
        this._functor.apply(out, in1);
    }

    public void apply(Sequence out, SubSequence in1) {
        this._functor.apply(out, in1);
    }

    public double[] apply(double[] in1, Controller controller) throws Controller.CanceledByUser {
        return this._functor.apply(in1, controller);
    }

    public Sequence apply(Sequence in1, Controller controller) throws Controller.CanceledByUser {
        return this._functor.apply(in1, controller);
    }

    public Sequence apply(SubSequence in1, Controller controller) throws Controller.CanceledByUser {
        return this._functor.apply(in1, controller);
    }

    public void apply(double[] out, double[] in1, Controller controller) throws Controller.CanceledByUser {
        this._functor.apply(out, in1, controller);
    }

    public void apply(Sequence out, Sequence in1, Controller controller) throws Controller.CanceledByUser {
        this._functor.apply(out, in1, controller);
    }

    public void apply(Sequence out, SubSequence in1, Controller controller) throws Controller.CanceledByUser {
        this._functor.apply(out, in1, controller);
    }
}

