/*
 * Decompiled with CFR 0.152.
 */
package org.jtransforms.dct;

import java.util.concurrent.Future;
import org.jtransforms.dct.FloatDCT_1D;
import org.jtransforms.utils.ConcurrencyUtils;
import pl.edu.icm.jlargearrays.FloatLargeArray;

public class FloatDCT_2D {
    private int rows;
    private int columns;
    private long rowsl;
    private long columnsl;
    private FloatDCT_1D dctColumns;
    private FloatDCT_1D dctRows;
    private boolean isPowerOfTwo = false;
    private boolean useThreads = false;

    public FloatDCT_2D(long l, long l2) {
        if (l <= 1L || l2 <= 1L) {
            throw new IllegalArgumentException("rows and columns must be greater than 1");
        }
        this.rows = (int)l;
        this.columns = (int)l2;
        this.rowsl = l;
        this.columnsl = l2;
        if (l * l2 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            this.useThreads = true;
        }
        if (ConcurrencyUtils.isPowerOf2(l) && ConcurrencyUtils.isPowerOf2(l2)) {
            this.isPowerOfTwo = true;
        }
        long l3 = ConcurrencyUtils.getLargeArraysBeginN();
        if (l * l2 > 0x10000000L) {
            ConcurrencyUtils.setLargeArraysBeginN(Math.min(l, l2));
        }
        this.dctRows = new FloatDCT_1D(l);
        this.dctColumns = l == l2 ? this.dctRows : new FloatDCT_1D(l2);
        ConcurrencyUtils.setLargeArraysBeginN(l3);
    }

    public void forward(final float[] fArray, final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (n > 1 && this.useThreads) {
                this.ddxt2d_subth(-1, fArray, bl);
                this.ddxt2d0_subth(-1, fArray, bl);
            } else {
                this.ddxt2d_sub(-1, fArray, bl);
                for (int i = 0; i < this.rows; ++i) {
                    this.dctColumns.forward(fArray, i * this.columns, bl);
                }
            }
        } else if (n > 1 && this.useThreads && this.rows >= n && this.columns >= n) {
            int n2;
            int n3;
            int n4;
            Future[] futureArray = new Future[n];
            int n5 = this.rows / n;
            for (n4 = 0; n4 < n; ++n4) {
                n3 = n4 * n5;
                n2 = n4 == n - 1 ? this.rows : n3 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n3; i < n2; ++i) {
                            FloatDCT_2D.this.dctColumns.forward(fArray, i * FloatDCT_2D.this.columns, bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n5 = this.columns / n;
            for (n4 = 0; n4 < n; ++n4) {
                n3 = n4 * n5;
                n2 = n4 == n - 1 ? this.columns : n3 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] fArray2 = new float[FloatDCT_2D.this.rows];
                        for (int i = n3; i < n2; ++i) {
                            int n;
                            for (n = 0; n < FloatDCT_2D.this.rows; ++n) {
                                fArray2[n] = fArray[n * FloatDCT_2D.this.columns + i];
                            }
                            FloatDCT_2D.this.dctRows.forward(fArray2, bl);
                            for (n = 0; n < FloatDCT_2D.this.rows; ++n) {
                                fArray[n * ((FloatDCT_2D)FloatDCT_2D.this).columns + i] = fArray2[n];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                this.dctColumns.forward(fArray, i * this.columns, bl);
            }
            float[] fArray2 = new float[this.rows];
            for (int i = 0; i < this.columns; ++i) {
                int n6;
                for (n6 = 0; n6 < this.rows; ++n6) {
                    fArray2[n6] = fArray[n6 * this.columns + i];
                }
                this.dctRows.forward(fArray2, bl);
                for (n6 = 0; n6 < this.rows; ++n6) {
                    fArray[n6 * this.columns + i] = fArray2[n6];
                }
            }
        }
    }

    public void forward(final FloatLargeArray floatLargeArray, final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (n > 1 && this.useThreads) {
                this.ddxt2d_subth(-1, floatLargeArray, bl);
                this.ddxt2d0_subth(-1, floatLargeArray, bl);
            } else {
                this.ddxt2d_sub(-1, floatLargeArray, bl);
                for (long i = 0L; i < this.rowsl; ++i) {
                    this.dctColumns.forward(floatLargeArray, i * this.columnsl, bl);
                }
            }
        } else if (n > 1 && this.useThreads && this.rowsl >= (long)n && this.columnsl >= (long)n) {
            long l;
            long l2;
            int n2;
            Future[] futureArray = new Future[n];
            long l3 = this.rowsl / (long)n;
            for (n2 = 0; n2 < n; ++n2) {
                l2 = (long)n2 * l3;
                l = n2 == n - 1 ? this.rowsl : l2 + l3;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l2; i < l; ++i) {
                            FloatDCT_2D.this.dctColumns.forward(floatLargeArray, i * FloatDCT_2D.this.columnsl, bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            l3 = this.columnsl / (long)n;
            for (n2 = 0; n2 < n; ++n2) {
                l2 = (long)n2 * l3;
                l = n2 == n - 1 ? this.columnsl : l2 + l3;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        FloatLargeArray floatLargeArray2 = new FloatLargeArray(FloatDCT_2D.this.rowsl, false);
                        for (long i = l2; i < l; ++i) {
                            long l3;
                            for (l3 = 0L; l3 < FloatDCT_2D.this.rowsl; ++l3) {
                                floatLargeArray2.setFloat(l3, floatLargeArray.getFloat(l3 * FloatDCT_2D.this.columnsl + i));
                            }
                            FloatDCT_2D.this.dctRows.forward(floatLargeArray2, bl);
                            for (l3 = 0L; l3 < FloatDCT_2D.this.rowsl; ++l3) {
                                floatLargeArray.setFloat(l3 * FloatDCT_2D.this.columnsl + i, floatLargeArray2.getFloat(l3));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (long i = 0L; i < this.rowsl; ++i) {
                this.dctColumns.forward(floatLargeArray, i * this.columnsl, bl);
            }
            FloatLargeArray floatLargeArray2 = new FloatLargeArray(this.rowsl, false);
            for (long i = 0L; i < this.columnsl; ++i) {
                long l;
                for (l = 0L; l < this.rowsl; ++l) {
                    floatLargeArray2.setFloat(l, floatLargeArray.getFloat(l * this.columnsl + i));
                }
                this.dctRows.forward(floatLargeArray2, bl);
                for (l = 0L; l < this.rowsl; ++l) {
                    floatLargeArray.setFloat(l * this.columnsl + i, floatLargeArray2.getFloat(l));
                }
            }
        }
    }

    public void forward(final float[][] fArray, final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (n > 1 && this.useThreads) {
                this.ddxt2d_subth(-1, fArray, bl);
                this.ddxt2d0_subth(-1, fArray, bl);
            } else {
                this.ddxt2d_sub(-1, fArray, bl);
                for (int i = 0; i < this.rows; ++i) {
                    this.dctColumns.forward(fArray[i], bl);
                }
            }
        } else if (n > 1 && this.useThreads && this.rows >= n && this.columns >= n) {
            int n2;
            int n3;
            int n4;
            Future[] futureArray = new Future[n];
            int n5 = this.rows / n;
            for (n4 = 0; n4 < n; ++n4) {
                n3 = n4 * n5;
                n2 = n4 == n - 1 ? this.rows : n3 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n3; i < n2; ++i) {
                            FloatDCT_2D.this.dctColumns.forward(fArray[i], bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n5 = this.columns / n;
            for (n4 = 0; n4 < n; ++n4) {
                n3 = n4 * n5;
                n2 = n4 == n - 1 ? this.columns : n3 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] fArray2 = new float[FloatDCT_2D.this.rows];
                        for (int i = n3; i < n2; ++i) {
                            int n;
                            for (n = 0; n < FloatDCT_2D.this.rows; ++n) {
                                fArray2[n] = fArray[n][i];
                            }
                            FloatDCT_2D.this.dctRows.forward(fArray2, bl);
                            for (n = 0; n < FloatDCT_2D.this.rows; ++n) {
                                fArray[n][i] = fArray2[n];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                this.dctColumns.forward(fArray[i], bl);
            }
            float[] fArray2 = new float[this.rows];
            for (int i = 0; i < this.columns; ++i) {
                int n6;
                for (n6 = 0; n6 < this.rows; ++n6) {
                    fArray2[n6] = fArray[n6][i];
                }
                this.dctRows.forward(fArray2, bl);
                for (n6 = 0; n6 < this.rows; ++n6) {
                    fArray[n6][i] = fArray2[n6];
                }
            }
        }
    }

    public void inverse(final float[] fArray, final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (n > 1 && this.useThreads) {
                this.ddxt2d_subth(1, fArray, bl);
                this.ddxt2d0_subth(1, fArray, bl);
            } else {
                this.ddxt2d_sub(1, fArray, bl);
                for (int i = 0; i < this.rows; ++i) {
                    this.dctColumns.inverse(fArray, i * this.columns, bl);
                }
            }
        } else if (n > 1 && this.useThreads && this.rows >= n && this.columns >= n) {
            int n2;
            int n3;
            int n4;
            Future[] futureArray = new Future[n];
            int n5 = this.rows / n;
            for (n4 = 0; n4 < n; ++n4) {
                n3 = n4 * n5;
                n2 = n4 == n - 1 ? this.rows : n3 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n3; i < n2; ++i) {
                            FloatDCT_2D.this.dctColumns.inverse(fArray, i * FloatDCT_2D.this.columns, bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n5 = this.columns / n;
            for (n4 = 0; n4 < n; ++n4) {
                n3 = n4 * n5;
                n2 = n4 == n - 1 ? this.columns : n3 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] fArray2 = new float[FloatDCT_2D.this.rows];
                        for (int i = n3; i < n2; ++i) {
                            int n;
                            for (n = 0; n < FloatDCT_2D.this.rows; ++n) {
                                fArray2[n] = fArray[n * FloatDCT_2D.this.columns + i];
                            }
                            FloatDCT_2D.this.dctRows.inverse(fArray2, bl);
                            for (n = 0; n < FloatDCT_2D.this.rows; ++n) {
                                fArray[n * ((FloatDCT_2D)FloatDCT_2D.this).columns + i] = fArray2[n];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                this.dctColumns.inverse(fArray, i * this.columns, bl);
            }
            float[] fArray2 = new float[this.rows];
            for (int i = 0; i < this.columns; ++i) {
                int n6;
                for (n6 = 0; n6 < this.rows; ++n6) {
                    fArray2[n6] = fArray[n6 * this.columns + i];
                }
                this.dctRows.inverse(fArray2, bl);
                for (n6 = 0; n6 < this.rows; ++n6) {
                    fArray[n6 * this.columns + i] = fArray2[n6];
                }
            }
        }
    }

    public void inverse(final FloatLargeArray floatLargeArray, final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (n > 1 && this.useThreads) {
                this.ddxt2d_subth(1, floatLargeArray, bl);
                this.ddxt2d0_subth(1, floatLargeArray, bl);
            } else {
                this.ddxt2d_sub(1, floatLargeArray, bl);
                for (long i = 0L; i < this.rowsl; ++i) {
                    this.dctColumns.inverse(floatLargeArray, i * this.columnsl, bl);
                }
            }
        } else if (n > 1 && this.useThreads && this.rowsl >= (long)n && this.columnsl >= (long)n) {
            long l;
            long l2;
            int n2;
            Future[] futureArray = new Future[n];
            long l3 = this.rowsl / (long)n;
            for (n2 = 0; n2 < n; ++n2) {
                l2 = (long)n2 * l3;
                l = n2 == n - 1 ? this.rowsl : l2 + l3;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l2; i < l; ++i) {
                            FloatDCT_2D.this.dctColumns.inverse(floatLargeArray, i * FloatDCT_2D.this.columnsl, bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            l3 = this.columnsl / (long)n;
            for (n2 = 0; n2 < n; ++n2) {
                l2 = (long)n2 * l3;
                l = n2 == n - 1 ? this.columnsl : l2 + l3;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        FloatLargeArray floatLargeArray2 = new FloatLargeArray(FloatDCT_2D.this.rowsl, false);
                        for (long i = l2; i < l; ++i) {
                            long l3;
                            for (l3 = 0L; l3 < FloatDCT_2D.this.rowsl; ++l3) {
                                floatLargeArray2.setFloat(l3, floatLargeArray.getFloat(l3 * FloatDCT_2D.this.columnsl + i));
                            }
                            FloatDCT_2D.this.dctRows.inverse(floatLargeArray2, bl);
                            for (l3 = 0L; l3 < FloatDCT_2D.this.rowsl; ++l3) {
                                floatLargeArray.setFloat(l3 * FloatDCT_2D.this.columnsl + i, floatLargeArray2.getFloat(l3));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (long i = 0L; i < this.rowsl; ++i) {
                this.dctColumns.inverse(floatLargeArray, i * this.columnsl, bl);
            }
            FloatLargeArray floatLargeArray2 = new FloatLargeArray(this.rowsl, false);
            for (long i = 0L; i < this.columnsl; ++i) {
                long l;
                for (l = 0L; l < this.rowsl; ++l) {
                    floatLargeArray2.setFloat(l, floatLargeArray.getFloat(l * this.columnsl + i));
                }
                this.dctRows.inverse(floatLargeArray2, bl);
                for (l = 0L; l < this.rowsl; ++l) {
                    floatLargeArray.setFloat(l * this.columnsl + i, floatLargeArray2.getFloat(l));
                }
            }
        }
    }

    public void inverse(final float[][] fArray, final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (n > 1 && this.useThreads) {
                this.ddxt2d_subth(1, fArray, bl);
                this.ddxt2d0_subth(1, fArray, bl);
            } else {
                this.ddxt2d_sub(1, fArray, bl);
                for (int i = 0; i < this.rows; ++i) {
                    this.dctColumns.inverse(fArray[i], bl);
                }
            }
        } else if (n > 1 && this.useThreads && this.rows >= n && this.columns >= n) {
            int n2;
            int n3;
            int n4;
            Future[] futureArray = new Future[n];
            int n5 = this.rows / n;
            for (n4 = 0; n4 < n; ++n4) {
                n3 = n4 * n5;
                n2 = n4 == n - 1 ? this.rows : n3 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n3; i < n2; ++i) {
                            FloatDCT_2D.this.dctColumns.inverse(fArray[i], bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n5 = this.columns / n;
            for (n4 = 0; n4 < n; ++n4) {
                n3 = n4 * n5;
                n2 = n4 == n - 1 ? this.columns : n3 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] fArray2 = new float[FloatDCT_2D.this.rows];
                        for (int i = n3; i < n2; ++i) {
                            int n;
                            for (n = 0; n < FloatDCT_2D.this.rows; ++n) {
                                fArray2[n] = fArray[n][i];
                            }
                            FloatDCT_2D.this.dctRows.inverse(fArray2, bl);
                            for (n = 0; n < FloatDCT_2D.this.rows; ++n) {
                                fArray[n][i] = fArray2[n];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                this.dctColumns.inverse(fArray[i], bl);
            }
            float[] fArray2 = new float[this.rows];
            for (int i = 0; i < this.columns; ++i) {
                int n6;
                for (n6 = 0; n6 < this.rows; ++n6) {
                    fArray2[n6] = fArray[n6][i];
                }
                this.dctRows.inverse(fArray2, bl);
                for (n6 = 0; n6 < this.rows; ++n6) {
                    fArray[n6][i] = fArray2[n6];
                }
            }
        }
    }

    private void ddxt2d_subth(final int n, final float[] fArray, final boolean bl) {
        int n2 = Math.min(this.columns, ConcurrencyUtils.getNumberOfThreads());
        int n3 = 4 * this.rows;
        if (this.columns == 2) {
            n3 >>= 1;
        } else if (this.columns < 2) {
            n3 >>= 2;
        }
        final int n4 = n3;
        final int n5 = n2;
        Future[] futureArray = new Future[n2];
        for (int i = 0; i < n2; ++i) {
            final int n6 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block13: {
                        int n10;
                        int n2;
                        float[] fArray2;
                        block12: {
                            fArray2 = new float[n4];
                            if (FloatDCT_2D.this.columns <= 2) break block12;
                            if (n == -1) {
                                for (int i = 4 * n6; i < FloatDCT_2D.this.columns; i += 4 * n5) {
                                    int n3;
                                    int n42;
                                    int n52;
                                    for (n52 = 0; n52 < FloatDCT_2D.this.rows; ++n52) {
                                        n42 = n52 * FloatDCT_2D.this.columns + i;
                                        n3 = FloatDCT_2D.this.rows + n52;
                                        fArray2[n52] = fArray[n42];
                                        fArray2[n3] = fArray[n42 + 1];
                                        fArray2[n3 + ((FloatDCT_2D)FloatDCT_2D.this).rows] = fArray[n42 + 2];
                                        fArray2[n3 + 2 * ((FloatDCT_2D)FloatDCT_2D.this).rows] = fArray[n42 + 3];
                                    }
                                    FloatDCT_2D.this.dctRows.forward(fArray2, 0, bl);
                                    FloatDCT_2D.this.dctRows.forward(fArray2, FloatDCT_2D.this.rows, bl);
                                    FloatDCT_2D.this.dctRows.forward(fArray2, 2 * FloatDCT_2D.this.rows, bl);
                                    FloatDCT_2D.this.dctRows.forward(fArray2, 3 * FloatDCT_2D.this.rows, bl);
                                    for (n52 = 0; n52 < FloatDCT_2D.this.rows; ++n52) {
                                        n42 = n52 * FloatDCT_2D.this.columns + i;
                                        n3 = FloatDCT_2D.this.rows + n52;
                                        fArray[n42] = fArray2[n52];
                                        fArray[n42 + 1] = fArray2[n3];
                                        fArray[n42 + 2] = fArray2[n3 + FloatDCT_2D.this.rows];
                                        fArray[n42 + 3] = fArray2[n3 + 2 * FloatDCT_2D.this.rows];
                                    }
                                }
                            } else {
                                for (int i = 4 * n6; i < FloatDCT_2D.this.columns; i += 4 * n5) {
                                    int n62;
                                    int n7;
                                    int n8;
                                    for (n8 = 0; n8 < FloatDCT_2D.this.rows; ++n8) {
                                        n7 = n8 * FloatDCT_2D.this.columns + i;
                                        n62 = FloatDCT_2D.this.rows + n8;
                                        fArray2[n8] = fArray[n7];
                                        fArray2[n62] = fArray[n7 + 1];
                                        fArray2[n62 + ((FloatDCT_2D)FloatDCT_2D.this).rows] = fArray[n7 + 2];
                                        fArray2[n62 + 2 * ((FloatDCT_2D)FloatDCT_2D.this).rows] = fArray[n7 + 3];
                                    }
                                    FloatDCT_2D.this.dctRows.inverse(fArray2, bl);
                                    FloatDCT_2D.this.dctRows.inverse(fArray2, FloatDCT_2D.this.rows, bl);
                                    FloatDCT_2D.this.dctRows.inverse(fArray2, 2 * FloatDCT_2D.this.rows, bl);
                                    FloatDCT_2D.this.dctRows.inverse(fArray2, 3 * FloatDCT_2D.this.rows, bl);
                                    for (n8 = 0; n8 < FloatDCT_2D.this.rows; ++n8) {
                                        n7 = n8 * FloatDCT_2D.this.columns + i;
                                        n62 = FloatDCT_2D.this.rows + n8;
                                        fArray[n7] = fArray2[n8];
                                        fArray[n7 + 1] = fArray2[n62];
                                        fArray[n7 + 2] = fArray2[n62 + FloatDCT_2D.this.rows];
                                        fArray[n7 + 3] = fArray2[n62 + 2 * FloatDCT_2D.this.rows];
                                    }
                                }
                            }
                            break block13;
                        }
                        if (FloatDCT_2D.this.columns != 2) break block13;
                        int n9 = 0;
                        while (n9 < FloatDCT_2D.this.rows) {
                            n2 = n9 * FloatDCT_2D.this.columns + 2 * n6;
                            n10 = n9++;
                            fArray2[n10] = fArray[n2];
                            fArray2[n10 + ((FloatDCT_2D)FloatDCT_2D.this).rows] = fArray[n2 + 1];
                        }
                        if (n == -1) {
                            FloatDCT_2D.this.dctRows.forward(fArray2, 0, bl);
                            FloatDCT_2D.this.dctRows.forward(fArray2, FloatDCT_2D.this.rows, bl);
                        } else {
                            FloatDCT_2D.this.dctRows.inverse(fArray2, 0, bl);
                            FloatDCT_2D.this.dctRows.inverse(fArray2, FloatDCT_2D.this.rows, bl);
                        }
                        n9 = 0;
                        while (n9 < FloatDCT_2D.this.rows) {
                            n2 = n9 * FloatDCT_2D.this.columns + 2 * n6;
                            n10 = n9++;
                            fArray[n2] = fArray2[n10];
                            fArray[n2 + 1] = fArray2[n10 + FloatDCT_2D.this.rows];
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void ddxt2d_subth(final int n, final FloatLargeArray floatLargeArray, final boolean bl) {
        int n2 = (int)Math.min(this.columnsl, (long)ConcurrencyUtils.getNumberOfThreads());
        long l = 4L * this.rowsl;
        if (this.columnsl == 2L) {
            l >>= 1;
        } else if (this.columnsl < 2L) {
            l >>= 2;
        }
        final long l2 = l;
        final long l3 = n2;
        Future[] futureArray = new Future[n2];
        for (int i = 0; i < n2; ++i) {
            final long l4 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block13: {
                        long l;
                        long l22;
                        FloatLargeArray floatLargeArray2;
                        block12: {
                            floatLargeArray2 = new FloatLargeArray(l2, false);
                            if (FloatDCT_2D.this.columnsl <= 2L) break block12;
                            if (n == -1) {
                                for (long i = 4L * l4; i < FloatDCT_2D.this.columnsl; i += 4L * l3) {
                                    long l32;
                                    long l42;
                                    long l5;
                                    for (l5 = 0L; l5 < FloatDCT_2D.this.rowsl; ++l5) {
                                        l42 = l5 * FloatDCT_2D.this.columnsl + i;
                                        l32 = FloatDCT_2D.this.rowsl + l5;
                                        floatLargeArray2.setFloat(l5, floatLargeArray.getFloat(l42));
                                        floatLargeArray2.setFloat(l32, floatLargeArray.getFloat(l42 + 1L));
                                        floatLargeArray2.setFloat(l32 + FloatDCT_2D.this.rowsl, floatLargeArray.getFloat(l42 + 2L));
                                        floatLargeArray2.setFloat(l32 + 2L * FloatDCT_2D.this.rowsl, floatLargeArray.getFloat(l42 + 3L));
                                    }
                                    FloatDCT_2D.this.dctRows.forward(floatLargeArray2, 0L, bl);
                                    FloatDCT_2D.this.dctRows.forward(floatLargeArray2, FloatDCT_2D.this.rowsl, bl);
                                    FloatDCT_2D.this.dctRows.forward(floatLargeArray2, 2L * FloatDCT_2D.this.rowsl, bl);
                                    FloatDCT_2D.this.dctRows.forward(floatLargeArray2, 3L * FloatDCT_2D.this.rowsl, bl);
                                    for (l5 = 0L; l5 < FloatDCT_2D.this.rowsl; ++l5) {
                                        l42 = l5 * FloatDCT_2D.this.columnsl + i;
                                        l32 = FloatDCT_2D.this.rowsl + l5;
                                        floatLargeArray.setFloat(l42, floatLargeArray2.getFloat(l5));
                                        floatLargeArray.setFloat(l42 + 1L, floatLargeArray2.getFloat(l32));
                                        floatLargeArray.setFloat(l42 + 2L, floatLargeArray2.getFloat(l32 + FloatDCT_2D.this.rowsl));
                                        floatLargeArray.setFloat(l42 + 3L, floatLargeArray2.getFloat(l32 + 2L * FloatDCT_2D.this.rowsl));
                                    }
                                }
                            } else {
                                for (long i = 4L * l4; i < FloatDCT_2D.this.columnsl; i += 4L * l3) {
                                    long l6;
                                    long l7;
                                    long l8;
                                    for (l8 = 0L; l8 < FloatDCT_2D.this.rowsl; ++l8) {
                                        l7 = l8 * FloatDCT_2D.this.columnsl + i;
                                        l6 = FloatDCT_2D.this.rowsl + l8;
                                        floatLargeArray2.setFloat(l8, floatLargeArray.getFloat(l7));
                                        floatLargeArray2.setFloat(l6, floatLargeArray.getFloat(l7 + 1L));
                                        floatLargeArray2.setFloat(l6 + FloatDCT_2D.this.rowsl, floatLargeArray.getFloat(l7 + 2L));
                                        floatLargeArray2.setFloat(l6 + 2L * FloatDCT_2D.this.rowsl, floatLargeArray.getFloat(l7 + 3L));
                                    }
                                    FloatDCT_2D.this.dctRows.inverse(floatLargeArray2, bl);
                                    FloatDCT_2D.this.dctRows.inverse(floatLargeArray2, FloatDCT_2D.this.rowsl, bl);
                                    FloatDCT_2D.this.dctRows.inverse(floatLargeArray2, 2L * FloatDCT_2D.this.rowsl, bl);
                                    FloatDCT_2D.this.dctRows.inverse(floatLargeArray2, 3L * FloatDCT_2D.this.rowsl, bl);
                                    for (l8 = 0L; l8 < FloatDCT_2D.this.rowsl; ++l8) {
                                        l7 = l8 * FloatDCT_2D.this.columnsl + i;
                                        l6 = FloatDCT_2D.this.rowsl + l8;
                                        floatLargeArray.setFloat(l7, floatLargeArray2.getFloat(l8));
                                        floatLargeArray.setFloat(l7 + 1L, floatLargeArray2.getFloat(l6));
                                        floatLargeArray.setFloat(l7 + 2L, floatLargeArray2.getFloat(l6 + FloatDCT_2D.this.rowsl));
                                        floatLargeArray.setFloat(l7 + 3L, floatLargeArray2.getFloat(l6 + 2L * FloatDCT_2D.this.rowsl));
                                    }
                                }
                            }
                            break block13;
                        }
                        if (FloatDCT_2D.this.columnsl != 2L) break block13;
                        long l9 = 0L;
                        while (l9 < FloatDCT_2D.this.rowsl) {
                            l22 = l9 * FloatDCT_2D.this.columnsl + 2L * l4;
                            l = l9++;
                            floatLargeArray2.setFloat(l, floatLargeArray.getFloat(l22));
                            floatLargeArray2.setFloat(l + FloatDCT_2D.this.rowsl, floatLargeArray.getFloat(l22 + 1L));
                        }
                        if (n == -1) {
                            FloatDCT_2D.this.dctRows.forward(floatLargeArray2, 0L, bl);
                            FloatDCT_2D.this.dctRows.forward(floatLargeArray2, FloatDCT_2D.this.rowsl, bl);
                        } else {
                            FloatDCT_2D.this.dctRows.inverse(floatLargeArray2, 0L, bl);
                            FloatDCT_2D.this.dctRows.inverse(floatLargeArray2, FloatDCT_2D.this.rowsl, bl);
                        }
                        l9 = 0L;
                        while (l9 < FloatDCT_2D.this.rowsl) {
                            l22 = l9 * FloatDCT_2D.this.columnsl + 2L * l4;
                            l = l9++;
                            floatLargeArray.setFloat(l22, floatLargeArray2.getFloat(l));
                            floatLargeArray.setFloat(l22 + 1L, floatLargeArray2.getFloat(l + FloatDCT_2D.this.rowsl));
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void ddxt2d_subth(final int n, final float[][] fArray, final boolean bl) {
        int n2 = Math.min(this.columns, ConcurrencyUtils.getNumberOfThreads());
        int n3 = 4 * this.rows;
        if (this.columns == 2) {
            n3 >>= 1;
        } else if (this.columns < 2) {
            n3 >>= 2;
        }
        final int n4 = n3;
        final int n5 = n2;
        Future[] futureArray = new Future[n2];
        for (int i = 0; i < n2; ++i) {
            final int n6 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block13: {
                        int n7;
                        int n2;
                        float[] fArray2;
                        block12: {
                            fArray2 = new float[n4];
                            if (FloatDCT_2D.this.columns <= 2) break block12;
                            if (n == -1) {
                                for (int i = 4 * n6; i < FloatDCT_2D.this.columns; i += 4 * n5) {
                                    int n3;
                                    int n42;
                                    for (n42 = 0; n42 < FloatDCT_2D.this.rows; ++n42) {
                                        n3 = FloatDCT_2D.this.rows + n42;
                                        fArray2[n42] = fArray[n42][i];
                                        fArray2[n3] = fArray[n42][i + 1];
                                        fArray2[n3 + ((FloatDCT_2D)FloatDCT_2D.this).rows] = fArray[n42][i + 2];
                                        fArray2[n3 + 2 * ((FloatDCT_2D)FloatDCT_2D.this).rows] = fArray[n42][i + 3];
                                    }
                                    FloatDCT_2D.this.dctRows.forward(fArray2, 0, bl);
                                    FloatDCT_2D.this.dctRows.forward(fArray2, FloatDCT_2D.this.rows, bl);
                                    FloatDCT_2D.this.dctRows.forward(fArray2, 2 * FloatDCT_2D.this.rows, bl);
                                    FloatDCT_2D.this.dctRows.forward(fArray2, 3 * FloatDCT_2D.this.rows, bl);
                                    for (n42 = 0; n42 < FloatDCT_2D.this.rows; ++n42) {
                                        n3 = FloatDCT_2D.this.rows + n42;
                                        fArray[n42][i] = fArray2[n42];
                                        fArray[n42][i + 1] = fArray2[n3];
                                        fArray[n42][i + 2] = fArray2[n3 + FloatDCT_2D.this.rows];
                                        fArray[n42][i + 3] = fArray2[n3 + 2 * FloatDCT_2D.this.rows];
                                    }
                                }
                            } else {
                                for (int i = 4 * n6; i < FloatDCT_2D.this.columns; i += 4 * n5) {
                                    int n52;
                                    int n62;
                                    for (n62 = 0; n62 < FloatDCT_2D.this.rows; ++n62) {
                                        n52 = FloatDCT_2D.this.rows + n62;
                                        fArray2[n62] = fArray[n62][i];
                                        fArray2[n52] = fArray[n62][i + 1];
                                        fArray2[n52 + ((FloatDCT_2D)FloatDCT_2D.this).rows] = fArray[n62][i + 2];
                                        fArray2[n52 + 2 * ((FloatDCT_2D)FloatDCT_2D.this).rows] = fArray[n62][i + 3];
                                    }
                                    FloatDCT_2D.this.dctRows.inverse(fArray2, 0, bl);
                                    FloatDCT_2D.this.dctRows.inverse(fArray2, FloatDCT_2D.this.rows, bl);
                                    FloatDCT_2D.this.dctRows.inverse(fArray2, 2 * FloatDCT_2D.this.rows, bl);
                                    FloatDCT_2D.this.dctRows.inverse(fArray2, 3 * FloatDCT_2D.this.rows, bl);
                                    for (n62 = 0; n62 < FloatDCT_2D.this.rows; ++n62) {
                                        n52 = FloatDCT_2D.this.rows + n62;
                                        fArray[n62][i] = fArray2[n62];
                                        fArray[n62][i + 1] = fArray2[n52];
                                        fArray[n62][i + 2] = fArray2[n52 + FloatDCT_2D.this.rows];
                                        fArray[n62][i + 3] = fArray2[n52 + 2 * FloatDCT_2D.this.rows];
                                    }
                                }
                            }
                            break block13;
                        }
                        if (FloatDCT_2D.this.columns != 2) break block13;
                        for (n2 = 0; n2 < FloatDCT_2D.this.rows; ++n2) {
                            n7 = n2;
                            fArray2[n7] = fArray[n2][2 * n6];
                            fArray2[n7 + ((FloatDCT_2D)FloatDCT_2D.this).rows] = fArray[n2][2 * n6 + 1];
                        }
                        if (n == -1) {
                            FloatDCT_2D.this.dctRows.forward(fArray2, 0, bl);
                            FloatDCT_2D.this.dctRows.forward(fArray2, FloatDCT_2D.this.rows, bl);
                        } else {
                            FloatDCT_2D.this.dctRows.inverse(fArray2, 0, bl);
                            FloatDCT_2D.this.dctRows.inverse(fArray2, FloatDCT_2D.this.rows, bl);
                        }
                        for (n2 = 0; n2 < FloatDCT_2D.this.rows; ++n2) {
                            n7 = n2;
                            fArray[n2][2 * n6] = fArray2[n7];
                            fArray[n2][2 * n6 + 1] = fArray2[n7 + FloatDCT_2D.this.rows];
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void ddxt2d0_subth(final int n, final float[] fArray, final boolean bl) {
        final int n2 = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        Future[] futureArray = new Future[n2];
        for (int i = 0; i < n2; ++i) {
            final int n3 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    if (n == -1) {
                        for (int i = n3; i < FloatDCT_2D.this.rows; i += n2) {
                            FloatDCT_2D.this.dctColumns.forward(fArray, i * FloatDCT_2D.this.columns, bl);
                        }
                    } else {
                        for (int i = n3; i < FloatDCT_2D.this.rows; i += n2) {
                            FloatDCT_2D.this.dctColumns.inverse(fArray, i * FloatDCT_2D.this.columns, bl);
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void ddxt2d0_subth(final int n, final FloatLargeArray floatLargeArray, final boolean bl) {
        final int n2 = (int)((long)ConcurrencyUtils.getNumberOfThreads() > this.rowsl ? this.rowsl : (long)ConcurrencyUtils.getNumberOfThreads());
        Future[] futureArray = new Future[n2];
        for (int i = 0; i < n2; ++i) {
            final int n3 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    if (n == -1) {
                        for (long i = (long)n3; i < FloatDCT_2D.this.rowsl; i += (long)n2) {
                            FloatDCT_2D.this.dctColumns.forward(floatLargeArray, i * FloatDCT_2D.this.columnsl, bl);
                        }
                    } else {
                        for (long i = (long)n3; i < FloatDCT_2D.this.rowsl; i += (long)n2) {
                            FloatDCT_2D.this.dctColumns.inverse(floatLargeArray, i * FloatDCT_2D.this.columnsl, bl);
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void ddxt2d0_subth(final int n, final float[][] fArray, final boolean bl) {
        final int n2 = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        Future[] futureArray = new Future[n2];
        for (int i = 0; i < n2; ++i) {
            final int n3 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    if (n == -1) {
                        for (int i = n3; i < FloatDCT_2D.this.rows; i += n2) {
                            FloatDCT_2D.this.dctColumns.forward(fArray[i], bl);
                        }
                    } else {
                        for (int i = n3; i < FloatDCT_2D.this.rows; i += n2) {
                            FloatDCT_2D.this.dctColumns.inverse(fArray[i], bl);
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void ddxt2d_sub(int n, float[] fArray, boolean bl) {
        block16: {
            int n2;
            int n3;
            float[] fArray2;
            block15: {
                int n4 = 4 * this.rows;
                if (this.columns == 2) {
                    n4 >>= 1;
                } else if (this.columns < 2) {
                    n4 >>= 2;
                }
                fArray2 = new float[n4];
                if (this.columns <= 2) break block15;
                if (n == -1) {
                    for (int i = 0; i < this.columns; i += 4) {
                        int n5;
                        int n6;
                        int n7;
                        for (n7 = 0; n7 < this.rows; ++n7) {
                            n6 = n7 * this.columns + i;
                            n5 = this.rows + n7;
                            fArray2[n7] = fArray[n6];
                            fArray2[n5] = fArray[n6 + 1];
                            fArray2[n5 + this.rows] = fArray[n6 + 2];
                            fArray2[n5 + 2 * this.rows] = fArray[n6 + 3];
                        }
                        this.dctRows.forward(fArray2, 0, bl);
                        this.dctRows.forward(fArray2, this.rows, bl);
                        this.dctRows.forward(fArray2, 2 * this.rows, bl);
                        this.dctRows.forward(fArray2, 3 * this.rows, bl);
                        for (n7 = 0; n7 < this.rows; ++n7) {
                            n6 = n7 * this.columns + i;
                            n5 = this.rows + n7;
                            fArray[n6] = fArray2[n7];
                            fArray[n6 + 1] = fArray2[n5];
                            fArray[n6 + 2] = fArray2[n5 + this.rows];
                            fArray[n6 + 3] = fArray2[n5 + 2 * this.rows];
                        }
                    }
                } else {
                    for (int i = 0; i < this.columns; i += 4) {
                        int n8;
                        int n9;
                        int n10;
                        for (n10 = 0; n10 < this.rows; ++n10) {
                            n9 = n10 * this.columns + i;
                            n8 = this.rows + n10;
                            fArray2[n10] = fArray[n9];
                            fArray2[n8] = fArray[n9 + 1];
                            fArray2[n8 + this.rows] = fArray[n9 + 2];
                            fArray2[n8 + 2 * this.rows] = fArray[n9 + 3];
                        }
                        this.dctRows.inverse(fArray2, 0, bl);
                        this.dctRows.inverse(fArray2, this.rows, bl);
                        this.dctRows.inverse(fArray2, 2 * this.rows, bl);
                        this.dctRows.inverse(fArray2, 3 * this.rows, bl);
                        for (n10 = 0; n10 < this.rows; ++n10) {
                            n9 = n10 * this.columns + i;
                            n8 = this.rows + n10;
                            fArray[n9] = fArray2[n10];
                            fArray[n9 + 1] = fArray2[n8];
                            fArray[n9 + 2] = fArray2[n8 + this.rows];
                            fArray[n9 + 3] = fArray2[n8 + 2 * this.rows];
                        }
                    }
                }
                break block16;
            }
            if (this.columns != 2) break block16;
            for (n3 = 0; n3 < this.rows; ++n3) {
                n2 = n3 * this.columns;
                fArray2[n3] = fArray[n2];
                fArray2[this.rows + n3] = fArray[n2 + 1];
            }
            if (n == -1) {
                this.dctRows.forward(fArray2, 0, bl);
                this.dctRows.forward(fArray2, this.rows, bl);
            } else {
                this.dctRows.inverse(fArray2, 0, bl);
                this.dctRows.inverse(fArray2, this.rows, bl);
            }
            for (n3 = 0; n3 < this.rows; ++n3) {
                n2 = n3 * this.columns;
                fArray[n2] = fArray2[n3];
                fArray[n2 + 1] = fArray2[this.rows + n3];
            }
        }
    }

    private void ddxt2d_sub(int n, FloatLargeArray floatLargeArray, boolean bl) {
        block16: {
            long l;
            long l2;
            FloatLargeArray floatLargeArray2;
            block15: {
                long l3 = 4L * this.rowsl;
                if (this.columnsl == 2L) {
                    l3 >>= 1;
                } else if (this.columnsl < 2L) {
                    l3 >>= 2;
                }
                floatLargeArray2 = new FloatLargeArray(l3, false);
                if (this.columnsl <= 2L) break block15;
                if (n == -1) {
                    for (long i = 0L; i < this.columnsl; i += 4L) {
                        long l4;
                        long l5;
                        long l6;
                        for (l6 = 0L; l6 < this.rowsl; ++l6) {
                            l5 = l6 * this.columnsl + i;
                            l4 = this.rowsl + l6;
                            floatLargeArray2.setFloat(l6, floatLargeArray.getFloat(l5));
                            floatLargeArray2.setFloat(l4, floatLargeArray.getFloat(l5 + 1L));
                            floatLargeArray2.setFloat(l4 + this.rowsl, floatLargeArray.getFloat(l5 + 2L));
                            floatLargeArray2.setFloat(l4 + 2L * this.rowsl, floatLargeArray.getFloat(l5 + 3L));
                        }
                        this.dctRows.forward(floatLargeArray2, 0L, bl);
                        this.dctRows.forward(floatLargeArray2, this.rowsl, bl);
                        this.dctRows.forward(floatLargeArray2, 2L * this.rowsl, bl);
                        this.dctRows.forward(floatLargeArray2, 3L * this.rowsl, bl);
                        for (l6 = 0L; l6 < this.rowsl; ++l6) {
                            l5 = l6 * this.columnsl + i;
                            l4 = this.rowsl + l6;
                            floatLargeArray.setFloat(l5, floatLargeArray2.getFloat(l6));
                            floatLargeArray.setFloat(l5 + 1L, floatLargeArray2.getFloat(l4));
                            floatLargeArray.setFloat(l5 + 2L, floatLargeArray2.getFloat(l4 + this.rowsl));
                            floatLargeArray.setFloat(l5 + 3L, floatLargeArray2.getFloat(l4 + 2L * this.rowsl));
                        }
                    }
                } else {
                    for (long i = 0L; i < this.columnsl; i += 4L) {
                        long l7;
                        long l8;
                        long l9;
                        for (l9 = 0L; l9 < this.rowsl; ++l9) {
                            l8 = l9 * this.columnsl + i;
                            l7 = this.rowsl + l9;
                            floatLargeArray2.setFloat(l9, floatLargeArray.getFloat(l8));
                            floatLargeArray2.setFloat(l7, floatLargeArray.getFloat(l8 + 1L));
                            floatLargeArray2.setFloat(l7 + this.rowsl, floatLargeArray.getFloat(l8 + 2L));
                            floatLargeArray2.setFloat(l7 + 2L * this.rowsl, floatLargeArray.getFloat(l8 + 3L));
                        }
                        this.dctRows.inverse(floatLargeArray2, 0L, bl);
                        this.dctRows.inverse(floatLargeArray2, this.rowsl, bl);
                        this.dctRows.inverse(floatLargeArray2, 2L * this.rowsl, bl);
                        this.dctRows.inverse(floatLargeArray2, 3L * this.rowsl, bl);
                        for (l9 = 0L; l9 < this.rowsl; ++l9) {
                            l8 = l9 * this.columnsl + i;
                            l7 = this.rowsl + l9;
                            floatLargeArray.setFloat(l8, floatLargeArray2.getFloat(l9));
                            floatLargeArray.setFloat(l8 + 1L, floatLargeArray2.getFloat(l7));
                            floatLargeArray.setFloat(l8 + 2L, floatLargeArray2.getFloat(l7 + this.rowsl));
                            floatLargeArray.setFloat(l8 + 3L, floatLargeArray2.getFloat(l7 + 2L * this.rowsl));
                        }
                    }
                }
                break block16;
            }
            if (this.columnsl != 2L) break block16;
            for (l2 = 0L; l2 < this.rowsl; ++l2) {
                l = l2 * this.columnsl;
                floatLargeArray2.setFloat(l2, floatLargeArray.getFloat(l));
                floatLargeArray2.setFloat(this.rowsl + l2, floatLargeArray.getFloat(l + 1L));
            }
            if (n == -1) {
                this.dctRows.forward(floatLargeArray2, 0L, bl);
                this.dctRows.forward(floatLargeArray2, this.rowsl, bl);
            } else {
                this.dctRows.inverse(floatLargeArray2, 0L, bl);
                this.dctRows.inverse(floatLargeArray2, this.rowsl, bl);
            }
            for (l2 = 0L; l2 < this.rowsl; ++l2) {
                l = l2 * this.columnsl;
                floatLargeArray.setFloat(l, floatLargeArray2.getFloat(l2));
                floatLargeArray.setFloat(l + 1L, floatLargeArray2.getFloat(this.rowsl + l2));
            }
        }
    }

    private void ddxt2d_sub(int n, float[][] fArray, boolean bl) {
        block16: {
            int n2;
            float[] fArray2;
            block15: {
                int n3 = 4 * this.rows;
                if (this.columns == 2) {
                    n3 >>= 1;
                } else if (this.columns < 2) {
                    n3 >>= 2;
                }
                fArray2 = new float[n3];
                if (this.columns <= 2) break block15;
                if (n == -1) {
                    for (int i = 0; i < this.columns; i += 4) {
                        int n4;
                        int n5;
                        for (n5 = 0; n5 < this.rows; ++n5) {
                            n4 = this.rows + n5;
                            fArray2[n5] = fArray[n5][i];
                            fArray2[n4] = fArray[n5][i + 1];
                            fArray2[n4 + this.rows] = fArray[n5][i + 2];
                            fArray2[n4 + 2 * this.rows] = fArray[n5][i + 3];
                        }
                        this.dctRows.forward(fArray2, 0, bl);
                        this.dctRows.forward(fArray2, this.rows, bl);
                        this.dctRows.forward(fArray2, 2 * this.rows, bl);
                        this.dctRows.forward(fArray2, 3 * this.rows, bl);
                        for (n5 = 0; n5 < this.rows; ++n5) {
                            n4 = this.rows + n5;
                            fArray[n5][i] = fArray2[n5];
                            fArray[n5][i + 1] = fArray2[n4];
                            fArray[n5][i + 2] = fArray2[n4 + this.rows];
                            fArray[n5][i + 3] = fArray2[n4 + 2 * this.rows];
                        }
                    }
                } else {
                    for (int i = 0; i < this.columns; i += 4) {
                        int n6;
                        int n7;
                        for (n7 = 0; n7 < this.rows; ++n7) {
                            n6 = this.rows + n7;
                            fArray2[n7] = fArray[n7][i];
                            fArray2[n6] = fArray[n7][i + 1];
                            fArray2[n6 + this.rows] = fArray[n7][i + 2];
                            fArray2[n6 + 2 * this.rows] = fArray[n7][i + 3];
                        }
                        this.dctRows.inverse(fArray2, 0, bl);
                        this.dctRows.inverse(fArray2, this.rows, bl);
                        this.dctRows.inverse(fArray2, 2 * this.rows, bl);
                        this.dctRows.inverse(fArray2, 3 * this.rows, bl);
                        for (n7 = 0; n7 < this.rows; ++n7) {
                            n6 = this.rows + n7;
                            fArray[n7][i] = fArray2[n7];
                            fArray[n7][i + 1] = fArray2[n6];
                            fArray[n7][i + 2] = fArray2[n6 + this.rows];
                            fArray[n7][i + 3] = fArray2[n6 + 2 * this.rows];
                        }
                    }
                }
                break block16;
            }
            if (this.columns != 2) break block16;
            for (n2 = 0; n2 < this.rows; ++n2) {
                fArray2[n2] = fArray[n2][0];
                fArray2[this.rows + n2] = fArray[n2][1];
            }
            if (n == -1) {
                this.dctRows.forward(fArray2, 0, bl);
                this.dctRows.forward(fArray2, this.rows, bl);
            } else {
                this.dctRows.inverse(fArray2, 0, bl);
                this.dctRows.inverse(fArray2, this.rows, bl);
            }
            for (n2 = 0; n2 < this.rows; ++n2) {
                fArray[n2][0] = fArray2[n2];
                fArray[n2][1] = fArray2[this.rows + n2];
            }
        }
    }
}

