/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.cinrad;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.IndexIterator;
import ucar.ma2.Range;
import ucar.nc2.iosp.cinrad.Cinrad2IOServiceProvider;
import ucar.unidata.io.RandomAccessFile;

public class Cinrad2Record {
    public static final int REFLECTIVITY = 1;
    public static final int VELOCITY_HI = 2;
    public static final int VELOCITY_LOW = 4;
    public static final int SPECTRUM_WIDTH = 3;
    public static final int DOPPLER_RESOLUTION_LOW_CODE = 4;
    public static final int DOPPLER_RESOLUTION_HIGH_CODE = 2;
    public static final float HORIZONTAL_BEAM_WIDTH = 1.5f;
    public static byte MISSING_DATA = 1;
    public static final byte BELOW_THRESHOLD = 0;
    static int FILE_HEADER_SIZE = 0;
    private static int CTM_HEADER_SIZE = 14;
    private static final int MESSAGE_HEADER_SIZE = 28;
    private static int RADAR_DATA_SIZE = 2432;
    private static Logger logger = LoggerFactory.getLogger(Cinrad2Record.class);
    int recno;
    long message_offset;
    boolean hasReflectData;
    boolean hasDopplerData;
    short message_size = 0;
    byte id_channel = 0;
    public byte message_type = 0;
    short id_sequence = 0;
    short mess_julian_date = 0;
    int mess_msecs = 0;
    short seg_count = 0;
    short seg_number = 0;
    int data_msecs = 0;
    short data_julian_date = 0;
    short unamb_range = 0;
    int azimuth_ang = 0;
    int azimuth_ang_end = 0;
    short radial_num = 0;
    short radial_status = 0;
    short elevation_ang = 0;
    short elevation_ang_end = 0;
    short elevation_num = 0;
    short reflect_first_gate = 0;
    short reflect_gate_size = 0;
    short reflect_gate_count = 0;
    short doppler_first_gate = 0;
    short doppler_gate_size = 0;
    short doppler_gate_count = 0;
    short cut = 0;
    float calibration = 0.0f;
    short resolution = 0;
    short vcp = 0;
    short nyquist_vel;
    short attenuation;
    short threshhold;
    private short reflect_offset;
    private short velocity_offset;
    private short spectWidth_offset;
    public DateTime dateTime0;
    public DateTime dateTimeE;
    public SweepInfo[] sweepInfo;
    int sweepN = 1;
    int echoType;
    int[] elev;
    int[] recordNum;
    byte cDataForm;

    public static String getDatatypeName(int datatype) {
        switch (datatype) {
            case 1: {
                return "Reflectivity";
            }
            case 2: 
            case 4: {
                return "RadialVelocity";
            }
            case 3: {
                return "SpectrumWidth";
            }
        }
        throw new IllegalArgumentException();
    }

    public static String getDatatypeUnits(int datatype) {
        switch (datatype) {
            case 1: {
                return "dBz";
            }
            case 2: 
            case 3: 
            case 4: {
                return "m/s";
            }
        }
        throw new IllegalArgumentException();
    }

    public static float getDatatypeScaleFactor(int datatype) {
        switch (datatype) {
            case 1: {
                if (Cinrad2IOServiceProvider.isCC) {
                    return 0.1f;
                }
                if (Cinrad2IOServiceProvider.isCC20) {
                    return 0.5f;
                }
                return 0.5f;
            }
            case 4: {
                if (Cinrad2IOServiceProvider.isSC) {
                    return 0.3673f;
                }
                if (Cinrad2IOServiceProvider.isCC) {
                    return 0.1f;
                }
                return 1.0f;
            }
            case 2: 
            case 3: {
                if (Cinrad2IOServiceProvider.isSC) {
                    return 0.1822f;
                }
                if (Cinrad2IOServiceProvider.isCC) {
                    return 0.1f;
                }
                if (Cinrad2IOServiceProvider.isCC20) {
                    return 1.0f;
                }
                return 0.5f;
            }
        }
        throw new IllegalArgumentException();
    }

    public static float getDatatypeAddOffset(int datatype) {
        switch (datatype) {
            case 1: {
                if (Cinrad2IOServiceProvider.isSC) {
                    return -32.0f;
                }
                if (Cinrad2IOServiceProvider.isCC) {
                    return 0.0f;
                }
                if (Cinrad2IOServiceProvider.isCC20) {
                    return -32.0f;
                }
                return -33.0f;
            }
            case 4: {
                if (Cinrad2IOServiceProvider.isSC) {
                    return 0.0f;
                }
                if (Cinrad2IOServiceProvider.isCC) {
                    return 0.0f;
                }
                if (Cinrad2IOServiceProvider.isCC20) {
                    return 0.0f;
                }
                return -129.0f;
            }
            case 2: 
            case 3: {
                if (Cinrad2IOServiceProvider.isSC) {
                    return 0.0f;
                }
                if (Cinrad2IOServiceProvider.isCC) {
                    return 0.0f;
                }
                if (Cinrad2IOServiceProvider.isCC20) {
                    return 0.0f;
                }
                return -64.5f;
            }
        }
        throw new IllegalArgumentException();
    }

    public static String getMessageTypeName(int code) {
        switch (code) {
            case 1: {
                return "digital radar data";
            }
            case 2: {
                return "RDA status data";
            }
            case 3: {
                return "performance/maintainence data";
            }
            case 4: {
                return "console message - RDA to RPG";
            }
            case 5: {
                return "maintainence log data";
            }
            case 6: {
                return "RDA control ocmmands";
            }
            case 7: {
                return "volume coverage pattern";
            }
            case 8: {
                return "clutter censor zones";
            }
            case 9: {
                return "request for data";
            }
            case 10: {
                return "console message - RPG to RDA";
            }
            case 11: {
                return "loop back test - RDA to RPG";
            }
            case 12: {
                return "loop back test - RPG to RDA";
            }
            case 13: {
                return "clutter filter bypass map - RDA to RPG";
            }
            case 14: {
                return "edited clutter filter bypass map - RDA to RPG";
            }
            case 15: {
                return "Notchwidth Map";
            }
            case 18: {
                return "RDA Adaptation data";
            }
        }
        return "unknown " + code;
    }

    public static String getRadialStatusName(int code) {
        switch (code) {
            case 0: {
                return "start of new elevation";
            }
            case 1: {
                return "intermediate radial";
            }
            case 2: {
                return "end of elevation";
            }
            case 3: {
                return "begin volume scan";
            }
            case 4: {
                return "end volume scan";
            }
        }
        return "unknown " + code;
    }

    public static String getVolumeCoveragePatternName(int code) {
        switch (code) {
            case 11: {
                return "16 elevation scans every 5 mins";
            }
            case 12: {
                return "14 elevation scan every 4.1 mins";
            }
            case 21: {
                return "11 elevation scans every 6 mins";
            }
            case 31: {
                return "8 elevation scans every 10 mins";
            }
            case 32: {
                return "7 elevation scans every 10 mins";
            }
            case 121: {
                return "9 elevations, 20 scans every 5 minutes";
            }
        }
        return "unknown " + code;
    }

    public static Date getDate(int julianDays, int msecs) {
        long total = (long)(julianDays - 1) * 24L * 3600L * 1000L + (long)msecs;
        return new Date(total);
    }

    public static Cinrad2Record factory(RandomAccessFile din, int record) throws IOException {
        long offset = (long)record * (long)RADAR_DATA_SIZE + (long)FILE_HEADER_SIZE;
        if (offset >= din.length()) {
            return null;
        }
        return new Cinrad2Record(din, record);
    }

    public short convertunsignedByte2Short(byte b) {
        return b < 0 ? (short)((short)b + 256) : (short)b;
    }

    public void readSCHeader(RandomAccessFile din) throws IOException {
        this.message_offset = 0L;
        din.seek(this.message_offset);
        din.skipBytes(90);
        byte[] b10 = new byte[10];
        din.read(b10);
        String stationNId = new String(b10);
        din.skipBytes(52);
        int lon = din.readInt();
        int lat = din.readInt();
        int hhh = din.readInt();
        din.skipBytes(6);
        this.message_type = 1;
        din.skipBytes(31);
        this.vcp = this.convertunsignedByte2Short(din.readByte());
        short syear = (short)din.readUnsignedShort();
        short smm = this.convertunsignedByte2Short(din.readByte());
        short sdd = this.convertunsignedByte2Short(din.readByte());
        short shh = this.convertunsignedByte2Short(din.readByte());
        short smi = this.convertunsignedByte2Short(din.readByte());
        short sss = this.convertunsignedByte2Short(din.readByte());
        this.dateTime0 = new DateTime((int)syear, (int)smm, (int)sdd, (int)shh, (int)smi, sss);
        din.skipBytes(8);
        long offset = din.getFilePointer();
        this.sweepInfo = new SweepInfo[30];
        for (int i = 0; i < 30; ++i) {
            this.sweepInfo[i] = new SweepInfo(din, (int)offset);
            offset += 21L;
        }
        din.skipBytes(6);
        syear = (short)din.readUnsignedShort();
        smm = this.convertunsignedByte2Short(din.readByte());
        sdd = this.convertunsignedByte2Short(din.readByte());
        shh = this.convertunsignedByte2Short(din.readByte());
        smi = this.convertunsignedByte2Short(din.readByte());
        sss = this.convertunsignedByte2Short(din.readByte());
        this.dateTimeE = new DateTime((int)syear, (int)smm, (int)sdd, (int)shh, (int)smi, sss);
    }

    public void readCCHeader(RandomAccessFile din) throws IOException {
        this.message_offset = 0L;
        din.seek(this.message_offset);
        din.skipBytes(66);
        String stationId = din.readString(40);
        String stationNbr = din.readString(10);
        din.skipBytes(20);
        String clon = din.readString(16);
        String clat = din.readString(16);
        int lon = din.readInt();
        int lat = din.readInt();
        int hhh = din.readInt();
        din.skipBytes(4);
        short syear1 = this.convertunsignedByte2Short(din.readByte());
        short syear2 = this.convertunsignedByte2Short(din.readByte());
        short syear = (short)(syear1 * 100 + syear2);
        short smm = this.convertunsignedByte2Short(din.readByte());
        short sdd = this.convertunsignedByte2Short(din.readByte());
        short shh = this.convertunsignedByte2Short(din.readByte());
        short smi = this.convertunsignedByte2Short(din.readByte());
        short sss = this.convertunsignedByte2Short(din.readByte());
        this.dateTime0 = new DateTime((int)syear, (int)smm, (int)sdd, (int)shh, (int)smi, sss);
        din.skipBytes(1);
        syear1 = this.convertunsignedByte2Short(din.readByte());
        syear2 = this.convertunsignedByte2Short(din.readByte());
        syear = (short)(syear1 * 100 + syear2);
        smm = this.convertunsignedByte2Short(din.readByte());
        sdd = this.convertunsignedByte2Short(din.readByte());
        shh = this.convertunsignedByte2Short(din.readByte());
        smi = this.convertunsignedByte2Short(din.readByte());
        sss = this.convertunsignedByte2Short(din.readByte());
        this.dateTimeE = new DateTime((int)syear, (int)smm, (int)sdd, (int)shh, (int)smi, sss);
        short scanMode = this.convertunsignedByte2Short(din.readByte());
        if (scanMode == 10) {
            this.sweepN = 1;
        } else if (scanMode >= 100) {
            this.sweepN = scanMode - 100;
        } else {
            throw new IOException("Error reading CINRAD CC data: Unsupported product: RHI/FFT");
        }
        this.elev = new int[this.sweepN];
        din.skipBytes(4);
        short sRHIA = (short)din.readUnsignedShort();
        din.skipBytes(4);
        this.echoType = din.readUnsignedShort();
        if (this.echoType != 16522) {
            throw new IOException("Error reading CINRAD CC data: Unsupported level 2 data");
        }
        int prodCode = din.readUnsignedShort();
        if (prodCode != 32771) {
            throw new IOException("Error reading CINRAD CC data: Unsupported product: RHI/FFT");
        }
        din.skipBytes(4);
        for (int i = 0; i < this.sweepN; ++i) {
            int maxV = din.readUnsignedShort();
            int maxL = din.readUnsignedShort();
            int binWidth = din.readUnsignedShort();
            int binNum = din.readUnsignedShort();
            int recordTotalNum = din.readUnsignedShort();
            din.skipBytes(8);
            this.elev[i] = din.readUnsignedShort();
            din.skipBytes(2);
        }
    }

    public void readCC20Header(RandomAccessFile din) throws IOException {
        int i;
        this.message_offset = 0L;
        din.seek(this.message_offset);
        din.skipBytes(62);
        String stationId = din.readString(40);
        String stationNbr = din.readString(10);
        din.skipBytes(20);
        String clon = din.readString(16);
        String clat = din.readString(16);
        int lon = din.readInt();
        int lat = din.readInt();
        int hhh = din.readInt();
        din.skipBytes(40);
        short scanMode = this.convertunsignedByte2Short(din.readByte());
        if (scanMode == 10) {
            this.sweepN = 1;
        } else if (scanMode >= 100) {
            this.sweepN = scanMode - 100;
        } else {
            throw new IOException("Error reading CINRAD CC data: Unsupported product: RHI/FFT");
        }
        short syear = (short)din.readUnsignedShort();
        short smm = this.convertunsignedByte2Short(din.readByte());
        short sdd = this.convertunsignedByte2Short(din.readByte());
        short shh = this.convertunsignedByte2Short(din.readByte());
        short smi = this.convertunsignedByte2Short(din.readByte());
        short sss = this.convertunsignedByte2Short(din.readByte());
        this.dateTime0 = new DateTime((int)syear, (int)smm, (int)sdd, (int)shh, (int)smi, sss);
        din.skipBytes(14);
        this.elev = new int[this.sweepN];
        this.recordNum = new int[this.sweepN];
        for (i = 0; i < this.sweepN; ++i) {
            din.skipBytes(14);
            int zbinWidth = din.readUnsignedShort();
            int vbinWidth = din.readUnsignedShort();
            int sbinWidth = din.readUnsignedShort();
            int zbinNum = din.readUnsignedShort();
            int vbinNum = din.readUnsignedShort();
            int sbinNum = din.readUnsignedShort();
            this.recordNum[i] = din.readUnsignedShort();
            this.elev[i] = din.readShort();
            this.cDataForm = din.readByte();
            if (this.cDataForm != 22 && this.cDataForm != 23 && this.cDataForm != 24) {
                throw new IOException("Unsupported CC data format");
            }
            int n = din.readInt();
        }
        for (i = this.sweepN; i < 32; ++i) {
            din.skipBytes(35);
        }
        din.skipBytes(6);
        syear = (short)din.readUnsignedShort();
        smm = this.convertunsignedByte2Short(din.readByte());
        sdd = this.convertunsignedByte2Short(din.readByte());
        shh = this.convertunsignedByte2Short(din.readByte());
        smi = this.convertunsignedByte2Short(din.readByte());
        sss = this.convertunsignedByte2Short(din.readByte());
        this.dateTimeE = new DateTime((int)syear, (int)smm, (int)sdd, (int)shh, (int)smi, sss);
    }

    public Cinrad2Record(RandomAccessFile din, int record) throws IOException {
        if (!(Cinrad2IOServiceProvider.isSC || Cinrad2IOServiceProvider.isCC || Cinrad2IOServiceProvider.isCC20)) {
            this.recno = record;
            this.message_offset = (long)record * (long)RADAR_DATA_SIZE + (long)FILE_HEADER_SIZE;
            din.seek(this.message_offset);
            din.skipBytes(CTM_HEADER_SIZE);
            this.message_type = din.readByte();
            din.skipBytes(13);
            if (this.message_type != 1) {
                return;
            }
            byte[] b4 = din.readBytes(4);
            this.data_msecs = Cinrad2Record.bytesToInt(b4, true);
            byte[] b2 = din.readBytes(2);
            this.data_julian_date = (short)Cinrad2Record.bytesToShort(b2, true);
            this.unamb_range = din.readShort();
            this.azimuth_ang = din.readUnsignedShort();
            this.radial_num = din.readShort();
            this.radial_status = din.readShort();
            this.elevation_ang = din.readShort();
            this.elevation_num = din.readShort();
            this.reflect_first_gate = din.readShort();
            this.doppler_first_gate = din.readShort();
            this.reflect_gate_size = din.readShort();
            this.doppler_gate_size = din.readShort();
            this.reflect_gate_count = din.readShort();
            this.doppler_gate_count = din.readShort();
            if (record == 0) {
                RADAR_DATA_SIZE = this.reflect_gate_count == 1000 && this.doppler_gate_count == 1000 ? 3132 : (this.reflect_gate_count == 800 || this.doppler_gate_count == 1600 ? 4132 : 2432);
            }
            din.skipBytes(6);
            this.reflect_offset = din.readShort();
            this.velocity_offset = din.readShort();
            this.spectWidth_offset = din.readShort();
            this.resolution = din.readShort();
            this.vcp = din.readShort();
            this.message_type = 1;
            din.skipBytes(14);
            this.nyquist_vel = din.readShort();
            din.skipBytes(38);
            this.hasReflectData = this.reflect_gate_count > 0;
            this.hasDopplerData = this.doppler_gate_count > 0;
        } else if (Cinrad2IOServiceProvider.isSC) {
            this.recno = record;
            this.readSCHeader(din);
            RADAR_DATA_SIZE = 4000;
            this.message_offset = (long)record * (long)RADAR_DATA_SIZE + 1024L;
            if (this.message_offset >= din.length()) {
                return;
            }
            din.seek(this.message_offset);
            this.azimuth_ang = din.readUnsignedShort();
            this.elevation_ang = (short)din.readUnsignedShort();
            this.azimuth_ang_end = din.readUnsignedShort();
            this.elevation_ang_end = (short)din.readUnsignedShort();
            this.radial_num = (short)(record % 360 + 1);
            this.elevation_num = (short)(record / 360 + 1);
            this.reflect_first_gate = (short)300;
            this.doppler_first_gate = (short)300;
            this.reflect_gate_size = (short)300;
            this.doppler_gate_size = (short)300;
            this.reflect_gate_count = (short)998;
            this.doppler_gate_count = (short)998;
            this.reflect_offset = (short)8;
            this.velocity_offset = (short)8;
            this.spectWidth_offset = (short)8;
            this.hasReflectData = this.reflect_gate_count > 0;
            this.hasDopplerData = this.doppler_gate_count > 0;
        } else if (Cinrad2IOServiceProvider.isCC) {
            this.recno = record;
            this.readCCHeader(din);
            RADAR_DATA_SIZE = 3000;
            this.message_type = 1;
            this.message_offset = (long)record * (long)RADAR_DATA_SIZE + 1024L;
            if (this.message_offset >= din.length()) {
                return;
            }
            din.seek(this.message_offset);
            this.radial_num = (short)(record % 512 + 1);
            this.azimuth_ang = this.radial_num;
            this.elevation_num = (short)(record / 512 + 1);
            if (this.elevation_num > this.sweepN) {
                this.elevation_num = (short)this.sweepN;
            }
            this.elevation_ang = (short)this.elev[this.elevation_num - 1];
            this.reflect_first_gate = (short)300;
            this.doppler_first_gate = (short)300;
            this.reflect_gate_size = (short)150;
            this.doppler_gate_size = (short)150;
            this.reflect_gate_count = (short)500;
            this.doppler_gate_count = (short)500;
            this.reflect_offset = 0;
            this.velocity_offset = (short)1000;
            this.spectWidth_offset = (short)2000;
            this.hasReflectData = this.reflect_gate_count > 0;
            this.hasDopplerData = this.doppler_gate_count > 0;
        } else if (Cinrad2IOServiceProvider.isCC20) {
            this.recno = record;
            this.readCC20Header(din);
            RADAR_DATA_SIZE = this.cDataForm == 24 ? 4011 : 3011;
            this.message_type = 1;
            this.message_offset = (long)record * (long)RADAR_DATA_SIZE + 2060L;
            if (this.message_offset >= din.length()) {
                return;
            }
            din.seek(this.message_offset);
            this.elevation_ang = din.readShort();
            this.azimuth_ang = din.readUnsignedShort();
            din.skipBytes(3);
            this.data_msecs = din.readInt();
            this.reflect_first_gate = 0;
            this.doppler_first_gate = 0;
            this.reflect_gate_size = (short)1500;
            this.doppler_gate_size = (short)1500;
            this.reflect_gate_count = (short)1000;
            this.doppler_gate_count = (short)1000;
            if (this.cDataForm == 24) {
                this.reflect_offset = (short)11;
                this.velocity_offset = (short)2011;
                this.spectWidth_offset = (short)3011;
            } else {
                this.reflect_offset = (short)11;
                this.velocity_offset = (short)1011;
                this.spectWidth_offset = (short)2011;
            }
            this.hasReflectData = this.reflect_gate_count > 0;
            this.hasDopplerData = this.doppler_gate_count > 0;
        }
    }

    public int findClosestIdx(int[] numbers, short myNumber) {
        int distance = Math.abs(numbers[0] - myNumber);
        int idx = 0;
        for (int c = 1; c < numbers.length; ++c) {
            int cdistance = Math.abs(numbers[c] - myNumber);
            if (cdistance >= distance) continue;
            idx = c;
            distance = cdistance;
        }
        return idx;
    }

    public static int bytesToInt(byte[] bytes, boolean swapBytes) {
        byte a = bytes[0];
        byte b = bytes[1];
        byte c = bytes[2];
        byte d = bytes[3];
        if (swapBytes) {
            return (a & 0xFF) + ((b & 0xFF) << 8) + ((c & 0xFF) << 16) + ((d & 0xFF) << 24);
        }
        return ((a & 0xFF) << 24) + ((b & 0xFF) << 16) + ((c & 0xFF) << 8) + (d & 0xFF);
    }

    public static int bytesToShort(byte[] bytes, boolean swapBytes) {
        byte a = bytes[0];
        byte b = bytes[1];
        if (swapBytes) {
            return (a & 0xFF) + ((b & 0xFF) << 8);
        }
        return ((a & 0xFF) << 24) + ((b & 0xFF) << 16);
    }

    public void dumpMessage(PrintStream out, Date d) {
        out.println(this.recno + " ---------------------");
        out.println(" message type = " + Cinrad2Record.getMessageTypeName(this.message_type) + " (" + this.message_type + ")");
        out.println(" message size = " + this.message_size + " segment=" + this.seg_number + "/" + this.seg_count);
        out.println(" message date = " + d.toString());
        out.println(" channel id = " + this.id_channel);
    }

    public void dump(PrintStream out) {
        out.println(this.recno + " ------------------------------------------" + this.message_offset);
        out.println(" message type = " + Cinrad2Record.getMessageTypeName(this.message_type));
        out.println(" data date = " + this.getDate().toString());
        out.println(" elevation = " + this.getElevation() + " (" + this.elevation_num + ")");
        out.println(" azimuth = " + this.getAzimuth());
        out.println(" radial = " + this.radial_num + " status= " + Cinrad2Record.getRadialStatusName(this.radial_status) + " ratio = " + this.getAzimuth() / (float)this.radial_num);
        out.println(" reflectivity first= " + this.reflect_first_gate + " size= " + this.reflect_gate_size + " count= " + this.reflect_gate_count);
        out.println(" doppler first= " + this.doppler_first_gate + " size= " + this.doppler_gate_size + " count= " + this.doppler_gate_count);
        out.println(" offset: reflect= " + this.reflect_offset + " velocity= " + this.velocity_offset + " spWidth= " + this.spectWidth_offset);
        out.println(" pattern = " + this.vcp);
    }

    public void dump2(PrintStream out) {
        out.println(this.recno + "= " + this.elevation_num + " size = " + this.message_size);
    }

    public boolean checkOk() {
        boolean ok = true;
        if (this.message_type != 1) {
            return ok;
        }
        if (this.reflect_offset < 0 || this.reflect_offset > RADAR_DATA_SIZE) {
            logger.warn("****" + this.recno + " HAS bad reflect offset= " + this.reflect_offset + this.who());
            ok = false;
        }
        if (this.velocity_offset < 0 || this.velocity_offset > RADAR_DATA_SIZE) {
            logger.warn("****" + this.recno + " HAS bad velocity offset= " + this.velocity_offset + this.who());
            ok = false;
        }
        if (this.spectWidth_offset < 0 || this.spectWidth_offset > RADAR_DATA_SIZE) {
            logger.warn("****" + this.recno + " HAS bad spwidth offset= " + this.spectWidth_offset + this.who());
            ok = false;
        }
        if (this.velocity_offset > 0 && this.spectWidth_offset <= 0) {
            logger.warn("****" + this.recno + " HAS velocity NOT spectWidth!!" + this.who());
            ok = false;
        }
        if (this.velocity_offset <= 0 && this.spectWidth_offset > 0) {
            logger.warn("****" + this.recno + " HAS spectWidth AND NOT velocity!!" + this.who());
            ok = false;
        }
        if (!this.hasReflectData && !this.hasDopplerData) {
            logger.info("*** no reflect or dopplar = " + this.who());
        }
        return ok;
    }

    private String who() {
        return " message(" + this.recno + " " + this.message_offset + ")";
    }

    public float getAzimuth() {
        if (this.message_type != 1) {
            return -1.0f;
        }
        if (Cinrad2IOServiceProvider.isSC) {
            return 360.0f * (float)this.azimuth_ang / 65536.0f;
        }
        if (Cinrad2IOServiceProvider.isCC) {
            return 360.0f * (float)this.azimuth_ang / 512.0f;
        }
        if (Cinrad2IOServiceProvider.isCC20) {
            return (float)this.azimuth_ang * 0.01f;
        }
        return 180.0f * (float)this.azimuth_ang / 32768.0f;
    }

    public float getElevation() {
        if (this.message_type != 1) {
            return -1.0f;
        }
        if (Cinrad2IOServiceProvider.isSC) {
            return 120.0f * (float)this.elevation_ang / 65536.0f;
        }
        if (Cinrad2IOServiceProvider.isCC) {
            return (float)this.elevation_ang * 0.01f;
        }
        if (Cinrad2IOServiceProvider.isCC20) {
            return (float)this.elevation_ang * 0.01f;
        }
        return 180.0f * (float)this.elevation_ang / 32768.0f;
    }

    public int getGateSize(int datatype) {
        switch (datatype) {
            case 1: {
                return this.reflect_gate_size;
            }
            case 2: 
            case 3: 
            case 4: {
                return this.doppler_gate_size;
            }
        }
        return -1;
    }

    public int getGateStart(int datatype) {
        switch (datatype) {
            case 1: {
                return this.reflect_first_gate;
            }
            case 2: 
            case 3: 
            case 4: {
                return this.doppler_first_gate;
            }
        }
        return -1;
    }

    public int getGateCount(int datatype) {
        switch (datatype) {
            case 1: {
                return this.reflect_gate_count;
            }
            case 2: 
            case 3: 
            case 4: {
                return this.doppler_gate_count;
            }
        }
        return 0;
    }

    private short getDataOffset(int datatype) {
        switch (datatype) {
            case 1: {
                return this.reflect_offset;
            }
            case 2: 
            case 4: {
                return this.velocity_offset;
            }
            case 3: {
                return this.spectWidth_offset;
            }
        }
        return Short.MIN_VALUE;
    }

    public Date getDate() {
        if (Cinrad2IOServiceProvider.isSC || Cinrad2IOServiceProvider.isCC) {
            return this.dateTime0.toDate();
        }
        if (Cinrad2IOServiceProvider.isCC20) {
            return this.dateTime0.toDate();
        }
        return Cinrad2Record.getDate(this.data_julian_date, this.data_msecs);
    }

    public void readData(RandomAccessFile raf, int datatype, Range gateRange, IndexIterator ii) throws IOException {
        long offset = this.message_offset;
        offset += 28L;
        raf.seek(offset += (long)this.getDataOffset(datatype));
        if (logger.isDebugEnabled()) {
            logger.debug("  read recno " + this.recno + " at offset " + offset + " count= " + this.getGateCount(datatype));
            logger.debug("   offset: reflect= " + this.reflect_offset + " velocity= " + this.velocity_offset + " spWidth= " + this.spectWidth_offset);
        }
        int dataCount = this.getGateCount(datatype);
        byte[] data = new byte[dataCount];
        raf.readFully(data);
        for (int i = gateRange.first(); i <= gateRange.last(); i += gateRange.stride()) {
            if (i >= dataCount) {
                ii.setByteNext(MISSING_DATA);
                continue;
            }
            ii.setByteNext(data[i]);
        }
    }

    public void readData0(RandomAccessFile raf, int datatype, Range gateRange, IndexIterator ii) throws IOException {
        long offset = this.message_offset;
        offset += 28L;
        raf.seek(offset += (long)this.getDataOffset(datatype));
        if (logger.isDebugEnabled()) {
            logger.debug("  read recno " + this.recno + " at offset " + offset + " count= " + this.getGateCount(datatype));
            logger.debug("   offset: reflect= " + this.reflect_offset + " velocity= " + this.velocity_offset + " spWidth= " + this.spectWidth_offset);
        }
        int dataCount = this.getGateCount(datatype);
        byte[] data = new byte[dataCount];
        byte[] b4 = new byte[4];
        int j = 0;
        if (datatype == 1) {
            j = 0;
        } else if (datatype == 4) {
            j = 1;
        } else if (datatype == 3) {
            j = 3;
        }
        for (int i = gateRange.first(); i <= gateRange.last(); i += gateRange.stride()) {
            if (i >= dataCount) {
                ii.setByteNext(MISSING_DATA);
                continue;
            }
            raf.read(b4);
            data[i] = b4[j];
            ii.setByteNext(data[i]);
        }
    }

    public void readData1(RandomAccessFile raf, int datatype, Range gateRange, IndexIterator ii) throws IOException {
        long offset = this.message_offset;
        offset += 28L;
        raf.seek(offset += (long)this.getDataOffset(datatype));
        if (logger.isDebugEnabled()) {
            logger.debug("  read recno " + this.recno + " at offset " + offset + " count= " + this.getGateCount(datatype));
            logger.debug("   offset: reflect= " + this.reflect_offset + " velocity= " + this.velocity_offset + " spWidth= " + this.spectWidth_offset);
        }
        int dataCount = this.getGateCount(datatype);
        short[] data = new short[dataCount];
        raf.readShort(data, 0, dataCount);
        for (int i = gateRange.first(); i <= gateRange.last(); i += gateRange.stride()) {
            if (i >= dataCount) {
                ii.setShortNext((short)Short.MIN_VALUE);
                continue;
            }
            ii.setShortNext(data[i]);
        }
    }

    public String toString() {
        return "elev= " + this.elevation_num + " radial_num = " + this.radial_num;
    }

    static class SweepInfo {
        byte amb;
        short arotate;
        short pref1;
        short pref2;
        short spulseW;
        short maxV;
        short maxL;
        short binWidth;
        short binnumber;
        short recordnumber;
        float elevationAngle;

        SweepInfo(RandomAccessFile din, int hoff) throws IOException {
            din.seek(hoff);
            this.amb = din.readByte();
            this.arotate = (short)din.readUnsignedShort();
            this.pref1 = (short)din.readUnsignedShort();
            this.pref2 = (short)din.readUnsignedShort();
            this.spulseW = (short)din.readUnsignedShort();
            this.maxV = (short)din.readUnsignedShort();
            this.maxL = (short)din.readUnsignedShort();
            this.binWidth = (short)din.readUnsignedShort();
            this.binnumber = (short)din.readUnsignedShort();
            this.recordnumber = (short)din.readUnsignedShort();
            this.elevationAngle = (float)((short)din.readUnsignedShort()) / 100.0f;
        }
    }
}

