/*
 * Decompiled with CFR 0.152.
 */
package plugins.nchenouard.kymographtracker;

import icy.gui.frame.progress.AnnounceFrame;
import icy.gui.frame.progress.ProgressFrame;
import icy.image.IcyBufferedImage;
import icy.main.Icy;
import icy.roi.ROI;
import icy.sequence.Sequence;
import icy.type.DataType;
import java.awt.geom.PathIterator;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import plugins.kernel.roi.roi2d.ROI2DShape;
import plugins.nchenouard.isotropicwavelets.IsotropicWaveletType;
import plugins.nchenouard.kymographtracker.Util;
import plugins.nchenouard.kymographtracker.spline.CubicSmoothingSpline;
import plugins.nchenouard.rieszwavelets.HarmonicTypes;
import plugins.nchenouard.rieszwavelets.RieszConfig;
import plugins.nchenouard.rieszwavelets.RieszGeneralization;
import plugins.nchenouard.rieszwavelets.RieszWaveletCoefficients;
import plugins.nchenouard.rieszwavelets.RieszWaveletConfig;
import plugins.nchenouard.rieszwavelets.StandardRieszFrames;

public class ROItoKymograph {
    Thread computeThread;
    double resamplingStep = 1.0;
    double diskRadius = 2.0;
    ArrayList<double[]> samplingPositions;

    public ROItoKymograph() {
    }

    public ROItoKymograph(double diskRadius, double resamplingStep) {
        this.diskRadius = diskRadius;
        this.resamplingStep = resamplingStep;
    }

    public ArrayList<double[]> resamplePositions(ArrayList<double[]> positions, double step) {
        ArrayList<double[]> resampledPositions = new ArrayList<double[]>();
        if (!positions.isEmpty()) {
            double prevX = positions.get(0)[0];
            double prevY = positions.get(0)[1];
            double t = 0.0;
            double currentStep = step;
            for (int i = 1; i < positions.size(); ++i) {
                double x = positions.get(i)[0];
                double y = positions.get(i)[1];
                double currentX = prevX;
                double currentY = prevY;
                double intervalSize = Math.sqrt((prevX - x) * (prevX - x) + (prevY - y) * (prevY - y));
                double nextPostT = t + intervalSize;
                while (t + currentStep <= nextPostT) {
                    currentX = prevX + (1.0 - (nextPostT - (t += currentStep)) / intervalSize) * (x - prevX);
                    currentY = prevY + (1.0 - (nextPostT - t) / intervalSize) * (y - prevY);
                    resampledPositions.add(new double[]{currentX, currentY});
                    currentStep = step;
                }
                prevX = currentX;
                prevY = currentY;
                currentStep = step - Math.sqrt((prevX - x) * (prevX - x) + (prevY - y) * (prevY - y));
                t += Math.sqrt((prevX - x) * (prevX - x) + (prevY - y) * (prevY - y));
                prevX = x;
                prevY = y;
            }
        }
        return resampledPositions;
    }

    public ArrayList<double[]> computeSamplingPositions(Sequence sequence, ROI2DShape roi, boolean shiftFromView) {
        double shiftX = 0.0;
        double shiftY = 0.0;
        if (shiftFromView) {
            shiftX = -0.5;
            shiftY = -0.5;
        }
        PathIterator pathIterator = roi.getPathIterator(null);
        double[] coords = new double[6];
        this.samplingPositions = new ArrayList();
        while (!pathIterator.isDone()) {
            int segType = pathIterator.currentSegment(coords);
            switch (segType) {
                case 4: {
                    break;
                }
                case 3: {
                    break;
                }
                case 1: {
                    this.samplingPositions.add(new double[]{coords[0] + shiftX, coords[1] + shiftY});
                    break;
                }
                case 0: {
                    this.samplingPositions.add(new double[]{coords[0] + shiftX, coords[1] + shiftY});
                    break;
                }
            }
            pathIterator.next();
        }
        this.samplingPositions = this.resamplePositions(this.samplingPositions, this.resamplingStep);
        return this.samplingPositions;
    }

    public Sequence[] separateKymograph(Sequence kymographSeq) {
        int height = kymographSeq.getSizeY();
        int width = kymographSeq.getSizeX();
        boolean isRealImage = true;
        int numScales = 4;
        boolean prefilter = false;
        IsotropicWaveletType waveletType = IsotropicWaveletType.Simoncelli;
        int order = 6;
        HarmonicTypes harmonicType = HarmonicTypes.even;
        boolean prepareRieszFilters = true;
        RieszWaveletConfig config = new RieszWaveletConfig(width, height, isRealImage, numScales, waveletType, prefilter, prepareRieszFilters, order, harmonicType, false);
        ArrayList<RieszConfig> rieszConfigList = config.getRieszConfigurations();
        ArrayList<RieszGeneralization> generalizationList = new ArrayList<RieszGeneralization>();
        for (int i = 0; i < numScales; ++i) {
            RieszGeneralization rieszGeneralization = new RieszGeneralization(StandardRieszFrames.Simoncelli, rieszConfigList.get(i));
            generalizationList.add(rieszGeneralization);
        }
        double[] image = kymographSeq.getDataXYAsDouble(0, 0, 0);
        RieszWaveletCoefficients anteroCoefficients = config.multiscaleRieszAnalysisInFourier(image, width, height, generalizationList);
        ArrayList<double[][]> retroBands = new ArrayList<double[][]>(anteroCoefficients.getNumScales());
        for (int i = 0; i < anteroCoefficients.getNumScales(); ++i) {
            double[][] anteroCoeffs = anteroCoefficients.getRieszBandsAtScale(i);
            double[][] retroCoeffs = new double[anteroCoeffs.length][];
            for (int j = 0; j < anteroCoeffs.length; ++j) {
                retroCoeffs[j] = (double[])anteroCoeffs[j].clone();
            }
            retroBands.add(retroCoeffs);
        }
        double[] retroHPResidual = null;
        if (anteroCoefficients.getHPResidual() != null) {
            retroHPResidual = (double[])anteroCoefficients.getHPResidual().clone();
        }
        double[] retroLPResidual = (double[])anteroCoefficients.getLPResidual().clone();
        RieszWaveletCoefficients retroCoefficients = new RieszWaveletCoefficients(anteroCoefficients.getConfig(), generalizationList, retroBands, retroHPResidual, retroLPResidual, anteroCoefficients.getPadX(), anteroCoefficients.getPadY());
        for (int i = 0; i < retroCoefficients.getNumScales(); ++i) {
            double[][] retroCoeffs = retroCoefficients.getRieszBandsAtScale(i);
            for (int j = 0; j < retroCoeffs.length / 2; ++j) {
                for (int k = 0; k < retroCoeffs[j].length; ++k) {
                    retroCoeffs[j][k] = 0.0;
                }
            }
        }
        int k = 0;
        while (k < retroLPResidual.length) {
            int n = k++;
            retroLPResidual[n] = retroLPResidual[n] / 2.0;
        }
        Sequence retroSeq = new Sequence();
        double[] reconstructedImage = config.multiscaleRieszSynthesisInFourier(retroCoefficients, width, height);
        retroSeq.addImage(0, (BufferedImage)new IcyBufferedImage(width, height, (Object)reconstructedImage));
        for (int i = 0; i < anteroCoefficients.getNumScales(); ++i) {
            double[][] anteroCoeffs = anteroCoefficients.getRieszBandsAtScale(i);
            for (int j = anteroCoeffs.length / 2 + 1; j < anteroCoeffs.length; ++j) {
                for (int k2 = 0; k2 < anteroCoeffs[j].length; ++k2) {
                    anteroCoeffs[j][k2] = 0.0;
                }
            }
        }
        double[] anteroLPresidual = anteroCoefficients.getLPResidual();
        int k3 = 0;
        while (k3 < anteroLPresidual.length) {
            int n = k3++;
            anteroLPresidual[n] = anteroLPresidual[n] / 2.0;
        }
        Sequence anteroSeq = new Sequence();
        double[] reconstructedImage2 = config.multiscaleRieszSynthesisInFourier(anteroCoefficients, width, height);
        anteroSeq.addImage(0, (BufferedImage)new IcyBufferedImage(width, height, (Object)reconstructedImage2));
        return new Sequence[]{kymographSeq, anteroSeq, retroSeq};
    }

    public Sequence[] getAnteroRetroKymographSequence(Sequence sequence, double length, CubicSmoothingSpline xSpline, CubicSmoothingSpline ySpline) {
        Sequence kymographSeq = this.getKymographSequence(sequence, length, xSpline, ySpline);
        return this.separateKymograph(kymographSeq);
    }

    public Sequence[] getAnteroRetroKymographSequenceFromDisks(Sequence sequence, ArrayList<double[]> samplingPositions) {
        Sequence kymographSeq = this.getKymographSequenceFromDisks(sequence, samplingPositions);
        return this.separateKymograph(kymographSeq);
    }

    public Sequence getKymographSequence(Sequence sequence, double length, CubicSmoothingSpline xSpline, CubicSmoothingSpline ySpline) {
        ArrayList masks = new ArrayList();
        this.samplingPositions = new ArrayList();
        for (double l = 0.0; l < length; l += this.resamplingStep) {
            ArrayList<int[]> mask = new ArrayList<int[]>();
            double x = xSpline.evaluate(l);
            double y = ySpline.evaluate(l);
            this.samplingPositions.add(new double[]{x, y});
            double d = xSpline.derivative(l);
            double dy = ySpline.derivative(l);
            double ux = dy / Math.sqrt(d * d + dy * dy);
            double uy = -d / Math.sqrt(d * d + dy * dy);
            for (double tt = -this.diskRadius; tt <= this.diskRadius; tt += 1.0) {
                int xx = (int)Math.round(x + tt * ux);
                int yy = (int)Math.round(y + tt * uy);
                if (xx < 0 || xx >= sequence.getSizeX() || yy < 0 || yy >= sequence.getSizeY()) continue;
                mask.add(new int[]{xx, yy});
            }
            masks.add(mask);
        }
        Sequence kymographSeq = new Sequence();
        kymographSeq.setImage(0, 0, (BufferedImage)new IcyBufferedImage(masks.size(), sequence.getSizeT(), 1, DataType.DOUBLE));
        double[] tabValues = kymographSeq.getImage(0, 0, 0).getDataXYAsDouble(0);
        for (int t = 0; t < sequence.getSizeT(); ++t) {
            int cnt = 0;
            for (ArrayList arrayList : masks) {
                double sum = 0.0;
                for (int[] m : arrayList) {
                    sum += sequence.getData(t, 0, 0, m[1], m[0]);
                }
                if (arrayList.size() > 1) {
                    sum /= (double)arrayList.size();
                }
                tabValues[cnt + t * kymographSeq.getSizeX()] = sum;
                ++cnt;
            }
        }
        kymographSeq.dataChanged();
        return kymographSeq;
    }

    public Sequence getKymographSequenceFromDisks(Sequence sequence, ArrayList<double[]> samplingPositions) {
        ArrayList masks = new ArrayList();
        for (double[] p : samplingPositions) {
            int n;
            int minY;
            int maxX;
            int minX = (int)Math.floor(p[0] - this.diskRadius);
            if (minX < 0) {
                minX = 0;
            }
            if (minX > sequence.getSizeX()) {
                minX = sequence.getSizeX() - 1;
            }
            if ((maxX = (int)Math.ceil(p[0] + this.diskRadius)) < 0) {
                maxX = 0;
            }
            if (maxX >= sequence.getSizeX()) {
                maxX = sequence.getSizeX() - 1;
            }
            if ((minY = (int)Math.floor(p[1] - this.diskRadius)) < 0) {
                minY = 0;
            }
            if (minY > sequence.getSizeY()) {
                minY = sequence.getSizeY() - 1;
            }
            if ((n = (int)Math.ceil(p[1] + this.diskRadius)) < 0) {
                n = 0;
            }
            if (n >= sequence.getSizeY()) {
                n = sequence.getSizeY() - 1;
            }
            ArrayList<int[]> mask = new ArrayList<int[]>();
            for (int y = minY; y <= n; ++y) {
                for (int x = minX; x <= maxX; ++x) {
                    if (!((p[0] - (double)x) * (p[0] - (double)x) + (p[1] - (double)y) * (p[1] - (double)y) <= this.diskRadius * this.diskRadius)) continue;
                    mask.add(new int[]{x, y});
                }
            }
            masks.add(mask);
        }
        Sequence kymographSeq = new Sequence();
        kymographSeq.setImage(0, 0, (BufferedImage)new IcyBufferedImage(samplingPositions.size(), sequence.getSizeT(), 1, DataType.DOUBLE));
        double[] tabValues = kymographSeq.getImage(0, 0, 0).getDataXYAsDouble(0);
        for (int t = 0; t < sequence.getSizeT(); ++t) {
            int cnt = 0;
            for (ArrayList arrayList : masks) {
                double sum = 0.0;
                for (int[] m : arrayList) {
                    sum += sequence.getData(t, 0, 0, m[1], m[0]);
                }
                if (arrayList.size() > 1) {
                    sum /= (double)arrayList.size();
                }
                tabValues[cnt + t * kymographSeq.getSizeX()] = sum;
                ++cnt;
            }
        }
        kymographSeq.dataChanged();
        return kymographSeq;
    }

    class CreateKymographThread
    extends Thread {
        ArrayList<ROI> rois;
        Sequence seq;

        protected CreateKymographThread(ArrayList<ROI> rois, Sequence seq) {
            this.rois = rois;
            this.seq = seq;
        }

        @Override
        public void run() {
            AnnounceFrame announce = new AnnounceFrame("Create of Kymograph images started");
            ArrayList<ROI> selectedROIs = new ArrayList<ROI>();
            for (ROI roi : this.rois) {
                if (!(roi instanceof ROI2DShape) || !roi.isSelected()) continue;
                selectedROIs.add(roi);
            }
            if (selectedROIs.isEmpty()) {
                for (ROI roi : this.rois) {
                    if (!(roi instanceof ROI2DShape)) continue;
                    selectedROIs.add(roi);
                }
            }
            if (selectedROIs.isEmpty()) {
                return;
            }
            ProgressFrame bar = new ProgressFrame("Processing started");
            bar.setLength((double)selectedROIs.size());
            boolean cnt = false;
            for (ROI roi : selectedROIs) {
                bar.setMessage("Processing roi " + roi.getName());
                bar.setPosition((double)cnt);
                Sequence kymograph = null;
                CubicSmoothingSpline xSpline = Util.getXsplineFromROI((ROI2DShape)roi);
                CubicSmoothingSpline ySpline = Util.getYsplineFromROI((ROI2DShape)roi);
                double length = Util.getSplineLength((ROI2DShape)roi);
                kymograph = ROItoKymograph.this.getKymographSequence(this.seq, length, xSpline, ySpline);
                kymograph.setName(this.seq.getName() + "_" + roi.getName() + "_kymograph");
                Icy.getMainInterface().addSequence(kymograph);
            }
            bar.close();
            announce.close();
        }
    }
}

