/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.geom;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.filter.ThresholdToSelection;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import mcib3d.geom.GeomTransform3D;
import mcib3d.geom.Object3D;
import mcib3d.geom.ObjectCreator3D;
import mcib3d.geom.Vector3D;
import mcib3d.geom.Voxel3D;
import mcib3d.image3d.ImageByte;
import mcib3d.image3d.ImageFloat;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.ImageInt;
import mcib3d.image3d.ImageLabeller;
import mcib3d.image3d.ImageShort;
import mcib3d.image3d.processing.FillHoles3D;
import mcib3d.utils.ArrayUtil;
import mcib3d.utils.KDTreeC;

public class Object3DVoxels
extends Object3D {
    ArrayList<Voxel3D> voxels = null;
    private boolean showStatus = false;
    private double correctedSurfaceArea;

    public Object3DVoxels() {
        this.value = 1;
        this.resXY = 1.0;
        this.resZ = 1.0;
        this.units = "pix";
        this.voxels = new ArrayList();
    }

    public Object3DVoxels(int val) {
        this.value = val;
        this.resXY = 1.0;
        this.resZ = 1.0;
        this.units = "pix";
        this.voxels = new ArrayList();
    }

    public Object3DVoxels(ImageHandler ima, int val) {
        this.value = val;
        this.resXY = ima.getScaleXY();
        this.resZ = ima.getScaleZ();
        this.units = ima.getUnit();
        this.voxels = this.createArrayList(ima, null);
        this.init();
    }

    public Object3DVoxels(ImageHandler ima) {
        this.value = (int)ima.getMax();
        this.resXY = ima.getScaleXY();
        this.resZ = ima.getScaleZ();
        this.units = ima.getUnit();
        this.voxels = this.createArrayList(ima, null);
        this.init();
    }

    public Object3DVoxels(ImageHandler imaSeg, ImageHandler imaRaw) {
        this.value = (int)imaSeg.getMax();
        this.resXY = imaSeg.getScaleXY();
        this.resZ = imaSeg.getScaleZ();
        this.units = imaSeg.getUnit();
        this.voxels = this.createArrayList(imaSeg, imaRaw);
        this.init();
    }

    public Object3DVoxels(ImagePlus plus, int val) {
        this.value = val;
        this.resXY = 1.0;
        this.resZ = 1.0;
        this.units = "pix";
        Calibration cal = plus.getCalibration();
        if (cal != null && cal.scaled()) {
            this.resXY = cal.getX(1.0);
            this.resZ = cal.getZ(1.0);
            this.units = cal.getUnits();
        }
        this.voxels = this.createArrayList(ImageInt.wrap(plus), null);
        this.init();
    }

    public Object3DVoxels(ImageStack stack, int val) {
        this.value = val;
        this.resXY = 1.0;
        this.resZ = 1.0;
        this.units = "pix";
        this.voxels = this.createArrayList(ImageInt.wrap(stack), null);
        this.init();
    }

    public Object3DVoxels(ArrayList<Voxel3D> al) {
        this.voxels = al;
        this.init();
        this.value = (int)this.voxels.get(0).getValue();
        this.resXY = 1.0;
        this.resZ = 1.0;
        this.units = "pix";
    }

    public Object3DVoxels(Object3DVoxels other) {
        this.voxels = new ArrayList();
        this.addVoxels(other.getVoxels());
        this.init();
        this.value = other.getValue();
        this.setCalibration(other.getResXY(), other.getResZ(), other.getUnits());
    }

    public Object3DVoxels(Object3D other) {
        this.voxels = new ArrayList();
        this.addVoxels(other.getVoxels());
        this.init();
        this.value = other.getValue();
        this.setCalibration(other.getResXY(), other.getResZ(), other.getUnits());
    }

    public Object3DVoxels copyObject(int newLabel) {
        Object3DVoxels res = new Object3DVoxels(this.getVoxels());
        if (newLabel != this.value) {
            this.computeContours();
            res.setContours(this.contours, this.areaContactUnit);
            res.setValue(newLabel);
        }
        res.resXY = this.resXY;
        res.resZ = this.resZ;
        res.units = this.units;
        return res;
    }

    private ArrayList<Voxel3D> createArrayList(ImageHandler ima, ImageHandler raw) {
        ArrayList<Voxel3D> voxelsTmp = new ArrayList<Voxel3D>();
        this.xmin = ima.sizeX;
        this.xmax = 0;
        this.ymin = ima.sizeY;
        this.ymax = 0;
        this.zmin = ima.sizeZ;
        this.zmax = 0;
        for (int k = 0; k < ima.sizeZ; ++k) {
            for (int j = 0; j < ima.sizeY; ++j) {
                for (int i = 0; i < ima.sizeX; ++i) {
                    if (ima.getPixel(i, j, k) != (float)this.value) continue;
                    float val = raw == null ? (float)this.value : raw.getPixel(i, j, k);
                    voxelsTmp.add(new Voxel3D(i, j, k, val));
                }
            }
        }
        return voxelsTmp;
    }

    public void createSphereUnit(float cx, float cy, float cz, float rad) {
        float rxy = (float)this.getResXY();
        float rz = (float)this.getResZ();
        int ix = Math.round(cx);
        int iy = Math.round(cy);
        int iz = Math.round(cz);
        float raxy = rad / rxy;
        float raz = rad / rz;
        this.createEllipsoidPixel(ix, iy, iz, raxy, raxy, raz);
    }

    public void createEllipsoidPixel(int cx, int cy, int cz, float rx, float ry, float rz) {
        ObjectCreator3D ell = new ObjectCreator3D((int)(2.0f * rx + 1.0f), (int)(2.0f * ry + 1.0f), (int)(2.0f * rz + 1.0f));
        int ex = Math.round(rx);
        int ey = Math.round(ry);
        int ez = Math.round(rz);
        ell.createEllipsoid(ex, ey, ez, rx, ry, rz, 255.0f, false);
        int tmpval = this.getValue();
        this.setValue(255);
        this.voxels = this.createArrayList(ell.getImageHandler(), null);
        this.setValue(tmpval);
        this.translate(cx - ex, cy - ey, cz - ez);
        this.init();
    }

    public void addVoxelsIntersection(Object3D ob1, Object3D ob2) {
        ArrayList<Voxel3D> al1 = ob1.getVoxels();
        ArrayList<Voxel3D> al2 = ob2.getVoxels();
        double dist = 0.25;
        Iterator<Voxel3D> iterator = al1.iterator();
        block0: while (iterator.hasNext()) {
            Voxel3D anAl1;
            Voxel3D v1 = anAl1 = iterator.next();
            for (Voxel3D anAl2 : al2) {
                Voxel3D v2 = anAl2;
                if (!(v1.distanceSquare(v2) < dist)) continue;
                this.voxels.add(new Voxel3D(v1));
                continue block0;
            }
        }
        this.init();
        this.contours = null;
    }

    public void addVoxelsIntersection(ArrayList<Object3D> objs) {
        int nbob = objs.size();
        ArrayList<Voxel3D> al1 = objs.get(0).getVoxels();
        ArrayList<Voxel3D> al2 = objs.get(1).getVoxels();
        double dist = 0.25;
        Iterator<Voxel3D> iterator = al1.iterator();
        while (iterator.hasNext()) {
            Voxel3D anAl1;
            Voxel3D v1 = anAl1 = iterator.next();
            for (Voxel3D anAl2 : al2) {
                Voxel3D v2 = anAl2;
                if (!(v1.distanceSquare(v2) < dist)) continue;
                boolean ok = true;
                int i = 2;
                block2: while (ok && i < nbob) {
                    ok = false;
                    for (Voxel3D v : objs.get(i).getVoxels()) {
                        if (!(v1.distanceSquare(v) < dist)) continue;
                        ok = true;
                        ++i;
                        continue block2;
                    }
                }
                if (!ok) continue;
                this.voxels.add(new Voxel3D(v1));
            }
        }
        this.init();
    }

    public void addVoxelsUnion(Object3D ob1, Object3D ob2) {
        Voxel3D v;
        ArrayList<Voxel3D> al1 = ob1.getVoxels();
        ArrayList<Voxel3D> al2 = ob2.getVoxels();
        Iterator<Voxel3D> iterator = al1.iterator();
        while (iterator.hasNext()) {
            Voxel3D anAl1;
            v = anAl1 = iterator.next();
            this.voxels.add(v);
        }
        iterator = al2.iterator();
        while (iterator.hasNext()) {
            Voxel3D anAl2;
            v = anAl2 = iterator.next();
            this.voxels.add(v);
        }
        this.init();
        this.contours = null;
    }

    public void addVoxelsUnion(ArrayList<Object3D> objs) {
        for (Object3D ob : objs) {
            for (Voxel3D v : ob.getVoxels()) {
                this.voxels.add(v);
            }
        }
        this.init();
        this.contours = null;
    }

    private void substractObjectVoxels(Object3D other) {
        ArrayList<Voxel3D> al2 = other.getVoxels();
        ArrayList<Voxel3D> al11 = new ArrayList<Voxel3D>();
        double dist = 0.25;
        for (Voxel3D vox : this.voxels) {
            boolean inter = false;
            for (Voxel3D vox2 : al2) {
                if (!(vox.distanceSquare(vox2) < dist)) continue;
                inter = true;
                break;
            }
            if (inter) continue;
            al11.add(vox);
        }
        this.voxels = al11;
        this.init();
        this.contours = null;
    }

    private void substractObjectImage(Object3D obj) {
        ImageInt seg = this.createSegImage(0, 0, 0, this.getXmax(), this.getYmax(), this.getZmax(), this.getValue());
        obj.draw(seg, 0);
        this.voxels = this.createArrayList(seg, null);
        this.init();
    }

    public void substractObject(Object3D other) {
        int seuil_vol = 100;
        if (this.getVolumePixels() > 100 || other.getVolumePixels() > 100) {
            this.substractObjectImage(other);
        } else {
            this.substractObjectVoxels(other);
        }
    }

    public final void addVoxels(ArrayList<Voxel3D> vox) {
        this.voxels.addAll(vox);
        this.init();
        this.contours = null;
    }

    public void removeVoxels(int threshold) {
        ArrayList<Voxel3D> toRemove = new ArrayList<Voxel3D>();
        for (Voxel3D V : this.voxels) {
            if (!(V.getValue() < (double)threshold)) continue;
            toRemove.add(V);
        }
        if (!toRemove.isEmpty()) {
            this.voxels.removeAll(toRemove);
            this.init();
            this.contours = null;
        }
    }

    public boolean isConnex() {
        ImageLabeller labeler = new ImageLabeller();
        ImageInt seg = this.getLabelImage();
        return labeler.getNbObjectsTotal(seg) == 1;
    }

    public ArrayList<Object3DVoxels> getConnexComponents() {
        ImageInt seg = this.getLabelImage();
        ImageLabeller labeler = new ImageLabeller();
        ArrayList<Object3DVoxels> objs = labeler.getObjects(seg);
        for (Object3DVoxels O : objs) {
            O.translate(seg.offsetX, seg.offsetY, seg.offsetZ);
        }
        return objs;
    }

    public Object3DVoxels getInterior3DFill() {
        ImageInt seg = this.getLabelImage();
        ImageInt fill = seg.duplicate();
        FillHoles3D.process(fill, this.value, 0, false);
        ImageFloat res = fill.subtractImage(seg);
        Object3DVoxels inte = new Object3DVoxels(res);
        inte.translate(seg.offsetX, seg.offsetY, seg.offsetZ);
        return inte;
    }

    public void setShowStatus(boolean showStatus) {
        this.showStatus = showStatus;
    }

    @Override
    public Voxel3D getPixelMax(ImageHandler ima) {
        Voxel3D res = null;
        float max = -3.4028235E38f;
        for (Voxel3D vox : this.voxels) {
            float pix = ima.getPixel(vox);
            if (!(pix > max)) continue;
            max = pix;
            res = new Voxel3D(vox);
        }
        return res;
    }

    public void computeMomentsInertia() {
        this.s200 = 0.0;
        this.s110 = 0.0;
        this.s101 = 0.0;
        this.s020 = 0.0;
        this.s011 = 0.0;
        this.s002 = 0.0;
        Iterator<Voxel3D> iterator = this.voxels.iterator();
        while (iterator.hasNext()) {
            Voxel3D voxel;
            Voxel3D vox = voxel = iterator.next();
            double i = vox.getX();
            double j = vox.getY();
            double k = vox.getZ();
            this.s200 += this.resXY * this.resXY * (j - this.by) * (j - this.by) + this.resZ * this.resZ * (k - this.bz) * (k - this.bz);
            this.s020 += this.resXY * this.resXY * (i - this.bx) * (i - this.bx) + this.resZ * this.resZ * (k - this.bz) * (k - this.bz);
            this.s002 += this.resXY * this.resXY * (i - this.bx) * (i - this.bx) + this.resXY * this.resXY * (j - this.by) * (j - this.by);
            this.s110 += this.resXY * this.resXY * (i - this.bx) * (j - this.by);
            this.s101 += this.resXY * this.resZ * (i - this.bx) * (k - this.bz);
            this.s011 += this.resXY * this.resZ * (j - this.by) * (k - this.bz);
        }
    }

    @Override
    protected void computeMoments2(boolean normalize) {
        this.s200 = 0.0;
        this.s110 = 0.0;
        this.s101 = 0.0;
        this.s020 = 0.0;
        this.s011 = 0.0;
        this.s002 = 0.0;
        Iterator<Voxel3D> iterator = this.voxels.iterator();
        while (iterator.hasNext()) {
            Voxel3D voxel;
            Voxel3D vox = voxel = iterator.next();
            double i = vox.getX();
            double j = vox.getY();
            double k = vox.getZ();
            this.s200 += (i - this.bx) * (i - this.bx);
            this.s020 += (j - this.by) * (j - this.by);
            this.s002 += (k - this.bz) * (k - this.bz);
            this.s110 += (i - this.bx) * (j - this.by);
            this.s101 += (i - this.bx) * (k - this.bz);
            this.s011 += (j - this.by) * (k - this.bz);
        }
        this.s200 *= this.resXY * this.resXY;
        this.s020 *= this.resXY * this.resXY;
        this.s002 *= this.resZ * this.resZ;
        this.s110 *= this.resXY * this.resXY;
        this.s101 *= this.resXY * this.resZ;
        this.s011 *= this.resXY * this.resZ;
        if (normalize) {
            this.s200 /= (double)this.volume;
            this.s020 /= (double)this.volume;
            this.s002 /= (double)this.volume;
            this.s110 /= (double)this.volume;
            this.s101 /= (double)this.volume;
            this.s011 /= (double)this.volume;
        }
        this.eigen = null;
    }

    @Override
    public void computeMoments3() {
        this.s003 = 0.0;
        this.s030 = 0.0;
        this.s300 = 0.0;
        this.s111 = 0.0;
        this.s012 = 0.0;
        this.s102 = 0.0;
        this.s021 = 0.0;
        this.s120 = 0.0;
        this.s201 = 0.0;
        this.s210 = 0.0;
        Iterator<Voxel3D> iterator = this.voxels.iterator();
        while (iterator.hasNext()) {
            Voxel3D voxel;
            Voxel3D vox = voxel = iterator.next();
            double i = vox.getX();
            double j = vox.getY();
            double k = vox.getZ();
            double xx = i - this.bx;
            double yy = j - this.by;
            double zz = k - this.bz;
            this.s300 += xx * xx * xx;
            this.s030 += yy * yy * yy;
            this.s003 += zz * zz * zz;
            this.s210 += xx * xx * yy;
            this.s201 += xx * xx * zz;
            this.s120 += yy * yy * xx;
            this.s021 += yy * yy * zz;
            this.s102 += zz * zz * xx;
            this.s012 += zz * zz * yy;
            this.s111 += xx * yy * zz;
        }
        this.s300 *= this.resXY * this.resXY * this.resXY;
        this.s030 *= this.resXY * this.resXY * this.resXY;
        this.s003 *= this.resZ * this.resZ * this.resZ;
        this.s210 *= this.resXY * this.resXY * this.resXY;
        this.s201 *= this.resXY * this.resXY * this.resZ;
        this.s120 *= this.resXY * this.resXY * this.resXY;
        this.s021 *= this.resXY * this.resXY * this.resZ;
        this.s102 *= this.resZ * this.resZ * this.resXY;
        this.s012 *= this.resZ * this.resZ * this.resXY;
        this.s111 *= this.resXY * this.resXY * this.resZ;
    }

    @Override
    public void computeMoments4() {
        this.s211 = 0.0;
        this.s112 = 0.0;
        this.s121 = 0.0;
        this.s022 = 0.0;
        this.s202 = 0.0;
        this.s220 = 0.0;
        this.s040 = 0.0;
        this.s040 = 0.0;
        this.s400 = 0.0;
        this.s031 = 0.0;
        this.s013 = 0.0;
        this.s310 = 0.0;
        this.s130 = 0.0;
        this.s301 = 0.0;
        this.s103 = 0.0;
        Iterator<Voxel3D> iterator = this.voxels.iterator();
        while (iterator.hasNext()) {
            Voxel3D voxel;
            Voxel3D vox = voxel = iterator.next();
            double i = vox.getX();
            double j = vox.getY();
            double k = vox.getZ();
            double xx = i - this.bx;
            double yy = j - this.by;
            double zz = k - this.bz;
            this.s400 += xx * xx * xx * xx;
            this.s040 += yy * yy * yy * yy;
            this.s004 += zz * zz * zz * zz;
            this.s220 += xx * xx * yy * yy;
            this.s202 += xx * xx * zz * zz;
            this.s022 += yy * yy * zz * zz;
            this.s121 += xx * yy * yy * zz;
            this.s112 += xx * yy * zz * zz;
            this.s211 += xx * xx * yy * zz;
            this.s103 += xx * zz * zz * zz;
            this.s301 += xx * xx * xx * zz;
            this.s130 += xx * yy * yy * yy;
            this.s310 += xx * xx * xx * yy;
            this.s013 += yy * zz * zz * zz;
            this.s031 += yy * yy * yy * zz;
        }
        this.s400 *= this.resXY * this.resXY * this.resXY * this.resXY;
        this.s040 *= this.resXY * this.resXY * this.resXY * this.resXY;
        this.s004 *= this.resZ * this.resZ * this.resZ * this.resZ;
        this.s220 *= this.resXY * this.resXY * this.resXY * this.resXY;
        this.s202 *= this.resXY * this.resXY * this.resZ * this.resZ;
        this.s022 *= this.resXY * this.resXY * this.resZ * this.resZ;
        this.s121 *= this.resXY * this.resXY * this.resXY * this.resZ;
        this.s112 *= this.resXY * this.resXY * this.resZ * this.resZ;
        this.s211 *= this.resXY * this.resXY * this.resXY * this.resZ;
        this.s103 *= this.resXY * this.resZ * this.resZ * this.resZ;
        this.s301 *= this.resXY * this.resXY * this.resXY * this.resZ;
        this.s130 *= this.resXY * this.resXY * this.resXY * this.resXY;
        this.s310 *= this.resXY * this.resXY * this.resXY * this.resXY;
        this.s013 *= this.resXY * this.resZ * this.resZ * this.resZ;
        this.s031 *= this.resXY * this.resXY * this.resXY * this.resZ;
    }

    @Override
    protected void computeCenter() {
        this.bx = 0.0;
        this.by = 0.0;
        this.bz = 0.0;
        for (Voxel3D vox : this.voxels) {
            this.bx += vox.getX();
            this.by += vox.getY();
            this.bz += vox.getZ();
        }
        int sum = this.voxels.size();
        this.bx /= (double)sum;
        this.by /= (double)sum;
        this.bz /= (double)sum;
        this.volume = sum;
    }

    public void setContours(ArrayList<Voxel3D> contours, double areaUnit) {
        this.areaContactUnit = areaUnit;
        this.areaNbVoxels = contours.size();
        this.contours = contours;
        this.kdtreeContours = null;
    }

    private void computeContours(ImageInt segImage, int x0, int y0, int z0) {
        this.kdtreeContours = new KDTreeC(3);
        this.kdtreeContours.setScale3(this.resXY, this.resXY, this.resZ);
        this.areaNbVoxels = 0.0;
        this.areaContactUnit = 0.0;
        this.areaContactVoxels = 0.0;
        this.contours = new ArrayList();
        double XZ = this.resXY * this.resZ;
        double XX = this.resXY * this.resXY;
        int sx = segImage.sizeX;
        int sy = segImage.sizeY;
        int sz = segImage.sizeZ;
        int class1 = 0;
        int class2 = 0;
        int class3 = 0;
        int class4 = 0;
        int class5 = 0;
        int class6 = 0;
        int val = this.value;
        if (val == 0) {
            val = (int)segImage.getMinAboveValue(0.0f);
        }
        for (int k = this.zmin - z0; k <= this.zmax - z0; ++k) {
            if (this.showStatus) {
                // empty if block
            }
            for (int j = this.ymin - y0; j <= this.ymax - y0; ++j) {
                for (int i = this.xmin - x0; i <= this.xmax - x0; ++i) {
                    int pix0;
                    boolean cont = false;
                    if (!segImage.contains(i, j, k) || (pix0 = segImage.getPixelInt(i, j, k)) != val) continue;
                    int face = 0;
                    boolean class3or4 = false;
                    int pix1 = i + 1 < sx ? segImage.getPixelInt(i + 1, j, k) : 0;
                    int pix2 = i - 1 >= 0 ? segImage.getPixelInt(i - 1, j, k) : 0;
                    int pix3 = j + 1 < sy ? segImage.getPixelInt(i, j + 1, k) : 0;
                    int pix4 = j - 1 >= 0 ? segImage.getPixelInt(i, j - 1, k) : 0;
                    int pix5 = k + 1 < sz ? segImage.getPixelInt(i, j, k + 1) : 0;
                    int pix6 = k - 1 >= 0 ? segImage.getPixelInt(i, j, k - 1) : 0;
                    if (pix1 != val) {
                        cont = true;
                        this.areaContactUnit += XZ;
                        this.areaContactVoxels += 1.0;
                        ++face;
                        if (pix2 != val) {
                            class3or4 = true;
                        }
                    }
                    if (pix2 != val) {
                        cont = true;
                        this.areaContactUnit += XZ;
                        this.areaContactVoxels += 1.0;
                        ++face;
                    }
                    if (pix3 != val) {
                        cont = true;
                        this.areaContactUnit += XZ;
                        this.areaContactVoxels += 1.0;
                        ++face;
                        if (pix4 != val) {
                            class3or4 = true;
                        }
                    }
                    if (pix4 != val) {
                        cont = true;
                        this.areaContactUnit += XZ;
                        this.areaContactVoxels += 1.0;
                        ++face;
                    }
                    if (pix5 != val) {
                        cont = true;
                        this.areaContactUnit += XX;
                        this.areaContactVoxels += 1.0;
                        ++face;
                        if (pix6 != val) {
                            class3or4 = true;
                        }
                    }
                    if (pix6 != val) {
                        cont = true;
                        this.areaContactUnit += XX;
                        this.areaContactVoxels += 1.0;
                        ++face;
                    }
                    if (!cont) continue;
                    this.areaNbVoxels += 1.0;
                    Voxel3D voxC = new Voxel3D(i + x0, j + y0, k + z0, val);
                    this.contours.add(voxC);
                    this.kdtreeContours.add(voxC.getArray(), voxC);
                    if (face == 1) {
                        ++class1;
                    }
                    if (face == 2) {
                        ++class2;
                    }
                    if (face == 3 && !class3or4) {
                        ++class3;
                    }
                    if (face == 3 && class3or4) {
                        ++class4;
                    }
                    if (face == 4) {
                        ++class5;
                    }
                    if (face != 5) continue;
                    ++class6;
                }
            }
        }
        double w1 = 0.894;
        double w2 = 1.3409;
        double w3 = 1.5879;
        double w4 = 2.0;
        double w5 = 2.6666666666666665;
        double w6 = 3.3333333333333335;
        this.correctedSurfaceArea = (double)class1 * w1 + (double)class2 * w2 + (double)class3 * w3 + (double)class4 * w4 + (double)class5 * w5 + (double)class6 * w6;
    }

    @Override
    public void computeContours() {
        ImageInt label = this.getLabelImage();
        this.computeContours(label, label.offsetX, label.offsetY, label.offsetZ);
    }

    @Override
    protected void computeBounding() {
        this.xmin = Integer.MAX_VALUE;
        this.xmax = 0;
        this.ymin = Integer.MAX_VALUE;
        this.ymax = 0;
        this.zmin = Integer.MAX_VALUE;
        this.zmax = 0;
        for (Voxel3D voxel : this.voxels) {
            Voxel3D vox = voxel;
            if (vox.getX() < (double)this.xmin) {
                this.xmin = (int)Math.floor(vox.getX());
            }
            if (vox.getX() > (double)this.xmax) {
                this.xmax = (int)Math.ceil(vox.getX());
            }
            if (vox.getY() < (double)this.ymin) {
                this.ymin = (int)Math.floor(vox.getY());
            }
            if (vox.getY() > (double)this.ymax) {
                this.ymax = (int)Math.ceil(vox.getY());
            }
            if (vox.getZ() < (double)this.zmin) {
                this.zmin = (int)Math.floor(vox.getZ());
            }
            if (!(vox.getZ() > (double)this.zmax)) continue;
            this.zmax = (int)Math.ceil(vox.getZ());
        }
    }

    private void computeEigenInertia() {
        if (this.eigen == null) {
            Matrix mat = new Matrix(3, 3);
            mat.set(0, 0, this.s200);
            mat.set(0, 1, -this.s110);
            mat.set(0, 2, -this.s101);
            mat.set(1, 0, -this.s110);
            mat.set(1, 1, this.s020);
            mat.set(1, 2, -this.s011);
            mat.set(2, 0, -this.s101);
            mat.set(2, 1, -this.s011);
            mat.set(2, 2, this.s002);
            this.eigen = new EigenvalueDecomposition(mat);
        }
    }

    protected ArrayList<Voxel3D> getVoxelInsideBoundingBox(int[] boundingBox) {
        ArrayList<Voxel3D> res = new ArrayList<Voxel3D>();
        for (Voxel3D v : this.voxels) {
            if (!v.isInsideBoundingBox(boundingBox)) continue;
            res.add(v);
        }
        return res;
    }

    @Override
    public int getColoc(Object3D obj) {
        if (this.disjointBox(obj)) {
            return 0;
        }
        if (this.labelImage != null && obj.getLabelImage() != null) {
            return this.getColocImage(obj);
        }
        int thres = 1000;
        if (this.getVolumePixels() > thres && obj.getVolumePixels() > thres) {
            return this.getColocImage(obj);
        }
        return this.getColocVoxels(obj);
    }

    @Override
    public boolean hasOneVoxelColoc(Object3D obj) {
        return this.hasOneVoxelColocVoxels(obj);
    }

    private int getColocImage(Object3D obj) {
        if (this.disjointBox(obj)) {
            return 0;
        }
        if (this.getLabelImage() == null || obj.getLabelImage() == null) {
            return this.getColocImageIntersection(obj);
        }
        int count = 0;
        int val = obj.getValue();
        ImageInt otherseg = obj.getLabelImage();
        ImageInt label = this.getLabelImage();
        int offX0 = label.offsetX;
        int offY0 = label.offsetY;
        int offZ0 = label.offsetZ;
        int offX1 = otherseg.offsetX;
        int offY1 = otherseg.offsetY;
        int offZ1 = otherseg.offsetZ;
        int xmin0 = this.getXmin();
        int ymin0 = this.getYmin();
        int zmin0 = this.getZmin();
        int xmax0 = this.getXmax();
        int ymax0 = this.getYmax();
        int zmax0 = this.getZmax();
        xmin0 = Math.max(xmin0, obj.getXmin());
        ymin0 = Math.max(ymin0, obj.getYmin());
        zmin0 = Math.max(zmin0, obj.getZmin());
        xmax0 = Math.min(xmax0, obj.getXmax());
        ymax0 = Math.min(ymax0, obj.getYmax());
        zmax0 = Math.min(zmax0, obj.getZmax());
        for (int k = zmin0; k <= zmax0; ++k) {
            for (int j = ymin0; j <= ymax0; ++j) {
                for (int i = xmin0; i <= xmax0; ++i) {
                    int x = i - offX0;
                    int y = j - offY0;
                    int z = k - offZ0;
                    int xx = i - offX1;
                    int yy = j - offY1;
                    int zz = k - offZ1;
                    if (!label.contains(x, y, z) || !otherseg.contains(xx, yy, zz) || label.getPixel(x, y, z) != (float)this.value || otherseg.getPixel(xx, yy, zz) != (float)val) continue;
                    ++count;
                }
            }
        }
        return count;
    }

    private int getColocImageIntersection(Object3D other) {
        ImageInt inter = this.createIntersectionImage(other, 1, 2);
        int count = 0;
        for (int i = 0; i < inter.sizeXYZ; ++i) {
            if (inter.getPixelInt(i) != 3) continue;
            ++count;
        }
        return count;
    }

    public int getColocVoxels(Object3D obj) {
        if (this.disjointBox(obj)) {
            return 0;
        }
        int[] intersec = this.getIntersectionBox(obj);
        ArrayList<Voxel3D> al1 = this.getVoxelInsideBoundingBox(intersec);
        if (!(obj instanceof Object3DVoxels)) {
            obj = obj.getObject3DVoxels();
        }
        ArrayList<Voxel3D> al2 = ((Object3DVoxels)obj).getVoxelInsideBoundingBox(intersec);
        int cpt = 0;
        for (Voxel3D v1 : al1) {
            for (Voxel3D v2 : al2) {
                if (!v1.sameVoxel(v2)) continue;
                ++cpt;
            }
        }
        return cpt;
    }

    private boolean hasOneVoxelColocVoxels(Object3D obj) {
        if (this.disjointBox(obj)) {
            return false;
        }
        int[] intersec = this.getIntersectionBox(obj);
        ArrayList<Voxel3D> al1 = this.getVoxelInsideBoundingBox(intersec);
        if (!(obj instanceof Object3DVoxels)) {
            obj = obj.getObject3DVoxels();
        }
        ArrayList<Voxel3D> al2 = ((Object3DVoxels)obj).getVoxelInsideBoundingBox(intersec);
        for (Voxel3D v1 : al1) {
            for (Voxel3D v2 : al2) {
                if (!v1.sameVoxel(v2)) continue;
                return true;
            }
        }
        return false;
    }

    public double pcColoc2(ArrayList<Object3DVoxels> objs) {
        int nb = objs.size();
        int cpt = 0;
        int sumVol = 1;
        Object3DVoxels ob1 = this;
        Object3DVoxels ob2 = objs.get(0);
        if (ob1.pcColoc(ob2) > 0.0) {
            Object3DVoxels obInter = new Object3DVoxels();
            obInter.addVoxelsIntersection(ob1, ob2);
            cpt = obInter.getVolumePixels();
            sumVol = ob1.getVolumePixels() + ob2.getVolumePixels();
            int i = 1;
            boolean ok = true;
            while (ok && i < nb) {
                ok = false;
                Object3DVoxels ob3 = objs.get(i);
                if (!obInter.overlapBox(ob3)) {
                    cpt = 0;
                    continue;
                }
                if (obInter.pcColoc(ob3) > 0.0) {
                    ok = true;
                    sumVol += ob3.getVolumePixels();
                    Object3DVoxels ob4 = new Object3DVoxels();
                    ob4.addVoxelsIntersection(obInter, ob3);
                    obInter = ob4;
                    cpt = obInter.getVolumePixels();
                    ++i;
                    continue;
                }
                cpt = 0;
            }
        }
        double pourc = 100.0 * (double)(nb * cpt) / (double)sumVol;
        return pourc;
    }

    @Override
    public void draw(ObjectCreator3D obj, int col) {
        for (Voxel3D voxel : this.voxels) {
            int vz;
            int vy;
            Voxel3D vox = voxel;
            int vx = vox.getRoundX();
            if (!obj.img.contains(vx, vy = vox.getRoundY(), vz = vox.getRoundZ())) continue;
            obj.createPixel(vx, vy, vz, col);
        }
    }

    @Override
    public Roi createRoi(int z) {
        int sx = this.getXmax() - this.getXmin() + 1;
        int sy = this.getYmax() - this.getYmin() + 1;
        ByteProcessor mask = new ByteProcessor(sx, sy);
        this.draw(mask, z, 255);
        ImagePlus maskPlus = new ImagePlus("mask " + z, (ImageProcessor)mask);
        ThresholdToSelection tts = new ThresholdToSelection();
        tts.setup("", maskPlus);
        tts.run((ImageProcessor)mask);
        maskPlus.updateAndDraw();
        Roi roi = maskPlus.getRoi();
        Rectangle rect = roi.getBounds();
        rect.x += this.getXmin();
        rect.y += this.getYmin();
        return roi;
    }

    @Override
    public boolean draw(ByteProcessor mask, int z, int col) {
        boolean ok = false;
        for (Voxel3D voxel : this.voxels) {
            Voxel3D vox = voxel;
            if (!(Math.abs((double)z - vox.getZ()) < 0.5)) continue;
            mask.putPixel(vox.getRoundX(), vox.getRoundY(), col);
            ok = true;
        }
        return ok;
    }

    public void drawContours(ObjectCreator3D ima, int col) {
        Iterator iterator = this.contours.iterator();
        while (iterator.hasNext()) {
            Voxel3D contour;
            Voxel3D p2 = contour = (Voxel3D)iterator.next();
            ima.createPixel(p2.getRoundX(), p2.getRoundY(), p2.getRoundZ(), col);
        }
    }

    public void drawContoursXY(ObjectCreator3D ima, int z, int col) {
        ImageInt seg = this.getMaxLabelImage(1);
        for (Voxel3D contour : this.contours) {
            ArrayUtil arrayUtil;
            Voxel3D p2 = contour;
            if (!(Math.abs(p2.getZ() - (double)z) < 0.5) || !(arrayUtil = seg.getNeighborhoodXY3x3(p2.getRoundX(), p2.getRoundY(), p2.getRoundZ())).hasValue(0)) continue;
            ima.createPixel(p2.getRoundX(), p2.getRoundY(), p2.getRoundZ(), col);
        }
    }

    @Override
    public void draw(ImageStack mask, int col) {
        Iterator<Voxel3D> iterator = this.voxels.iterator();
        while (iterator.hasNext()) {
            Voxel3D voxel;
            Voxel3D vox = voxel = iterator.next();
            mask.setVoxel(vox.getRoundX(), vox.getRoundY(), vox.getRoundZ(), (double)col);
        }
    }

    @Override
    public void draw(ImageStack mask, int r, int g, int b) {
        Color col = new Color(r, g, b);
        Iterator<Voxel3D> iterator = this.voxels.iterator();
        while (iterator.hasNext()) {
            Voxel3D voxel;
            Voxel3D vox = voxel = iterator.next();
            ImageProcessor tmp = mask.getProcessor((int)(vox.getZ() + 1.0));
            tmp.setColor(col);
            tmp.drawPixel(vox.getRoundX(), vox.getRoundY());
        }
    }

    @Override
    public ArrayList<Voxel3D> getVoxels() {
        return this.voxels;
    }

    public void setVoxels(ArrayList<Voxel3D> al) {
        this.voxels = al;
        this.init();
    }

    public Voxel3D getFirstVoxel() {
        return this.voxels.get(0);
    }

    public Voxel3D getRandomvoxel(Random ra) {
        if (this.isEmpty()) {
            return null;
        }
        return this.voxels.get(ra.nextInt(this.getVolumePixels()));
    }

    public double getDiscreteCompactness() {
        double n = this.getVolumePixels();
        double tmp = Math.pow(n, 0.6666666666666666);
        return (n - this.areaContactVoxels / 6.0) / (n - tmp);
    }

    public double getCompactnessCorrected() {
        double V = this.getVolumePixels();
        double S = this.correctedSurfaceArea;
        return 113.09733552923255 * V * V / (S * S * S);
    }

    public double getSphericityCorrected() {
        return Math.pow(this.getCompactnessCorrected(), 0.3333333333333333);
    }

    public double getAreaPixelsCorrected() {
        if (this.correctedSurfaceArea == -1.0) {
            this.computeContours();
        }
        return this.correctedSurfaceArea;
    }

    @Override
    public void saveObject(String path) {
        int c = 0;
        try {
            BufferedWriter bf = new BufferedWriter(new FileWriter(path + this.name + ".3droi"));
            this.saveInfo(bf);
            for (Voxel3D voxel : this.voxels) {
                Voxel3D pixel = new Voxel3D(voxel);
                bf.write(++c + "\t" + pixel.getX() + "\t" + pixel.getY() + "\t" + pixel.getZ() + "\t" + pixel.getValue() + "\n");
            }
            bf.close();
        }
        catch (IOException ex) {
            Logger.getLogger(Object3DVoxels.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void loadObject(String path, String name) {
        this.setName(name);
        this.voxels = new ArrayList();
        try {
            BufferedReader bf = new BufferedReader(new FileReader(path + name));
            String data = this.loadInfo(bf);
            while (data != null) {
                String[] coord = data.split("\t");
                double dx = Double.parseDouble(coord[1]);
                double dy = Double.parseDouble(coord[2]);
                double dz = Double.parseDouble(coord[3]);
                int v = (int)Double.parseDouble(coord[4]);
                this.voxels.add(new Voxel3D(dx, dy, dz, (double)v));
                data = bf.readLine();
            }
            bf.close();
            this.init();
        }
        catch (IOException ex) {
            Logger.getLogger(Object3DVoxels.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void translate(double x, double y, double z) {
        for (Voxel3D v : this.voxels) {
            v.translate(x, y, z);
        }
        this.init();
    }

    @Override
    public void translate(Vector3D trans) {
        for (Voxel3D v : this.voxels) {
            v.translate(trans);
        }
        this.init();
    }

    public void rotate(Vector3D Axis, double angle) {
        GeomTransform3D trans = new GeomTransform3D();
        trans.setRotation(Axis, angle);
        for (Voxel3D v : this.voxels) {
            Vector3D tv = trans.getVectorTransformed(v.getVector3D(), this.getCenterAsVector());
            v.setVoxel(tv.getX(), tv.getY(), tv.getZ(), v.getValue());
        }
    }

    @Override
    protected void computeMassCenter(ImageHandler ima) {
        if (ima != null) {
            this.cx = 0.0;
            this.cy = 0.0;
            this.cz = 0.0;
            double sum = 0.0;
            double sum2 = 0.0;
            double pmin = Double.POSITIVE_INFINITY;
            double pmax = Double.NEGATIVE_INFINITY;
            int nb = 0;
            Iterator<Voxel3D> iterator = this.voxels.iterator();
            while (iterator.hasNext()) {
                double pix;
                Voxel3D voxel;
                Voxel3D vox = voxel = iterator.next();
                double i = vox.getX();
                double j = vox.getY();
                double k = vox.getZ();
                if (!ima.contains(vox) || Double.isNaN(pix = (double)ima.getPixel(vox))) continue;
                ++nb;
                this.cx += i * pix;
                this.cy += j * pix;
                this.cz += k * pix;
                sum += pix;
                sum2 += pix * pix;
                if (pix > pmax) {
                    pmax = pix;
                }
                if (!(pix < pmin)) continue;
                pmin = pix;
            }
            this.cx /= sum;
            this.cy /= sum;
            this.cz /= sum;
            this.integratedDensity = sum;
            this.meanDensity = this.integratedDensity / (double)nb;
            this.pixmin = pmin;
            this.pixmax = pmax;
            if (pmin == Double.POSITIVE_INFINITY) {
                this.pixmin = Double.NaN;
            }
            if (pmax == Double.NEGATIVE_INFINITY) {
                this.pixmax = Double.NaN;
            }
            int vol = this.getVolumePixels();
            this.sigma = Math.sqrt((sum2 - sum * sum / (double)vol) / (double)(vol - 1));
        }
    }

    @Override
    protected void computeMassCenter(ImageHandler ima, ImageHandler mask) {
        if (ima != null) {
            this.cx = 0.0;
            this.cy = 0.0;
            this.cz = 0.0;
            double sum = 0.0;
            double sum2 = 0.0;
            double pmin = Double.MAX_VALUE;
            double pmax = -1.7976931348623157E308;
            for (Voxel3D voxel : this.voxels) {
                Voxel3D vox = voxel;
                if (!ima.contains(vox) || !mask.contains(vox) || !(mask.getPixel(vox) > 0.0f)) continue;
                double i = vox.getX();
                double j = vox.getY();
                double k = vox.getZ();
                double pix = ima.getPixel(vox);
                this.cx += i * pix;
                this.cy += j * pix;
                this.cz += k * pix;
                sum += pix;
                sum2 += pix * pix;
                if (pix > pmax) {
                    pmax = pix;
                }
                if (!(pix < pmin)) continue;
                pmin = pix;
            }
            this.cx /= sum;
            this.cy /= sum;
            this.cz /= sum;
            this.integratedDensity = sum;
            this.pixmin = pmin;
            this.pixmax = pmax;
            int vol = this.getVolumePixels();
            this.sigma = Math.sqrt((sum2 - sum * sum / (double)vol) / (double)(vol - 1));
        }
    }

    @Override
    public ArrayList<Voxel3D> listVoxels(ImageHandler ima, double threshold) {
        return this.listVoxels(ima, threshold, Double.POSITIVE_INFINITY);
    }

    @Override
    public ArrayList<Voxel3D> listVoxels(ImageHandler ima, double thresholdLow, double thresholdHigh) {
        ArrayList<Voxel3D> list = new ArrayList<Voxel3D>();
        for (Voxel3D voxel : this.voxels) {
            float pixvalue;
            if (!ima.contains(voxel.getX(), voxel.getY(), voxel.getZ()) || !((double)(pixvalue = ima.getPixel(voxel)) > thresholdLow) || !((double)pixvalue < thresholdHigh)) continue;
            Voxel3D newVoxel = new Voxel3D(voxel);
            newVoxel.setValue(pixvalue);
            list.add(newVoxel);
        }
        return list;
    }

    public ArrayUtil listVoxels(ImageHandler ima, int newCenterX, int newCenterY, int newCenterZ) {
        ArrayUtil list = new ArrayUtil(this.getVolumePixels());
        Iterator<Voxel3D> it = this.voxels.iterator();
        double tx = (double)newCenterX - this.bx;
        double ty = (double)newCenterY - this.by;
        double tz = (double)newCenterZ - this.bz;
        int idx = 0;
        while (it.hasNext()) {
            int pz;
            int py;
            Voxel3D voxel = it.next();
            int px = (int)Math.round(tx + voxel.getX());
            if (!ima.contains(px, py = (int)Math.round(ty + voxel.getY()), pz = (int)Math.round(tz + voxel.getZ()))) continue;
            float pixvalue = ima.getPixel(px, py, pz);
            list.putValue(idx, pixvalue);
            ++idx;
        }
        list.setSize(idx);
        return list;
    }

    @Override
    public void draw(ImageHandler mask, int col) {
        for (Voxel3D voxel : this.voxels) {
            int z;
            int y;
            Voxel3D vox = voxel;
            int x = vox.getRoundX();
            if (!mask.contains(x, y = vox.getRoundY(), z = vox.getRoundZ())) continue;
            mask.setPixel(x, y, z, col);
        }
    }

    @Override
    public void draw(ImageHandler mask, int col, int tx, int ty, int tz) {
        for (Voxel3D voxel : this.voxels) {
            int z;
            int y;
            Voxel3D vox = voxel;
            int x = vox.getRoundX() + tx;
            if (!mask.contains(x, y = vox.getRoundY() + ty, z = vox.getRoundZ() + tz)) continue;
            mask.setPixel(x, y, z, col);
        }
    }

    @Override
    public ArrayUtil listValues(ImageHandler ima) {
        ArrayUtil list = new ArrayUtil(this.getVolumePixels());
        Iterator<Voxel3D> it = this.voxels.iterator();
        int idx = 0;
        while (it.hasNext()) {
            Voxel3D voxel = it.next();
            if (!ima.contains(voxel.getX(), voxel.getY(), voxel.getZ())) continue;
            list.putValue(idx, ima.getPixel(voxel));
            ++idx;
        }
        list.setSize(idx);
        return list;
    }

    @Override
    public ArrayUtil listValues(ImageHandler ima, float thresh) {
        ArrayUtil list = new ArrayUtil(this.getVolumePixels());
        Iterator<Voxel3D> it = this.voxels.iterator();
        int idx = 0;
        while (it.hasNext()) {
            float pix;
            Voxel3D voxel = it.next();
            if (!ima.contains(voxel.getX(), voxel.getY(), voxel.getZ()) || !((pix = ima.getPixel(voxel)) > thresh)) continue;
            list.putValue(idx, pix);
            ++idx;
        }
        list.setSize(idx);
        return list;
    }

    public float[] getValueArray(ImageHandler im) {
        float[] res = new float[this.getVolumePixels()];
        int i = 0;
        if (im instanceof ImageFloat) {
            ImageFloat imf = (ImageFloat)im;
            for (Voxel3D v : this.getVoxels()) {
                res[i++] = imf.pixels[v.getRoundZ()][v.getXYCoord(imf.sizeX)];
            }
        } else if (im instanceof ImageShort) {
            ImageShort imf = (ImageShort)im;
            for (Voxel3D v : this.getVoxels()) {
                res[i++] = imf.pixels[v.getRoundZ()][v.getXYCoord(imf.sizeX)] & 0xFFFF;
            }
        } else if (im instanceof ImageByte) {
            ImageByte imf = (ImageByte)im;
            for (Voxel3D v : this.getVoxels()) {
                res[i++] = imf.pixels[v.getRoundZ()][v.getXYCoord(imf.sizeX)] & 0xFF;
            }
        } else {
            for (Voxel3D v : this.getVoxels()) {
                res[i++] = im.getPixel(v);
            }
        }
        return res;
    }

    public Object3DVoxels dilate(float dilateSize, ImageInt mask, int nbCPUs) {
        Object3DVoxels dilated = this.getDilatedObject(dilateSize, dilateSize, dilateSize);
        ImageInt seg = dilated.getLabelImage();
        ImageInt label = this.getLabelImage();
        ArrayList<Voxel3D> vox = new ArrayList<Voxel3D>();
        for (int z = 0; z < seg.sizeZ; ++z) {
            for (int y = 0; y < seg.sizeY; ++y) {
                for (int x = 0; x < seg.sizeX; ++x) {
                    if (seg.getPixelInt(x, y, z) == 0) continue;
                    int xx = x + label.offsetX;
                    int yy = y + label.offsetY;
                    int zz = z + label.offsetZ;
                    if (mask != null && (!mask.contains(xx, yy, zz) || mask.getPixel(xx, yy, zz) != 0.0f && mask.getPixel(xx, yy, zz) != (float)this.value)) continue;
                    vox.add(new Voxel3D(xx, yy, zz, this.value));
                }
            }
        }
        Object3DVoxels res = new Object3DVoxels(vox);
        res.setResXY(this.resXY);
        res.setResZ(this.resZ);
        res.setUnits(this.units);
        return res;
    }

    @Override
    public double getPixMedianValue(ImageHandler img) {
        ArrayUtil tab = this.listValues(img);
        return tab.median();
    }
}

